/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNRevisionProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.ISVNFileContentFetcher;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNAddParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCClient
extends SVNBasicClient {
    public static ISVNAddParameters DEFAULT_ADD_PARAMETERS = new ISVNAddParameters(){

        public ISVNAddParameters.Action onInconsistentEOLs(File file) {
            return ISVNAddParameters.REPORT_ERROR;
        }
    };
    private ISVNAddParameters myAddParameters;
    private ISVNCommitHandler myCommitHandler;

    public SVNWCClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNWCClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setAddParameters(ISVNAddParameters addParameters) {
        this.myAddParameters = addParameters;
    }

    public ISVNCommitHandler getCommitHandler() {
        if (this.myCommitHandler == null) {
            this.myCommitHandler = new DefaultSVNCommitHandler();
        }
        return this.myCommitHandler;
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    protected ISVNAddParameters getAddParameters() {
        if (this.myAddParameters == null) {
            return DEFAULT_ADD_PARAMETERS;
        }
        return this.myAddParameters;
    }

    public void doGetFileContents(File path, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        if (dst == null) {
            return;
        }
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.BASE;
        } else if (revision == SVNRevision.COMMITTED) {
            revision = SVNRevision.BASE;
        }
        if (!(pegRevision.isValid() && pegRevision != SVNRevision.BASE && pegRevision != SVNRevision.WORKING || revision.isValid() && revision != SVNRevision.BASE && revision != SVNRevision.WORKING)) {
            this.doGetLocalFileContents(path, dst, revision, expandKeywords);
        } else {
            SVNRepository repos = this.createRepository(null, path, null, pegRevision, revision, null);
            this.checkCancelled();
            long revNumber = this.getRevisionNumber(revision, repos, path);
            SVNNodeKind kind = repos.checkPath("", revNumber);
            if (kind == SVNNodeKind.DIR) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", repos.getLocation());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            this.checkCancelled();
            if (!expandKeywords) {
                repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this));
            } else {
                SVNProperties properties = new SVNProperties();
                repos.getFile("", revNumber, properties, null);
                this.checkCancelled();
                String keywords = properties.getStringValue("svn:keywords");
                String eol = properties.getStringValue("svn:eol-style");
                String charset = SVNTranslator.getCharset(properties.getStringValue("svnkit:charset"), path.getPath(), this.getOptions());
                if (keywords != null || eol != null || charset != null) {
                    String cmtRev = properties.getStringValue("svn:entry:committed-rev");
                    String cmtDate = properties.getStringValue("svn:entry:committed-date");
                    String author = properties.getStringValue("svn:entry:last-author");
                    Map keywordsMap = SVNTranslator.computeKeywords(keywords, expandKeywords ? repos.getLocation().toString() : null, author, cmtDate, cmtRev, this.getOptions());
                    OutputStream translatingStream = SVNTranslator.getTranslatingOutputStream(dst, charset, SVNTranslator.getEOL(eol, this.getOptions()), false, keywordsMap, expandKeywords);
                    repos.getFile("", revNumber, null, new SVNCancellableOutputStream(translatingStream, this.getEventDispatcher()));
                    try {
                        translatingStream.close();
                    }
                    catch (IOExceptionWrapper ioew) {
                        throw ioew.getOriginalException();
                    }
                    catch (IOException e) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.WC);
                    }
                } else {
                    repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this.getEventDispatcher()));
                }
            }
            try {
                dst.flush();
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.WC);
            }
        }
    }

    public void doGetFileContents(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        revision = revision == null || !revision.isValid() ? SVNRevision.HEAD : revision;
        SVNRepository repos = this.createRepository(url, null, null, pegRevision, revision, null);
        this.checkCancelled();
        long revNumber = this.getRevisionNumber(revision, repos, null);
        this.checkCancelled();
        SVNNodeKind nodeKind = repos.checkPath("", revNumber);
        this.checkCancelled();
        if (nodeKind == SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "URL ''{0}'' refers to a directory", url);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.checkCancelled();
        if (!expandKeywords) {
            repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this));
        } else {
            SVNProperties properties = new SVNProperties();
            repos.getFile("", revNumber, properties, null);
            this.checkCancelled();
            String charset = SVNTranslator.getCharset(properties.getStringValue("svnkit:charset"), repos.getLocation().toDecodedString(), this.getOptions());
            String keywords = properties.getStringValue("svn:keywords");
            String eol = properties.getStringValue("svn:eol-style");
            if (charset != null || keywords != null || eol != null) {
                String cmtRev = properties.getStringValue("svn:entry:committed-rev");
                String cmtDate = properties.getStringValue("svn:entry:committed-date");
                String author = properties.getStringValue("svn:entry:last-author");
                Map keywordsMap = SVNTranslator.computeKeywords(keywords, expandKeywords ? repos.getLocation().toString() : null, author, cmtDate, cmtRev, this.getOptions());
                OutputStream translatingStream = SVNTranslator.getTranslatingOutputStream(dst, charset, SVNTranslator.getEOL(eol, this.getOptions()), false, keywordsMap, expandKeywords);
                repos.getFile("", revNumber, null, new SVNCancellableOutputStream(translatingStream, this.getEventDispatcher()));
                try {
                    translatingStream.close();
                }
                catch (IOExceptionWrapper ioew) {
                    throw ioew.getOriginalException();
                }
                catch (IOException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.WC);
                }
            } else {
                repos.getFile("", revNumber, null, new SVNCancellableOutputStream(dst, this.getEventDispatcher()));
            }
        }
        try {
            dst.flush();
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.WC);
        }
    }

    public void doCleanup(File path) throws SVNException {
        this.doCleanup(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanup(File path, boolean deleteWCProperties) throws SVNException {
        SVNFileType fType = SVNFileType.getType(path);
        if (fType == SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' does not exist", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (fType == SVNFileType.FILE || fType == SVNFileType.SYMLINK) {
            path = path.getParentFile();
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminArea adminArea = wcAccess.open(path, true, true, 0);
            adminArea.cleanup();
            if (deleteWCProperties) {
                SVNPropertiesManager.deleteWCProperties(adminArea, null, true);
            }
        }
        catch (SVNException e) {
            if (e instanceof SVNCancelException) {
                throw e;
            }
            if (!SVNAdminArea.isSafeCleanup()) {
                throw e;
            }
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "CLEANUP FAILED for " + path);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e);
        }
        finally {
            wcAccess.close();
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetProperty(File path, String propName, SVNPropertyValue propValue, boolean skipChecks, SVNDepth depth, ISVNPropertyHandler handler, Collection changeLists) throws SVNException {
        SVNErrorMessage err;
        depth = depth == null ? SVNDepth.UNKNOWN : depth;
        int admLockLevel = -1;
        if (depth == SVNDepth.EMPTY || depth == SVNDepth.FILES) {
            admLockLevel = 0;
        }
        if (propValue != null && !SVNPropertiesManager.isValidPropertyName(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNRevisionProperty.isRevisionProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (SVNProperty.isWorkingCopyProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (SVNProperty.isEntryProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            boolean modified;
            wcAccess.probeOpen(path, true, admLockLevel);
            SVNEntry entry = wcAccess.getVersionedEntry(path, false);
            if (SVNDepth.FILES.compareTo(depth) <= 0 && entry.isDirectory()) {
                PropSetHandler entryHandler = new PropSetHandler(skipChecks, propName, propValue, handler, changeLists);
                wcAccess.walkEntries(path, entryHandler, false, depth);
            } else if (SVNWCAccess.matchesChangeList(changeLists, entry) && (modified = SVNPropertiesManager.setProperty(wcAccess, path, propName, propValue, skipChecks)) && handler != null) {
                handler.handleProperty(path, new SVNPropertyData(propName, propValue, this.getOptions()));
            }
        }
        finally {
            wcAccess.close();
        }
    }

    public SVNCommitInfo doSetProperty(SVNURL url, String propName, SVNPropertyValue propValue, SVNRevision baseRevision, String commitMessage, SVNProperties revisionProperties, boolean skipChecks, ISVNPropertyHandler handler) throws SVNException {
        SVNNodeKind kind;
        SVNErrorMessage err;
        SVNErrorMessage err2;
        if (propValue != null && !SVNPropertiesManager.isValidPropertyName(propName)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", propName);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (SVNRevisionProperty.isRevisionProperty(propName)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", propName);
            SVNErrorManager.error(err2, SVNLogType.WC);
        } else if (SVNProperty.isWorkingCopyProperty(propName)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err2, SVNLogType.WC);
        } else if (SVNProperty.isEntryProperty(propName)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        final SVNRepository repos = this.createRepository(url, null, null, true);
        long revNumber = -1L;
        try {
            revNumber = this.getRevisionNumber(baseRevision, repos, null);
        }
        catch (SVNException svne) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Setting property on non-local target ''{0}'' needs a base revision", url);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ("svn:eol-style".equals(propName) || "svn:keywords".equals(propName) || "svnkit:charset".equals(propName)) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Setting property ''{0}'' on non-local target ''{1}'' is not supported", new Object[]{propName, url});
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        if ((kind = repos.checkPath("", revNumber)) == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist in revision {1}", new Object[]{url.getPath(), new Long(revNumber)});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (propValue != null && SVNProperty.isSVNProperty(propName)) {
            final long baseRev = revNumber;
            propValue = SVNPropertiesManager.validatePropertyValue(url.toString(), kind, propName, propValue, skipChecks, this.getOptions(), new ISVNFileContentFetcher(){
                Boolean isBinary = null;

                public void fetchFileContent(OutputStream os) throws SVNException {
                    SVNProperties props = new SVNProperties();
                    repos.getFile("", baseRev, props, os);
                    this.setBinary(props);
                }

                public boolean fileIsBinary() throws SVNException {
                    if (this.isBinary == null) {
                        SVNProperties props = new SVNProperties();
                        repos.getFile("", baseRev, props, null);
                        this.setBinary(props);
                    }
                    return this.isBinary;
                }

                private void setBinary(SVNProperties props) {
                    String mimeType = props.getStringValue("svn:mime-type");
                    this.isBinary = SVNProperty.isBinaryMimeType(mimeType);
                }
            });
        }
        ArrayList<SVNCommitItem> commitItems = new ArrayList<SVNCommitItem>(2);
        SVNCommitItem commitItem = new SVNCommitItem(null, url, null, kind, SVNRevision.create(revNumber), SVNRevision.UNDEFINED, false, false, true, false, false, false);
        commitItems.add(commitItem);
        commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitItems.toArray(new SVNCommitItem[commitItems.size()]));
        if (commitMessage == null) {
            return SVNCommitInfo.NULL;
        }
        commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
        ISVNEditor commitEditor = repos.getCommitEditor(commitMessage, null, true, revisionProperties, null);
        try {
            commitEditor.openRoot(revNumber);
            if (kind == SVNNodeKind.FILE) {
                commitEditor.openFile("", revNumber);
                commitEditor.changeFileProperty("", propName, propValue);
                commitEditor.closeFile("", null);
            } else {
                commitEditor.changeDirProperty(propName, propValue);
            }
            commitEditor.closeDir();
        }
        catch (SVNException svne) {
            commitEditor.abortEdit();
        }
        if (handler != null) {
            handler.handleProperty(url, new SVNPropertyData(propName, propValue, this.getOptions()));
        }
        return commitEditor.closeEdit();
    }

    public void doSetRevisionProperty(File path, SVNRevision revision, String propName, SVNPropertyValue propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        if (propValue != null && !SVNPropertiesManager.isValidPropertyName(propName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNURL url = this.getURL(path);
        this.doSetRevisionProperty(url, revision, propName, propValue, force, handler);
    }

    public void doSetRevisionProperty(SVNURL url, SVNRevision revision, String propName, SVNPropertyValue propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (propValue != null && !SVNPropertiesManager.isValidPropertyName(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name ''{0}''", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!force && "svn:author".equals(propName) && propValue != null && propValue.isString() && propValue.getString().indexOf(10) >= 0) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE, "Value will not be set unless forced");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNRepository repos = this.createRepository(url, null, null, SVNRevision.UNDEFINED, revision, null);
        long revNumber = this.getRevisionNumber(revision, repos, null);
        repos.setRevisionPropertyValue(revNumber, propName, propValue);
        if (handler != null) {
            handler.handleProperty(revNumber, new SVNPropertyData(propName, propValue, this.getOptions()));
        }
    }

    public SVNPropertyData doGetProperty(final File path, String propName, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        this.doGetProperty(path, propName, pegRevision, revision, SVNDepth.EMPTY, new ISVNPropertyHandler(){

            public void handleProperty(File file, SVNPropertyData property) {
                if (data[0] == null && path.equals(file)) {
                    data[0] = property;
                }
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) {
            }

            public void handleProperty(long revision, SVNPropertyData property) {
            }
        }, null);
        return data[0];
    }

    public SVNPropertyData doGetProperty(final SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        this.doGetProperty(url, propName, pegRevision, revision, SVNDepth.EMPTY, new ISVNPropertyHandler(){

            public void handleProperty(File file, SVNPropertyData property) {
            }

            public void handleProperty(long revision, SVNPropertyData property) {
            }

            public void handleProperty(SVNURL location, SVNPropertyData property) throws SVNException {
                if (data[0] == null && url.toString().equals(location.toString())) {
                    data[0] = property;
                }
            }
        });
        return data[0];
    }

    public void doGetProperty(File path, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        this.doGetProperty(path, propName, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetProperty(File path, String propName, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, ISVNPropertyHandler handler, Collection changeLists) throws SVNException {
        SVNErrorMessage err;
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (depth == null || depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        if (revision != SVNRevision.WORKING && revision != SVNRevision.BASE && revision != SVNRevision.COMMITTED && revision != SVNRevision.UNDEFINED || pegRevision != SVNRevision.WORKING && pegRevision != SVNRevision.BASE && pegRevision != SVNRevision.COMMITTED && pegRevision != SVNRevision.UNDEFINED) {
            long[] revNum = new long[]{-1L};
            SVNRepository repository = this.createRepository(null, path, null, pegRevision, revision, revNum);
            revision = SVNRevision.create(revNum[0]);
            this.doGetRemoteProperty(repository.getLocation(), "", repository, propName, revision, depth, handler);
        } else {
            SVNWCAccess wcAccess = this.createWCAccess();
            try {
                int admDepth = this.getLevelsToLockFromDepth(depth);
                SVNAdminArea area = wcAccess.probeOpen(path, false, admDepth);
                SVNEntry entry = wcAccess.getVersionedEntry(path, false);
                boolean base = revision == SVNRevision.BASE || revision == SVNRevision.COMMITTED;
                this.doGetLocalProperty(entry, area, propName, base, handler, depth, changeLists);
            }
            finally {
                wcAccess.close();
            }
        }
    }

    public void doGetProperty(SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        this.doGetProperty(url, propName, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), handler);
    }

    public void doGetProperty(SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        long[] pegRev = new long[]{-1L};
        SVNRepository repos = this.createRepository(url, null, null, pegRevision, revision, pegRev);
        revision = pegRev[0] < 0L ? revision : SVNRevision.create(pegRev[0]);
        this.doGetRemoteProperty(url, "", repos, propName, revision, depth, handler);
    }

    public void doGetRevisionProperty(File path, String propName, SVNRevision revision, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!revision.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SVNRepository repository = this.createRepository(null, path, null, SVNRevision.UNDEFINED, revision, null);
        long revisionNumber = this.getRevisionNumber(revision, repository, path);
        this.doGetRevisionProperty(repository, propName, revisionNumber, handler);
    }

    public long doGetRevisionProperty(SVNURL url, String propName, SVNRevision revision, ISVNPropertyHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property ''{0}'' is an entry property", propName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!revision.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SVNRepository repos = this.createRepository(url, null, null, true);
        long revNumber = this.getRevisionNumber(revision, repos, null);
        this.doGetRevisionProperty(repos, propName, revNumber, handler);
        return revNumber;
    }

    public void doDelete(File path, boolean force, boolean dryRun) throws SVNException {
        this.doDelete(path, force, true, dryRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(File path, boolean force, boolean deleteFiles, boolean dryRun) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        path = path.getAbsoluteFile();
        try {
            if (!force) {
                SVNWCManager.canDelete(path, this.getOptions(), this);
            }
            SVNAdminArea root = wcAccess.open(path.getParentFile(), true, 0);
            if (!dryRun) {
                SVNWCManager.delete(wcAccess, root, path, deleteFiles, true);
            }
        }
        finally {
            wcAccess.close();
        }
    }

    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, boolean recursive) throws SVNException {
        this.doAdd(path, force, mkdir, climbUnversionedParents, SVNDepth.getInfinityOrEmptyDepth(recursive), false, false);
    }

    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, boolean recursive, boolean includeIgnored) throws SVNException {
        this.doAdd(path, force, mkdir, climbUnversionedParents, SVNDepth.getInfinityOrEmptyDepth(recursive), includeIgnored, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, SVNDepth depth, boolean includeIgnored, boolean makeParents) throws SVNException {
        block27: {
            depth = depth == null ? SVNDepth.UNKNOWN : depth;
            path = path.getAbsoluteFile();
            if (!mkdir && makeParents && path.getParentFile() != null) {
                SVNWCAccess wcAccess = this.createWCAccess();
                try {
                    wcAccess.open(path.getParentFile(), false, 0);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        if (path.getParentFile() == null) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_VERSIONED_PARENT);
                            SVNErrorManager.error(err, SVNLogType.WC);
                        } else {
                            this.doAdd(path.getParentFile(), false, false, climbUnversionedParents, SVNDepth.EMPTY, false, makeParents);
                        }
                        break block27;
                    }
                    throw e;
                }
                finally {
                    wcAccess.close();
                }
            }
        }
        SVNFileType kind = SVNFileType.getType(path);
        if (force && mkdir && kind == SVNFileType.DIRECTORY) {
            this.doAdd(path, force, false, true, SVNDepth.EMPTY, true, makeParents);
            return;
        }
        if (mkdir) {
            File parent;
            File firstCreated = path;
            for (parent = path; parent != null && SVNFileType.getType(parent) == SVNFileType.NONE; parent = parent.getParentFile()) {
                if (!parent.equals(path) && !makeParents) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directoy ''{0}'' with non-existent parents", path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                firstCreated = parent;
            }
            boolean created = path.mkdirs();
            if (!created) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new directory ''{0}''", path);
                while (parent == null ? path != null : !path.equals(parent)) {
                    SVNFileUtil.deleteAll(path, true);
                    path = path.getParentFile();
                }
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            try {
                this.doAdd(firstCreated, false, false, climbUnversionedParents, depth, true, makeParents);
            }
            catch (SVNException e) {
                SVNFileUtil.deleteAll(firstCreated, true);
                throw e;
            }
            return;
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminArea dir = null;
            dir = path.isDirectory() ? wcAccess.open(SVNWCUtil.isVersionedDirectory(path.getParentFile()) ? path.getParentFile() : path, true, 0) : wcAccess.open(path.getParentFile(), true, 0);
            SVNFileType fileType = SVNFileType.getType(path);
            if (fileType == SVNFileType.DIRECTORY && depth.compareTo(SVNDepth.FILES) >= 0) {
                this.addDirectory(path, dir, force, includeIgnored, depth);
            } else if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
                this.addFile(path, fileType, dir);
            } else {
                SVNWCManager.add(path, dir, null, SVNRevision.UNDEFINED);
            }
        }
        catch (SVNException e) {
            if (!force || e.getErrorMessage().getErrorCode() != SVNErrorCode.ENTRY_EXISTS) {
                throw e;
            }
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMarkReplaced(File path) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        path = path.getAbsoluteFile();
        try {
            SVNAdminAreaInfo areaInfo = wcAccess.openAnchor(path, true, -1);
            SVNAdminArea anchor = areaInfo.getAnchor();
            if (path.equals(anchor.getRoot().getAbsoluteFile())) {
                SVNWCManager.markTree(anchor, "replace", false, false, 1);
            } else {
                SVNEntry entry = anchor.getEntry(path.getName(), false);
                SVNWCManager.markEntry(anchor, entry, "replace", false, false, 1);
            }
            anchor.saveEntries(false);
        }
        finally {
            wcAccess.close();
        }
    }

    public void doRevert(File path, boolean recursive) throws SVNException {
        this.doRevert(new File[]{path}, SVNDepth.getInfinityOrEmptyDepth(recursive), null);
    }

    public void doRevert(File[] paths, boolean recursive) throws SVNException {
        this.doRevert(paths, recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRevert(File[] paths, SVNDepth depth, Collection changeLists) throws SVNException {
        boolean reverted = false;
        try {
            for (int i = 0; i < paths.length; ++i) {
                File path = paths[i];
                path = path.getAbsoluteFile();
                SVNWCAccess wcAccess = this.createWCAccess();
                try {
                    int admLockLevel = this.getLevelsToLockFromDepth(depth);
                    SVNAdminAreaInfo info = wcAccess.openAnchor(path, true, admLockLevel);
                    SVNEntry entry = wcAccess.getEntry(path, false);
                    if (entry != null && entry.isDirectory() && entry.isScheduledForAddition() && depth != SVNDepth.INFINITY) {
                        this.getDebugLog().logFine(SVNLogType.WC, "Forcing revert on path '" + path + "' to recurse");
                        depth = SVNDepth.INFINITY;
                        wcAccess.close();
                        info = wcAccess.openAnchor(path, true, -1);
                    }
                    boolean useCommitTimes = this.getOptions().isUseCommitTimes();
                    reverted |= this.doRevert(path, info.getAnchor(), depth, useCommitTimes, changeLists);
                    continue;
                }
                catch (SVNException e) {
                    reverted |= true;
                    SVNErrorCode code = e.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.ENTRY_NOT_FOUND || code == SVNErrorCode.UNVERSIONED_RESOURCE) {
                        SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.SKIP, SVNEventAction.REVERT, null, null);
                        this.dispatchEvent(event);
                        continue;
                    }
                    throw e;
                }
                finally {
                    wcAccess.close();
                }
            }
        }
        finally {
            if (reverted) {
                this.sleepForTimeStamp();
            }
        }
    }

    public void doResolve(File path, boolean recursive) throws SVNException {
        this.doResolve(path, SVNDepth.fromRecurse(recursive), SVNConflictChoice.MERGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResolve(File path, SVNDepth depth, SVNConflictChoice conflictChoice) throws SVNException {
        final SVNConflictChoice choice = conflictChoice == null ? SVNConflictChoice.MERGED : conflictChoice;
        path = path.getAbsoluteFile();
        final SVNWCAccess wcAccess = this.createWCAccess();
        int admLockLevel = -1;
        if (depth == SVNDepth.EMPTY || depth == SVNDepth.FILES) {
            admLockLevel = 0;
        }
        try {
            wcAccess.probeOpen(path, true, admLockLevel);
            ISVNEntryHandler resolveEntryHandler = new ISVNEntryHandler(){

                public void handleEntry(File path, SVNEntry entry) throws SVNException {
                    SVNAdminArea adminArea = entry.getAdminArea();
                    if (entry.isDirectory() && !adminArea.getThisDirName().equals(entry.getName())) {
                        return;
                    }
                    File conflictDir = entry.isDirectory() ? path : path.getParentFile();
                    SVNAdminArea conflictArea = wcAccess.retrieve(conflictDir);
                    if (conflictArea.markResolved(entry.getName(), true, true, choice)) {
                        SVNEvent event = SVNEventFactory.createSVNEvent(conflictArea.getFile(entry.getName()), entry.getKind(), null, entry.getRevision(), SVNEventAction.RESOLVED, null, null, null);
                        SVNWCClient.this.dispatchEvent(event);
                    }
                }

                public void handleError(File path, SVNErrorMessage error) throws SVNException {
                    SVNErrorManager.error(error, SVNLogType.WC);
                }
            };
            if (depth == SVNDepth.EMPTY) {
                SVNEntry entry = wcAccess.getVersionedEntry(path, false);
                resolveEntryHandler.handleEntry(path, entry);
            } else {
                wcAccess.walkEntries(path, resolveEntryHandler, false, depth);
            }
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLock(File[] paths, boolean stealLock, String lockMessage) throws SVNException {
        if (paths == null || paths.length == 0) {
            return;
        }
        final SVNHashMap entriesMap = new SVNHashMap();
        SVNHashMap pathsRevisionsMap = new SVNHashMap();
        final SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNURL topURL = this.collectLockInfo(wcAccess, paths, entriesMap, pathsRevisionsMap, true, stealLock);
            SVNRepository repository = this.createRepository(topURL, paths[0], wcAccess, true);
            final SVNURL rootURL = repository.getRepositoryRoot(true);
            repository.lock(pathsRevisionsMap, lockMessage, stealLock, new ISVNLockHandler(){

                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    SVNURL fullURL = rootURL.appendPath(path, false);
                    LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
                    SVNAdminArea dir = wcAccess.probeRetrieve(lockInfo.myFile);
                    if (error == null) {
                        SVNEntry entry = wcAccess.getVersionedEntry(lockInfo.myFile, false);
                        entry.setLockToken(lock.getID());
                        entry.setLockComment(lock.getComment());
                        entry.setLockOwner(lock.getOwner());
                        entry.setLockCreationDate(SVNDate.formatDate(lock.getCreationDate()));
                        SVNVersionedProperties props = dir.getProperties(entry.getName());
                        if (props.getPropertyValue("svn:needs-lock") != null) {
                            SVNFileUtil.setReadonly(dir.getFile(entry.getName()), false);
                        }
                        SVNFileUtil.setExecutable(dir.getFile(entry.getName()), props.getPropertyValue("svn:executable") != null);
                        dir.saveEntries(false);
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(dir.getFile(entry.getName()), SVNEventAction.LOCKED, lock, null), -1.0);
                    } else {
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(dir.getFile(lockInfo.myFile.getName()), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
                    }
                }

                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) {
                }
            });
        }
        finally {
            wcAccess.close();
        }
    }

    public void doLock(SVNURL[] urls, boolean stealLock, String lockMessage) throws SVNException {
        HashSet<String> paths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        SVNHashMap pathsToRevisions = new SVNHashMap();
        Iterator p = paths.iterator();
        while (p.hasNext()) {
            String path = (String)p.next();
            path = SVNEncodingUtil.uriDecode(path);
            pathsToRevisions.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.createRepository(topURL, null, null, true);
        repository.lock(pathsToRevisions, lockMessage, stealLock, new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                if (error != null) {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
                } else {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCKED, lock, null), -1.0);
                }
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnlock(File[] paths, boolean breakLock) throws SVNException {
        if (paths == null || paths.length == 0) {
            return;
        }
        final SVNHashMap entriesMap = new SVNHashMap();
        SVNHashMap pathsTokensMap = new SVNHashMap();
        final SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNURL topURL = this.collectLockInfo(wcAccess, paths, entriesMap, pathsTokensMap, false, breakLock);
            this.checkCancelled();
            SVNRepository repository = this.createRepository(topURL, paths[0], wcAccess, true);
            final SVNURL rootURL = repository.getRepositoryRoot(true);
            repository.unlock(pathsTokensMap, breakLock, new ISVNLockHandler(){

                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                }

                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    SVNURL fullURL = rootURL.appendPath(path, false);
                    LockInfo lockInfo = (LockInfo)entriesMap.get(fullURL);
                    SVNEventAction action = null;
                    SVNAdminArea dir = wcAccess.probeRetrieve(lockInfo.myFile);
                    if (error == null || error != null && error.getErrorCode() != SVNErrorCode.FS_LOCK_OWNER_MISMATCH) {
                        SVNEntry entry = wcAccess.getVersionedEntry(lockInfo.myFile, false);
                        entry.setLockToken(null);
                        entry.setLockComment(null);
                        entry.setLockOwner(null);
                        entry.setLockCreationDate(null);
                        SVNVersionedProperties props = dir.getProperties(entry.getName());
                        if (props.getPropertyValue("svn:needs-lock") != null) {
                            SVNFileUtil.setReadonly(dir.getFile(entry.getName()), true);
                        }
                        dir.saveEntries(false);
                        action = SVNEventAction.UNLOCKED;
                    }
                    if (error != null) {
                        action = SVNEventAction.UNLOCK_FAILED;
                    }
                    if (action != null) {
                        SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(dir.getFile(lockInfo.myFile.getName()), action, lock, error), -1.0);
                    }
                }
            });
        }
        finally {
            wcAccess.close();
        }
    }

    public void doUnlock(SVNURL[] urls, boolean breakLock) throws SVNException {
        HashSet<String> paths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        Map pathsToTokens = new SVNHashMap();
        Iterator p = paths.iterator();
        while (p.hasNext()) {
            String path = (String)p.next();
            path = SVNEncodingUtil.uriDecode(path);
            pathsToTokens.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.createRepository(topURL, null, null, true);
        if (!breakLock) {
            pathsToTokens = this.fetchLockTokens(repository, pathsToTokens);
        }
        repository.unlock(pathsToTokens, breakLock, new ISVNLockHandler(){

            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }

            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                if (error != null) {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.UNLOCK_FAILED, null, error), -1.0);
                } else {
                    SVNWCClient.this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.UNLOCKED, null, null), -1.0);
                }
            }
        });
    }

    public void doInfo(File path, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, SVNRevision.UNDEFINED, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), null, handler);
    }

    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, Collection changeLists, ISVNInfoHandler handler) throws SVNException {
        boolean local;
        if (handler == null) {
            return;
        }
        boolean bl = local = !(revision != null && revision.isValid() && !revision.isLocal() || pegRevision != null && pegRevision.isValid() && !pegRevision.isLocal());
        if (!local) {
            SVNWCAccess wcAccess = this.createWCAccess();
            SVNRevision wcRevision = null;
            SVNURL url = null;
            try {
                wcAccess.probeOpen(path, false, 0);
                SVNEntry entry = wcAccess.getVersionedEntry(path, false);
                url = entry.getSVNURL();
                if (url == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                wcRevision = SVNRevision.create(entry.getRevision());
            }
            finally {
                wcAccess.close();
            }
            this.doInfo(url, pegRevision == null || !pegRevision.isValid() || pegRevision.isLocal() ? wcRevision : pegRevision, revision, depth, handler);
            return;
        }
        HashSet<String> changelistsSet = null;
        if (changeLists != null) {
            changelistsSet = new HashSet<String>();
            Iterator changeListsIter = changeLists.iterator();
            while (changeListsIter.hasNext()) {
                String changeList = (String)changeListsIter.next();
                changelistsSet.add(changeList);
            }
        }
        this.crawlEntries(path, depth, changelistsSet, handler);
    }

    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(url, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), handler);
    }

    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, ISVNInfoHandler handler) throws SVNException {
        SVNLock lock;
        String baseName;
        String reposUUID;
        SVNURL reposRoot;
        SVNDirEntry rootEntry;
        SVNRepository repos;
        long[] revNum;
        block30: {
            SVNDepth sVNDepth = depth = depth == null ? SVNDepth.UNKNOWN : depth;
            if (revision == null || !revision.isValid()) {
                revision = SVNRevision.HEAD;
            }
            if (pegRevision == null || !pegRevision.isValid()) {
                pegRevision = revision;
            }
            revNum = new long[]{-1L};
            repos = this.createRepository(url, null, null, pegRevision, revision, revNum);
            url = repos.getLocation();
            rootEntry = null;
            reposRoot = repos.getRepositoryRoot(true);
            reposUUID = repos.getRepositoryUUID(true);
            baseName = SVNPathUtil.tail(url.getPath());
            try {
                rootEntry = repos.info("", revNum[0]);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                    SVNNodeKind urlKind;
                    if (url.equals(reposRoot)) {
                        if (depth.compareTo(SVNDepth.EMPTY) > 0) {
                            SVNLock[] locks = null;
                            if (pegRevision == SVNRevision.HEAD) {
                                try {
                                    locks = repos.getLocks("");
                                }
                                catch (SVNException svne) {
                                    SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                                    if (code == SVNErrorCode.RA_NOT_IMPLEMENTED || code == SVNErrorCode.UNSUPPORTED_FEATURE) {
                                        locks = new SVNLock[]{};
                                    }
                                    throw svne;
                                }
                            } else {
                                locks = new SVNLock[]{};
                            }
                            locks = locks == null ? new SVNLock[]{} : locks;
                            SVNHashMap locksMap = new SVNHashMap();
                            for (int i = 0; i < locks.length; ++i) {
                                SVNLock lock2 = locks[i];
                                locksMap.put(lock2.getPath(), lock2);
                            }
                            this.pushDirInfo(repos, SVNRevision.create(revNum[0]), "", repos.getRepositoryRoot(true), reposUUID, url, locksMap, depth, handler);
                            return;
                        }
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Server does not support retrieving information about the repository root");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if ((urlKind = repos.checkPath("", revNum[0])) == SVNNodeKind.NONE) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", new Object[]{url, new Long(revNum[0])});
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    SVNRepository parentRepos = this.createRepository(url.removePathTail(), null, null, false);
                    Collection dirEntries = parentRepos.getDir("", revNum[0], null, 57, (Collection)null);
                    Iterator ents = dirEntries.iterator();
                    while (ents.hasNext()) {
                        SVNDirEntry dirEntry = (SVNDirEntry)ents.next();
                        if (!baseName.equals(dirEntry.getName())) continue;
                        rootEntry = dirEntry;
                        break;
                    }
                    if (rootEntry == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", new Object[]{url, new Long(revNum[0])});
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                throw e;
            }
            if (rootEntry == null || rootEntry.getKind() == SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision ''{1}''", new Object[]{url, new Long(revNum[0])});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            lock = null;
            if (rootEntry.getKind() == SVNNodeKind.FILE) {
                try {
                    SVNURL headURL;
                    SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(url, null, null, revision, SVNRevision.HEAD, SVNRevision.UNDEFINED);
                    if (locations == null || locations.length <= 0 || !(headURL = locations[0].getURL()).equals(url)) break block30;
                    try {
                        lock = repos.getLock("");
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                            throw e;
                        }
                    }
                }
                catch (SVNException e) {
                    SVNErrorCode code = e.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block30;
                    throw e;
                }
            }
        }
        SVNInfo info = SVNInfo.createInfo(baseName, reposRoot, reposUUID, url, SVNRevision.create(revNum[0]), rootEntry, lock);
        handler.handleInfo(info);
        if (depth.compareTo(SVNDepth.EMPTY) > 0 && rootEntry.getKind() == SVNNodeKind.DIR) {
            SVNLock[] locks = null;
            if (pegRevision == SVNRevision.HEAD) {
                try {
                    locks = repos.getLocks("");
                }
                catch (SVNException svne) {
                    SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.RA_NOT_IMPLEMENTED || code == SVNErrorCode.UNSUPPORTED_FEATURE) {
                        locks = new SVNLock[]{};
                    }
                    throw svne;
                }
            } else {
                locks = new SVNLock[]{};
            }
            locks = locks == null ? new SVNLock[]{} : locks;
            SVNHashMap locksMap = new SVNHashMap();
            for (int i = 0; i < locks.length; ++i) {
                lock = locks[i];
                locksMap.put(lock.getPath(), lock);
            }
            this.pushDirInfo(repos, SVNRevision.create(revNum[0]), "", repos.getRepositoryRoot(true), reposUUID, url, locksMap, depth, handler);
        }
    }

    public String doGetWorkingCopyID(File path, String trailURL) throws SVNException {
        return this.doGetWorkingCopyID(path, trailURL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetWorkingCopyID(final File path, String trailURL, final boolean committed) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.open(path, false, 0);
        }
        catch (SVNException e) {
            SVNFileType pathType = SVNFileType.getType(path);
            if (pathType == SVNFileType.DIRECTORY) {
                String string = "exported";
                return string;
            }
            if (pathType == SVNFileType.NONE) {
                throw e;
            }
            String string = "'" + path + "' is not versioned and not exported";
            return string;
        }
        finally {
            wcAccess.close();
        }
        SVNStatusClient statusClient = new SVNStatusClient((ISVNAuthenticationManager)null, this.getOptions());
        statusClient.setIgnoreExternals(true);
        final long[] maxRevision = new long[1];
        final long[] minRevision = new long[]{-1L};
        final boolean[] switched = new boolean[3];
        final String[] wcURL = new String[1];
        statusClient.doStatus(path, SVNRevision.WORKING, SVNDepth.INFINITY, false, true, false, false, new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (status.getEntryProperties() == null || status.getEntryProperties().isEmpty()) {
                    return;
                }
                if (status.getContentsStatus() != SVNStatusType.STATUS_ADDED) {
                    SVNRevision revision;
                    SVNRevision sVNRevision = revision = committed ? status.getCommittedRevision() : status.getRevision();
                    if (revision != null) {
                        if (minRevision[0] < 0L || minRevision[0] > revision.getNumber()) {
                            minRevision[0] = revision.getNumber();
                        }
                        maxRevision[0] = Math.max(maxRevision[0], revision.getNumber());
                    }
                }
                switched[0] = switched[0] | status.isSwitched();
                switched[1] = switched[1] | status.getContentsStatus() != SVNStatusType.STATUS_NORMAL;
                switched[1] = switched[1] | (status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL && status.getPropertiesStatus() != SVNStatusType.STATUS_NONE);
                switched[2] = switched[2] | (status.getEntry() != null && status.getEntry().getDepth() != SVNDepth.INFINITY);
                if (wcURL[0] == null && status.getFile() != null && status.getFile().equals(path) && status.getURL() != null) {
                    wcURL[0] = status.getURL().toString();
                }
            }
        }, null);
        if (!switched[0] && trailURL != null) {
            switched[0] = wcURL[0] == null ? true : !wcURL[0].endsWith(trailURL);
        }
        StringBuffer id = new StringBuffer();
        id.append(minRevision[0]);
        if (minRevision[0] != maxRevision[0]) {
            id.append(":").append(maxRevision[0]);
        }
        if (switched[1]) {
            id.append("M");
        }
        if (switched[0]) {
            id.append("S");
        }
        if (switched[2]) {
            id.append("P");
        }
        return id.toString();
    }

    public SVNInfo doInfo(File path, SVNRevision revision) throws SVNException {
        final SVNInfo[] result = new SVNInfo[1];
        this.doInfo(path, SVNRevision.UNDEFINED, revision, SVNDepth.EMPTY, null, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) {
                if (result[0] == null) {
                    result[0] = info;
                }
            }
        });
        return result[0];
    }

    public SVNInfo doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNInfo[] result = new SVNInfo[1];
        this.doInfo(url, pegRevision, revision, SVNDepth.EMPTY, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) {
                if (result[0] == null) {
                    result[0] = info;
                }
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupWCProperties(File directory) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(this);
        try {
            SVNAdminArea dir = wcAccess.open(directory, true, true, -1);
            if (dir != null) {
                SVNPropertiesManager.deleteWCProperties(dir, null, true);
            }
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetWCFormat(File directory, int format) throws SVNException {
        SVNAdminAreaInfo info = null;
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(this);
        try {
            info = wcAccess.openAnchor(directory, false, -1);
            this.setWCFormat(info, info.getTarget(), format);
        }
        finally {
            wcAccess.close();
        }
        if (!this.isIgnoreExternals() && info != null) {
            File externalDir;
            String externalPath;
            int i;
            SVNExternal[] externalDefs;
            String value;
            String path;
            HashSet<File> processedDirs = new HashSet<File>();
            Map externals = info.getOldExternals();
            Iterator paths = externals.keySet().iterator();
            while (paths.hasNext()) {
                path = (String)paths.next();
                value = (String)externals.get(path);
                if (value == null) continue;
                externalDefs = SVNExternal.parseExternals("", value);
                for (i = 0; i < externalDefs.length; ++i) {
                    externalPath = externalDefs[i].getPath();
                    externalDir = new File(info.getAnchor().getRoot(), SVNPathUtil.append(path, externalPath));
                    if (!processedDirs.add(externalDir)) continue;
                    try {
                        wcAccess.open(externalDir, false, 0);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw svne;
                    }
                    finally {
                        wcAccess.close();
                    }
                    try {
                        this.doSetWCFormat(externalDir, format);
                        continue;
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw e;
                    }
                }
            }
            externals = info.getNewExternals();
            paths = externals.keySet().iterator();
            while (paths.hasNext()) {
                path = (String)paths.next();
                value = (String)externals.get(path);
                externalDefs = SVNExternal.parseExternals("", value);
                for (i = 0; i < externalDefs.length; ++i) {
                    externalPath = externalDefs[i].getPath();
                    externalDir = new File(info.getAnchor().getRoot(), SVNPathUtil.append(path, externalPath));
                    if (!processedDirs.add(externalDir)) continue;
                    try {
                        wcAccess.open(externalDir, false, 0);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw svne;
                    }
                    finally {
                        wcAccess.close();
                    }
                    try {
                        this.doSetWCFormat(externalDir, format);
                        continue;
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) continue;
                        throw e;
                    }
                }
            }
        }
    }

    public void doSetProperty(File path, String propName, SVNPropertyValue propValue, boolean force, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        this.doSetProperty(path, propName, propValue, force, SVNDepth.getInfinityOrEmptyDepth(recursive), handler, null);
    }

    private void doGetRevisionProperty(SVNRepository repos, String propName, long revNumber, ISVNPropertyHandler handler) throws SVNException {
        if (propName != null) {
            SVNPropertyValue value = repos.getRevisionPropertyValue(revNumber, propName);
            if (value != null) {
                handler.handleProperty(revNumber, new SVNPropertyData(propName, value, this.getOptions()));
            }
        } else {
            SVNProperties props = new SVNProperties();
            repos.getRevisionProperties(revNumber, props);
            Iterator names = props.nameSet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                SVNPropertyValue value = props.getSVNPropertyValue(name);
                handler.handleProperty(revNumber, new SVNPropertyData(name, value, this.getOptions()));
            }
        }
    }

    private void addDirectory(File path, SVNAdminArea parentDir, boolean force, boolean noIgnore, SVNDepth depth) throws SVNException {
        block8: {
            this.checkCancelled();
            try {
                SVNWCManager.add(path, parentDir, null, SVNRevision.UNDEFINED);
            }
            catch (SVNException e) {
                if (force && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) break block8;
                throw e;
            }
        }
        SVNWCAccess access = parentDir.getWCAccess();
        SVNAdminArea dir = access.retrieve(path);
        Collection ignores = Collections.EMPTY_SET;
        if (!noIgnore) {
            ignores = SVNStatusEditor.getIgnorePatterns(dir, SVNStatusEditor.getGlobalIgnores(this.getOptions()));
        }
        File[] children = SVNFileListUtil.listFiles(dir.getRoot());
        for (int i = 0; children != null && i < children.length; ++i) {
            this.checkCancelled();
            if (SVNFileUtil.getAdminDirectoryName().equals(children[i].getName()) || !noIgnore && SVNStatusEditor.isIgnored(ignores, children[i].getName())) continue;
            SVNFileType childType = SVNFileType.getType(children[i]);
            if (childType == SVNFileType.DIRECTORY && depth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                SVNDepth depthBelowHere = depth;
                if (depth == SVNDepth.IMMEDIATES) {
                    depthBelowHere = SVNDepth.EMPTY;
                }
                this.addDirectory(children[i], dir, force, noIgnore, depthBelowHere);
                continue;
            }
            if (childType == SVNFileType.UNKNOWN || childType == SVNFileType.DIRECTORY || depth.compareTo(SVNDepth.FILES) < 0) continue;
            try {
                this.addFile(children[i], childType, dir);
                continue;
            }
            catch (SVNException e) {
                if (force && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) continue;
                throw e;
            }
        }
    }

    private void addFile(File path, SVNFileType type, SVNAdminArea dir) throws SVNException {
        ISVNEventHandler handler = dir.getWCAccess().getEventHandler();
        dir.getWCAccess().setEventHandler(null);
        SVNWCManager.add(path, dir, null, SVNRevision.UNDEFINED);
        dir.getWCAccess().setEventHandler(handler);
        String mimeType = null;
        if (type == SVNFileType.SYMLINK) {
            SVNPropertiesManager.setProperty(dir.getWCAccess(), path, "svn:special", SVNProperty.getValueOfBooleanProperty("svn:special"), false);
        } else {
            Map props = SVNPropertiesManager.computeAutoProperties(this.getOptions(), path, null);
            Iterator names = props.keySet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                String propValue = (String)props.get(propName);
                try {
                    SVNPropertiesManager.setProperty(dir.getWCAccess(), path, propName, SVNPropertyValue.create(propValue), false);
                }
                catch (SVNException e) {
                    if ("svn:eol-style".equals(propName) && e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET && e.getErrorMessage().getMessage().indexOf("newlines") >= 0) {
                        ISVNAddParameters.Action action = this.getAddParameters().onInconsistentEOLs(path);
                        if (action == ISVNAddParameters.REPORT_ERROR) {
                            throw e;
                        }
                        if (action == ISVNAddParameters.ADD_AS_IS) {
                            SVNPropertiesManager.setProperty(dir.getWCAccess(), path, propName, null, false);
                            continue;
                        }
                        if (action != ISVNAddParameters.ADD_AS_BINARY) continue;
                        SVNPropertiesManager.setProperty(dir.getWCAccess(), path, propName, null, false);
                        mimeType = "application/octet-stream";
                        continue;
                    }
                    throw e;
                }
            }
            if (mimeType != null) {
                SVNPropertiesManager.setProperty(dir.getWCAccess(), path, "svn:mime-type", SVNPropertyValue.create(mimeType), false);
            } else {
                mimeType = (String)props.get("svn:mime-type");
            }
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(dir.getFile(path.getName()), SVNNodeKind.FILE, mimeType, -1L, SVNEventAction.ADD, null, null, null);
        this.dispatchEvent(event);
    }

    private SVNURL collectLockInfo(SVNWCAccess wcAccess, File[] files, Map lockInfo, Map lockPaths, boolean lock, boolean stealLock) throws SVNException {
        SVNErrorMessage err;
        int i;
        String[] paths = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            paths[i2] = files[i2].getAbsolutePath();
            paths[i2] = paths[i2].replace(File.separatorChar, '/');
        }
        ArrayList<String> condencedPaths = new ArrayList<String>();
        String commonParentPath = SVNPathUtil.condencePaths(paths, condencedPaths, false);
        if (condencedPaths.isEmpty()) {
            condencedPaths.add(SVNPathUtil.tail(commonParentPath));
            commonParentPath = SVNPathUtil.removeTail(commonParentPath);
        }
        if (commonParentPath == null || "".equals(commonParentPath)) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "No common parent found, unable to operate on dijoint arguments");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        paths = condencedPaths.toArray(new String[condencedPaths.size()]);
        int depth = 0;
        for (i = 0; i < paths.length; ++i) {
            int segments = SVNPathUtil.getSegmentsCount(paths[i]);
            if (depth >= segments) continue;
            depth = segments;
        }
        wcAccess.probeOpen(new File(commonParentPath).getAbsoluteFile(), true, depth);
        for (i = 0; i < paths.length; ++i) {
            File file = new File(commonParentPath, paths[i]);
            SVNEntry entry = wcAccess.getVersionedEntry(file, false);
            if (entry.getURL() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", file);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (lock) {
                SVNRevision revision = stealLock ? SVNRevision.UNDEFINED : SVNRevision.create(entry.getRevision());
                lockInfo.put(entry.getSVNURL(), new LockInfo(file, revision));
                continue;
            }
            if (!stealLock && entry.getLockToken() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked in this working copy", file);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            lockInfo.put(entry.getSVNURL(), new LockInfo(file, entry.getLockToken()));
        }
        this.checkCancelled();
        SVNURL[] urls = lockInfo.keySet().toArray(new SVNURL[lockInfo.size()]);
        HashSet<String> urlPaths = new HashSet<String>();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, urlPaths, false);
        if (urlPaths.isEmpty()) {
            urlPaths.add("");
        }
        if (topURL == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unable to lock/unlock across multiple repositories");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        Iterator encodedPaths = urlPaths.iterator();
        while (encodedPaths.hasNext()) {
            String encodedPath = (String)encodedPaths.next();
            SVNURL fullURL = topURL.appendPath(encodedPath, true);
            LockInfo info = (LockInfo)lockInfo.get(fullURL);
            encodedPath = SVNEncodingUtil.uriDecode(encodedPath);
            if (lock) {
                if (info.myRevision == SVNRevision.UNDEFINED) {
                    lockPaths.put(encodedPath, null);
                    continue;
                }
                lockPaths.put(encodedPath, new Long(info.myRevision.getNumber()));
                continue;
            }
            lockPaths.put(encodedPath, info.myToken);
        }
        return topURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crawlEntries(File path, SVNDepth depth, final Collection changeLists, final ISVNInfoHandler handler) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        int admLockLevel = this.getLevelsToLockFromDepth(depth);
        try {
            wcAccess.probeOpen(path, false, admLockLevel);
            wcAccess.walkEntries(path, new ISVNEntryHandler(){

                public void handleEntry(File path, SVNEntry entry) throws SVNException {
                    if (entry.isDirectory() && !entry.isThisDir()) {
                        return;
                    }
                    if (SVNWCAccess.matchesChangeList(changeLists, entry)) {
                        SVNWCClient.this.reportEntry(path, entry, handler);
                    }
                }

                public void handleError(File path, SVNErrorMessage error) throws SVNException {
                    SVNErrorManager.error(error, SVNLogType.WC);
                }
            }, false, depth);
        }
        finally {
            wcAccess.close();
        }
    }

    private void reportEntry(File path, SVNEntry entry, ISVNInfoHandler handler) throws SVNException {
        if (entry.isDirectory() && !"".equals(entry.getName())) {
            return;
        }
        handler.handleInfo(SVNInfo.createInfo(path, entry));
    }

    private boolean doRevert(File path, SVNAdminArea parent, SVNDepth depth, boolean useCommitTimes, Collection changeLists) throws SVNException {
        SVNFileType fileType;
        SVNErrorMessage err;
        this.checkCancelled();
        SVNWCAccess wcAccess = parent.getWCAccess();
        SVNAdminArea dir = wcAccess.probeRetrieve(path);
        SVNEntry entry = null;
        try {
            entry = wcAccess.getVersionedEntry(path, false);
        }
        catch (SVNException svne) {
            err = svne.getErrorMessage().wrap("Cannot revert.");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (entry.getKind() == SVNNodeKind.DIR && (fileType = SVNFileType.getType(path)) != SVNFileType.DIRECTORY && !entry.isScheduledForAddition()) {
            SVNEvent event = SVNEventFactory.createSVNEvent(dir.getFile(entry.getName()), entry.getKind(), null, entry.getRevision(), SVNEventAction.FAILED_REVERT, null, null, null);
            this.dispatchEvent(event);
            return false;
        }
        if (entry.getKind() != SVNNodeKind.DIR && entry.getKind() != SVNNodeKind.FILE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot revert ''{0}'': unsupported entry node kind", path);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if ((fileType = SVNFileType.getType(path)) == SVNFileType.UNKNOWN) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot revert ''{0}'': unsupported node kind in working copy", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean reverted = false;
        if (SVNWCAccess.matchesChangeList(changeLists, entry)) {
            if (entry.isScheduledForAddition()) {
                boolean wasDeleted = false;
                if (entry.getKind() == SVNNodeKind.FILE) {
                    wasDeleted = entry.isDeleted();
                    parent.removeFromRevisionControl(path.getName(), false, false);
                } else if (entry.getKind() == SVNNodeKind.DIR) {
                    SVNEntry entryInParent = parent.getEntry(path.getName(), true);
                    if (entryInParent != null) {
                        wasDeleted = entryInParent.isDeleted();
                    }
                    if (fileType == SVNFileType.NONE || wcAccess.isMissing(path)) {
                        parent.deleteEntry(path.getName());
                        parent.saveEntries(false);
                    } else {
                        dir.removeFromRevisionControl("", false, false);
                    }
                }
                reverted = true;
                depth = SVNDepth.EMPTY;
                if (wasDeleted) {
                    SVNHashMap attributes = new SVNHashMap();
                    attributes.put("svn:entry:kind", entry.getKind().toString());
                    attributes.put("svn:entry:deleted", Boolean.TRUE.toString());
                    parent.modifyEntry(path.getName(), attributes, true, false);
                }
            } else if (entry.getSchedule() == null || entry.isScheduledForDeletion() || entry.isScheduledForReplacement()) {
                if (entry.getKind() == SVNNodeKind.FILE) {
                    reverted = this.revert(parent, entry.getName(), entry, useCommitTimes);
                } else if (entry.getKind() == SVNNodeKind.DIR) {
                    reverted = this.revert(dir, dir.getThisDirName(), entry, useCommitTimes);
                    if (reverted && parent != dir) {
                        SVNEntry entryInParent = parent.getEntry(path.getName(), false);
                        this.revert(parent, path.getName(), entryInParent, useCommitTimes);
                    }
                    if (entry.isScheduledForReplacement()) {
                        depth = SVNDepth.INFINITY;
                    }
                }
            }
            if (reverted) {
                SVNEvent event = SVNEventFactory.createSVNEvent(dir.getFile(entry.getName()), entry.getKind(), null, entry.getRevision(), SVNEventAction.REVERT, null, null, null);
                this.dispatchEvent(event);
            }
        }
        if (entry.getKind() == SVNNodeKind.DIR && depth.compareTo(SVNDepth.EMPTY) > 0) {
            SVNDepth depthBelowHere = depth;
            if (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            Iterator entries = dir.entries(false);
            while (entries.hasNext()) {
                SVNEntry childEntry = (SVNEntry)entries.next();
                if (dir.getThisDirName().equals(childEntry.getName()) || depth == SVNDepth.FILES && !childEntry.isFile()) continue;
                File childPath = new File(path, childEntry.getName());
                reverted |= this.doRevert(childPath, dir, depthBelowHere, useCommitTimes, changeLists);
            }
        }
        return reverted;
    }

    private boolean revert(SVNAdminArea dir, String name, SVNEntry entry, boolean useCommitTime) throws SVNException {
        String basePath;
        SVNLog log = dir.getLog();
        boolean reverted = false;
        SVNVersionedProperties baseProperties = null;
        SVNProperties command = new SVNProperties();
        boolean revertBase = false;
        if (entry.isScheduledForReplacement()) {
            revertBase = entry.isCopied();
            SVNVersionedProperties sVNVersionedProperties = baseProperties = revertBase ? dir.getRevertProperties(name) : dir.getBaseProperties(name);
            if (revertBase) {
                String propRevertPath = SVNAdminUtil.getPropRevertPath(name, entry.getKind(), false);
                command.put("name", propRevertPath);
                log.addCommand("rm", command, false);
                command.clear();
            }
            reverted = true;
        }
        boolean reinstallWorkingFile = false;
        if (baseProperties == null && dir.hasPropModifications(name)) {
            baseProperties = dir.getBaseProperties(name);
            SVNVersionedProperties propDiff = dir.getProperties(name).compareTo(baseProperties);
            Collection propNames = propDiff.getPropertyNames(null);
            boolean bl = reinstallWorkingFile = propNames.contains("svn:executable") || propNames.contains("svn:keywords") || propNames.contains("svn:eol-style") || propNames.contains("svnkit:charset") || propNames.contains("svn:special") || propNames.contains("svn:needs-lock");
        }
        if (baseProperties != null) {
            SVNProperties newProperties = baseProperties.asMap();
            SVNVersionedProperties originalBaseProperties = dir.getBaseProperties(name);
            SVNVersionedProperties workProperties = dir.getProperties(name);
            if (entry.isScheduledForReplacement()) {
                originalBaseProperties.removeAll();
            }
            workProperties.removeAll();
            Iterator names = newProperties.nameSet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                if (entry.isScheduledForReplacement()) {
                    originalBaseProperties.setPropertyValue(propName, newProperties.getSVNPropertyValue(propName));
                }
                workProperties.setPropertyValue(propName, newProperties.getSVNPropertyValue(propName));
            }
            dir.saveVersionedProperties(log, false);
            reverted = true;
        }
        SVNProperties newEntryProperties = new SVNProperties();
        if (entry.getKind() == SVNNodeKind.FILE) {
            File revertFile;
            SVNFileType fileType;
            if (!reinstallWorkingFile && (fileType = SVNFileType.getType(dir.getFile(name))) == SVNFileType.NONE) {
                reinstallWorkingFile = true;
            }
            if (!dir.getFile(basePath = SVNAdminUtil.getTextBasePath(name, false)).isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error restoring text for ''{0}''", dir.getFile(name));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((revertFile = dir.getFile(SVNAdminUtil.getTextRevertPath(name, false))).isFile()) {
                command.put("name", SVNAdminUtil.getTextRevertPath(name, false));
                command.put("dest", SVNAdminUtil.getTextBasePath(name, false));
                log.addCommand("mv", command, false);
                command.clear();
                reinstallWorkingFile = true;
            }
            if (!reinstallWorkingFile) {
                reinstallWorkingFile = dir.hasTextModifications(name, false, false, false);
            }
            if (reinstallWorkingFile) {
                command.put("name", SVNAdminUtil.getTextBasePath(name, false));
                command.put("dest", name);
                log.addCommand("cp-and-translate", command, false);
                command.clear();
                if (useCommitTime && entry.getCommittedDate() != null) {
                    command.put("name", name);
                    command.put("timestamp", entry.getCommittedDate());
                    log.addCommand("set-timestamp", command, false);
                    command.clear();
                } else {
                    command.put("name", name);
                    command.put("timestamp", SVNDate.formatDate(new Date(System.currentTimeMillis())));
                    log.addCommand("set-timestamp", command, false);
                    command.clear();
                }
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                log.addCommand("modify-entry", command, false);
                command.clear();
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
                log.addCommand("modify-entry", command, false);
                command.clear();
            }
            reverted |= reinstallWorkingFile;
        }
        if (entry.getConflictNew() != null) {
            command.put("name", entry.getConflictNew());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), (String)null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getConflictNew()).exists();
            }
        }
        if (entry.getConflictOld() != null) {
            command.put("name", entry.getConflictOld());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), (String)null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getConflictOld()).exists();
            }
        }
        if (entry.getConflictWorking() != null) {
            command.put("name", entry.getConflictWorking());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), (String)null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getConflictWorking()).exists();
            }
        }
        if (entry.getPropRejectFile() != null) {
            command.put("name", entry.getPropRejectFile());
            log.addCommand("rm", command, false);
            command.clear();
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), (String)null);
            if (!reverted) {
                reverted |= dir.getFile(entry.getPropRejectFile()).exists();
            }
        }
        if (entry.isScheduledForReplacement()) {
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:copied"), SVNProperty.toString(false));
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-url"), (String)null);
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:copyfrom-rev"), SVNProperty.toString(-1L));
            if (entry.isFile() && entry.getCopyFromURL() != null) {
                basePath = SVNAdminUtil.getTextRevertPath(name, false);
                File baseFile = dir.getFile(basePath);
                String digest = SVNFileUtil.computeChecksum(baseFile);
                newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:checksum"), digest);
            }
        }
        if (entry.getSchedule() != null) {
            newEntryProperties.put(SVNProperty.shortPropertyName("svn:entry:schedule"), (String)null);
            reverted = true;
        }
        if (!newEntryProperties.isEmpty()) {
            newEntryProperties.put("name", name);
            log.addCommand("modify-entry", newEntryProperties, false);
        }
        log.save();
        dir.runLogs();
        return reverted;
    }

    private void setWCFormat(SVNAdminAreaInfo info, SVNAdminArea area, int format) throws SVNException {
        if (!this.isIgnoreExternals()) {
            SVNVersionedProperties props = area.getProperties(area.getThisDirName());
            SVNVersionedProperties baseProps = area.getBaseProperties(area.getThisDirName());
            SVNPropertyValue property = props.getPropertyValue("svn:externals");
            SVNPropertyValue baseProperty = baseProps.getPropertyValue("svn:externals");
            if (property != null || baseProperty != null) {
                String areaPath = area.getRelativePath(info.getAnchor());
                info.addExternal(areaPath, property != null ? property.getString() : null, baseProperty != null ? baseProperty.getString() : null);
            }
        }
        area.getWCAccess().closeAdminArea(area.getRoot());
        area = area.getWCAccess().open(area.getRoot(), true, false, false, 0, Level.FINE);
        SVNAdminArea newArea = SVNAdminAreaFactory.changeWCFormat(area, format);
        Iterator entries = newArea.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (entry.isThisDir() || entry.isFile()) continue;
            File childDir = new File(newArea.getRoot(), entry.getName());
            SVNAdminArea childArea = newArea.getWCAccess().getAdminArea(childDir);
            if (childArea == null) continue;
            this.setWCFormat(info, childArea, format);
        }
    }

    private void pushDirInfo(SVNRepository repos, SVNRevision rev, String path, SVNURL root, String uuid, SVNURL url, Map locks, SVNDepth depth, ISVNInfoHandler handler) throws SVNException {
        Collection children = repos.getDir(path, rev.getNumber(), null, 57, new ArrayList());
        Iterator ents = children.iterator();
        while (ents.hasNext()) {
            this.checkCancelled();
            SVNDirEntry child = (SVNDirEntry)ents.next();
            SVNURL childURL = url.appendPath(child.getName(), false);
            String childPath = SVNPathUtil.append(path, child.getName());
            String displayPath = repos.getFullPath(childPath);
            displayPath = displayPath.substring(repos.getLocation().getPath().length());
            if (displayPath.startsWith("/")) {
                displayPath = displayPath.substring(1);
            }
            if ("".equals(displayPath)) {
                displayPath = path;
            }
            SVNLock lock = (SVNLock)locks.get(path);
            SVNInfo info = SVNInfo.createInfo(displayPath, root, uuid, url, rev, child, lock);
            if (depth.compareTo(SVNDepth.IMMEDIATES) >= 0 || depth == SVNDepth.FILES && child.getKind() == SVNNodeKind.FILE) {
                handler.handleInfo(info);
            }
            if (depth != SVNDepth.INFINITY || child.getKind() != SVNNodeKind.DIR) continue;
            this.pushDirInfo(repos, rev, SVNPathUtil.append(path, child.getName()), root, uuid, childURL, locks, depth, handler);
        }
    }

    private void doGetRemoteProperty(SVNURL url, String path, SVNRepository repos, String propName, SVNRevision rev, SVNDepth depth, ISVNPropertyHandler handler) throws SVNException {
        this.checkCancelled();
        long revNumber = this.getRevisionNumber(rev, repos, null);
        SVNNodeKind kind = repos.checkPath(path, revNumber);
        SVNProperties props = new SVNProperties();
        if (kind == SVNNodeKind.DIR) {
            Collection children = repos.getDir(path, revNumber, props, 1, SVNDepth.FILES.compareTo(depth) <= 0 ? new ArrayList() : null);
            if (propName != null) {
                SVNPropertyValue value = props.getSVNPropertyValue(propName);
                if (value != null) {
                    handler.handleProperty(url, new SVNPropertyData(propName, value, this.getOptions()));
                }
            } else {
                Iterator names = props.nameSet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (name.startsWith("svn:entry:") || name.startsWith("svn:wc:")) continue;
                    SVNPropertyValue value = props.getSVNPropertyValue(name);
                    handler.handleProperty(url, new SVNPropertyData(name, value, this.getOptions()));
                }
            }
            if (SVNDepth.FILES.compareTo(depth) <= 0) {
                this.checkCancelled();
                Iterator entries = children.iterator();
                while (entries.hasNext()) {
                    SVNDirEntry child = (SVNDirEntry)entries.next();
                    SVNURL childURL = url.appendPath(child.getName(), false);
                    String childPath = "".equals(path) ? child.getName() : SVNPathUtil.append(path, child.getName());
                    SVNDepth depthBelowHere = depth;
                    if (child.getKind() == SVNNodeKind.DIR && depth == SVNDepth.FILES) continue;
                    if (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
                        depthBelowHere = SVNDepth.EMPTY;
                    }
                    this.doGetRemoteProperty(childURL, childPath, repos, propName, rev, depthBelowHere, handler);
                }
            }
        } else if (kind == SVNNodeKind.FILE) {
            repos.getFile(path, revNumber, props, null);
            if (propName != null) {
                SVNPropertyValue value = props.getSVNPropertyValue(propName);
                if (value != null) {
                    handler.handleProperty(url, new SVNPropertyData(propName, value, this.getOptions()));
                }
            } else {
                Iterator names = props.nameSet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (name.startsWith("svn:entry:") || name.startsWith("svn:wc:")) continue;
                    SVNPropertyValue value = props.getSVNPropertyValue(name);
                    handler.handleProperty(url, new SVNPropertyData(name, value, this.getOptions()));
                }
            }
        } else if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' does not exist in revision {1}", new Object[]{path, String.valueOf(revNumber)});
            SVNErrorManager.error(err, SVNLogType.WC);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown node kind for ''{0}''", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private void doGetLocalProperty(SVNEntry entry, SVNAdminArea area, String propName, boolean base, ISVNPropertyHandler handler, SVNDepth depth, Collection changeLists) throws SVNException {
        if (depth == null || depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        File target = area.getFile(entry.getName());
        SVNWCAccess wcAccess = area.getWCAccess();
        PropFetchHandler propGetHandler = new PropFetchHandler(changeLists, propName, handler, base);
        if (SVNDepth.FILES.compareTo(depth) <= 0 && entry.isDirectory()) {
            wcAccess.walkEntries(target, propGetHandler, false, depth);
        } else if (SVNWCAccess.matchesChangeList(changeLists, entry)) {
            if (propName == null) {
                SVNVersionedProperties properties;
                SVNVersionedProperties sVNVersionedProperties = properties = base ? area.getBaseProperties(entry.getName()) : area.getProperties(entry.getName());
                if (propName != null) {
                    SVNPropertyValue propValue = properties.getPropertyValue(propName);
                    if (propValue != null) {
                        handler.handleProperty(target, new SVNPropertyData(propName, propValue, this.getOptions()));
                    }
                } else {
                    SVNProperties allProps = properties.asMap();
                    Iterator names = allProps.nameSet().iterator();
                    while (names.hasNext()) {
                        String name = (String)names.next();
                        SVNPropertyValue val = allProps.getSVNPropertyValue(name);
                        handler.handleProperty(area.getFile(entry.getName()), new SVNPropertyData(name, val, this.getOptions()));
                    }
                }
            } else {
                propGetHandler.handleEntry(target, entry);
            }
        }
    }

    private Map fetchLockTokens(SVNRepository repository, Map pathsTokensMap) throws SVNException {
        SVNHashMap tokens = new SVNHashMap();
        Iterator paths = pathsTokensMap.keySet().iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            SVNLock lock = repository.getLock(path);
            if (lock == null || lock.getID() == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", path);
                SVNErrorManager.error(err, SVNLogType.WC);
                continue;
            }
            tokens.put(path, lock.getID());
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetLocalFileContents(File path, OutputStream dst, SVNRevision revision, boolean expandKeywords) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        InputStream input = null;
        boolean hasMods = false;
        SVNVersionedProperties properties = null;
        try {
            SVNAdminArea area = wcAccess.open(path.getParentFile(), false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(path, false);
            if (entry.getKind() != SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' refers to a directory", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            String name = path.getName();
            if (revision != SVNRevision.WORKING) {
                input = area.getBaseFileForReading(name, false);
                properties = area.getBaseProperties(name);
            } else {
                input = SVNFileUtil.openFileForReading(area.getFile(path.getName()), SVNLogType.WC);
                hasMods = area.hasPropModifications(name) || area.hasTextModifications(name, true);
                properties = area.getProperties(name);
            }
            String charsetProp = properties.getStringPropertyValue("svnkit:charset");
            String eolStyle = properties.getStringPropertyValue("svn:eol-style");
            String keywords = properties.getStringPropertyValue("svn:keywords");
            boolean special = properties.getPropertyValue("svn:special") != null;
            byte[] eols = null;
            Map keywordsMap = null;
            String time = null;
            String charset = SVNTranslator.getCharset(charsetProp, path.getPath(), this.getOptions());
            eols = SVNTranslator.getEOL(eolStyle, this.getOptions());
            time = hasMods && !special ? SVNDate.formatDate(new Date(path.lastModified())) : entry.getCommittedDate();
            if (keywords != null) {
                String url = entry.getURL();
                String author = hasMods ? "(local)" : entry.getAuthor();
                String rev = hasMods ? entry.getCommittedRevision() + "M" : entry.getCommittedRevision() + "";
                keywordsMap = SVNTranslator.computeKeywords(keywords, expandKeywords ? url : null, author, time, rev, this.getOptions());
            }
            OutputStream translatingStream = charset != null || eols != null || keywordsMap != null ? SVNTranslator.getTranslatingOutputStream(dst, charset, eols, false, keywordsMap, expandKeywords) : dst;
            try {
                SVNTranslator.copy(input, new SVNCancellableOutputStream(translatingStream, this.getEventDispatcher()));
                if (translatingStream != dst) {
                    SVNFileUtil.closeFile(translatingStream);
                }
                dst.flush();
            }
            catch (IOExceptionWrapper ioew) {
                throw ioew.getOriginalException();
            }
            catch (IOException e) {
                if (e instanceof SVNCancellableOutputStream.IOCancelException) {
                    SVNErrorManager.cancel(e.getMessage(), SVNLogType.NETWORK);
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.WC);
            }
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(input);
            wcAccess.close();
            throw throwable;
        }
        SVNFileUtil.closeFile(input);
        wcAccess.close();
    }

    private class PropFetchHandler
    implements ISVNEntryHandler {
        private Collection myChangeLists;
        private boolean myIsPristine;
        private String myPropName;
        private ISVNPropertyHandler myPropHandler;

        public PropFetchHandler(Collection changeLists, String propName, ISVNPropertyHandler handler, boolean pristine) {
            this.myChangeLists = changeLists;
            this.myIsPristine = pristine;
            this.myPropName = propName;
            this.myPropHandler = handler;
        }

        public void handleEntry(File path, SVNEntry entry) throws SVNException {
            SVNVersionedProperties properties;
            SVNAdminArea adminArea = entry.getAdminArea();
            if (entry.isDirectory() && !entry.isThisDir()) {
                return;
            }
            if (this.myIsPristine && entry.isScheduledForAddition() || !this.myIsPristine && entry.isScheduledForDeletion()) {
                return;
            }
            if (!SVNWCAccess.matchesChangeList(this.myChangeLists, entry)) {
                return;
            }
            SVNVersionedProperties sVNVersionedProperties = properties = this.myIsPristine ? adminArea.getBaseProperties(entry.getName()) : adminArea.getProperties(entry.getName());
            if (this.myPropName != null) {
                SVNPropertyValue propValue = properties.getPropertyValue(this.myPropName);
                if (propValue != null) {
                    this.myPropHandler.handleProperty(path, new SVNPropertyData(this.myPropName, propValue, SVNWCClient.this.getOptions()));
                }
            } else {
                SVNProperties allProps = properties.asMap();
                Iterator names = allProps.nameSet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    SVNPropertyValue val = allProps.getSVNPropertyValue(name);
                    this.myPropHandler.handleProperty(path, new SVNPropertyData(name, val, SVNWCClient.this.getOptions()));
                }
            }
        }

        public void handleError(File path, SVNErrorMessage error) throws SVNException {
            SVNErrorManager.error(error, SVNLogType.WC);
        }
    }

    private class PropSetHandler
    implements ISVNEntryHandler {
        private boolean myIsForce;
        private String myPropName;
        private SVNPropertyValue myPropValue;
        private ISVNPropertyHandler myPropHandler;
        private Collection myChangeLists;

        public PropSetHandler(boolean isForce, String propName, SVNPropertyValue propValue, ISVNPropertyHandler handler, Collection changeLists) {
            this.myIsForce = isForce;
            this.myPropName = propName;
            this.myPropValue = propValue;
            this.myPropHandler = handler;
            this.myChangeLists = changeLists;
        }

        public void handleEntry(File path, SVNEntry entry) throws SVNException {
            block6: {
                SVNAdminArea adminArea = entry.getAdminArea();
                if (entry.isDirectory() && !adminArea.getThisDirName().equals(entry.getName())) {
                    return;
                }
                if (entry.isScheduledForDeletion()) {
                    return;
                }
                if (!SVNWCAccess.matchesChangeList(this.myChangeLists, entry)) {
                    return;
                }
                try {
                    boolean modified = SVNPropertiesManager.setProperty(adminArea.getWCAccess(), path, this.myPropName, this.myPropValue, this.myIsForce);
                    if (modified && this.myPropHandler != null) {
                        this.myPropHandler.handleProperty(path, new SVNPropertyData(this.myPropName, this.myPropValue, SVNWCClient.this.getOptions()));
                    }
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET) break block6;
                    throw svne;
                }
            }
        }

        public void handleError(File path, SVNErrorMessage error) throws SVNException {
            SVNErrorManager.error(error, SVNLogType.WC);
        }
    }

    private static class LockInfo {
        private File myFile;
        private SVNRevision myRevision;
        private String myToken;

        public LockInfo(File file, SVNRevision rev) {
            this.myFile = file;
            this.myRevision = rev;
        }

        public LockInfo(File file, String token) {
            this.myFile = file;
            this.myToken = token;
        }
    }
}

