<?xml version="1.0"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.7 $
																																																																										-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- Import xalan extensions -->
	<xsl:import href="xalan-ext.xsl" />

	<!-- Defin string variables -->
	<xsl:param name="request.locale">en</xsl:param>
	
	<xsl:variable name="pageWidth">1000</xsl:variable>

	<xsl:variable name="strings" select="document(concat('strings_', $request.locale, '.xml'))" />

	<!-- Common head template -->
	<xsl:template name="head">
		<xsl:if test="$head.title">
			<title>
				<xsl:call-template name="str">
					<xsl:with-param name="id">
						<xsl:value-of select="$head.title" />
					</xsl:with-param>
				</xsl:call-template>
			</title>
		</xsl:if>
	  
	  <link rel="stylesheet" href="sbbi.css" type="text/css" />
		<meta name="generator" content="MX4J HttpAdaptor, JMX, SuperBonBon Industries, SBBI"/>
    <script src="sbbi.js" language="JavaScript" type="text/javascript"/>
    
	</xsl:template>

	<!-- Common title template -->
	<xsl:template name="toprow">
		<xsl:param name="selection" select="." />
		
		<table width="{$pageWidth}" border="0" cellspacing="0" cellpadding="0">
      <tr valign="top" align="left"> 
      <td height="40" rowspan="3" width="287"><img src="images/logo_{$request.locale}.gif" width="287" height="90"/></td>
      <td height="40" rowspan="3" width="83"><img src="images/coude_top.gif" width="83" height="90"/></td>
      <td height="37" colspan="6" background="images/bkgd_top.gif">
        <img src="images/s_tit_top_console_{$request.locale}.gif" width="388" height="40"/>
        <img src="images/poussoir.gif" width="10" height="10"/>
          <a href="http://www.sbbi.net" target="_blank">
            <img src="images/sign_superbonbon.gif" width="226" height="40" border="0"/>
          </a>
      </td>
    </tr>
    <tr valign="top" align="left"> 
      <xsl:call-template name="tabs">
			  <xsl:with-param name="selection" select="$selection"/>
		  </xsl:call-template>
      <td width="41" align="right" bgcolor="#660066">
        <a href="mailto:info@sbbi.net" onMouseOut="MM_swapImgRestore()" onMouseOver="MM_swapImage('btn_contact','','images/bkgd_onglet_contact_on.gif',1)">
          <img name="btn_contact" border="0" src="images/bkgd_onglet_contact_off.gif" width="40" height="24"/>
        </a>
      </td>
      <td width="34" bgcolor="#660066">&#160;</td>
    </tr>
    <tr valign="top" align="left"> 
      <td width="139" bgcolor="#660066"><img src="images/poussoir.gif" width="139" height="26"/></td>
      <td width="139" bgcolor="#660066"><img src="images/poussoir.gif" width="139" height="10"/></td>
      <td width="139" bgcolor="#660066"><img src="images/poussoir.gif" width="139" height="10"/></td>
      <td width="139" bgcolor="#660066"><img src="images/poussoir.gif" width="139" height="10"/></td>
      <td width="41" bgcolor="#660066" align="right">&#160;</td>
      <td bgcolor="#660066" width="34">&#160;</td>
    </tr>
    </table>
	</xsl:template>

	<!-- Common bottom template -->
	<xsl:template name="bottom">
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td class="fronttab">&#160;</td>
			</tr>
			<tr>
				<td class="darker" />
			</tr>
		</table>
	</xsl:template>

	<!-- Common tabs template -->
	<xsl:template name="tabs">
		<xsl:param name="selection" select="." />

		<xsl:if test="not ($selection='server')">
		  <td background="images/bkgd_onglet_nav_off.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
			    <a href="serverbydomain" class="tabs">
				    <xsl:call-template name="str">
					    <xsl:with-param name="id">common.tabs.serverview</xsl:with-param>
					  </xsl:call-template>
				  </a></b></font></div>
      </td>
		</xsl:if>
		<xsl:if test="$selection='server'">
		  <td background="images/bkgd_onglet_nav_on.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
				  <xsl:call-template name="str">
					  <xsl:with-param name="id">common.tabs.serverview</xsl:with-param>
					</xsl:call-template>
				 </b></font></div>
      </td>
		</xsl:if>
		
		<xsl:if test="not ($selection='mbean')">
		  <td background="images/bkgd_onglet_nav_off.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
			    <a href="empty?template=emptymbean" class="tabs">
						<xsl:call-template name="str">
							<xsl:with-param name="id">common.tabs.mbeanview</xsl:with-param>
						</xsl:call-template>
					</a></b></font></div>
      </td>
		</xsl:if>
		<xsl:if test="$selection='mbean'">
		  <td background="images/bkgd_onglet_nav_on.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
				  <xsl:call-template name="str">
					  <xsl:with-param name="id">common.tabs.mbeanview</xsl:with-param>
					</xsl:call-template>
				 </b></font></div>
      </td>
		</xsl:if>
		
		<xsl:if test="not ($selection='timer')">
		  <td background="images/bkgd_onglet_nav_off.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
			    <a href="serverbydomain?instanceof=javax.management.timer.Timer&amp;template=timer" class="tabs">
						<xsl:call-template name="str">
							<xsl:with-param name="id">common.tabs.timerview</xsl:with-param>
						</xsl:call-template>
					</a></b></font></div>
      </td>
		</xsl:if>
		<xsl:if test="$selection='timer'">
		  <td background="images/bkgd_onglet_nav_on.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
				  <xsl:call-template name="str">
					  <xsl:with-param name="id">common.tabs.timerview</xsl:with-param>
					</xsl:call-template>
				 </b></font></div>
      </td>
		</xsl:if>
		
		<xsl:if test="not ($selection='about')">
		  <td background="images/bkgd_onglet_nav_off.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
			    <a href="mbean?objectname=JMImplementation%3Atype%3DMBeanServerDelegate&amp;template=about" class="tabs">
						<xsl:call-template name="str">
							<xsl:with-param name="id">common.tabs.about</xsl:with-param>
						</xsl:call-template>
					</a></b></font></div>
      </td>
		</xsl:if>
		<xsl:if test="$selection='about'">
		  <td background="images/bkgd_onglet_nav_on.gif" width="139" valign="middle"> 
        <div align="center"><font color="#FFFFFF"><b>
				  <xsl:call-template name="str">
					  <xsl:with-param name="id">common.tabs.about</xsl:with-param>
					</xsl:call-template>
				 </b></font></div>
      </td>
		</xsl:if>
		
				<!--td class="{$monitor.class}">
					<a href="serverbydomain?instanceof=javax.management.monitor.Monitor&amp;template=monitor" class="tabs">
						<xsl:call-template name="str">
							<xsl:with-param name="id">common.tabs.monitorview</xsl:with-param>
						</xsl:call-template>
					</a>
				</td>

				<td width="2"/>

				<td class="{$relation.class}">
					<a href="relation?instanceof=javax.management.relation.Relation&amp;template=relation" class="tabs">
						<xsl:call-template name="str">
							<xsl:with-param name="id">common.tabs.relationview</xsl:with-param>
						</xsl:call-template>
					</a>
				</td>

				<td width="2"/>

				<td class="{$mlet.class}">
					<a href="serverbydomain?instanceof=javax.management.loading.MLetMBean&amp;template=mlet" class="tabs">
						<xsl:call-template name="str">
							<xsl:with-param name="id">common.tabs.mletview</xsl:with-param>
						</xsl:call-template>
					</a>
				</td>

				<td width="2"/-->

	</xsl:template>

	<xsl:template name="serverview">
		<tr>
			<td class="darkline" align="right">
				<a href="serverbydomain">
					<xsl:call-template name="str">
						<xsl:with-param name="id">common.serverview.return</xsl:with-param>
					</xsl:call-template>
				</a>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="mbeanview">
		<xsl:param name="objectname" />
		<xsl:param name="colspan">1</xsl:param>
		<xsl:param name="text">common.mbeanview.return</xsl:param>

		<tr>
			<td class="darkline" align="right" colspan="{$colspan}">
				<xsl:variable name="objectname-encode">
					<xsl:call-template name="uri-encode">
						<xsl:with-param name="uri" select="$objectname" />
					</xsl:call-template>
				</xsl:variable>

				<a href="mbean?objectname={$objectname-encode}">
					<xsl:call-template name="str">
						<xsl:with-param name="id"><xsl:value-of select="$text" /></xsl:with-param>
					</xsl:call-template>
				</a>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="aggregation-navigation">
		<xsl:param name="url"/>
		<xsl:param name="total"/>
		<xsl:param name="step"/>
		<xsl:param name="start"/>
		<xsl:param name="str.prefix">common</xsl:param>

		<xsl:if test="$total&gt;$step">
			<xsl:variable name="isfirst">
				<xsl:choose>
					<xsl:when test='$start=0'>true</xsl:when>
					<xsl:when test='$start&gt;0'>false</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="islast">
				<xsl:choose>
					<xsl:when test='$total&lt;=($step + $start)'>true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<tr><td/></tr>
			<tr><td>
				<xsl:choose>
					<xsl:when test="$isfirst='false'">
					<a href="{$url}&amp;start=0">
						<xsl:call-template name="str">
							<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.first')"/></xsl:with-param>
						</xsl:call-template>
					</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="str">
								<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.first')"/></xsl:with-param>
							</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				 -
				<xsl:choose>
					<xsl:when test="$isfirst='false'">
						<xsl:variable name="previndex" select="($start - $step)"/>
						<a href="{$url}&amp;start={$previndex}">
						<xsl:call-template name="str">
							<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.previous')"/></xsl:with-param>
						</xsl:call-template>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="str">
							<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.previous')"/></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				 -
				<xsl:choose>
					<xsl:when test="$islast='false'">
						<xsl:variable name="nextindex" select="($start + $step)"/>
						<a href="{$url}&amp;start={$nextindex}">
							<xsl:call-template name="str">
								<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.next')"/></xsl:with-param>
							</xsl:call-template>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="str">
							<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.next')"/></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				 -
				<xsl:choose>
					<xsl:when test="$islast='false'">
						<xsl:variable name="lastindex" select="($total - ($total mod $step))"/>
						<a href="{$url}&amp;start={$lastindex}">
							<xsl:call-template name="str">
								<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.last')"/></xsl:with-param>
							</xsl:call-template>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="str">
							<xsl:with-param name="id"><xsl:value-of select="concat($str.prefix, '.navigation.last')"/></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			</tr>
		</xsl:if>
	</xsl:template>

	<!-- Finds a string in the strings file by id. It can replace two params -->
	<xsl:template name="str">
		<xsl:param name="id"/>
		<xsl:param name="p0"/>
		<xsl:param name="p1"/>

		<xsl:variable name="str" select="$strings//str[@id=$id]" />

		<!-- This is a bit lame, should be improved -->
		<xsl:variable name="temp">
			<xsl:call-template name="replace-param">
				<xsl:with-param name="text" select="$str" />
				<xsl:with-param name="paramText">{0}</xsl:with-param>
				<xsl:with-param name="paramValue">
					<xsl:value-of select="$p0" />
				</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$p1">
				<xsl:call-template name="replace-param">
					<xsl:with-param name="text" select="$temp" />
					<xsl:with-param name="paramText">{1}</xsl:with-param>
					<xsl:with-param name="paramValue">
						<xsl:value-of select="$p1" />
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="$temp"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Replaces paramText by paramValue in text -->
	<xsl:template name="replace-param">
		<xsl:param name="text"/>
		<xsl:param name="paramText"/>
		<xsl:param name="paramValue"/>

		<xsl:choose>
			<xsl:when test="contains($text, $paramText)">
				<xsl:copy-of select="substring-before($text, $paramText)" />
				<!--xsl:copy-of select="$paramValue" /-->
				<xsl:call-template name="br-replace">
					<xsl:with-param name="word" select="$paramValue" />
				</xsl:call-template>
				<xsl:copy-of select="substring-after($text, $paramText)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template name="br-replace">
	<xsl:param name="word"/>
	<xsl:variable name="cr" select ="'&#10;'"/>
   
	<xsl:choose>
		<xsl:when test="contains($word,$cr)">
			<xsl:value-of select="substring-before($word,$cr)"/>
			<br/>
			<xsl:call-template name="br-replace">
				<xsl:with-param name="word" select="substring-after($word,$cr)"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$word"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template> 


</xsl:stylesheet>


