unit InputAssistDataModule;

interface

uses
  SysUtils, Classes, Windows;

type
  TResistWord = class;

  TInputAssistDM = class(TDataModule)
    procedure DataModuleDestroy(Sender: TObject);
    procedure DataModuleCreate(Sender: TObject);
  private
	{ Private 錾 }
	FInit : Boolean;
	FDictionary : TStringList;	///< o^Pƒ^̎
	FSorted : Boolean;
	function GetSorted: Boolean;	///< \[g̏Ԃ̎擾
	procedure SetSorted(Value: Boolean);	///< \[gԂ̐ݒ

  public
	{ Public 錾 }
	property Sorted : Boolean read GetSorted write SetSorted;
	procedure Init(FilePath: String);
	procedure SaveToFile(FilePath: String);
	function ResistWordCount : Integer;	///<o^Pꐔ擾
	function GetResistWord(Index: Integer): TResistWord;	///< o^P擾
	procedure DeleteResistWord(ResistWord: TResistWord);  ///< o^P̍폜
	function Add(Key: String): TResistWord;	///< o^Pǉ
	procedure ChangeKey(ResistWord: TResistWord);  ///< o^P̃L[ύX
	//! KeyL[Ɏo^ĂP擾
	function GetStartWithKeyResistWords(Key: String; var list: TStringList): Integer;
	//! KeyJeSɎo^ĂP擾
	function GetStartWithCategoryResistWords(Key: String; var list: TStringList): Integer;
	//! KeỹJeSɓo^ĂP擾
	function GetCategoryResistWords(Key: String; var list: TStringList): Integer;
	//! o^ς݃L[̑SẴJeSXg擾
	procedure GetCategoryList(var list: TStringList);
	//! ɓo^ς݂̃L[ƃJeS̃Zbgǂ`FbN
	function IsDupulicate(Key: String; Category: String): Boolean;

  end;

  TResistWord = class(TObject)
  private
	FKey : String;		///< ϊ̃L[ɂȂ
	FCategory : String;	///< 
	FText : String;		///< ^
  public
	function GetKey: String;
	procedure SetKey(Value: String);
	function GetCategory: String;
	procedure SetCategory(Value: String);
	function GetText: String;
	procedure SetText(Value: String);
	property Key: String read FKey write FKey;
	property Category: String read FCategory write FCategory;
	property Text: String read GetText write SetText;
  end;

  function CategorySort(List: TStringList; Index1, Index2: Integer): Integer;
  function KeySort(List: TStringList; Index1, Index2: Integer): Integer;
var
  InputAssistDM: TInputAssistDM;

implementation

uses
  MojuUtils, IniFiles;

{$R *.dfm}
//! FKeyɐݒ肳Ăl擾
function TResistWord.GetKey: String;
begin
	//GXP[vĂ=𕜌
	Result := MojuUtils.CustomStringReplace(FKey, '&#61;', '=');
end;
//! FKeyɒlݒ肷
procedure TResistWord.SetKey(Value: String);
begin
	//=͕ۑɎĝŃGXP[v
	FKey := MojuUtils.CustomStringReplace(Value, '=', '&#61;');
end;
//! FCategoryɐݒ肳Ăl擾
function TResistWord.GetCategory: String;
begin
	//GXP[vĂ=𕜌
	Result := MojuUtils.CustomStringReplace(FCategory, '&#61;', '=');
end;
//! FCategoryɒlݒ肷
procedure TResistWord.SetCategory(Value: String);
begin
	//=͕ۑɎĝŃGXP[v
	FCategory := MojuUtils.CustomStringReplace(Value, '=', '&#61;');
end;
//! FTextɐݒ肳Ăl擾
function TResistWord.GetText: String;
begin
	//GXP[vĂ=𕜌
	Result := MojuUtils.CustomStringReplace(FText, '&#61;', '=');
	// #1ɂsR[h#13#10ɕ
	Result := MojuUtils.CustomStringReplace(Result, #1, #13#10);
end;
procedure TResistWord.SetText(Value: String);
begin
	//=͕ۑɎĝŃGXP[v
	FText := MojuUtils.CustomStringReplace(Value, '=', '&#61;');
	//sR[h#1ɂi1sɂ邽)
	FText := MojuUtils.CustomStringReplace(FText, #13#10, #1);
end;
//! t@Cǂݍŏ
procedure TInputAssistDM.Init(FilePath: String);
var
	ini : TMemIniFile;
	sections: TStringList;
	keys: TStringList;
	i, j : Integer;
	resWord : TResistWord;
begin
	FInit := True;
	try
		// t@C݂̑mF
		if FileExists(FilePath) then begin
            ini := TMemIniFile.Create(FilePath);
			sections := TStringList.Create;
			keys := TStringList.Create;
			try
				ini.ReadSections(sections);

				for i :=0 to sections.Count - 1 do begin
					keys.Clear;
					ini.ReadSection(sections[i], keys);
					for j := 0 to keys.Count - 1 do begin
						resWord := TResistWord.Create;
						resWord.SetCategory(sections[i]);
						resWord.SetKey(keys[j]);
						resWord.SetText(ini.ReadString(sections[i], keys[j], ''));
						FDictionary.AddObject(resWord.GetKey, resWord);
					end;
				end;
			finally
				keys.Free;
				sections.Free;
				ini.Free;
			end;
			if FSorted Then begin
				FDictionary.CustomSort(KeySort);
			end;
		end;

	except
		FInit := False;
	end;
end;
//! w肳ꂽpX̃t@Cɕۑ
procedure TInputAssistDM.SaveToFile(FilePath: String);
var
	ini : TMemIniFile;
	i : Integer;
	resWord : TResistWord;
begin
	if FileExists(FilePath) then begin
		try
			SysUtils.DeleteFile(FilePath);
		except
		end;
	end;

	ini := TMemIniFile.Create(FilePath);
	try
		for i :=0 to FDictionary.Count - 1 do begin
			resWord := TResistWord(FDictionary.Objects[i]);
			ini.WriteString(resWord.FCategory, resWord.FKey, resWord.FText);
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;
//! fXgN^
procedure TInputAssistDM.DataModuleDestroy(Sender: TObject);
var
	i : Integer;
begin
	if (FDictionary <> nil) then begin
		for i := FDictionary.Count - 1 downto 0 do begin
			TResistWord(FDictionary.Objects[i]).Free;
		end;
		FDictionary.Clear;
		FDictionary.Capacity := 0;
		FDictionary.Free;
	end;
end;
//! RXgN^
procedure TInputAssistDM.DataModuleCreate(Sender: TObject);
begin
	FDictionary := TStringList.Create;
	FDictionary.Sorted := False;
	FSorted := True;
end;
//! o^Pꐔ擾
function TInputAssistDM.ResistWordCount : Integer;
begin
	Result := 0;
	if (FDictionary <> nil) then begin
		Result := FDictionary.Count;
	end;
end;
//! o^P擾
function TInputAssistDM.GetResistWord(Index: Integer): TResistWord;
begin
	Result := nil;
	if (FDictionary <> nil) then begin
		if (Index >= 0) and (Index < FDictionary.Count) then begin
			Result := TResistWord(FDictionary.Objects[index]);
		end;
	end;
end;
//! o^P̍폜
procedure TInputAssistDM.DeleteResistWord(ResistWord: TResistWord);
var
	i : Integer;
begin
	if (FDictionary <> nil) then begin
		for i := 0 to FDictionary.Count - 1 do begin
			if (ResistWord = FDictionary.Objects[i]) then begin
				TResistWord(FDictionary.Objects[i]).Free;
				FDictionary.Delete(i);
				break;
			end;
		end;
		if FSorted Then begin
			FDictionary.CustomSort(KeySort);
		end;
	end;
end;
//! o^Pǉ
function TInputAssistDM.Add(Key: String): TResistWord;
var
	resWord : TResistWord;
begin
	Result := nil;
	if (FDictionary <> nil) then begin
		resWord := TResistWord.Create;
		resWord.SetKey(Key);
		resWord.SetCategory('JeS');
		resWord.SetText('^');
		FDictionary.AddObject(Key, resWord);
		Result := resWord;
		if FSorted Then begin
			FDictionary.CustomSort(KeySort);
		end;
	end;
end;
//! o^P̃L[ύX
procedure TInputAssistDM.ChangeKey(ResistWord: TResistWord);
var
	i : Integer;
begin
	if (FDictionary <> nil) then begin
		for i := 0 to FDictionary.Count - 1 do begin
			if (ResistWord = FDictionary.Objects[i]) then begin
				FDictionary.Strings[i] := ResistWord.GetKey;
				break;
			end;
		end;
		if FSorted Then begin
			FDictionary.CustomSort(KeySort);
		end;

	end;
end;
//! Keyo^ĂP擾
function TInputAssistDM.GetStartWithKeyResistWords(Key: String; var list: TStringList): Integer;
var
	i : Integer;
	resWord : TResistWord;

begin
	Result := 0;
	if (FDictionary <> nil) and (list <> nil) then begin
		Key := ZenToHan(Key);
		for i := 0 to FDictionary.Count - 1 do begin
			if (AnsiPos(Key, ZenToHan(FDictionary.Strings[i])) = 1) then begin
				Inc(Result);
				resWord := TResistWord(FDictionary.Objects[i]);
				list.AddObject(resWord.GetKey + '(' +
								resWord.GetCategory + ')', resWord);
			end else if (Result > 0) then begin
				//\[gĂ邩AqbgΘA͂
				break;
			end;
		end;
	end;
end;
//! KeyJeSɎo^ĂP擾
function TInputAssistDM.GetStartWithCategoryResistWords(Key: String; var list: TStringList): Integer;
var
	i : Integer;
	resWord : TResistWord;
begin
	Result := 0;
	if (FDictionary <> nil) and (list <> nil) then begin
		Key := ZenToHan(Key);
		for i := 0 to FDictionary.Count - 1 do begin
			resWord := TResistWord(FDictionary.Objects[i]);
			if (AnsiPos(Key, ZenToHan(resWord.GetCategory)) = 1) then begin
				Inc(Result);
				list.AddObject(resWord.GetKey + '(' +
								resWord.GetCategory + ')', resWord);
			end;
		end;
		list.CustomSort(CategorySort);
	end;
end;

//! \[g̏Ԃ̎擾
function TInputAssistDM.GetSorted: Boolean;
begin
	Result := FSorted;
end;
//! \[gԂ̐ݒ
procedure TInputAssistDM.SetSorted(Value: Boolean);
begin
	if (not FSorted) and (Value) then begin
		FDictionary.CustomSort(KeySort);
	end;
	FSorted := Value;
end;
//! KeỹJeSɓo^ĂP擾
function TInputAssistDM.GetCategoryResistWords(Key: String; var list: TStringList): Integer;
var
	i : Integer;
	resWord : TResistWord;
begin
	Result := 0;
	if (FDictionary <> nil) and (list <> nil) then begin
		for i := 0 to FDictionary.Count - 1 do begin
			resWord := TResistWord(FDictionary.Objects[i]);
			if (Key = resWord.GetCategory) then begin
				Inc(Result);
				list.AddObject(resWord.GetKey + '(' +
								resWord.GetCategory + ')', resWord);
			end;
		end;
		list.CustomSort(CategorySort);
	end;
end;

//! o^ς݃L[̑SẴJeSXg擾
procedure TInputAssistDM.GetCategoryList(var list: TStringList);
var
	i : Integer;
begin
	if (FDictionary <> nil) and (list <> nil) then begin
		// d`FbNTStringList̋@\ōs
		list.Clear;
		list.Duplicates := dupIgnore;
		list.Sorted := true;
		list.BeginUpdate;
		for i := 0 to FDictionary.Count - 1 do begin
			list.Add(TResistWord(FDictionary.Objects[i]).GetCategory);
		end;
		list.EndUpdate;
	end;
end;

//! KeyJeSɎo^PԂ̃\[gpr\bh
function CategorySort(List: TStringList; Index1, Index2: Integer): Integer;
var
	resWord1 : TResistWord;
	resWord2 : TResistWord;
begin
	Result := 0;
	try
		resWord1 := TResistWord(List.Objects[Index1]);
		resWord2 := TResistWord(List.Objects[Index2]);
		Result := CompareStr(ZenToHan(resWord1.GetCategory),
								 ZenToHan(resWord2.GetCategory));
		if (Result = 0) then begin
			Result := CompareStr(ZenToHan(resWord1.GetKey),
									 ZenToHan(resWord2.GetKey));
		end;
	except
	end;
end;
//! KeySp̌`Ń\[gۂ̔r\bh
function KeySort(List: TStringList; Index1, Index2: Integer): Integer;
var
	resWord1 : TResistWord;
	resWord2 : TResistWord;
begin
	Result := 0;
	try
		resWord1 := TResistWord(List.Objects[Index1]);
		resWord2 := TResistWord(List.Objects[Index2]);
		Result := CompareStr(ZenToHan(resWord1.FKey),
								 ZenToHan(resWord2.FKey));
		if (Result = 0) then begin
			Result := CompareStr(ZenToHan(resWord1.GetCategory),
									 ZenToHan(resWord2.GetCategory));
		end;
	except
	end;
end;
//! ɓo^ς݂̃L[ƃJeS̃Zbgǂ`FbN
function TInputAssistDM.IsDupulicate(Key: String; Category: String): Boolean;
var
	i : Integer;
begin
	// ̃\bhł́A\[gς݂Ƃ͌Ȃ̂ŁASẴL[TĂ
	Result := False;
	if (FDictionary <> nil) then begin
		for i := 0 to FDictionary.Count - 1 do begin
			if (Key = FDictionary.Strings[i]) and
				(Category = TResistWord(FDictionary.Objects[i]).GetCategory)
			then begin
				Result := True;
				Break;
			end;
		end;
	end;
end;

end.
