unit WideMemo;

interface

uses
    Messages, Windows, Controls, StdCtrls, SysUtils, Classes, Types;

type
    TWideMemo = class;

    TWideMemo = class(TMemo)
private
    function GetEncodeText: AnsiString;
    procedure SetEncodeText(SrcText: AnsiString);
protected
    procedure CreateWindowHandle(const Params: TCreateParams); override;
public
    constructor Create(AOwner: TComponent); override;
    procedure InsertText(SrcText: AnsiString);
    property EncodeText: AnsiString read GetEncodeText write SetEncodeText;
end;


implementation

constructor TWideMemo.Create(AOwner: TComponent);
begin
    inherited Create(AOwner);
end;

procedure TWideMemo.CreateWindowHandle(const Params: TCreateParams);
//var
//    ClassName: WideString;
begin
    with Params do
    begin
//        ClassName := WideString(WinClassName);
//        WindowHandle := CreateWindowExW(ExStyle, PWideChar(ClassName), '', Style,
        WindowHandle := CreateWindowExW(ExStyle, 'EDIT', '', Style,
                                        X, Y, Width, Height, WndParent, 0,
                                        HInstance, Param);
//        SendMessage(WindowHandle, WM_SETTEXT, 0, Longint(Caption));
    end;
end;

function TWideMemo.GetEncodeText: AnsiString;
var
    Len: Integer;
    LenUC: Integer;
    BufUC: PWideChar;
    BufUCSize: Integer;
    BufSJ: array[0..16] of AnsiChar;
    UseDefChar: LongBool;
    Cnt: Integer;
    TextSJ: AnsiString;
begin
    Len := GetWindowTextLengthW(Handle);
    LenUC := Len + 1;
    BufUCSize := LenUC * SizeOf(WideChar);
    BufUC := AllocMem(BufUCSize);
    ZeroMemory(BufUC, BufUCSize);
    GetWindowTextW(Handle, BufUC, LenUC);

    WideCharToMultiByte(CP_ACP, 0, BufUC, LenUC, nil, 0, nil, @UseDefChar);
    if (UseDefChar = False) then begin
        Result := AnsiString(BufUC);
    end else begin
        for Cnt := 0 to Len do
        begin
            ZeroMemory(@BufSJ, 16);
            WideCharToMultiByte(CP_ACP, 0, @BufUC[Cnt], 1, BufSJ, 16, nil, @UseDefChar);
            if (UseDefChar = False) then begin
                TextSJ := TextSJ + AnsiString(BufSJ);
            end else begin
                TextSJ := TextSJ + Format('&#%d;', [Ord(BufUC[Cnt])]);
            end;
        end;
        Result := TextSJ;
    end;
    FreeMem(BufUC);
end;

procedure TWideMemo.SetEncodeText(SrcText: AnsiString);
var
    CodePos: Integer;
    TextSJ: AnsiString;
    TextUC: WideString;
    CodeSJ: AnsiString;
    CodeVal: Integer;
begin
    TextSJ := SrcText;
    while Length(TextSJ) > 0 do begin
        CodePos := AnsiPos('&#', TextSJ);
        if (CodePos < 1) then begin
            TextUC := TextUC + WideString(TextSJ);
            Break;
        end;
        if (CodePos > 1) then begin
            TextUC := TextUC + WideString(Copy(TextSJ, 1, CodePos - 1));
            Delete(TextSJ, 1, CodePos - 1);
        end;
        CodePos := AnsiPos(';', TextSJ);
        if (CodePos < 1) then begin
            TextUC := TextUC + WideString(TextSJ);
            Break;
        end;
        CodeSJ := Copy(TextSJ, 3, CodePos - 3);
        CodeVal := StrToIntDef(CodeSJ, 0);
        if ((CodeVal < 1) or (CodeVal > $FFFF)) then begin
            TextUC := TextUC + WideString(Copy(TextSJ, 1, CodePos));
        end else begin
            TextUC := TextUC + WideString(WideChar(CodeVal));
        end;
        Delete(TextSJ, 1, CodePos);
    end;

    SetWindowTextW(Handle, PWideChar(TextUC));
end;

procedure TWideMemo.InsertText(SrcText: AnsiString);
var
    LenUC: Integer;
    BufUC: PWideChar;
    BufUCSize: Integer;
    SelS: LongWord;
    SelE: LongWord;
    FullText: WideString;
    InsText: WideString;
    AftCurPos: LongInt;
begin
    InsText := WideString(SrcText);

    LenUC := GetWindowTextLengthW(Handle) + 1;
    BufUCSize := LenUC * SizeOf(WideChar);
    BufUC := AllocMem(BufUCSize);
    ZeroMemory(BufUC, BufUCSize);
    GetWindowTextW(Handle, BufUC, LenUC);
    FullText := WideString(BufUC);
    FreeMem(BufUC);

    SelS := 0;
    SelE := 0;
    SendMessageW(Handle, EM_GETSEL, WPARAM(@SelS), LPARAM(@SelE));

    if (SelS <> SelE) then
        Delete(FullText, SelS + 1, SelE - SelS);
    Insert(InsText, FullText, SelS + 1);

    SetWindowTextW(Handle, PWideChar(FullText));

    AftCurPos := LongInt(SelS) + Length(InsText);

    SendMessageW(Handle, EM_SETSEL, AftCurPos, AftCurPos);
end;

end.
