unit ThreadSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdHTTP, Menus, Clipbrd, IniFiles;

type
  TThreadSrch = class(TForm)
    Panel1: TPanel;
    ResultList: TListView;
    Label1: TLabel;
    BtnSearch: TButton;
    CmbType: TComboBox;
    Label2: TLabel;
    CmbMax: TComboBox;
    Label3: TLabel;
    CmbLim: TComboBox;
    Label4: TLabel;
    CmbSort: TComboBox;
    CmbBoard: TComboBox;
    Cmb924: TComboBox;
    Indy: TIdHTTP;
    ChkTop: TCheckBox;
    CmbKW: TComboBox;
    PopupMenu: TPopupMenu;
    MenuShowThread: TMenuItem;
    N1: TMenuItem;
    MenuCopyURL: TMenuItem;
    MenuCopyThread: TMenuItem;
    MenuCopyThrURL: TMenuItem;
    MessageList: TListBox;
    Splitter1: TSplitter;
    ChkBbs: TCheckBox;
    PnlBbsName: TPanel;
    PnlBbsId: TPanel;
    BtnBbs: TButton;
    PopMenuBbs: TPopupMenu;
    Label5: TLabel;
    LblSite: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure BtnSearchClick(Sender: TObject);
    procedure ResultListDblClick(Sender: TObject);
    procedure ChkTopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MenuShowThreadClick(Sender: TObject);
    procedure MenuCopyURLClick(Sender: TObject);
    procedure MenuCopyThreadClick(Sender: TObject);
    procedure MenuCopyThrURLClick(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure ChkBbsClick(Sender: TObject);
    procedure BtnBbsClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure LblSiteClick(Sender: TObject);
  private
    { Private 錾 }
    BbsNmList: TStringList;
    BbsIdList: TStringList;

    procedure AddHistory;
    function KWEncode(const KWSrc: String): String;
    function EncodeUtf8ToSJis(var SrcStream: TMemoryStream): String;
    procedure ParsHtml(HTML: String);
    function HTMLEncode(const SrcText: String): String;
    function SplitResCount(var Title: String): String;
    procedure InitHttpClient(client: TIdHttp);
    procedure ClearHttpClient(client: TIdHttp);
    procedure MenuBbsClick(Sender: TObject);
  public
    { Public 錾 }
    procedure SaveSetting;
  end;

function ConvertINetString(lpdwMode: LPDWORD;
                            dwSrcEncoding: DWORD;
                            dwDstEncoding: DWORD;
                            lpSrcStr: PChar;
                            lpnSrcSize: pointer;
                            lpDstStr: PChar;
                            lpnDstSize: pointer): HRESULT;
                                                stdcall; external 'mlang.dll';

var
  ThreadSrch: TThreadSrch;
const
    ENC_SJIS: DWORD = 932;
    ENC_UTF8: DWORD = 65001;

implementation

uses GikoSystem, GikoDataModule;

{$R *.dfm}

procedure TThreadSrch.FormCreate(Sender: TObject);
begin
    BbsNmList := TStringList.Create;
    BbsIdList := TStringList.Create;

    Top    := GikoSys.Setting.ThrdSrchTop;
    Left   := GikoSys.Setting.ThrdSrchLeft;
    Width  := GikoSys.Setting.ThrdSrchWidth;
    Height := GikoSys.Setting.ThrdSrchHeight;
    if (GikoSys.Setting.ThrdSrchMax = True) then
        WindowState := wsMaximized;
    if (GikoSys.Setting.ThrdSrchStay = True) then begin
        ChkTop.Checked := True;
        FormStyle := fsStayOnTop;
    end;
    ResultList.Column[0].Width := GikoSys.Setting.ThrdSrchCol1W;
    ResultList.Column[1].Width := GikoSys.Setting.ThrdSrchCol2W;
    ResultList.Column[2].Width := GikoSys.Setting.ThrdSrchCol3W;
    ResultList.Column[3].Width := GikoSys.Setting.ThrdSrchCol4W;
    CmbKW.Items.AddStrings(GikoSys.Setting.ThrdSrchHistory);
end;

procedure TThreadSrch.BtnSearchClick(Sender: TObject);
const
    BBS_VALUE: array[0..19] of string = (
                                            'all',				// SĂ̔
                                            'newsplus',			// {
                                            'mnewsplus',		// |{
                                            'U_plus',			// {S
                                            'U_live',			// S
                                            'G_game',			// Q[G
                                            'G_entame',			// |\EerG
                                            'G_subcal',			// TuJG
                                            'G_base',			// 싅G
                                            'G_soccer',			// TbJ[G
                                            'G_pc',				// PC֌WG
                                            'G_academy',		// wEG
                                            'G_female',			// G
                                            'G_world',			// G
                                            'G_eastasia',		// ہEG
                                            'G_fareast',		// ɓG
                                            'G_operate',		// ^cG
                                            'S_bbspink',		// bbspinkI
                                            'morningcoffee',	// TB
                                            'poverty'			// 
                                        );
var
    URL: String;
    RspStream: TMemoryStream;
    HTML: String;
    Ok: Boolean;
    Board: String;
begin
    ResultList.Clear;

    Screen.Cursor := crHourGlass;

    AddHistory;

    if (ChkBbs.Checked = True) then
        Board := PnlBbsId.Caption
    else
        Board := BBS_VALUE[CmbBoard.ItemIndex];

    URL := 'http://dig.2ch.net/?keywords=' + KWEncode(CmbKW.Text)
            + '&AndOr='      + IntToStr(CmbType.ItemIndex)
            + '&maxResult='  + CmbMax.Text
            + '&atLeast='    + CmbLim.Text
            + '&Sort='       + IntToStr(CmbSort.ItemIndex)
            + '&Link=1&Bbs=' + Board
            + '&924='        + IntToStr(Cmb924.ItemIndex);
//    Application.MessageBox(PChar(URL), 'debug', MB_OK);

    RspStream := TMemoryStream.Create;

    Ok := False;
    InitHttpClient(Indy);
    try
        Indy.Get(URL, RspStream);
        Ok := True;
    except
        on E: Exception do begin
            MessageList.Items.Add('G[F' + E.Message);
        end;
    end;

    if (Ok = True) and (RspStream.Size > 0) then begin
        HTML := EncodeUtf8ToSJis(RspStream);
        if (HTML = '') then     // ϊs̏ꍇ1񂾂gC
            HTML := EncodeUtf8ToSJis(RspStream);
        if (HTML = '') then begin
            Ok := False;
            MessageList.Items.Add('G[FR[hϊs');
        end;
    end;

    RspStream.Free;

    if (Ok = True) then begin
        if (Length(HTML) > 0) then
            ParsHtml(HTML);
        MessageList.Items.Add(Format('y%szʁF%d', [CmbKW.Text, ResultList.Items.Count]));
    end;

    MessageList.TopIndex := MessageList.Count - 1;

    Screen.Cursor := crDefault;
end;

procedure TThreadSrch.AddHistory;
const
    HISTORY_MAX: Integer = 20;
var
    KW: String;
    Idx: Integer;
begin
    if (CmbKW.Text = '') then
        Exit;
    KW := CmbKW.Text;
    Idx := CmbKW.Items.IndexOf(KW);
    if (Idx <> 0) then begin
        if (Idx > 0) then
            CmbKW.Items.Delete(Idx);
        CmbKW.Items.Insert(0, KW);
        CmbKW.Text := KW;
    end;
    while (CmbKW.Items.Count > HISTORY_MAX) do begin
        CmbKW.Items.Delete(CmbKW.Items.Count - 1);
    end;
end;

function TThreadSrch.KWEncode(const KWSrc: String): String;
const
    BufSize: Integer = 1024;
var
    KWEnc: String;
    CnvSjis: String;
    Utf8: array [0..1023] of Byte;
    Cnt: Integer;
    Cnt2: Integer;
    Len: Integer;
    SrcSize: Integer;
    DstSize: Integer;
    Stat: HRESULT;
    Max: Integer;
begin
    Len := Length(KWSrc);
    if (Len < 1) then begin
        Result := '';
        Exit;
    end;

    Cnt := 1;
    while (Cnt <= Len) do begin
        case ByteType(KWSrc, Cnt) of
            mbSingleByte: begin
                if (KWSrc[Cnt] >= #$80) then begin
                    CnvSjis := CnvSjis + Copy(KWSrc, Cnt, 1);
                end else begin
                    SrcSize := Length(CnvSjis);
                    if (SrcSize > 0) then begin
                        ZeroMemory(@Utf8, BufSize);
                        DstSize := BufSize;
                        Stat := ConvertINetString(nil, ENC_SJIS, ENC_UTF8,
                                    PChar(CnvSjis), @SrcSize, PChar(@Utf8), @DstSize);
                        if (Stat = S_OK) and (DstSize > 0) then begin
                            Max := DstSize - 1;
                            for Cnt2 := 0 to Max do begin
                                KWEnc := KWEnc + '%' + Format('%02X', [Utf8[Cnt2], 0]);
                            end;
                        end;
                        CnvSjis := '';
                    end;

                    if (((KWSrc[Cnt] >= '0') and (KWSrc[Cnt] <= '9')) or
                             ((KWSrc[Cnt] >= 'A') and (KWSrc[Cnt] <= 'Z')) or
                             ((KWSrc[Cnt] >= 'a') and (KWSrc[Cnt] <= 'z')) or
                             (KWSrc[Cnt] = '-') or (KWSrc[Cnt] = '.') or
                             (KWSrc[Cnt] = '_') or (KWSrc[Cnt] = '~')) then begin
                        KWEnc := KWEnc + Copy(KWSrc, Cnt, 1);
                    end else if (KWSrc[Cnt] = ' ') then begin
                        KWEnc := KWEnc + '+';
                    end else begin
                        KWEnc := KWEnc + '%' + Format('%02X', [Ord(KWSrc[Cnt])]);
                    end;
                end;
            end;
            mbLeadByte: begin
                CnvSjis := CnvSjis + Copy(KWSrc, Cnt, 2);
                Cnt := Cnt + 1;
            end;
            mbTrailByte: begin
            end;
        end;
        Cnt := Cnt + 1;
    end;

    SrcSize := Length(CnvSjis);
    if (SrcSize > 0) then begin
        ZeroMemory(@Utf8, BufSize);
        DstSize := BufSize;
        Stat := ConvertINetString(nil, ENC_SJIS, ENC_UTF8,
                                    PChar(CnvSjis), @SrcSize, PChar(@Utf8), @DstSize);
        if (Stat = S_OK) and (DstSize > 0) then begin
            Max := DstSize - 1;
            for Cnt2 := 0 to Max do begin
                KWEnc := KWEnc + '%' + Format('%02X', [Utf8[Cnt2]]);
            end;
        end;
    end;

    Result := KWEnc;
end;

function TThreadSrch.EncodeUtf8ToSJis(var SrcStream: TMemoryStream): String;
//const
//    CNV_SRC: array[0..2] of Byte = ($E3, $80, $9C);
//    CNV_DST: array[0..2] of Byte = ($EF, $BD, $9E);
var
    Buf: PChar;
    BufSize: Integer;
    SrcSize: Integer;
    Stat: HRESULT;
//    Data: PByteArray;
//    Cnt: Integer;
//    Max: Integer;
begin
    SrcStream.Position := 0;
    SrcSize := SrcStream.Size;
    BufSize := SrcSize * 2;
    Buf := AllocMem(BufSize);
    ZeroMemory(Buf, BufSize);
(*
    // u`vShiftJISɂȂR[h̕ɕϊĂ邽ߒu
    Data := PByteArray(SrcStream.Memory);
    Max := SrcSize - 2;
    Cnt := 0;
    while (Cnt < Max) do begin
        if (Data[Cnt] = CNV_SRC[0]) then begin
            if (Data[Cnt + 1] = CNV_SRC[1]) and (Data[Cnt + 2] = CNV_SRC[2]) then begin
                Data[Cnt    ] := CNV_DST[0];
                Data[Cnt + 1] := CNV_DST[1];
                Data[Cnt + 2] := CNV_DST[2];
                Cnt := Cnt + 2;
            end;
        end;
        Cnt := Cnt + 1;
    end;
*)
    Stat := ConvertINetString(nil, ENC_UTF8, ENC_SJIS,
                                SrcStream.Memory, @SrcSize, Buf, @BufSize);
    if (Stat = S_OK) or (Stat = S_FALSE) then begin     // S_FALSEFϊłȂ̂͐
        Result := String(Buf);
    end else begin
        Result := '';
    end;

    FreeMem(Buf);
end;

procedure TThreadSrch.ParsHtml(HTML: String);
const
    KW_START: String = '܂ / S';
    KW_LINE_S: String = '%d[<a href=';
    KW_BBS_S: String = '<font color="saddlebrown">';
    KW_BBS_E: String = '</font>';
    KW_MAE_S: String = '<span class="mae">';
    KW_URL_S: String = '<a href="';
    KW_URL_E: String = '">';
    KW_THR_E: String = '</a>';
var
    Pos1: Integer;
    Cnt: Integer;
    KW: String;
    Item: TListItem;
    Title: String;
    ResNum: String;
    URL: String;
begin

    Pos1 := Pos(KW_START, HTML);
    if (Pos1 < 1) then
        Exit;
    Delete(HTML, 1, Pos1);

    for Cnt := 1 to 1000 do begin
        KW := Format(KW_LINE_S, [Cnt]);
        Pos1 := Pos(KW, HTML);
        if (Pos1 < 1) then
            Break;
        Delete(HTML, 1, Pos1);

        Pos1 := Pos(KW_BBS_S, HTML);
        if (Pos1 < 1) then
            Break;
        Delete(HTML, 1, Pos1 + Length(KW_BBS_S) - 1);

        Pos1 := Pos(KW_BBS_E, HTML);
        if (Pos1 < 1) then
            Break;

        Item := ResultList.Items.Add;
        Item.Caption := Copy(HTML, 1, Pos1 - 1);

        Pos1 := Pos(KW_MAE_S, HTML);
        if (Pos1 < 1) then
            Break;
        Delete(HTML, 1, Pos1);

        Pos1 := Pos(KW_URL_S, HTML);
        if (Pos1 < 1) then
            Break;
        Delete(HTML, 1, Pos1 + Length(KW_URL_S) - 1);

        Pos1 := Pos(KW_URL_E, HTML);
        if (Pos1 < 1) then
            Break;
        URL := Trim(Copy(HTML, 1, Pos1 - 1));
        Delete(HTML, 1, Pos1 + Length(KW_URL_E) - 1);

        Pos1 := Pos(KW_THR_E, HTML);
        if (Pos1 < 1) then
            Break;
        Title := HTMLEncode(Copy(HTML, 1, Pos1 - 1));
        ResNum := SplitResCount(Title);
        Item.SubItems.Add(Title);
        Item.SubItems.Add(ResNum);
        Item.SubItems.Add(URL);
    end;

end;

function TThreadSrch.HTMLEncode(const SrcText: String): String;
const
    KW_SRC: array[1..4] of String = ('&quot;', '&lt;', '&gt;', '&amp;');
    KW_DST: array[1..4] of String = ('"',      '<',    '>',    '&');
var
    Cnt: Integer;
    PosKW: Integer;
    DstText: String;
begin
    DstText := SrcText;

    for Cnt := 1 to 4 do begin
        while (True) do begin
            PosKW := Pos(KW_SRC[Cnt], DstText);
            if (PosKW < 1) then
                Break;
            Delete(DstText, PosKW, Length(KW_SRC[Cnt]));
            Insert(KW_DST[Cnt], DstText, PosKW);
        end;
    end;
    Result := DstText;
end;

function TThreadSrch.SplitResCount(var Title: String): String;
var
    Len: Integer;
    Cnt: Integer;
    Res: String;
begin
    Len := Length(Title);
    if (Title[Len] <> ')') then
        Exit;

    for Cnt := Len - 1 downto 1 do begin
        if (Title[Cnt] = '(') then begin
            Res := Copy(Title, Cnt + 1, Len - Cnt - 1);
            SetLength(Title, Cnt - 1);
            Break;
        end;
    end;
    Result := Res;
end;

procedure TThreadSrch.InitHttpClient(client: TIdHttp);
begin
	ClearHttpClient(client);
	client.Disconnect;
	client.Request.UserAgent := GikoSys.GetUserAgent;
	client.RecvBufferSize := Gikosys.Setting.RecvBufferSize;
	client.ProxyParams.BasicAuthentication := False;
	client.ReadTimeout := GikoSys.Setting.ReadTimeOut;
    client.ConnectTimeout := GikoSys.Setting.ReadTimeOut;
	{$IFDEF DEBUG}
	Writeln('------------------------------------------------------------');
	{$ENDIF}
	//FIndy.AllowCookies := False;
	if GikoSys.Setting.ReadProxy then begin
		if GikoSys.Setting.ProxyProtocol then
			client.ProtocolVersion := pv1_1
		else
			client.ProtocolVersion := pv1_0;
		client.ProxyParams.ProxyServer := GikoSys.Setting.ReadProxyAddress;
		client.ProxyParams.ProxyPort := GikoSys.Setting.ReadProxyPort;
		client.ProxyParams.ProxyUsername := GikoSys.Setting.ReadProxyUserID;
		client.ProxyParams.ProxyPassword := GikoSys.Setting.ReadProxyPassword;
		if GikoSys.Setting.ReadProxyUserID <> '' then
			client.ProxyParams.BasicAuthentication := True;
		{$IFDEF DEBUG}
		Writeln('vLVݒ肠');
		Writeln('zXg: ' + GikoSys.Setting.ReadProxyAddress);
		Writeln('|[g: ' + IntToStr(GikoSys.Setting.ReadProxyPort));
		{$ENDIF}
	end else begin
		if GikoSys.Setting.Protocol then
			client.ProtocolVersion := pv1_1
		else
			client.ProtocolVersion := pv1_0;
		client.ProxyParams.ProxyServer := '';
		client.ProxyParams.ProxyPort := 80;
		client.ProxyParams.ProxyUsername := '';
		client.ProxyParams.ProxyPassword := '';
		{$IFDEF DEBUG}
		Writeln('vLVݒȂ');
		{$ENDIF}
	end;
end;

procedure TThreadSrch.ClearHttpClient(client: TIdHttp);
begin
	client.Request.CustomHeaders.Clear;
	client.Request.RawHeaders.Clear;
	client.Request.Clear;
	client.Response.CustomHeaders.Clear;
	client.Response.RawHeaders.Clear;
	client.Response.Clear;

	client.ProxyParams.Clear;
end;

procedure TThreadSrch.ResultListDblClick(Sender: TObject);
begin
    MenuShowThreadClick(MenuShowThread);
end;

procedure TThreadSrch.ChkTopClick(Sender: TObject);
begin
    if (ChkTop.Checked = True) then
        FormStyle := fsStayOnTop
    else
        FormStyle := fsNormal;
end;

procedure TThreadSrch.SaveSetting;
begin
    GikoSys.Setting.ThrdSrchTop := Top;
    GikoSys.Setting.ThrdSrchLeft := Left;
    GikoSys.Setting.ThrdSrchWidth := Width;
    GikoSys.Setting.ThrdSrchHeight := Height;
    if (WindowState = wsMaximized) then
        GikoSys.Setting.ThrdSrchMax := True
    else
        GikoSys.Setting.ThrdSrchMax := False;
    if (ChkTop.Checked = True) then
        GikoSys.Setting.ThrdSrchStay := True
    else
        GikoSys.Setting.ThrdSrchStay := False;
    GikoSys.Setting.ThrdSrchCol1W := ResultList.Column[0].Width;
    GikoSys.Setting.ThrdSrchCol2W := ResultList.Column[1].Width;
    GikoSys.Setting.ThrdSrchCol3W := ResultList.Column[2].Width;
    GikoSys.Setting.ThrdSrchCol4W := ResultList.Column[3].Width;
    GikoSys.Setting.ThrdSrchHistory.Clear;
    GikoSys.Setting.ThrdSrchHistory.AddStrings(CmbKW.Items);
end;

procedure TThreadSrch.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    SaveSetting;
end;

procedure TThreadSrch.MenuShowThreadClick(Sender: TObject);
begin
    if (ResultList.Selected <> nil) then
        GikoDM.MoveURLWithHistory(ResultList.Selected.SubItems[2]);
end;

procedure TThreadSrch.MenuCopyURLClick(Sender: TObject);
begin
    if (ResultList.Selected <> nil) then
        Clipboard.AsText := ResultList.Selected.SubItems[2];
end;

procedure TThreadSrch.MenuCopyThreadClick(Sender: TObject);
begin
    if (ResultList.Selected <> nil) then
        Clipboard.AsText := ResultList.Selected.SubItems[0];
end;

procedure TThreadSrch.MenuCopyThrURLClick(Sender: TObject);
begin
    if (ResultList.Selected <> nil) then
        Clipboard.AsText := ResultList.Selected.SubItems[0] + #13#10
                          + ResultList.Selected.SubItems[2];
end;

procedure TThreadSrch.PopupMenuPopup(Sender: TObject);
var
    Enb: Boolean;
begin
    if (ResultList.Selected = nil) then
        Enb := False
    else
        Enb := True;
    MenuShowThread.Enabled := Enb;
    MenuCopyURL.Enabled    := Enb;
    MenuCopyThread.Enabled := Enb;
    MenuCopyThrURL.Enabled := Enb;
end;

procedure TThreadSrch.ChkBbsClick(Sender: TObject);
begin
    if (ChkBbs.Checked = True) then begin
        CmbBoard.Enabled := False;
        PnlBbsName.Font.Color := clWindowText;
        PnlBbsId.Font.Color := clWindowText;
        BtnBbs.Enabled := True;
    end else begin
        CmbBoard.Enabled := True;
        PnlBbsName.Font.Color := clGrayText;
        PnlBbsId.Font.Color := clGrayText;
        BtnBbs.Enabled := False;
    end;
end;

procedure TThreadSrch.BtnBbsClick(Sender: TObject);
var
    CliPos: TPoint;
    ScrPos: TPoint;
begin
    CliPos.X := PnlBbsName.Left;
    CliPos.Y := 0;
    ScrPos := ClientToScreen(CliPos);

    PopMenuBbs.Popup(ScrPos.X, ScrPos.Y);
end;

procedure TThreadSrch.FormShow(Sender: TObject);
var
    Ini: TIniFile;
    Sec: TStringList;
    Itm: TStringList;
    IdxSec: Integer;
    IdxItm: Integer;
    MaxSec: Integer;
    MaxItm: Integer;
    SecItem: TMenuItem;
    BbsItem: TMenuItem;
    SecName: String;
    BbsName: String;
    BbsId: String;
    SepPos: Integer;
begin
    ResultList.Clear;
    MessageList.Clear;
    CmbKW.Text := '';
    CmbType.ItemIndex := 0;
    CmbMax.ItemIndex := 3;
    CmbLim.ItemIndex := 0;
    CmbSort.ItemIndex := 5;
    CmbBoard.ItemIndex := 0;
    Cmb924.ItemIndex := 1;
    ChkBbs.Checked := False;
    ChkBbsClick(ChkBbs);
    PnlBbsName.Caption := '';
    PnlBbsId.Caption := '';

    PopMenuBbs.Items.Clear;
    BbsNmList.Clear;
    BbsIdList.Clear;

    Sec := TStringList.Create;
    Itm := TStringList.Create;
    Ini := TIniFile.Create(GikoSys.GetBoardFileName);

    Ini.ReadSections(Sec);

    MaxSec := Sec.Count - 1;
    if (MaxSec > 0) then begin
        for IdxSec := 0 to MaxSec do begin
            SecName := Sec.Strings[IdxSec];
            SecItem := TMenuItem.Create(PopMenuBbs);
            PopMenuBbs.Items.Add(SecItem);
            SecItem.Caption := SecName;

            Ini.ReadSection(SecName, Itm);
            MaxItm := Itm.Count - 1;
            if (MaxItm > 0) then begin
                for IdxItm := 0 to MaxItm do begin
                    BbsName := Itm.Strings[IdxItm];
                    BbsId   := Ini.ReadString(SecName, BbsName, '');
                    SepPos := Pos('.2ch.net/', BbsId);
                    if (SepPos > 0) then
                        Delete(BbsId, 1, SepPos + Length('.2ch.net/') - 1);
                    SepPos := Pos('.bbspink.com/', BbsId);
                    if (SepPos > 0) then
                        Delete(BbsId, 1, SepPos + Length('.bbspink.com/') - 1);
                    SepPos := Pos('/', BbsId);
                    if (SepPos > 0) then
                        SetLength(BbsId, SepPos - 1);

                    BbsItem := TMenuItem.Create(PopMenuBbs);
                    SecItem.Add(BbsItem);
                    BbsItem.Caption := BbsName;
                    BbsNmList.Add('y' + SecName + 'zy' + BbsName + 'z');
                    BbsIdList.Add(BbsId);
                    BbsItem.Tag := BbsIdList.Count - 1;
                    BbsItem.OnClick := MenuBbsClick;
                end;
            end;
        end;
    end;

    Ini.Free;
    Itm.Free;
    Sec.Free;

end;

procedure TThreadSrch.MenuBbsClick(Sender: TObject);
var
    SelItem: TMenuItem;
    BbsName: String;
    BbsId: String;
begin
    if (Sender <> nil) then begin
        SelItem := TMenuItem(Sender);
        if (SelItem.Tag >= 0) and (SelItem.Tag < BbsNmList.Count) then begin
            BbsName := BbsNmList.Strings[SelItem.Tag];
            BbsId   := BbsIdList.Strings[SelItem.Tag];
        end;
    end;
    PnlBbsName.Caption := BbsName;
    PnlBbsId.Caption   := BbsId;
end;

procedure TThreadSrch.FormDestroy(Sender: TObject);
begin
    BbsNmList.Free;
    BbsIdList.Free;
end;

procedure TThreadSrch.LblSiteClick(Sender: TObject);
begin
	GikoSys.OpenBrowser(PChar(LblSite.Caption), gbtAuto);
end;

end.
