package glpkeclipse.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class GlpkConfiguration extends SourceViewerConfiguration {
	private GlpkDoubleClickStrategy doubleClickStrategy;
	private GlpkTagScanner tagScanner;
	private GlpkScanner scanner;
	private ColorManager colorManager;

	public GlpkConfiguration(ColorManager colorManager) {
		this.colorManager = colorManager;
	}
	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[] {
			IDocument.DEFAULT_CONTENT_TYPE,
			GlpkPartitionScanner.GLPK_COMMENT,
			GlpkPartitionScanner.GLPK_TAG };
	}
	public ITextDoubleClickStrategy getDoubleClickStrategy(
		ISourceViewer sourceViewer,
		String contentType) {
		if (doubleClickStrategy == null)
			doubleClickStrategy = new GlpkDoubleClickStrategy();
		return doubleClickStrategy;
	}

	protected GlpkScanner getGlpkScanner() {
		if (scanner == null) {
			scanner = new GlpkScanner(colorManager);
			scanner.setDefaultReturnToken(
				new Token(
					new TextAttribute(
						colorManager.getColor(IGlpkColorConstants.DEFAULT))));
		}
		return scanner;
	}
	protected GlpkTagScanner getGlpkTagScanner() {
		if (tagScanner == null) {
			tagScanner = new GlpkTagScanner(colorManager);
			tagScanner.setDefaultReturnToken(
				new Token(
					new TextAttribute(
						colorManager.getColor(IGlpkColorConstants.TAG))));
		}
		return tagScanner;
	}

	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		PresentationReconciler reconciler = new PresentationReconciler();

		DefaultDamagerRepairer dr =
			new DefaultDamagerRepairer(getGlpkTagScanner());
		reconciler.setDamager(dr, GlpkPartitionScanner.GLPK_TAG);
		reconciler.setRepairer(dr, GlpkPartitionScanner.GLPK_TAG);

		dr = new DefaultDamagerRepairer(getGlpkScanner());
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);

		NonRuleBasedDamagerRepairer ndr =
			new NonRuleBasedDamagerRepairer(
				new TextAttribute(
					colorManager.getColor(IGlpkColorConstants.GLPK_COMMENT)));
		reconciler.setDamager(ndr, GlpkPartitionScanner.GLPK_COMMENT);
		reconciler.setRepairer(ndr, GlpkPartitionScanner.GLPK_COMMENT);

		return reconciler;
	}

}