/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Environment;
import jp.co.olympus.camerakit.OLYCameraLog;
import jp.co.olympus.camerakit.OLYPublicAPI;

@OLYPublicAPI
public class OACentralConfiguration {
    private String a;
    private String b;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OACentralConfiguration load() {
        String bleName = null;
        String bleCode = null;
        SQLiteDatabase database = null;
        Cursor cursor = null;
        try {
            String storagePath = Environment.getExternalStorageDirectory().getAbsolutePath();
            String databasePath = storagePath + "/OLYMPUS/.olydb/OlyAirInfo.db";
            String table = "oly_air_info";
            String[] columns = new String[]{"ble_device_neme", "ble_passcode"};
            database = SQLiteDatabase.openDatabase((String)databasePath, null, (int)1);
            cursor = database.query("oly_air_info", columns, null, null, null, null, null, null);
            int indexOfName = cursor.getColumnIndex(columns[0]);
            int indexOfCode = cursor.getColumnIndex(columns[1]);
            if (cursor.moveToNext()) {
                bleName = cursor.getString(indexOfName);
                bleCode = cursor.getString(indexOfCode);
            }
        }
        catch (SQLiteException e2) {
            OLYCameraLog.w("Could not access to OA.Central's database.: %s", e2.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (database != null) {
                database.close();
            }
        }
        OACentralConfiguration configuration = new OACentralConfiguration();
        configuration.a = bleName;
        configuration.b = bleCode;
        return configuration;
    }

    private OACentralConfiguration() {
    }

    @OLYPublicAPI
    public String getBleName() {
        return this.a;
    }

    @OLYPublicAPI
    public String getBleCode() {
        return this.b;
    }
}

