﻿Option Explicit On
Option Strict On

Imports System.Windows.Controls.Primitives

''' <summary>画像テキスト付大型ボタンクラス。</summary>
''' <remarks>
''' 画像とテキストを表示する大型ボタン情報を格納する。
''' </remarks>
Public NotInheritable Class LargeButtonInfo
    Inherits System.Windows.Controls.Control

    ' XAMLで使用することを宣言
    Shared Sub New()
        DefaultStyleKeyProperty.OverrideMetadata(GetType(LargeButtonInfo), New FrameworkPropertyMetadata(GetType(LargeButtonInfo)))
    End Sub

    ' 表示するテキスト
    Private mText As String

    ' 表示する画像
    Private mImage As ImageSource

#Region "properties"

    ''' <summary>表示するテキスト。</summary>
    ''' <value>文字列型。</value>
    Public Property TextContent() As String
        Get
            Return Me.mText
        End Get
        Set(value As String)
            Me.mText = value
        End Set
    End Property

    ''' <summary>表示する画像。</summary>
    ''' <value>画像データ。</value>
    Public Property ImageContent() As ImageSource
        Get
            Return Me.mImage
        End Get
        Set(value As ImageSource)
            Me.mImage = value
        End Set
    End Property

#End Region

End Class
