﻿Option Explicit On
Option Strict On

Imports System.Windows.Media.Animation

''' <summary>ページ名コントロール。</summary>
''' <remarks>
''' インクページの名前を表示するためのコントロール。
''' </remarks>
Public NotInheritable Class PageNameControl

    ''' <summary>コンストラクタ。</summary>
    Public Sub New()
        InitializeComponent()
        Me.DataContext = Me
    End Sub

    ''' <summary>マウス侵入イベントハンドラ。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Private Sub UserControl_MouseEnter(sender As Object, e As MouseEventArgs)
        If Me.nameText.Text.Trim() <> String.Empty Then
            DirectCast(Me.Resources("OnMouseEnterAnime"), Storyboard).Begin()
        End If
    End Sub

    ''' <summary>マウス離脱イベントハンドラ。</summary>
    ''' <param name="sender">イベント発行元。</param>
    ''' <param name="e">イベントオブジェクト。</param>
    Private Sub UserControl_MouseLeave(sender As Object, e As MouseEventArgs)
        If Me.nameText.Text.Trim() <> String.Empty Then
            DirectCast(Me.Resources("OnMouseLeaveAnime"), Storyboard).Begin()
        End If
    End Sub

#Region "properties"

    ''' <summary>表示するページ名。</summary>
    ''' <value>文字列型。</value>
    Public Property PageName() As String
        Get
            Return Me.nameText.Text
        End Get
        Set(value As String)
            Me.nameText.Text = value

            If value <> String.Empty Then
                Me.ToolTip = "マウスリリースを遅らせると編集できます"
            Else
                Me.ToolTip = Nothing
            End If
        End Set
    End Property

#End Region

End Class
