#! C:\Perl\bin\perl 
#
# usage: perl make_aalt.pl glyphlist.txt aalt_all.fea > aalt.fea

use strict;
use warnings;
use utf8;

my @cid = ();

open(LIST, "<:utf8", $ARGV[0]) or die "$!";

while (<LIST>) {
  if (/\{(\d+)/) {
    $cid[$1] = 1;
  }
}

close(LIST);


open(AALT, "<:utf8", $ARGV[1]) or die "$!";

while (<AALT>) {
  my @array = /\\(\d+)/g;
  my $target = shift(@array);
  if (!$target) {
    print "$_";
  } elsif ($cid[$target]) {
    my @by = ();
    my $i = 0;
    foreach (@array) {
      $by[$i++] = "\\" . $_ if ($cid[$_]);
    }
    $target = "\\" . $target;
    if ($#by == 0) {
      print "  sub $target by $by[0];\n";
    } elsif ($#by > 0) {
      print "  sub $target from [@by];\n";
    }
  }
}

close(AALT);

exit;
