#include "angband.h"
#include "gameoption.h"

/*!
 * @brief IvVe[u /
 * Available Options
 */
const option_type option_info[] =
{
	/*** Input Options ***/

	{ &rogue_like_commands,         FALSE, OPT_PAGE_INPUT, 0, 0,
	"rogue_like_commands",          _("[OL[zugp", "Rogue-like commands") },

	{ &always_pickup,               FALSE, OPT_PAGE_INPUT, 0, 5,
	"always_pickup",                _("ɃACeE" , "Pick things up by default") },

	{ &carry_query_flag,            FALSE, OPT_PAGE_INPUT, 0, 3,
	"carry_query_flag",             _("ACeEOɊmF", "Prompt before picking things up") },

	{ &quick_messages,              TRUE,  OPT_PAGE_INPUT, 0, 1,
	"quick_messages",               _("NCbNEbZ[Wgp", "Activate quick messages") },

	{ &auto_more,                   FALSE, OPT_PAGE_INPUT, 2, 6,
	"auto_more",                    _("L[҂ȂŘAŃbZ[W\", "Automatically clear '-more-' prompts") },

	{ &command_menu,                TRUE,  OPT_PAGE_INPUT, 2, 7,
	"command_menu",                 _("j[ɂR}hILɂ", "Enable command selection menu") },

	{ &other_query_flag,            FALSE, OPT_PAGE_INPUT, 0, 2,
	"other_query_flag",             _("̃ACegpƂɊmF", "Prompt for floor item selection") },

	{ &use_old_target,              FALSE, OPT_PAGE_INPUT, 0, 4,
	"use_old_target",               _("ɈȑÕ^[Qbgw肷", "Use old target by default") },

	{ &always_repeat,               TRUE,  OPT_PAGE_INPUT, 0, 6,
	"always_repeat",                _("R}hJԂ", "Repeat obvious commands") },

	{ &confirm_destroy,             FALSE, OPT_PAGE_INPUT, 5, 3,
	"confirm_destroy",              _("ulvȃACej󂷂鎞mF", "Prompt for destruction of known worthless items") },

	{ &confirm_wear,                TRUE,  OPT_PAGE_INPUT, 5, 4,
	"confirm_wear",                 _("ꂽ𑕔鎞mF", "Confirm to wear/wield known cursed items") },

	{ &confirm_quest,               TRUE,  OPT_PAGE_INPUT, 1, 9,
	"confirm_quest",                _("NGXg߂ĊKiœOɊmF", "Prompt before exiting a quest level") },

	{ &target_pet,                  FALSE, OPT_PAGE_INPUT, 2, 5,
	"target_pet",                   _("ybg^[Qbgɂ", "Allow targetting pets") },

#ifdef ALLOW_EASY_OPEN
{ &easy_open,                   TRUE,  OPT_PAGE_INPUT, 5, 7,
"easy_open",                    _("IɃhAJ", "Automatically open doors") },
#endif /* ALLOW_EASY_OPEN */

#ifdef ALLOW_EASY_DISARM
{ &easy_disarm,                 TRUE,  OPT_PAGE_INPUT, 5, 8,
"easy_disarm",                  _("I㩂", "Automatically disarm traps") },
#endif /* ALLOW_EASY_DISARM */

#ifdef ALLOW_EASY_FLOOR /* TNB */
{ &easy_floor,                  FALSE, OPT_PAGE_INPUT, 5, 9,
"easy_floor",                   _("ŏdȂACeXg", "Display floor stacks in a list") },
#endif /* ALLOW_EASY_FLOOR -- TNB */

{ &use_command,                 FALSE, OPT_PAGE_INPUT, 5, 10,
"use_command",                  _("ug(a)vR}hŃACełg", "Allow unified use command") },

{ &over_exert,                  FALSE, OPT_PAGE_INPUT, 0, 29,
"over_exert",                   _("MPȂĂ@ɒ킷", "Allow casting spells when short of mana") },

{ &numpad_as_cursorkey,         TRUE, OPT_PAGE_INPUT, 2, 31,
"numpad_as_cursorkey",          _("GfB^ŃeL[J[\L[ƂĎg", "Use numpad keys as cursor keys in editor mode") },

/*** Map Screen Options ***/

{ &center_player,               FALSE, OPT_PAGE_MAPSCREEN, 5, 11,
"center_player",                _("ɃvC[𒆐Sɒu(*x*)", "Center map while walking (*slow*)") },

{ &center_running,              TRUE,  OPT_PAGE_MAPSCREEN, 5, 12,
"center_running",               _("Ă鎞łSɒu", "Centering even while running") },

{ &view_yellow_lite,            TRUE,  OPT_PAGE_MAPSCREEN, 1, 28,
"view_yellow_lite",             _("͈̔͂ʂȐFŕ\", "Use special colors for torch-lit grids") },

{ &view_bright_lite,            TRUE,  OPT_PAGE_MAPSCREEN, 1, 29,
"view_bright_lite",             _("E͈̔͂ʂȐFŕ\", "Use special colors for 'viewable' grids") },

{ &view_granite_lite,           TRUE,  OPT_PAGE_MAPSCREEN, 1, 30,
"view_granite_lite",            _("ǂʂȐFŕ\(d)", "Use special colors for wall grids (slow)") },

{ &view_special_lite,           TRUE,  OPT_PAGE_MAPSCREEN, 1, 31,
"view_special_lite",            _("ʂȐFŕ\(d)", "Use special colors for floor grids (slow)") },

{ &view_perma_grids,            TRUE,  OPT_PAGE_MAPSCREEN, 1, 6,
"view_perma_grids",             _("邢ꏊ͂̂܂܂ɂ", "Map remembers all perma-lit grids") },

{ &view_torch_grids,            FALSE, OPT_PAGE_MAPSCREEN, 1, 7,
"view_torch_grids",             _("ŏƂ炵ꏊ͂̂܂܂ɂ", "Map remembers all torch-lit grids") },

{ &view_unsafe_grids,           FALSE, OPT_PAGE_MAPSCREEN, 1, 8,
"view_unsafe_grids",            _("gbvmς݂łȂꏊ\", "Map marked by detect traps") },

{ &view_reduce_view,            FALSE, OPT_PAGE_MAPSCREEN, 1, 17,
"view_reduce_view",             _("Xł͎", "Reduce view-radius in town") },

{ &fresh_before,                TRUE,  OPT_PAGE_MAPSCREEN, 1, 23,
"fresh_before",                 _("AR}hɉʂĕ`悵", "Flush output while continuous command") },

{ &fresh_after,                 FALSE, OPT_PAGE_MAPSCREEN, 1, 24,
"fresh_after",                  _("R}hɉʂɍĕ`悵", "Flush output after monster's move") },

{ &fresh_message,               FALSE, OPT_PAGE_MAPSCREEN, 1, 25,
"fresh_message",                _("bZ[W̌ɉʂĕ`悷", "Flush output after every message") },

{ &hilite_player,               FALSE, OPT_PAGE_MAPSCREEN, 1, 27,
"hilite_player",                _("vC[ɃJ[\킹", "Hilite the player with the cursor") },

{ &display_path,                FALSE, OPT_PAGE_MAPSCREEN, 2, 8,
"display_path",                 _("@̋OՂ\", "Display actual path before shooting") },

/*** Text Display Options ***/

{ &plain_descriptions,          TRUE,  OPT_PAGE_TEXT, 5, 1,
"plain_descriptions",           _("ACe̋Lqȗɂ", "Plain object descriptions") },

{ &plain_pickup,                FALSE, OPT_PAGE_TEXT, 6, 6,
"plain_pickup",                 _("uEvbZ[Wȗ", "Plain pickup messages(japanese only)") },

{ &always_show_list,            TRUE,  OPT_PAGE_TEXT, 4, 0,
"always_show_list",             _("Iɂ͏Ɉꗗ\", "Always show list when choosing items") },

{ &depth_in_feet,               FALSE, OPT_PAGE_TEXT, 0, 7,
"depth_in_feet",                _("_W̐[tB[gŕ\", "Show dungeon level in feet") },

{ &show_labels,                 TRUE,  OPT_PAGE_TEXT, 0, 10,
"show_labels",                  _("ꗗőꏊ\", "Show labels in object listings") },

{ &show_weights,                TRUE,  OPT_PAGE_TEXT, 0, 11,
"show_weights",                 _("ACeꗗŏdʂ\", "Show weights in object listings") },

{ &show_item_graph,             TRUE,  OPT_PAGE_TEXT, 2, 0,
"show_item_graph",              _("ACẽV{\", "Show items graphics") },

{ &equippy_chars,               TRUE,  OPT_PAGE_TEXT, 1, 12,
"equippy_chars",                _("Xe[^Xɕő\", "Display 'equippy' chars") },

{ &display_mutations,           FALSE, OPT_PAGE_TEXT, 5, 0,
"display_mutations",            _("'C'R}hœˑRψق\", "Display mutations in 'C'haracter Display") },

{ &compress_savefile,           FALSE, OPT_PAGE_TEXT, 1, 26,
"compress_savefile",            _("Z[uEt@C̃bZ[Wk", "Compress messages in savefiles") },

{ &abbrev_extra,                FALSE, OPT_PAGE_TEXT, 2, 10,
"abbrev_extra",                 _("ACeɒǉϐ/\̗͂̂", "Describe obj's extra resistances by abbreviation") },

{ &abbrev_all,                  FALSE, OPT_PAGE_TEXT, 2, 11,
"abbrev_all",                   _("ACeɑSĂ̑ϐ/\̗͂̂", "Describe obj's all resistances by abbreviation") },

{ &exp_need,                    FALSE, OPT_PAGE_TEXT, 2, 12,
"exp_need",                     _("̃xɕKvȌol\", "Show the experience needed for next level") },

{ &ignore_unview,               FALSE, OPT_PAGE_TEXT, 2, 13,
"ignore_unview",                _("EÕX^[̍s\Ȃ", "Ignore whenever any monster does") },

{ &show_ammo_detail,            TRUE, OPT_PAGE_TEXT, 2, 14,
"show_ammo_detail",             _("ẽ_[W̐\", "Show description of ammo damage") },

{ &show_ammo_no_crit,           FALSE, OPT_PAGE_TEXT, 2, 15,
"show_ammo_no_crit",            _("SlȂꍇ̖ẽ_[W\", "Show ammo damage with no critical") },

{ &show_ammo_crit_ratio,           FALSE, OPT_PAGE_TEXT, 2, 16,
"show_ammo_crit_ratio",            _("ẻS\", "Show critical ratio of ammo") },


/*** Game-Play ***/

{ &stack_force_notes,           TRUE,  OPT_PAGE_GAMEPLAY, 0, 8,
"stack_force_notes",            _("قȂ̃ACe܂Ƃ߂", "Merge inscriptions when stacking") },

{ &stack_force_costs,           FALSE, OPT_PAGE_GAMEPLAY, 0, 9,
"stack_force_costs",            _("قȂ銄\̃ACe܂Ƃ߂", "Merge discounts when stacking") },

{ &expand_list,                 TRUE,  OPT_PAGE_GAMEPLAY, 1, 5,
"expand_list",                  _("uꗗvR}hg", "Expand the power of the list commands") },

{ &small_levels,                TRUE,  OPT_PAGE_GAMEPLAY, 0, 30,
"small_levels",                 _("ɏtA̐\ɂ", "Allow unusually small dungeon levels") },

{ &always_small_levels,         FALSE, OPT_PAGE_GAMEPLAY, 2, 3,
"always_small_levels",          _("ɔɏtA𐶐", "Always create unusually small dungeon levels") },

{ &empty_levels,                TRUE,  OPT_PAGE_GAMEPLAY, 0, 31,
"empty_levels",                 _("ۂ́uA[ivx̐\ɂ", "Allow empty 'arena' levels") },

{ &bound_walls_perm,            FALSE, OPT_PAGE_GAMEPLAY, 2, 1,
"bound_walls_perm",             _("_W̊Oǂivɂ", "Boundary walls become 'permanent wall'") },

{ &last_words,                  TRUE,  OPT_PAGE_GAMEPLAY, 0, 28,
"last_words",                   _("LN^[񂾎⌾̂", "Leave last words when your character dies") },

#ifdef WORLD_SCORE
{ &send_score,                  TRUE,  OPT_PAGE_GAMEPLAY, 4, 6,
"send_score",                   _("XRAT[oɃXRA𑗂", "Send score dump to the world score server") },
#endif

{ &allow_debug_opts,            FALSE, OPT_PAGE_GAMEPLAY, 6, 11,
"allow_debug_opts",             _("fobO/\IvV", "Allow use of debug/cheat options") },

/*** Disturbance ***/

{ &find_ignore_stairs,          FALSE, OPT_PAGE_DISTURBANCE, 0, 16,
"find_ignore_stairs",           _("Ki͒ʉ߂", "Run past stairs") },

{ &find_ignore_doors,           TRUE,  OPT_PAGE_DISTURBANCE, 0, 17,
"find_ignore_doors",            _("hA͒ʉ߂", "Run through open doors") },

{ &find_cut,                    FALSE, OPT_PAGE_DISTURBANCE, 0, 18,
"find_cut",                     _("Ȃp΂߂ɍŒZŒʉ߂", "Run past known corners") },

{ &check_abort,                 TRUE,  OPT_PAGE_DISTURBANCE, 1, 18,
"check_abort",                  _("AR}h̓L[͂Œf", "Check for user abort while continuous command") },

{ &flush_failure,               TRUE,  OPT_PAGE_DISTURBANCE, 1, 20,
"flush_failure",                _("lXȃ~Xɓ͂NA", "Flush input on various failures") },

{ &flush_disturb,               FALSE, OPT_PAGE_DISTURBANCE, 1, 21,
"flush_disturb",                _("Qɓ͂NA", "Flush input whenever disturbed") },

{ &disturb_move,                FALSE, OPT_PAGE_DISTURBANCE, 0, 20,
"disturb_move",                 _("ǂ̃X^[Ăs𒆎~", "Disturb whenever any monster moves") },

{ &disturb_high,                FALSE, OPT_PAGE_DISTURBANCE, 1, 3,
"disturb_high",                 _("x̍X^[s𒆎~", "Disturb whenever high-level monster moves") },

{ &disturb_near,                TRUE,  OPT_PAGE_DISTURBANCE, 0, 21,
"disturb_near",                 _("ẼX^[s𒆎~", "Disturb whenever viewable monster moves") },

{ &disturb_pets,                FALSE, OPT_PAGE_DISTURBANCE, 5, 6,
"disturb_pets",                 _("Ẽybgs𒆎~", "Disturb when visible pets move") },

{ &disturb_panel,               TRUE,  OPT_PAGE_DISTURBANCE, 0, 22,
"disturb_panel",                _("ʃXN[ɍs𒆎~", "Disturb whenever map panel changes") },

{ &disturb_state,               TRUE,  OPT_PAGE_DISTURBANCE, 0, 23,
"disturb_state",                _("̃Xe[^Xωɍs𒆎~", "Disturb whenever player state changes") },

{ &disturb_minor,               TRUE,  OPT_PAGE_DISTURBANCE, 0, 24,
"disturb_minor",                _("ׂȂƂNĂs𒆎~", "Disturb whenever boring things happen") },

{ &ring_bell,                   FALSE, OPT_PAGE_DISTURBANCE, 0, 14,
"ring_bell",                    _("G[Ƀr[v炷", "Audible bell (on errors, etc)") },

{ &disturb_trap_detect,         TRUE,  OPT_PAGE_DISTURBANCE, 0, 27,
"disturb_trap_detect",          _("gbvm͈͊Oɏo钼Oɍs𒆎~", "Disturb when leaving trap detected area") },

{ &alert_trap_detect,           FALSE, OPT_PAGE_DISTURBANCE, 0, 25,
"alert_trap_detect",            _("gbvm͈͊Oɏo钼OɌx", "Alert when leaving trap detected area") },

/*** Birth Options ***/
{ &manual_haggle,               FALSE, OPT_PAGE_BIRTH, 1, 0,
"manual_haggle",                _("XŒl؂", "Manually haggle in stores") },

{ &easy_band,                   FALSE, OPT_PAGE_BIRTH, 6, 31,
"easy_band",                    _("SҗpȒP[h(*)", "Easy Mode (*)") },

{ &smart_learn,                 TRUE,  OPT_PAGE_BIRTH, 1, 14,
"smart_learn",                  _("X^[͎swK(*)", "Monsters learn from their mistakes (*)") },

{ &smart_cheat,                 FALSE, OPT_PAGE_BIRTH, 1, 15,
"smart_cheat",                  _("X^[̓vC[݂̎˂(*)", "Monsters exploit players weaknesses (*)") },

{ &vanilla_town,                FALSE, OPT_PAGE_BIRTH, 6, 0,
"vanilla_town",                 _("c̊X/NGXgƍrȂ", "Use 'vanilla' town without quests and wilderness") },

{ &lite_town,                   FALSE, OPT_PAGE_BIRTH, 6, 1,
"lite_town",                    _("K͂ȊX/rȂ", "Use 'lite' town without a wilderness") },

{ &ironman_shops,               FALSE, OPT_PAGE_BIRTH, 6, 2,
"ironman_shops",                _("(Slp)XgpȂ(*)", "Stores are permanently closed (*)") },

{ &ironman_small_levels,        FALSE, OPT_PAGE_BIRTH, 6, 3,
"ironman_small_levels",         _("(Slp)ɔɏtA𐶐(*)", "Always create unusually small dungeon levels (*)") },

{ &ironman_downward,            FALSE, OPT_PAGE_BIRTH, 6, 4,
"ironman_downward",             _("(Slp)A҂ƏKiȂ(*)", "Disable recall and use of up stairs (*)") },

{ &ironman_empty_levels,        FALSE, OPT_PAGE_BIRTH, 6, 8,
"ironman_empty_levels",         _("(Slp)ɋۂ̃A[ix𐶐(*)", "Always create empty 'arena' levels (*)") },

{ &ironman_rooms,               FALSE, OPT_PAGE_BIRTH, 6, 12,
"ironman_rooms",                _("(Slp)ɕʂłȂ𐶐(*)", "Always generate very unusual rooms (*)") },

{ &ironman_nightmare,           FALSE, OPT_PAGE_BIRTH, 6, 18,
"ironman_nightmare",            _("(Slp)[h(͑Ss𗝂łI)(*)", "Nightmare mode(it isn't even remotely fair!)(*)") },

{ &left_hander,                 FALSE, OPT_PAGE_BIRTH, 6, 13,
"left_hander",                  _("ł", "Left-Hander") },

{ &preserve_mode,               TRUE,  OPT_PAGE_BIRTH, 6, 14,
"preserve_mode",                _("`̃ACe蓦ĂĐ(*)", "Preserve artifacts (*)") },

{ &autoroller,                  TRUE,  OPT_PAGE_BIRTH, 6, 15,
"autoroller",                   _("\͒lɃI[g[[gp(*)", "Allow use of autoroller for stats (*)") },

{ &autochara,                   FALSE, OPT_PAGE_BIRTH, 6, 16,
"autochara",                   _("̊i/nʂɃI[g[[gp", "Autoroll for weight, height and social status") },

{ &powerup_home,                TRUE,  OPT_PAGE_BIRTH, 4, 3,
"powerup_home",                 _("䂪Ƃg(*)", "Increase capacity of your home (*)") },

/*** Easy Object Auto-Destroyer ***/

{ &destroy_items,               FALSE, OPT_PAGE_AUTODESTROY, 7, 0,
"destroy_items",                _("ACe̊ȈՎjgp", "Use easy auto-destroyer") },

{ &destroy_feeling,             FALSE, OPT_PAGE_AUTODESTROY, 7, 8,
"destroy_feeling",              _("ȈՊӒ肵ƂjKp", "Apply auto-destroy as sense feeling") },

{ &destroy_identify,            FALSE, OPT_PAGE_AUTODESTROY, 7, 9,
"destroy_identify",             _("Ӓ肵ƂjKp", "Apply auto-destroy as identify an item") },

{ &leave_worth,                 TRUE,  OPT_PAGE_AUTODESTROY, 7, 2,
"leave_worth",                  _("lACe͉󂳂Ȃ", "Auto-destroyer leaves known worthy items") },

{ &leave_equip,                 FALSE, OPT_PAGE_AUTODESTROY, 7, 3,
"leave_equip",                  _("/h͉󂳂Ȃ", "Auto-destroyer leaves weapons and armour") },

{ &leave_chest,                 TRUE,  OPT_PAGE_AUTODESTROY, 7, 7,
"leave_chest",                  _("JĂȂ͉󂳂Ȃ", "Auto-destroyer leaves closed chests") },

{ &leave_wanted,                TRUE,  OPT_PAGE_AUTODESTROY, 7, 4,
"leave_wanted",                 _("܋̎/͉󂳂Ȃ", "Auto-destroyer leaves wanted corpses") },

{ &leave_corpse,                FALSE, OPT_PAGE_AUTODESTROY, 7, 5,
"leave_corpse",                 _("/͉󂳂Ȃ", "Auto-destroyer leaves corpses and skeletons") },

{ &leave_junk,                  FALSE, OPT_PAGE_AUTODESTROY, 7, 6,
"leave_junk",                   _("炭͉󂳂Ȃ", "Auto-destroyer leaves junk") },

{ &leave_special,               TRUE,  OPT_PAGE_AUTODESTROY, 7, 1,
"leave_special",                _("푰/EƂœʂɕKvȃACe͉󂳂Ȃ", "Auto-destroyer leaves items your race/class needs") },

/*** Play-record Options ***/

{ &record_fix_art,              TRUE,  OPT_PAGE_PLAYRECORD, 4, 11,
"record_fix_art",               _("ŒA[eBt@Ng̓L^", "Record fixed artifacts") },

{ &record_rand_art,             TRUE,  OPT_PAGE_PLAYRECORD, 4, 12,
"record_rand_art",              _("_A[eBt@Ng̓L^", "Record random artifacts") },

{ &record_destroy_uniq,         TRUE,  OPT_PAGE_PLAYRECORD, 4, 13,
"record_destroy_uniq",          _("j[NX^[|ƂL^", "Record when destroy unique monster") },

{ &record_fix_quest,            TRUE,  OPT_PAGE_PLAYRECORD, 4, 14,
"record_fix_quest",             _("ŒNGXg̒BL^", "Record fixed quests") },

{ &record_rand_quest,           TRUE,  OPT_PAGE_PLAYRECORD, 4, 15,
"record_rand_quest",            _("_NGXg̒BL^", "Record random quests") },

{ &record_maxdepth,             TRUE,  OPT_PAGE_PLAYRECORD, 4, 16,
"record_maxdepth",              _("Ő[KXVƂɋL^", "Record movements to deepest level") },

{ &record_stair,                TRUE,  OPT_PAGE_PLAYRECORD, 4, 17,
"record_stair",                 _("K̈ړL^", "Record recall and stair movements") },

{ &record_buy,                  TRUE,  OPT_PAGE_PLAYRECORD, 4, 18,
"record_buy",                   _("ACe̍wL^", "Record purchased items") },

{ &record_sell,                 FALSE, OPT_PAGE_PLAYRECORD, 4, 19,
"record_sell",                  _("ACe̔pL^", "Record sold items") },

{ &record_danger,               TRUE,  OPT_PAGE_PLAYRECORD, 4, 20,
"record_danger",                _("s`ɂȂƂL^", "Record hitpoint warning") },

{ &record_arena,                TRUE,  OPT_PAGE_PLAYRECORD, 4, 21,
"record_arena",                 _("A[ił̏L^", "Record arena victories") },

{ &record_ident,                TRUE,  OPT_PAGE_PLAYRECORD, 4, 22,
"record_ident",                 _("̃ACe̎ʂL^", "Record first identified items") },

{ &record_named_pet,            FALSE, OPT_PAGE_PLAYRECORD, 4, 23,
"record_named_pet",             _("Oybg̏L^", "Record informations of named pets") },

/*** End of Table ***/

{ NULL,                         0, 0, 0, 0,
NULL,                           NULL }
};
