/*!
 * @file selfinfo.c
 * @brief ȕ͏/ Self knowledge
 * @date 2018/09/07
 * @author
 * <pre>
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 * </pre>
 * 2018 Deskull
 * @details
 * spell2s.c番
 */

#include "angband.h"

/*!
 * @brief ȕ͏(Nethack̃ACfA) / self-knowledge... idea from nethack.
 * @return Ȃ
 * @details
 * <pre>
 * Useful for determining powers and
 * resistences of items.  It saves the screen, clears it, then starts listing
 * attributes, a screenful at a time.  (There are a LOT of attributes to
 * list.  It will probably take 2 or 3 screens for a powerful character whose
 * using several artifacts...) -CFT
 *
 * It is now a lot more efficient. -BEN-
 *
 * See also "identify_fully()".
 *
 * XXX XXX XXX Use the "show_file()" method, perhaps.
 * </pre>
 */
void self_knowledge(void)
{
	int i = 0, j, k;

	int v_nr = 0;
	char v_string [8] [128];
	char s_string [6] [128];

	u32b flgs[TR_FLAG_SIZE];

	object_type *o_ptr;

	char Dummy[80];
	char buf[2][80];

	cptr info[220];

	int plev = p_ptr->lev;

	int percent;

	for (j = 0; j < TR_FLAG_SIZE; j++)
		flgs[j] = 0L;

	p_ptr->knowledge |= (KNOW_STAT | KNOW_HPRATE);

	strcpy(Dummy, "");

	percent = (int)(((long)p_ptr->player_hp[PY_MAX_LEVEL - 1] * 200L) /
		(2 * p_ptr->hitdie +
		((PY_MAX_LEVEL - 1+3) * (p_ptr->hitdie + 1))));

	sprintf(Dummy, _("݂̗̑̓N : %d/100", "Your current Life Rating is %d/100."), percent);
	strcpy(buf[0], Dummy);
	info[i++] = buf[0];
	info[i++] = "";

	chg_virtue(V_KNOWLEDGE, 1);
	chg_virtue(V_ENLIGHTEN, 1);

	/* Acquire item flags from equipment */
	for (k = INVEN_RARM; k < INVEN_TOTAL; k++)
	{
		u32b tflgs[TR_FLAG_SIZE];

		o_ptr = &inventory[k];

		/* Skip non-objects */
		if (!o_ptr->k_idx) continue;

		/* Extract the flags */
		object_flags(o_ptr, tflgs);

		/* Extract flags */
		for (j = 0; j < TR_FLAG_SIZE; j++)
			flgs[j] |= tflgs[j];
	}

	info[i++] = _("\͂̍ől", "Limits of maximum stats");

	for (v_nr = 0; v_nr < 6; v_nr++)
	{
		char stat_desc[80];

		sprintf(stat_desc, "%s 18/%d", stat_names[v_nr], p_ptr->stat_max_max[v_nr]-18);

		strcpy(s_string[v_nr], stat_desc);

		info[i++] = s_string[v_nr];
	}
	info[i++] = "";

	sprintf(Dummy, _("݂̑ : %s(%ld)", "Your alighnment : %s(%ld)"), your_alignment(), (long int)p_ptr->align);
	strcpy(buf[1], Dummy);
	info[i++] = buf[1];
	for (v_nr = 0; v_nr < 8; v_nr++)
	{
		char vir_name [20];
		char vir_desc[80];
		int tester = p_ptr->virtues[v_nr];
	
		strcpy(vir_name, virtue[(p_ptr->vir_types[v_nr])-1]);
 
		sprintf(vir_desc, _("ƁB%s̏ȂB", "Oops. No info about %s."), vir_name);
		if (tester < -100)
			sprintf(vir_desc, _("[%s]̑΋ (%d)", "You are the polar opposite of %s (%d)."),
				vir_name, tester);
		else if (tester < -80)
			sprintf(vir_desc, _("[%s]̑G (%d)", "You are an arch-enemy of %s (%d)."),
				vir_name, tester);
		else if (tester < -60)
			sprintf(vir_desc, _("[%s]̋G (%d)", "You are a bitter enemy of %s (%d)."),
				vir_name, tester);
		else if (tester < -40)
			sprintf(vir_desc, _("[%s]̓G (%d)", "You are an enemy of %s (%d)."),
				vir_name, tester);
		else if (tester < -20)
			sprintf(vir_desc, _("[%s]̍ߎ (%d)", "You have sinned against %s (%d)."),
				vir_name, tester);
		else if (tester < 0)
			sprintf(vir_desc, _("[%s]̖ (%d)", "You have strayed from the path of %s (%d)."),
				vir_name, tester);
		else if (tester == 0)
			sprintf(vir_desc, _("[%s]̒ (%d)", "You are neutral to %s (%d)."),
				vir_name, tester);
		else if (tester < 20)
			sprintf(vir_desc, _("[%s]̏ (%d)", "You are somewhat virtuous in %s (%d)."),
				vir_name, tester);
		else if (tester < 40)
			sprintf(vir_desc, _("[%s]̒ (%d)", "You are virtuous in %s (%d)."),
				vir_name, tester);
		else if (tester < 60)
			sprintf(vir_desc, _("[%s]̍ (%d)", "You are very virtuous in %s (%d)."),
				vir_name, tester);
		else if (tester < 80)
			sprintf(vir_desc, _("[%s]̔e (%d)", "You are a champion of %s (%d)."),
				vir_name, tester);
		else if (tester < 100)
			sprintf(vir_desc, _("[%s]̈̑Ȕe (%d)", "You are a great champion of %s (%d)."),
				vir_name, tester);
		else
			sprintf(vir_desc, _("[%s]̋ (%d)", "You are the living embodiment of %s (%d)."),
				vir_name, tester);
	
		strcpy(v_string[v_nr], vir_desc);
	
		info[i++] = v_string[v_nr];
	}
	info[i++] = "";
	
	/* Racial powers... */
	if (p_ptr->mimic_form)
	{
		switch (p_ptr->mimic_form)
		{
			case MIMIC_DEMON:
			case MIMIC_DEMON_LORD:
			sprintf(Dummy, _("Ȃ %d _[W̒nΉ̃uXfƂłB(%d MP)", 
							"You can nether breathe, dam. %d (cost %d)."), 3 * plev, 10+plev/3);

				info[i++] = Dummy;
			break;
		case MIMIC_VAMPIRE:
			if (plev > 1)
			{
				sprintf(Dummy, _("Ȃ͓G %d-%d HP ̐͂złB(%d MP)", 
								"You can steal life from a foe, dam. %d-%d (cost %d)."),
				    plev + MAX(1, plev / 10), plev + plev * MAX(1, plev / 10), 1 + (plev / 3));
				info[i++] = Dummy;
			}
			break;
		}
	}
	else
	{
	switch (p_ptr->prace)
	{
		case RACE_NIBELUNG:
		case RACE_DWARF:
			if (plev > 4)
			info[i++] = _("Ȃ㩂ƃhAƊKimłB(5 MP)", "You can find traps, doors and stairs (cost 5).");
			break;
		case RACE_HOBBIT:
			if (plev > 14)
			{
				info[i++] = _("Ȃ͐H𐶐łB(10 MP)", "You can produce food (cost 10).");
			}
			break;
		case RACE_GNOME:
			if (plev > 4)
			{
				sprintf(Dummy, _("Ȃ͔͈ %d ȓɃe|[głB(%d MP)", "You can teleport, range %d (cost %d)."),
				    (1 + plev), (5 + (plev / 5)));
				info[i++] = Dummy;
			}
			break;
		case RACE_HALF_ORC:
			if (plev > 2)
				info[i++] = _("Ȃ͋|łB(5 MP)", "You can remove fear (cost 5).");
			break;
		case RACE_HALF_TROLL:
			if (plev > 9)
				info[i++] = _("Ȃ͋\邱ƂłB(12 MP) ", "You enter berserk fury (cost 12).");
			break;
		case RACE_AMBERITE:
			if (plev > 29)
				info[i++] = _("Ȃ̓VhEVtg邱ƂłB(50 MP)", "You can Shift Shadows (cost 50).");

			if (plev > 39)
				info[i++] = _("Ȃ́up^[vSɕ`ĕƂłB(75 MP)", "You can mentally Walk the Pattern (cost 75).");

			break;
		case RACE_BARBARIAN:
			if (plev > 7)
				info[i++] = _("Ȃ͋\邱ƂłB(10 MP) ", "You can enter berserk fury (cost 10).");

			break;
		case RACE_HALF_OGRE:
			if (plev > 24)
				info[i++] = _("Ȃ͔̃[d|邱ƂłB(35 MP)", "You can set an Explosive Rune (cost 35).");

			break;
		case RACE_HALF_GIANT:
			if (plev > 19)
				info[i++] = _("Ȃ͐΂̕ǂ󂷂ƂłB(10 MP)", "You can break stone walls (cost 10).");
			break;
		case RACE_HALF_TITAN:
			if (plev > 34)
				info[i++] = _("Ȃ̓X^[XL邱ƂłB(20 MP)", "You can probe monsters (cost 20).");
			break;
		case RACE_CYCLOPS:
			if (plev > 19)
			{
				sprintf(Dummy, _("Ȃ %d _[W̊΂𓊂邱ƂłB(15 MP)", 
							 "You can throw a boulder, dam. %d (cost 15)."), 3 * plev);
				info[i++] = Dummy;
			}
			break;
		case RACE_YEEK:
			if (plev > 14)
				info[i++] = _("Ȃ͋|ĂыNѐ𔭂邱ƂłB(15 MP)", "You can make a terrifying scream (cost 15).");
			break;
		case RACE_KLACKON:
			if (plev > 8)
			{
				sprintf(Dummy, _("Ȃ %d _[W̎_𐁂邱ƂłB(9 MP)", "You can spit acid, dam. %d (cost 9)."), plev);
				info[i++] = Dummy;
			}
			break;
		case RACE_KOBOLD:
			if (plev > 11)
			{
				sprintf(Dummy,
						_("Ȃ %d _[W̓Ŗ𓊂邱ƂłB(8 MP)", "You can throw a dart of poison, dam. %d (cost 8)."), plev);
				info[i++] = Dummy;
			}
			break;
		case RACE_DARK_ELF:
			if (plev > 1)
			{
				sprintf(Dummy, _("Ȃ %d _[W̃}WbNE~TC̎gB(2 MP)", "You can cast a Magic Missile, dam %d (cost 2)."),
				    (3 + ((plev-1) / 5)));
				info[i++] = Dummy;
			}
			break;
		case RACE_DRACONIAN:
			sprintf(Dummy, _("Ȃ %d _[W̃uXfƂłB(%d MP)", "You can breathe, dam. %d (cost %d)."), 2 * plev, plev);
			info[i++] = Dummy;
			break;
		case RACE_MIND_FLAYER:
			if (plev > 14)
				sprintf(Dummy, _("Ȃ %d _[W̐_U邱ƂłB(12 MP)", "You can mind blast your enemies, dam %d (cost 12)."), plev);
			info[i++] = Dummy;
			break;
		case RACE_IMP:
			if (plev > 29)
			{
				sprintf(Dummy, _("Ȃ %d _[W̃t@CAE{[̎gB(15 MP)", "You can cast a Fire Ball, dam. %d (cost 15)."), plev);
				info[i++] = Dummy;
			}
			else if (plev > 8)
			{
				sprintf(Dummy, _("Ȃ %d _[W̃t@CAE{g̎gB(15 MP)", "You can cast a Fire Bolt, dam. %d (cost 15)."), plev);
				info[i++] = Dummy;
			}
			break;
		case RACE_GOLEM:
			if (plev > 19)
				info[i++] = _("Ȃ d20+30 ^[̊Ԕ΂ɕωB(15 MP)", "You can turn your skin to stone, dur d20+30 (cost 15).");
			break;
		case RACE_ZOMBIE:
		case RACE_SKELETON:
			if (plev > 29)
				info[i++] = _("Ȃ͎ol񕜂邱ƂłB(30 MP)", "You can restore lost experience (cost 30).");
			break;
		case RACE_VAMPIRE:
			if (plev > 1)
			{
				sprintf(Dummy, _("Ȃ͓G %d-%d HP ̐͂złB(%d MP)", "You can steal life from a foe, dam. %d-%d (cost %d)."),
				    plev + MAX(1, plev / 10), plev + plev * MAX(1, plev / 10), 1 + (plev / 3));
				info[i++] = Dummy;
			}
			break;
		case RACE_SPECTRE:
			if (plev > 3)
			{
				info[i++] = _("Ȃ͋œG|邱ƂłB(3 MP)", "You can wail to terrify your enemies (cost 3).");
			}
			break;
		case RACE_SPRITE:
			if (plev > 11)
			{
				info[i++] = _("Ȃ͓G𖰂点閂@̕𓊂邱ƂłB(12 MP)", "You can throw magical dust which induces sleep (cost 12).");
			}
			break;
		case RACE_DEMON:
			sprintf(Dummy, _("Ȃ %d _[W̒nΉ̃uXfƂłB(%d MP)", 
						"You can breathe nether, dam. %d (cost %d)."), 3 * plev, 10+plev/3);

			info[i++] = Dummy;
			break;
		case RACE_KUTAR:
			if (plev > 19)
				info[i++] = _("Ȃ d20+30 ^[̊ԉɐLт邱ƂłB(15 MP)", "You can expand horizontally, dur d20+30 (cost 15).");
			break;
		case RACE_ANDROID:
			if (plev < 10)
				sprintf(Dummy, _("Ȃ %d _[W̃CKƂłB(7 MP)", "You can fire a ray gun with damage %d (cost 7)."), 
					(plev + 1) / 2);
			else if (plev < 25)
				sprintf(Dummy, _("Ȃ %d _[W̃uX^[ƂłB(13 MP)", "You can fire a blaster with damage %d (cost 13)."), plev);
			else if (plev < 35)
				sprintf(Dummy, _("Ȃ %d _[W̃oY[JƂłB(26 MP)", "You can fire a bazooka with damage %d (cost 26)."), plev * 2);
			else if (plev < 45)
				sprintf(Dummy, _("Ȃ %d _[W̃r[LmƂłB(40 MP)", 
						"You can fire a beam cannon with damage %d (cost 40)."), plev * 2);
			else
				sprintf(Dummy, _("Ȃ %d _[W̃PbgƂłB(60 MP)", 
						"You can fire a rocket with damage %d (cost 60)."), plev * 5);

			info[i++] = Dummy;
			break;
		default:
			break;
	}
	}

	switch(p_ptr->pclass)
	{
		case CLASS_WARRIOR:
			if (plev > 39)
			{
				info[i++] = _("Ȃ̓_ȕɑ΂ĐU邱ƂłB(75 MP)", 
							"You can attack some random directions at a time (cost 75).");
			}
			break;
		case CLASS_HIGH_MAGE:
			if (p_ptr->realm1 == REALM_HEX) break;
		case CLASS_MAGE:
		case CLASS_SORCERER:
			if (plev > 24)
			{
				info[i++] = _("Ȃ̓ACe̖͂z邱ƂłB(1 MP)", 
						"You can absorb charges from an item (cost 1).");
			}
			break;
		case CLASS_PRIEST:
			if (is_good_realm(p_ptr->realm1))
			{
				if (plev > 34)
				{
					info[i++] = _("Ȃ͕j邱ƂłB(70 MP)", "You can bless a weapon (cost 70).");
				}
			}
			else
			{
				if (plev > 41)
				{
					info[i++] = _("Ȃׂ͎̂ẴX^[U邱ƂłB(40 MP)", "You can damages all monsters in sight (cost 40).");
				}
			}
			break;
		case CLASS_ROGUE:
			if (plev > 7)
			{
				info[i++] = _("Ȃ͍Uđɓ邱ƂłB(12 MP)", "You can hit a monster and teleport at a time (cost 12).");
			}
			break;
		case CLASS_RANGER:
			if (plev > 14)
			{
				info[i++] = _("Ȃ͉𒲍邱ƂłB(20 MP)", "You can prove monsters (cost 20).");
			}
			break;
		case CLASS_PALADIN:
			if (is_good_realm(p_ptr->realm1))
			{
				if (plev > 29)
				{
					info[i++] = _("Ȃ͐Ȃ鑄ƂłB(30 MP)", "You can fires a holy spear (cost 30).");
				}
			}
			else
			{
				if (plev > 29)
				{
					info[i++] = _("Ȃ͐͂鑄ƂłB(30 MP)", "You can fires a spear which drains vitality (cost 30).");
				}
			}
			break;
		case CLASS_WARRIOR_MAGE:
			if (plev > 24)
			{
				info[i++] = _("Ȃ͂goloɕϊ邱ƂłB(0 MP)", "You can convert HP to SP (cost 0).");
				info[i++] = _("Ȃ͂logoɕϊ邱ƂłB(0 MP)", "You can convert SP to HP (cost 0).");
			}
			break;
		case CLASS_CHAOS_WARRIOR:
			if (plev > 39)
			{
				info[i++] = _("Ȃ͎͂ɉf킷𔭐邱ƂłB(50 MP)",
						"You can radiate light which confuses nearby monsters (cost 50).");
			}
			break;
		case CLASS_MONK:
			if (plev > 24)
			{
				info[i++] = _("Ȃ͍\邱ƂłB(0 MP)", "You can assume a posture of special form (cost 0).");
			}
			if (plev > 29)
			{
				info[i++] = _("Ȃ͒ʏ2{̍UsƂłB(30 MP)", "You can perform double attacks in a time (cost 30).");
			}
			break;
		case CLASS_MINDCRAFTER:
		case CLASS_FORCETRAINER:
			if (plev > 14)
			{
				info[i++] = _("Ȃ͐_WĂlo񕜂邱ƂłB(0 MP)", "You can concentrate to regenerate your mana (cost 0).");
			}
			break;
		case CLASS_TOURIST:
			info[i++] = _("Ȃ͎ʐ^Be邱ƂłB(0 MP)", "You can take a photograph (cost 0).");
			if (plev > 24)
			{
				info[i++] = _("Ȃ̓ACeSɊӒ肷邱ƂłB(20 MP)", "You can *identify* items (cost 20).");
			}
			break;
		case CLASS_IMITATOR:
			if (plev > 29)
			{
				info[i++] = _("Ȃ͉̓U_[W2{ł܂˂邱ƂłB(100 MP)", 
						"You can imitate monster's special attacks with double damage (cost 100).");
			}
			break;
		case CLASS_BEASTMASTER:
			info[i++] = _("Ȃ1̂̐̂郂X^[xz邱ƂłB(x/4 MP)", "You can dominate a monster (cost level/4).");
			if (plev > 29)
			{
				info[i++] = _("Ȃ͎E̐̂郂X^[xz邱ƂłB((x+20)/2 MP)", 
						"You can dominate living monsters in sight (cost (level+20)/4).");
			}
			break;
		case CLASS_MAGIC_EATER:
			info[i++] = _("Ȃ͏/@_/bh̖͂̂̂ɂ邱ƂłB", "You can absorb a staff, wand or rod itself.");
			break;
		case CLASS_RED_MAGE:
			if (plev > 47)
			{
				info[i++] = _("Ȃ1^[2񖂖@邱ƂłB(20 MP)", "You can cast two spells in one time (cost 20).");
			}
			break;
		case CLASS_SAMURAI:
			{
				info[i++] = _("Ȃ͐_WċC𗭂߂邱ƂłB", "You can concentrate to regenerate your mana.");
			}
			if (plev > 24)
			{
				info[i++] = _("Ȃ͓Ȍ^ō\邱ƂłB", "You can assume a posture of special form.");
			}
			break;
		case CLASS_BLUE_MAGE:
			info[i++] = _("Ȃ͑Ɏgꂽ@wԂƂłB", "You can study spells which your enemy casts on you.");
			break;
		case CLASS_CAVALRY:
			if (plev > 9)
			{
				info[i++] = _("Ȃ̓X^[ɏĖybgɂ邱ƂłB", "You can ride on a hostile monster forcibly to turn it into pet.");
			}
			break;
		case CLASS_BERSERKER:
			if (plev > 9)
			{
				info[i++] = _("Ȃ͊Xƃ_W̊Ԃs邱ƂłB", "You can travel between town and the depths.");
			}
			break;
		case CLASS_MIRROR_MASTER:
			info[i++] = _("Ȃ͋oƂłB(2 MP)", "You can create a Mirror (cost 2).");
			info[i++] = _("Ȃ͋邱ƂłB(0 MP)", "You can break distant Mirrors (cost 0).");
			break;
		case CLASS_NINJA:
			if (plev > 19)
			{
				info[i++] = _("Ȃ͑fړ邱ƂłB", "You can walk extremery fast.");
			}
			break;
	}

	if (p_ptr->muta1)
	{
		if (p_ptr->muta1 & MUT1_SPIT_ACID)
		{
			info[i++] = _("Ȃ͎_𐁂邱ƂłB(_[W xX1)", "You can spit acid (dam lvl).");
		}
		if (p_ptr->muta1 & MUT1_BR_FIRE)
		{
			info[i++] = _("Ȃ͉̃uXfƂłB(_[W xX2)", "You can breathe fire (dam lvl * 2).");
		}
		if (p_ptr->muta1 & MUT1_HYPN_GAZE)
		{
			info[i++] = _("Ȃɂ݂͍ÖʂB", "Your gaze is hypnotic.");
		}
		if (p_ptr->muta1 & MUT1_TELEKINES)
		{
			info[i++] = _("Ȃ͔O͂ĂB", "You are telekinetic.");
		}
		if (p_ptr->muta1 & MUT1_VTELEPORT)
		{
			info[i++] = _("Ȃ͎̈ӎvŃe|[głB", "You can teleport at will.");
		}
		if (p_ptr->muta1 & MUT1_MIND_BLST)
		{
			info[i++] = _("Ȃ͐_UsB(_[W 3`12d3)", "You can Mind Blast your enemies (3 to 12d3 dam).");
		}
		if (p_ptr->muta1 & MUT1_RADIATION)
		{
			info[i++] = _("Ȃ͎̈ӎvŋː𔭐邱ƂłB(_[W xX2)", "You can emit hard radiation at will (dam lvl * 2).");
		}
		if (p_ptr->muta1 & MUT1_VAMPIRISM)
		{
			info[i++] = _("Ȃ͋zŜ悤ɓG琶͂z邱ƂłB(_[W xX2)", 
						"You can drain life from a foe like a vampire (dam lvl * 2).");
		}
		if (p_ptr->muta1 & MUT1_SMELL_MET)
		{
			info[i++] = _("Ȃ͋߂ɂM邱ƂłB", "You can smell nearby precious metal.");
		}
		if (p_ptr->muta1 & MUT1_SMELL_MON)
		{
			info[i++] = _("Ȃ͋߂̃X^[݂̑邱ƂłB", "You can smell nearby monsters.");
		}
		if (p_ptr->muta1 & MUT1_BLINK)
		{
			info[i++] = _("Ȃ͒Ze|[głB", "You can teleport yourself short distances.");
		}
		if (p_ptr->muta1 & MUT1_EAT_ROCK)
		{
			info[i++] = _("Ȃ͍dHׂ邱ƂłB", "You can consume solid rock.");
		}
		if (p_ptr->muta1 & MUT1_SWAP_POS)
		{
			info[i++] = _("Ȃ͑̎҂Əꏊւ邱ƂłB", "You can switch locations with another being.");
		}
		if (p_ptr->muta1 & MUT1_SHRIEK)
		{
			info[i++] = _("Ȃ͐g̖т悾ѐ𔭂邱ƂłB(_[W xX2)", "You can emit a horrible shriek (dam 2 * lvl).");
		}
		if (p_ptr->muta1 & MUT1_ILLUMINE)
		{
			info[i++] = _("Ȃ͖邢ƂłB", "You can emit bright light.");
		}
		if (p_ptr->muta1 & MUT1_DET_CURSE)
		{
			info[i++] = _("Ȃ͎׈Ȗ@̊댯Ƃ邱ƂłB", "You can feel the danger of evil magic.");
		}
		if (p_ptr->muta1 & MUT1_BERSERK)
		{
			info[i++] = _("Ȃ͎̈ӎvŋ퓬ԂɂȂ邱ƂłB", "You can drive yourself into a berserk frenzy.");
		}
		if (p_ptr->muta1 & MUT1_POLYMORPH)
		{
			info[i++] = _("Ȃ͎̈ӎuŕωłB", "You can polymorph yourself at will.");
		}
		if (p_ptr->muta1 & MUT1_MIDAS_TCH)
		{
			info[i++] = _("Ȃ͒ʏACeɕς邱ƂłB", "You can turn ordinary items to gold.");
		}
		if (p_ptr->muta1 & MUT1_GROW_MOLD)
		{
			info[i++] = _("Ȃ͎͂ɃLmR𐶂₷ƂłB", "You can cause mold to grow near you.");
		}
		if (p_ptr->muta1 & MUT1_RESIST)
		{
			info[i++] = _("Ȃ͌f̍Uɑ΂Đgd邱ƂłB", "You can harden yourself to the ravages of the elements.");
		}
		if (p_ptr->muta1 & MUT1_EARTHQUAKE)
		{
			info[i++] = _("Ȃ͎͂̃_W󂳂邱ƂłB", "You can bring down the dungeon around your ears.");
		}
		if (p_ptr->muta1 & MUT1_EAT_MAGIC)
		{
			info[i++] = _("Ȃ͖@̃GlM[̕ƂĎgpłB", "You can consume magic energy for your own use.");
		}
		if (p_ptr->muta1 & MUT1_WEIGH_MAG)
		{
			info[i++] = _("Ȃ͎ɉe^閂@̗͂邱ƂłB", "You can feel the strength of the magics affecting you.");
		}
		if (p_ptr->muta1 & MUT1_STERILITY)
		{
			info[i++] = _("Ȃ͏WcIBs\NƂłB", "You can cause mass impotence.");
		}
		if (p_ptr->muta1 & MUT1_PANIC_HIT)
		{
			info[i++] = _("Ȃ͍Ug邽ߓ邱ƂłB", "You can run for your life after hitting something.");
		}
		if (p_ptr->muta1 & MUT1_DAZZLE)
		{
			info[i++] = _("Ȃ͍ƖӖڂN˔\𔭐邱ƂłB ", "You can emit confusing, blinding radiation.");
		}
		if (p_ptr->muta1 & MUT1_LASER_EYE)
		{
			info[i++] = _("Ȃ͖ڂ烌[U[𔭂邱ƂłB(_[W xX2)", "Your eyes can fire laser beams (dam 2 * lvl).");
		}
		if (p_ptr->muta1 & MUT1_RECALL)
		{
			info[i++] = _("Ȃ͊Xƃ_W̊Ԃs邱ƂłB", "You can travel between town and the depths.");
		}
		if (p_ptr->muta1 & MUT1_BANISH)
		{
			info[i++] = _("Ȃ͎׈ȃX^[nɗƂƂłB", "You can send evil creatures directly to Hell.");
		}
		if (p_ptr->muta1 & MUT1_COLD_TOUCH)
		{
			info[i++] = _("Ȃ͓GGē点邱ƂłB(_[W xX3)", "You can freeze things with a touch (dam 3 * lvl).");
		}
		if (p_ptr->muta1 & MUT1_LAUNCHER)
		{
			info[i++] = _("Ȃ̓ACe͋邱ƂłB", "You can hurl objects with great force.");
		}
	}

	if (p_ptr->muta2)
	{
		if (p_ptr->muta2 & MUT2_BERS_RAGE)
		{
			info[i++] = _("Ȃ͋m̔NB", "You are subject to berserker fits.");
		}
		if (p_ptr->muta2 & MUT2_COWARDICE)
		{
			info[i++] = _("Ȃ͎XaɂȂB", "You are subject to cowardice.");
		}
		if (p_ptr->muta2 & MUT2_RTELEPORT)
		{
			info[i++] = _("Ȃ̓_Ƀe|[gB", "You are teleporting randomly.");
		}
		if (p_ptr->muta2 & MUT2_ALCOHOL)
		{
			info[i++] = _("Ȃ̑̂̓AR[𕪔傷B", "Your body produces alcohol.");
		}
		if (p_ptr->muta2 & MUT2_HALLU)
		{
			info[i++] = _("Ȃ͌oN_ɐNĂB", "You have a hallucinatory insanity.");
		}
		if (p_ptr->muta2 & MUT2_FLATULENT)
		{
			info[i++] = _("Ȃ͐łȂțB", "You are subject to uncontrollable flatulence.");
		}
		if (p_ptr->muta2 & MUT2_PROD_MANA)
		{
			info[i++] = _("Ȃ͐s\Ȗ@̃GlM[𔭂ĂB", "You are producing magical energy uncontrollably.");
		}
		if (p_ptr->muta2 & MUT2_ATT_DEMON)
		{
			info[i++] = _("Ȃ̓f[B", "You attract demons.");
		}
		if (p_ptr->muta2 & MUT2_SCOR_TAIL)
		{
			info[i++] = _("Ȃ̓T\̐KĂB(ŁA_[W 3d7)", "You have a scorpion tail (poison, 3d7).");
		}
		if (p_ptr->muta2 & MUT2_HORNS)
		{
			info[i++] = _("Ȃ͊pĂB(_[W 2d6)", "You have horns (dam. 2d6).");
		}
		if (p_ptr->muta2 & MUT2_BEAK)
		{
			info[i++] = _("Ȃ̓N`oVĂB(_[W 2d4)", "You have a beak (dam. 2d4).");
		}
		if (p_ptr->muta2 & MUT2_SPEED_FLUX)
		{
			info[i++] = _("Ȃ̓_ɑx肷B", "You move faster or slower randomly.");
		}
		if (p_ptr->muta2 & MUT2_BANISH_ALL)
		{
			info[i++] = _("Ȃ͎X߂̃X^[łB", "You sometimes cause nearby creatures to vanish.");
		}
		if (p_ptr->muta2 & MUT2_EAT_LIGHT)
		{
			info[i++] = _("Ȃ͎X͂̌zĉh{ɂB", "You sometimes feed off of the light around you.");
		}
		if (p_ptr->muta2 & MUT2_TRUNK)
		{
			info[i++] = _("Ȃ͏ۂ̂悤ȕ@ĂB(_[W 1d4)", "You have an elephantine trunk (dam 1d4).");
		}
		if (p_ptr->muta2 & MUT2_ATT_ANIMAL)
		{
			info[i++] = _("Ȃ͓B", "You attract animals.");
		}
		if (p_ptr->muta2 & MUT2_TENTACLES)
		{
			info[i++] = _("Ȃ͎׈ȐGĂB(_[W 2d5)", "You have evil looking tentacles (dam 2d5).");
		}
		if (p_ptr->muta2 & MUT2_RAW_CHAOS)
		{
			info[i++] = _("Ȃ͂΂ΏJIXɕ܂B", "You occasionally are surrounded with raw chaos.");
		}
		if (p_ptr->muta2 & MUT2_NORMALITY)
		{
			info[i++] = _("Ȃ͕ψقĂA񕜂ĂĂB", "You may be mutated, but you're recovering.");
		}
		if (p_ptr->muta2 & MUT2_WRAITH)
		{
			info[i++] = _("Ȃ̓̂͗H̉̉肷B", "You fade in and out of physical reality.");
		}
		if (p_ptr->muta2 & MUT2_POLY_WOUND)
		{
			info[i++] = _("Ȃ̌N̓JIX̗͂ɉe󂯂B", "Your health is subject to chaotic forces.");
		}
		if (p_ptr->muta2 & MUT2_WASTING)
		{
			info[i++] = _("Ȃ͐シ鋰낵aCɂĂB", "You have a horrible wasting disease.");
		}
		if (p_ptr->muta2 & MUT2_ATT_DRAGON)
		{
			info[i++] = _("Ȃ̓hSB", "You attract dragons.");
		}
		if (p_ptr->muta2 & MUT2_WEIRD_MIND)
		{
			info[i++] = _("Ȃ̐_̓_Ɋg債k肵ĂB", "Your mind randomly expands and contracts.");
		}
		if (p_ptr->muta2 & MUT2_NAUSEA)
		{
			info[i++] = _("Ȃ݂͔̈ɗȂB", "You have a seriously upset stomach.");
		}
		if (p_ptr->muta2 & MUT2_CHAOS_GIFT)
		{
			info[i++] = _("Ȃ̓JIX̎숫JƂB", "Chaos deities give you gifts.");
		}
		if (p_ptr->muta2 & MUT2_WALK_SHAD)
		{
			info[i++] = _("Ȃ͂΂ΆuevɖށB", "You occasionally stumble into other shadows.");
		}
		if (p_ptr->muta2 & MUT2_WARNING)
		{
			info[i++] = _("Ȃ͓GɊւxB", "You receive warnings about your foes.");
		}
		if (p_ptr->muta2 & MUT2_INVULN)
		{
			info[i++] = _("Ȃ͎Xm炸ȋCɂȂB", "You occasionally feel invincible.");
		}
		if (p_ptr->muta2 & MUT2_SP_TO_HP)
		{
			info[i++] = _("Ȃ͎XؓɂǂƗB", "Your blood sometimes rushes to your muscles.");
		}
		if (p_ptr->muta2 & MUT2_HP_TO_SP)
		{
			info[i++] = _("Ȃ͎XɌǂƗB", "Your blood sometimes rushes to your head.");
		}
		if (p_ptr->muta2 & MUT2_DISARM)
		{
			info[i++] = _("Ȃ͂悭܂Âĕ𗎂ƂB", "You occasionally stumble and drop things.");
		}
	}

	if (p_ptr->muta3)
	{
		if (p_ptr->muta3 & MUT3_HYPER_STR)
		{
			info[i++] = _("Ȃ͒lIɋB(r+4)", "You are superhumanly strong (+4 STR).");
		}
		if (p_ptr->muta3 & MUT3_PUNY)
		{
			info[i++] = _("Ȃ͋ゾB(r-4)", "You are puny (-4 STR).");
		}
		if (p_ptr->muta3 & MUT3_HYPER_INT)
		{
			info[i++] = _("Ȃ̔]͐̃Rs[^B(m\+4)", "Your brain is a living computer (+4 INT/WIS).");
		}
		if (p_ptr->muta3 & MUT3_MORONIC)
		{
			info[i++] = _("Ȃ͐_ゾB(m\-4)", "You are moronic (-4 INT/WIS).");
		}
		if (p_ptr->muta3 & MUT3_RESILIENT)
		{
			info[i++] = _("Ȃ͔Ƀ^tB(ϋv+4)", "You are very resilient (+4 CON).");
		}
		if (p_ptr->muta3 & MUT3_XTRA_FAT)
		{
			info[i++] = _("Ȃ͋ɒ[ɑĂB(ϋv+2,Xs[h-2)", "You are extremely fat (+2 CON, -2 speed).");
		}
		if (p_ptr->muta3 & MUT3_ALBINO)
		{
			info[i++] = _("Ȃ̓ArmB(ϋv-4)", "You are albino (-4 CON).");
		}
		if (p_ptr->muta3 & MUT3_FLESH_ROT)
		{
			info[i++] = _("Ȃ͕̓̂sĂB(ϋv-2,-1)", "Your flesh is rotting (-2 CON, -1 CHR).");
		}
		if (p_ptr->muta3 & MUT3_SILLY_VOI)
		{
			info[i++] = _("Ȃ̐͊ԔȃL[L[B(-4)", "Your voice is a silly squeak (-4 CHR).");
		}
		if (p_ptr->muta3 & MUT3_BLANK_FAC)
		{
			info[i++] = _("Ȃ͂̂؂ڂB(-1)", "Your face is featureless (-1 CHR).");
		}
		if (p_ptr->muta3 & MUT3_ILL_NORM)
		{
			info[i++] = _("Ȃ͌eɕĂB", "Your appearance is masked with illusion.");
		}
		if (p_ptr->muta3 & MUT3_XTRA_EYES)
		{
			info[i++] = _("Ȃ͗]ɓ̖ڂĂB(T+15)", "You have an extra pair of eyes (+15 search).");
		}
		if (p_ptr->muta3 & MUT3_MAGIC_RES)
		{
			info[i++] = _("Ȃ͖@ւ̑ϐĂB", "You are resistant to magic.");
		}
		if (p_ptr->muta3 & MUT3_XTRA_NOIS)
		{
			info[i++] = _("Ȃ͕ςȉ𔭂ĂB(B-3)", "You make a lot of strange noise (-3 stealth).");
		}
		if (p_ptr->muta3 & MUT3_INFRAVIS)
		{
			info[i++] = _("Ȃ͑f炵ԊO͂ĂB(+3)", "You have remarkable infravision (+3).");
		}
		if (p_ptr->muta3 & MUT3_XTRA_LEGS)
		{
			info[i++] = _("Ȃ͗]ɓ{̑ĂB(+3)", "You have an extra pair of legs (+3 speed).");
		}
		if (p_ptr->muta3 & MUT3_SHORT_LEG)
		{
			info[i++] = _("Ȃ̑͒ZˋNB(-3)", "Your legs are short stubs (-3 speed).");
		}
		if (p_ptr->muta3 & MUT3_ELEC_TOUC)
		{
			info[i++] = _("Ȃ̌ǂɂ͓dĂB", "Electricity is running through your veins.");
		}
		if (p_ptr->muta3 & MUT3_FIRE_BODY)
		{
			info[i++] = _("Ȃ͉̑̂ɂ܂ĂB", "Your body is enveloped in flames.");
		}
		if (p_ptr->muta3 & MUT3_WART_SKIN)
		{
			info[i++] = _("Ȃ̔̓C{ɔĂB(-2, AC+5)", "Your skin is covered with warts (-2 CHR, +5 AC).");
		}
		if (p_ptr->muta3 & MUT3_SCALES)
		{
			info[i++] = _("Ȃ̔͗؂ɂȂĂB(-1, AC+10)", "Your skin has turned into scales (-1 CHR, +10 AC).");
		}
		if (p_ptr->muta3 & MUT3_IRON_SKIN)
		{
			info[i++] = _("Ȃ͓̔SłłĂB(p-1, AC+25)", "Your skin is made of steel (-1 DEX, +25 AC).");
		}
		if (p_ptr->muta3 & MUT3_WINGS)
		{
			info[i++] = _("Ȃ͉HĂB", "You have wings.");
		}
		if (p_ptr->muta3 & MUT3_FEARLESS)
		{
			/* Unnecessary */
		}
		if (p_ptr->muta3 & MUT3_REGEN)
		{
			/* Unnecessary */
		}
		if (p_ptr->muta3 & MUT3_ESP)
		{
			/* Unnecessary */
		}
		if (p_ptr->muta3 & MUT3_LIMBER)
		{
			info[i++] = _("Ȃ͔̑̂ɂȂ₩B(p+3)", "Your body is very limber (+3 DEX).");
		}
		if (p_ptr->muta3 & MUT3_ARTHRITIS)
		{
			info[i++] = _("Ȃ͂֐߂ɒɂ݂ĂB(p-3)", "Your joints ache constantly (-3 DEX).");
		}
		if (p_ptr->muta3 & MUT3_VULN_ELEM)
		{
			info[i++] = _("Ȃ͌f̍UɎアB", "You are susceptible to damage from the elements.");
		}
		if (p_ptr->muta3 & MUT3_MOTION)
		{
			info[i++] = _("Ȃ̓͐mŗ͋B(B+1)", "Your movements are precise and forceful (+1 STL).");
		}
		if (p_ptr->muta3 & MUT3_GOOD_LUCK)
		{
			info[i++] = _("Ȃ͔I[ɂ܂ĂB", "There is a white aura surrounding you.");
		}
		if (p_ptr->muta3 & MUT3_BAD_LUCK)
		{
			info[i++] = _("Ȃ͍I[ɂ܂ĂB", "There is a black aura surrounding you.");
		}
	}

	if (p_ptr->blind)
	{
		info[i++] = _("Ȃ͖ڂȂB", "You cannot see.");
	}
	if (p_ptr->confused)
	{
		info[i++] = _("Ȃ͍ĂB", "You are confused.");
	}
	if (p_ptr->afraid)
	{
		info[i++] = _("Ȃ͋|ɐNĂB", "You are terrified.");
	}
	if (p_ptr->cut)
	{
		info[i++] = _("Ȃ͏oĂB", "You are bleeding.");
	}
	if (p_ptr->stun)
	{
		info[i++] = _("Ȃ͂낤ƂĂB", "You are stunned.");
	}
	if (p_ptr->poisoned)
	{
		info[i++] = _("Ȃ͓łɐNĂB", "You are poisoned.");
	}
	if (p_ptr->image)
	{
		info[i++] = _("Ȃ͌oĂB", "You are hallucinating.");
	}
	if (p_ptr->cursed & TRC_TY_CURSE)
	{
		info[i++] = _("Ȃ͎׈ȉOɕ܂ĂB", "You carry an ancient foul curse.");
	}
	if (p_ptr->cursed & TRC_AGGRAVATE)
	{
		info[i++] = _("Ȃ̓X^[{点ĂB", "You aggravate monsters.");
	}
	if (p_ptr->cursed & TRC_DRAIN_EXP)
	{
		info[i++] = _("Ȃ͌olzĂB", "You are drained.");
	}
	if (p_ptr->cursed & TRC_SLOW_REGEN)
	{
		info[i++] = _("Ȃ̉񕜗͔͂ɒxB", "You regenerate slowly.");
	}
	if (p_ptr->cursed & TRC_ADD_L_CURSE)
	{
		info[i++] = _("Ȃ̎ア􂢂͑B","Your weak curses multiply."); /* bI -- henkma */
	}
	if (p_ptr->cursed & TRC_ADD_H_CURSE)
	{
		info[i++] = _("Ȃ̋􂢂͑B","Your heavy curses multiply."); /* bI -- henkma */
	}
	if (p_ptr->cursed & TRC_CALL_ANIMAL)
	{
		info[i++] = _("Ȃ͓ɑ_ĂB", "You attract animals.");
	}
	if (p_ptr->cursed & TRC_CALL_DEMON)
	{
		info[i++] = _("Ȃ͈ɑ_ĂB", "You attract demons.");
	}
	if (p_ptr->cursed & TRC_CALL_DRAGON)
	{
		info[i++] = _("Ȃ̓hSɑ_ĂB", "You attract dragons.");
	}
	if (p_ptr->cursed & TRC_COWARDICE)
	{
		info[i++] = _("Ȃ͎XaɂȂB", "You are subject to cowardice.");
	}
	if (p_ptr->cursed & TRC_TELEPORT)
	{
		info[i++] = _("Ȃ̈ʒu͂Ђ傤ɕs肾B", "Your position is very uncertain.");
	}
	if (p_ptr->cursed & TRC_LOW_MELEE)
	{
		info[i++] = _("Ȃ͍̕UO₷B", "Your weapon causes you to miss blows.");
	}
	if (p_ptr->cursed & TRC_LOW_AC)
	{
		info[i++] = _("Ȃ͍U󂯂₷B", "You are subject to be hit.");
	}
	if (p_ptr->cursed & TRC_LOW_MAGIC)
	{
		info[i++] = _("Ȃ͖@s₷B", "You are subject to fail spellcasting.");
	}
	if (p_ptr->cursed & TRC_FAST_DIGEST)
	{
		info[i++] = _("Ȃ͂ւB", "You have a good appetite.");
	}
	if (p_ptr->cursed & TRC_DRAIN_HP)
	{
		info[i++] = _("Ȃ̗͑͂zĂB", "You are drained.");
	}
	if (p_ptr->cursed & TRC_DRAIN_MANA)
	{
		info[i++] = _("Ȃ͖͂zĂB", "You brain is drained.");
	}
	if (IS_BLESSED())
	{
		info[i++] = _("Ȃ͍ĂB", "You feel rightous.");
	}
	if (IS_HERO())
	{
		info[i++] = _("Ȃ̓q[[CB", "You feel heroic.");
	}
	if (p_ptr->shero)
	{
		info[i++] = _("Ȃ͐퓬B", "You are in a battle rage.");
	}
	if (p_ptr->protevil)
	{
		info[i++] = _("Ȃ͎׈Ȃ鑶݂ĂB", "You are protected from evil.");
	}
	if (p_ptr->shield)
	{
		info[i++] = _("Ȃ͐_̃V[hŎĂB", "You are protected by a mystic shield.");
	}
	if (IS_INVULN())
	{
		info[i++] = _("Ȃ͌ݏȂB", "You are temporarily invulnerable.");
	}
	if (p_ptr->wraith_form)
	{
		info[i++] = _("Ȃ͈ꎞIɗH̉ĂB", "You are temporarily incorporeal.");
	}
	if (p_ptr->special_attack & ATTACK_CONFUSE)
	{
		info[i++] = _("Ȃ̎͐ԂPĂB", "Your hands are glowing dull red.");
	}
	if (p_ptr->special_attack & ATTACK_FIRE)
	{
		info[i++] = _("Ȃ͉̎ΉɕĂB", "You can strike the enemy with flame.");
	}
	if (p_ptr->special_attack & ATTACK_COLD)
	{
		info[i++] = _("Ȃ̎͗CɕĂB", "You can strike the enemy with cold.");
	}
	if (p_ptr->special_attack & ATTACK_ACID)
	{
		info[i++] = _("Ȃ͎̎_ɕĂB", "You can strike the enemy with acid.");
	}
	if (p_ptr->special_attack & ATTACK_ELEC)
	{
		info[i++] = _("Ȃ͓̎dɕĂB", "You can strike the enemy with electoric shock.");
	}
	if (p_ptr->special_attack & ATTACK_POIS)
	{
		info[i++] = _("Ȃ͓̎łɕĂB", "You can strike the enemy with poison.");
	}
	switch (p_ptr->action)
	{
		case ACTION_SEARCH:
			info[i++] = _("Ȃ͂Ђ傤ɒӐ[͂nĂB", "You are looking around very carefully.");
			break;
	}
	if (p_ptr->new_spells)
	{
		info[i++] = _("Ȃ͎FwԂƂłB", "You can learn some spells/prayers.");
	}
	if (p_ptr->word_recall)
	{
		info[i++] = _("Ȃ͂ɋA҂邾낤B", "You will soon be recalled.");
	}
	if (p_ptr->alter_reality)
	{
		info[i++] = _("Ȃ͂ɂ̐E𗣂邾낤B", "You will soon be altered.");
	}
	if (p_ptr->see_infra)
	{
		info[i++] = _("Ȃ̓͐ԊOɕqłB", "Your eyes are sensitive to infrared light.");
	}
	if (p_ptr->see_inv)
	{
		info[i++] = _("Ȃ͓ȃX^[邱ƂłB", "You can see invisible creatures.");
	}
	if (p_ptr->levitation)
	{
		info[i++] = _("Ȃ͔ԂƂłB", "You can fly.");
	}
	if (p_ptr->free_act)
	{
		info[i++] = _("Ȃ͖გm炸̌ʂĂB", "You have free action.");
	}
	if (p_ptr->regenerate)
	{
		info[i++] = _("Ȃ͑f̗͂񕜂B", "You regenerate quickly.");
	}
	if (p_ptr->slow_digest)
	{
		info[i++] = _("Ȃ͐H~ȂB", "Your appetite is small.");
	}
	if (p_ptr->telepathy)
	{
		info[i++] = _("Ȃ̓epV[\͂ĂB", "You have ESP.");
	}
	if (p_ptr->esp_animal)
	{
		info[i++] = _("Ȃ͎RE݂̐̑\͂ĂB", "You sense natural creatures.");
	}
	if (p_ptr->esp_undead)
	{
		info[i++] = _("Ȃ̓Afbh݂̑\͂ĂB", "You sense undead.");
	}
	if (p_ptr->esp_demon)
	{
		info[i++] = _("Ȃ͈݂̑\͂ĂB", "You sense demons.");
	}
	if (p_ptr->esp_orc)
	{
		info[i++] = _("Ȃ̓I[N݂̑\͂ĂB", "You sense orcs.");
	}
	if (p_ptr->esp_troll)
	{
		info[i++] = _("Ȃ̓g݂̑\͂ĂB", "You sense trolls.");
	}
	if (p_ptr->esp_giant)
	{
		info[i++] = _("Ȃ͋l݂̑\͂ĂB", "You sense giants.");
	}
	if (p_ptr->esp_dragon)
	{
		info[i++] = _("Ȃ̓hS݂̑\͂ĂB", "You sense dragons.");
	}
	if (p_ptr->esp_human)
	{
		info[i++] = _("Ȃ͐lԂ݂̑\͂ĂB", "You sense humans.");
	}
	if (p_ptr->esp_evil)
	{
		info[i++] = _("Ȃ͎׈Ȑ݂̑\͂ĂB", "You sense evil creatures.");
	}
	if (p_ptr->esp_good)
	{
		info[i++] = _("Ȃ͑PǂȐ݂̑\͂ĂB", "You sense good creatures.");
	}
	if (p_ptr->esp_nonliving)
	{
		info[i++] = _("Ȃ͊閳݂̂̑\͂ĂB", "You sense non-living creatures.");
	}
	if (p_ptr->esp_unique)
	{
		info[i++] = _("Ȃ͓ʂȋG݂̑\͂ĂB", "You sense unique monsters.");
	}
	if (p_ptr->hold_exp)
	{
		info[i++] = _("Ȃ͎Ȃ̌olƈێB", "You have a firm hold on your experience.");
	}
	if (p_ptr->reflect)
	{
		info[i++] = _("Ȃ͖̎𔽎˂B", "You reflect bolt spells.");
	}
	if (p_ptr->sh_fire)
	{
		info[i++] = _("Ȃ͉̃I[ɕ܂ĂB", "You are surrounded with a fiery aura.");
	}
	if (p_ptr->sh_elec)
	{
		info[i++] = _("Ȃ͓dCɕ܂ĂB", "You are surrounded with electricity.");
	}
	if (p_ptr->sh_cold)
	{
		info[i++] = _("Ȃ͗C̃I[ɕ܂ĂB", "You are surrounded with an aura of coldness.");
	}
	if (p_ptr->tim_sh_holy)
	{
		info[i++] = _("Ȃ͐ȂI[ɕ܂ĂB", "You are surrounded with a holy aura.");
	}
	if (p_ptr->tim_sh_touki)
	{
		info[i++] = _("Ȃ͓C̃I[ɕ܂ĂB", "You are surrounded with a energy aura.");
	}
	if (p_ptr->anti_magic)
	{
		info[i++] = _("Ȃ͔@V[hɕ܂ĂB", "You are surrounded by an anti-magic shell.");
	}
	if (p_ptr->anti_tele)
	{
		info[i++] = _("Ȃ̓e|[głȂB", "You cannot teleport.");
	}
	if (p_ptr->lite)
	{
		info[i++] = _("Ȃ̐ĝ͌ĂB", "You are carrying a permanent light.");
	}
	if (p_ptr->warning)
	{
		info[i++] = _("Ȃ͍s̑OɊ댯@m邱ƂłB", "You will be warned before dangerous actions.");
	}
	if (p_ptr->dec_mana)
	{
		info[i++] = _("Ȃ͏Ȃ͂Ŗ@邱ƂłB", "You can cast spells with fewer mana points.");
	}
	if (p_ptr->easy_spell)
	{
		info[i++] = _("Ȃ͒ႢsŖ@邱ƂłB", "Fail rate of your magic is decreased.");
	}
	if (p_ptr->heavy_spell)
	{
		info[i++] = _("Ȃ͍sŖ@Ȃ΂ȂB", "Fail rate of your magic is increased.");
	}
	if (p_ptr->mighty_throw)
	{
		info[i++] = _("Ȃ͋𓊂B", "You can throw objects powerfully.");
	}

	if (p_ptr->immune_acid)
	{
		info[i++] = _("Ȃ͎_ɑ΂銮SȂƉuĂB", "You are completely immune to acid.");
	}
	else if (p_ptr->resist_acid && IS_OPPOSE_ACID())
	{
		info[i++] = _("Ȃ͎_ւ̋͂ȑϐĂB", "You resist acid exceptionally well.");
	}
	else if (p_ptr->resist_acid || IS_OPPOSE_ACID())
	{
		info[i++] = _("Ȃ͎_ւ̑ϐĂB", "You are resistant to acid.");
	}

	if (p_ptr->immune_elec)
	{
		info[i++] = _("Ȃ͓dɑ΂銮SȂƉuĂB", "You are completely immune to lightning.");
	}
	else if (p_ptr->resist_elec && IS_OPPOSE_ELEC())
	{
		info[i++] = _("Ȃ͓dւ̋͂ȑϐĂB", "You resist lightning exceptionally well.");
	}
	else if (p_ptr->resist_elec || IS_OPPOSE_ELEC())
	{
		info[i++] = _("Ȃ͓dւ̑ϐĂB", "You are resistant to lightning.");
	}

	if (prace_is_(RACE_ANDROID) && !p_ptr->immune_elec)
	{
		info[i++] = _("Ȃ͓dɎアB", "You are susceptible to damage from lightning.");
	}

	if (p_ptr->immune_fire)
	{
		info[i++] = _("Ȃ͉΂ɑ΂銮SȂƉuĂB", "You are completely immune to fire.");
	}
	else if (p_ptr->resist_fire && IS_OPPOSE_FIRE())
	{
		info[i++] = _("Ȃ͉΂ւ̋͂ȑϐĂB", "You resist fire exceptionally well.");
	}
	else if (p_ptr->resist_fire || IS_OPPOSE_FIRE())
	{
		info[i++] = _("Ȃ͉΂ւ̑ϐĂB", "You are resistant to fire.");
	}

	if (prace_is_(RACE_ENT) && !p_ptr->immune_fire)
	{
		info[i++] = _("Ȃ͉΂ɎアB", "You are susceptible to damage from fire.");
	}

	if (p_ptr->immune_cold)
	{
		info[i++] = _("Ȃ͗Cɑ΂銮SȂƉuĂB", "You are completely immune to cold.");
	}
	else if (p_ptr->resist_cold && IS_OPPOSE_COLD())
	{
		info[i++] = _("Ȃ͗Cւ̋͂ȑϐĂB", "You resist cold exceptionally well.");
	}
	else if (p_ptr->resist_cold || IS_OPPOSE_COLD())
	{
		info[i++] = _("Ȃ͗Cւ̑ϐĂB", "You are resistant to cold.");
	}

	if (p_ptr->resist_pois && IS_OPPOSE_POIS())
	{
		info[i++] = _("Ȃ͓łւ̋͂ȑϐĂB", "You resist poison exceptionally well.");
	}
	else if (p_ptr->resist_pois || IS_OPPOSE_POIS())
	{
		info[i++] = _("Ȃ͓łւ̑ϐĂB", "You are resistant to poison.");
	}

	if (p_ptr->resist_lite)
	{
		info[i++] = _("Ȃ͑Mւ̑ϐĂB", "You are resistant to bright light.");
	}

	if (prace_is_(RACE_VAMPIRE) || prace_is_(RACE_S_FAIRY) || (p_ptr->mimic_form == MIMIC_VAMPIRE))
	{
		info[i++] = _("Ȃ͑MɎアB", "You are susceptible to damage from bright light.");
	}

	if (prace_is_(RACE_VAMPIRE) || (p_ptr->mimic_form == MIMIC_VAMPIRE) || p_ptr->wraith_form)
	{
		info[i++] = _("Ȃ͈Íɑ΂銮SȂƉuĂB", "You are completely immune to darkness.");
	}

	else if (p_ptr->resist_dark)
	{
		info[i++] = _("Ȃ͈Íւ̑ϐĂB", "You are resistant to darkness.");
	}
	if (p_ptr->resist_conf)
	{
		info[i++] = _("Ȃ͍ւ̑ϐĂB", "You are resistant to confusion.");
	}
	if (p_ptr->resist_sound)
	{
		info[i++] = _("Ȃ͉g̏Ռւ̑ϐĂB", "You are resistant to sonic attacks.");
	}
	if (p_ptr->resist_disen)
	{
		info[i++] = _("Ȃ͗򉻂ւ̑ϐĂB", "You are resistant to disenchantment.");
	}
	if (p_ptr->resist_chaos)
	{
		info[i++] = _("Ȃ̓JIX̗͂ւ̑ϐĂB", "You are resistant to chaos.");
	}
	if (p_ptr->resist_shard)
	{
		info[i++] = _("Ȃ͔jЂ̍Uւ̑ϐĂB", "You are resistant to blasts of shards.");
	}
	if (p_ptr->resist_nexus)
	{
		info[i++] = _("Ȃ͈ʍ̍Uւ̑ϐĂB", "You are resistant to nexus attacks.");
	}

	if (prace_is_(RACE_SPECTRE))
	{
		info[i++] = _("Ȃ͒n̗͂złB", "You can drain nether forces.");
	}
	else if (p_ptr->resist_neth)
	{
		info[i++] = _("Ȃ͒n̗͂ւ̑ϐĂB", "You are resistant to nether forces.");
	}
	if (p_ptr->resist_fear)
	{
		info[i++] = _("Ȃ͑S|ȂB", "You are completely fearless.");
	}
	if (p_ptr->resist_blind)
	{
		info[i++] = _("Ȃ̖ڂ͖Ӗڂւ̑ϐĂB", "Your eyes are resistant to blindness.");
	}
	if (p_ptr->resist_time)
	{
		info[i++] = _("Ȃ͎ԋt]ւ̑ϐĂB", "You are resistant to time.");
	}

	if (p_ptr->sustain_str)
	{
		info[i++] = _("Ȃ̘r͈͂ێĂB", "Your strength is sustained.");
	}
	if (p_ptr->sustain_int)
	{
		info[i++] = _("Ȃ̒m\͈ێĂB", "Your intelligence is sustained.");
	}
	if (p_ptr->sustain_wis)
	{
		info[i++] = _("Ȃ͈̌ێĂB", "Your wisdom is sustained.");
	}
	if (p_ptr->sustain_con)
	{
		info[i++] = _("Ȃ̑ϋv͈͂ێĂB", "Your constitution is sustained.");
	}
	if (p_ptr->sustain_dex)
	{
		info[i++] = _("Ȃ̊p͈ێĂB", "Your dexterity is sustained.");
	}
	if (p_ptr->sustain_chr)
	{
		info[i++] = _("Ȃ̖͈͂ێĂB", "Your charisma is sustained.");
	}

	if (have_flag(flgs, TR_STR))
	{
		info[i++] = _("Ȃ̘r͂͑ɂĉe󂯂ĂB", "Your strength is affected by your equipment.");
	}
	if (have_flag(flgs, TR_INT))
	{
		info[i++] = _("Ȃ̒m\͑ɂĉe󂯂ĂB", "Your intelligence is affected by your equipment.");
	}
	if (have_flag(flgs, TR_WIS))
	{
		info[i++] = _("Ȃ̌͑ɂĉe󂯂ĂB", "Your wisdom is affected by your equipment.");
	}
	if (have_flag(flgs, TR_DEX))
	{
		info[i++] = _("Ȃ̊p͑ɂĉe󂯂ĂB", "Your dexterity is affected by your equipment.");
	}
	if (have_flag(flgs, TR_CON))
	{
		info[i++] = _("Ȃ̑ϋv͂͑ɂĉe󂯂ĂB", "Your constitution is affected by your equipment.");
	}
	if (have_flag(flgs, TR_CHR))
	{
		info[i++] = _("Ȃ̖͂͑ɂĉe󂯂ĂB", "Your charisma is affected by your equipment.");
	}

	if (have_flag(flgs, TR_STEALTH))
	{
		info[i++] = _("Ȃ̉Bs\͂͑ɂĉe󂯂ĂB", "Your stealth is affected by your equipment.");
	}
	if (have_flag(flgs, TR_SEARCH))
	{
		info[i++] = _("Ȃ̒T\͂͑ɂĉe󂯂ĂB", "Your searching ability is affected by your equipment.");
	}
	if (have_flag(flgs, TR_INFRA))
	{
		info[i++] = _("Ȃ̐ԊO͂͑ɂĉe󂯂ĂB", "Your infravision is affected by your equipment.");
	}
	if (have_flag(flgs, TR_TUNNEL))
	{
		info[i++] = _("Ȃ̍̌@\͂͑ɂĉe󂯂ĂB", "Your digging ability is affected by your equipment.");
	}
	if (have_flag(flgs, TR_SPEED))
	{
		info[i++] = _("Ȃ̃Xs[h͑ɂĉe󂯂ĂB", "Your speed is affected by your equipment.");
	}
	if (have_flag(flgs, TR_BLOWS))
	{
		info[i++] = _("Ȃ̍Ux͑ɂĉe󂯂ĂB", "Your attack speed is affected by your equipment.");
	}


	/* Access the current weapon */
	o_ptr = &inventory[INVEN_RARM];

	/* Analyze the weapon */
	if (o_ptr->k_idx)
	{
		/* Indicate Blessing */
		if (have_flag(flgs, TR_BLESSED))
		{
			info[i++] = _("Ȃ͐̕_̏j󂯂ĂB", "Your weapon has been blessed by the gods.");
		}

		if (have_flag(flgs, TR_CHAOTIC))
		{
			info[i++] = _("Ȃ̓̕OX̒̑B", "Your weapon is branded with the Sign of Logrus.");
		}

		/* Hack */
		if (have_flag(flgs, TR_IMPACT))
		{
			info[i++] = _("Ȃ͑̕ŌŒnk𔭐邱ƂłB", "The impact of your weapon can cause earthquakes.");
		}

		if (have_flag(flgs, TR_VORPAL))
		{
			info[i++] = _("Ȃ͔̕ɉsB", "Your weapon is very sharp.");
		}

		if (have_flag(flgs, TR_VAMPIRIC))
		{
			info[i++] = _("Ȃ͓̕G琶͂zB", "Your weapon drains life from your foes.");
		}

		/* Special "Attack Bonuses" */
		if (have_flag(flgs, TR_BRAND_ACID))
		{
			info[i++] = _("Ȃ͓̕GnB", "Your weapon melts your foes.");
		}
		if (have_flag(flgs, TR_BRAND_ELEC))
		{
			info[i++] = _("Ȃ͓̕GdB", "Your weapon shocks your foes.");
		}
		if (have_flag(flgs, TR_BRAND_FIRE))
		{
			info[i++] = _("Ȃ͓̕GR₷B", "Your weapon burns your foes.");
		}
		if (have_flag(flgs, TR_BRAND_COLD))
		{
			info[i++] = _("Ȃ͓̕G𓀂点B", "Your weapon freezes your foes.");
		}
		if (have_flag(flgs, TR_BRAND_POIS))
		{
			info[i++] = _("Ȃ͓̕GłŐNB", "Your weapon poisons your foes.");
		}

		/* Special "slay" flags */
		if (have_flag(flgs, TR_KILL_ANIMAL))
		{
			info[i++] = _("Ȃ͓̓̕VGłB", "Your weapon is a great bane of animals.");
		}
		else if (have_flag(flgs, TR_SLAY_ANIMAL))
		{
			info[i++] = _("Ȃ͓̕ɑ΂ċ͂𔭊B", "Your weapon strikes at animals with extra force.");
		}
		if (have_flag(flgs, TR_KILL_EVIL))
		{
			info[i++] = _("Ȃ͎̕׈Ȃ鑶݂̓VGłB", "Your weapon is a great bane of evil.");
		}
		else if (have_flag(flgs, TR_SLAY_EVIL))
		{
			info[i++] = _("Ȃ͎̕׈Ȃ鑶݂ɑ΂ċ͂𔭊B", "Your weapon strikes at evil with extra force.");
		}
		if (have_flag(flgs, TR_KILL_HUMAN))
		{
			info[i++] = _("Ȃ͐̕lԂ̓VGłB", "Your weapon is a great bane of humans.");
		}
		else if (have_flag(flgs, TR_SLAY_HUMAN))
		{
			info[i++] = _("Ȃ͐̕lԂɑ΂ēɋ͂𔭊B", "Your weapon is especially deadly against humans.");
		}
		if (have_flag(flgs, TR_KILL_UNDEAD))
		{
			info[i++] = _("Ȃ̓̕Afbh̓VGłB", "Your weapon is a great bane of undead.");
		}
		else if (have_flag(flgs, TR_SLAY_UNDEAD))
		{
			info[i++] = _("Ȃ̓̕Afbhɑ΂Đ_Ȃ͂𔭊B", "Your weapon strikes at undead with holy wrath.");
		}
		if (have_flag(flgs, TR_KILL_DEMON))
		{
			info[i++] = _("Ȃ̓̕f[̓VGłB", "Your weapon is a great bane of demons.");
		}
		else if (have_flag(flgs, TR_SLAY_DEMON))
		{
			info[i++] = _("Ȃ̓̕f[ɑ΂Đ_Ȃ͂𔭊B", "Your weapon strikes at demons with holy wrath.");
		}
		if (have_flag(flgs, TR_KILL_ORC))
		{
			info[i++] = _("Ȃ̓̕I[N̓VGłB", "Your weapon is a great bane of orcs.");
		}
		else if (have_flag(flgs, TR_SLAY_ORC))
		{
			info[i++] = _("Ȃ̓̕I[Nɑ΂ēɋ͂𔭊B", "Your weapon is especially deadly against orcs.");
		}
		if (have_flag(flgs, TR_KILL_TROLL))
		{
			info[i++] = _("Ȃ̓̕g̓VGłB", "Your weapon is a great bane of trolls.");
		}
		else if (have_flag(flgs, TR_SLAY_TROLL))
		{
			info[i++] = _("Ȃ̓̕gɑ΂ēɋ͂𔭊B", "Your weapon is especially deadly against trolls.");
		}
		if (have_flag(flgs, TR_KILL_GIANT))
		{
			info[i++] = _("Ȃ̓̕WCAg̓VGłB", "Your weapon is a great bane of giants.");
		}
		else if (have_flag(flgs, TR_SLAY_GIANT))
		{
			info[i++] = _("Ȃ̓̕WCAgɑ΂ēɋ͂𔭊B", "Your weapon is especially deadly against giants.");
		}
		/* Special "kill" flags */
		if (have_flag(flgs, TR_KILL_DRAGON))
		{
			info[i++] = _("Ȃ̓̕hS̓VGłB", "Your weapon is a great bane of dragons.");
		}
		else if (have_flag(flgs, TR_SLAY_DRAGON))
		{
			info[i++] = _("Ȃ̓̕hSɑ΂ēɋ͂𔭊B", "Your weapon is especially deadly against dragons.");
		}

		if (have_flag(flgs, TR_FORCE_WEAPON))
		{
			info[i++] = _("Ȃ̕MPgčUB", "Your weapon causes greate damages using your MP.");
		}
		if (have_flag(flgs, TR_THROW))
		{
			info[i++] = _("Ȃ͓̕₷B", "Your weapon can be thrown well.");
		}
	}


	/* Save the screen */
	screen_save();

	/* Erase the screen */
	for (k = 1; k < 24; k++) prt("", k, 13);

	/* Label the information */
	prt(_("        Ȃ̏:", "     Your Attributes:"), 1, 15);

	/* We will print on top of the map (column 13) */
	for (k = 2, j = 0; j < i; j++)
	{
		/* Show the info */
		prt(info[j], k++, 15);

		/* Every 20 entries (lines 2 to 21), start over */
		if ((k == 22) && (j+1 < i))
		{
			prt(_("--  --", "-- more --"), k, 15);
			inkey();
			for (; k > 2; k--) prt("", k, 15);
		}
	}

	/* Pause */
	prt(_("[L[ƃQ[ɖ߂܂]", "[Press any key to continue]"), k, 13);
	inkey();

	/* Restore the screen */
	screen_load();
}

/*!
 * @brief @ʎԂ̃^[ɊÂĕ\IDԂB
 * @param dur ʃ^[
 * @return ʎԂ̕\ID
 */
static int report_magics_aux(int dur)
{
	if (dur <= 5)
	{
		return 0;
	}
	else if (dur <= 10)
	{
		return 1;
	}
	else if (dur <= 20)
	{
		return 2;
	}
	else if (dur <= 50)
	{
		return 3;
	}
	else if (dur <= 100)
	{
		return 4;
	}
	else if (dur <= 200)
	{
		return 5;
	}
	else
	{
		return 6;
	}
}

static cptr report_magic_durations[] =
{
#ifdef JP
"Z",
"̊",
"΂炭̊",
"",
"",
"ɒ",
"Mقǒ",
"X^[U܂"
#else
	"for a short time",
	"for a little while",
	"for a while",
	"for a long while",
	"for a long time",
	"for a very long time",
	"for an incredibly long time",
	"until you hit a monster"
#endif

};

/*!
 * @brief ݂̈ꎞIʈꗗԂ / Report all currently active magical effects.
 * @return Ȃ
 */
void report_magics(void)
{
	int     i = 0, j, k;
	char    Dummy[80];
	cptr    info[128];
	int     info2[128];


	if (p_ptr->blind)
	{
		info2[i]  = report_magics_aux(p_ptr->blind);
		info[i++] = _("Ȃ͖ڂȂ", "You cannot see");
	}
	if (p_ptr->confused)
	{
		info2[i]  = report_magics_aux(p_ptr->confused);
		info[i++] = _("Ȃ͍Ă", "You are confused");
	}
	if (p_ptr->afraid)
	{
		info2[i]  = report_magics_aux(p_ptr->afraid);
		info[i++] = _("Ȃ͋|ɐNĂ", "You are terrified");
	}
	if (p_ptr->poisoned)
	{
		info2[i]  = report_magics_aux(p_ptr->poisoned);
		info[i++] = _("Ȃ͓łɐNĂ", "You are poisoned");
	}
	if (p_ptr->image)
	{
		info2[i]  = report_magics_aux(p_ptr->image);
		info[i++] = _("Ȃ͌oĂ", "You are hallucinating");
	}
	if (p_ptr->blessed)
	{
		info2[i]  = report_magics_aux(p_ptr->blessed);
		info[i++] = _("Ȃ͍Ă", "You feel rightous");
	}
	if (p_ptr->hero)
	{
		info2[i]  = report_magics_aux(p_ptr->hero);
		info[i++] = _("Ȃ̓q[[C", "You feel heroic");
	}
	if (p_ptr->shero)
	{
		info2[i]  = report_magics_aux(p_ptr->shero);
		info[i++] = _("Ȃ͐퓬", "You are in a battle rage");
	}
	if (p_ptr->protevil)
	{
		info2[i]  = report_magics_aux(p_ptr->protevil);
		info[i++] = _("Ȃ͎׈Ȃ鑶݂Ă", "You are protected from evil");
	}
	if (p_ptr->shield)
	{
		info2[i]  = report_magics_aux(p_ptr->shield);
		info[i++] = _("Ȃ͐_̃V[hŎĂ", "You are protected by a mystic shield");
	}
	if (p_ptr->invuln)
	{
		info2[i]  = report_magics_aux(p_ptr->invuln);
		info[i++] = _("Ȃ͖G", "You are invulnerable");
	}
	if (p_ptr->wraith_form)
	{
		info2[i]  = report_magics_aux(p_ptr->wraith_form);
		info[i++] = _("Ȃ͗H̉Ă", "You are incorporeal");
	}
	if (p_ptr->special_attack & ATTACK_CONFUSE)
	{
		info2[i]  = 7;
		info[i++] = _("Ȃ̎͐ԂPĂ", "Your hands are glowing dull red.");
	}
	if (p_ptr->word_recall)
	{
		info2[i]  = report_magics_aux(p_ptr->word_recall);
		info[i++] = _("̌A҂̏ق", "You are waiting to be recalled");
	}
	if (p_ptr->alter_reality)
	{
		info2[i]  = report_magics_aux(p_ptr->alter_reality);
		info[i++] = _("̌㌻ϗe", "You waiting to be altered");
	}
	if (p_ptr->oppose_acid)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_acid);
		info[i++] = _("Ȃ͎_ւ̑ϐĂ", "You are resistant to acid");
	}
	if (p_ptr->oppose_elec)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_elec);
		info[i++] = _("Ȃ͓dւ̑ϐĂ", "You are resistant to lightning");
	}
	if (p_ptr->oppose_fire)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_fire);
		info[i++] = _("Ȃ͉΂ւ̑ϐĂ", "You are resistant to fire");
	}
	if (p_ptr->oppose_cold)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_cold);
		info[i++] = _("Ȃ͗Cւ̑ϐĂ", "You are resistant to cold");
	}
	if (p_ptr->oppose_pois)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_pois);
		info[i++] = _("Ȃ͓łւ̑ϐĂ", "You are resistant to poison");
	}

	/* Save the screen */
	screen_save();

	/* Erase the screen */
	for (k = 1; k < 24; k++) prt("", k, 13);

	/* Label the information */
	prt(_("    ݂Ă閂@     :", "     Your Current Magic:"), 1, 15);


	/* We will print on top of the map (column 13) */
	for (k = 2, j = 0; j < i; j++)
	{
		/* Show the info */
		sprintf(Dummy, _("%-28s :  - %s ", "%s %s."), info[j],
			report_magic_durations[info2[j]]);
		prt(Dummy, k++, 15);

		/* Every 20 entries (lines 2 to 21), start over */
		if ((k == 22) && (j + 1 < i))
		{
			prt(_("--  --", "-- more --"), k, 15);
			inkey();
			for (; k > 2; k--) prt("", k, 15);
		}
	}

	/* Pause */
	prt(_("[L[ƃQ[ɖ߂܂]", "[Press any key to continue]"), k, 13);
	inkey();

	/* Restore the screen */
	screen_load();
}
