﻿#pragma once
#include "realm/realm.h"

/* spells1.c */
extern bool in_disintegration_range(floor_type *floor_ptr, POSITION y1, POSITION x1, POSITION y2, POSITION x2);
extern void breath_shape(player_type *caster_ptr, u16b *path_g, int dist, int *pgrids, POSITION *gx, POSITION *gy, POSITION *gm, POSITION *pgm_rad, POSITION rad, POSITION y1, POSITION x1, POSITION y2, POSITION x2, EFFECT_ID typ);
extern POSITION dist_to_line(POSITION y, POSITION x, POSITION y1, POSITION x1, POSITION y2, POSITION x2);
extern bool binding_field(player_type *caster_ptr, HIT_POINT dam);
extern void seal_of_mirror(player_type *caster_ptr, HIT_POINT dam);
extern concptr spell_category_name(OBJECT_TYPE_VALUE tval);

/* spells2.c */
extern bool detect_traps(player_type *caster_ptr, POSITION range, bool known);
extern bool detect_doors(player_type *caster_ptr, POSITION range);
extern bool detect_stairs(player_type *caster_ptr, POSITION range);
extern bool detect_treasure(player_type *caster_ptr, POSITION range);
extern bool detect_objects_gold(player_type *caster_ptr, POSITION range);
extern bool detect_objects_normal(player_type *caster_ptr, POSITION range);
extern bool detect_objects_magic(player_type *caster_ptr, POSITION range);
extern bool detect_monsters_normal(player_type *caster_ptr, POSITION range);
extern bool detect_monsters_invis(player_type *caster_ptr, POSITION range);
extern bool detect_monsters_evil(player_type *caster_ptr, POSITION range);
extern bool detect_monsters_xxx(player_type *caster_ptr, POSITION range, u32b match_flag);
extern bool detect_monsters_string(player_type *caster_ptr, POSITION range, concptr);
extern bool detect_monsters_nonliving(player_type *caster_ptr, POSITION range);
extern bool detect_monsters_mind(player_type *caster_ptr, POSITION range);
extern bool detect_all(player_type *caster_ptr, POSITION range);
extern bool wall_stone(player_type *caster_ptr);
extern bool speed_monsters(player_type *caster_ptr);
extern bool slow_monsters(player_type *caster_ptr, int power);
extern bool sleep_monsters(player_type *caster_ptr, int power);
extern void aggravate_monsters(player_type *caster_ptr, MONSTER_IDX who);
extern bool genocide_aux(player_type *caster_ptr, MONSTER_IDX m_idx, int power, bool player_cast, int dam_side, concptr spell_name);
extern bool symbol_genocide(player_type *caster_ptr, int power, bool player_cast);
extern bool mass_genocide(player_type *caster_ptr, int power, bool player_cast);
extern bool mass_genocide_undead(player_type *caster_ptr, int power, bool player_cast);
extern bool probing(player_type *caster_ptr);
extern bool banish_evil(player_type *caster_ptr, int dist);
extern bool dispel_evil(player_type *caster_ptr, HIT_POINT dam);
extern bool dispel_good(player_type *caster_ptr, HIT_POINT dam);
extern bool dispel_undead(player_type *caster_ptr, HIT_POINT dam);
extern bool dispel_monsters(player_type *caster_ptr, HIT_POINT dam);
extern bool dispel_living(player_type *caster_ptr, HIT_POINT dam);
extern bool dispel_demons(player_type *caster_ptr, HIT_POINT dam);
extern bool cleansing_nova(player_type *creature_ptr, bool magic, bool powerful);
extern bool unleash_mana_storm(player_type *creature_ptr, bool powerful);
extern bool crusade(player_type *caster_ptr);
extern bool turn_undead(player_type *caster_ptr);
extern void lite_room(player_type *caster_ptr, POSITION y1, POSITION x1);
extern bool starlight(player_type *caster_ptr, bool magic);
extern void unlite_room(player_type *caster_ptr, POSITION y1, POSITION x1);
extern bool lite_area(player_type *caster_ptr, HIT_POINT dam, POSITION rad);
extern bool unlite_area(player_type *caster_ptr, HIT_POINT dam, POSITION rad);
extern bool fire_ball(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
extern bool fire_breath(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
extern bool fire_rocket(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
extern bool fire_ball_hide(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, POSITION rad);
extern bool fire_meteor(player_type *caster_ptr, MONSTER_IDX who, EFFECT_ID typ, POSITION x, POSITION y, HIT_POINT dam, POSITION rad);
extern bool fire_bolt(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam);
extern bool fire_blast(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, DICE_NUMBER dd, DICE_SID ds, int num, int dev);
extern void call_chaos(player_type *caster_ptr);
extern bool fire_beam(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam);
extern bool fire_bolt_or_beam(player_type *caster_ptr, PERCENTAGE prob, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam);
extern bool lite_line(player_type *caster_ptr, DIRECTION dir, HIT_POINT dam);
extern bool hypodynamic_bolt(player_type *caster_ptr, DIRECTION dir, HIT_POINT dam);
extern bool death_ray(player_type *caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
extern bool wall_to_mud(player_type *caster_ptr, DIRECTION dir, HIT_POINT dam);
extern bool destroy_door(player_type *caster_ptr, DIRECTION dir);
extern bool disarm_trap(player_type *caster_ptr, DIRECTION dir);
extern bool wizard_lock(player_type *caster_ptr, DIRECTION dir);
extern bool teleport_monster(player_type *caster_ptr, DIRECTION dir, int distance);
extern bool door_creation(player_type *caster_ptr, POSITION y, POSITION x);
extern bool trap_creation(player_type *caster_ptr, POSITION y, POSITION x);
extern bool tree_creation(player_type *caster_ptr, POSITION y, POSITION x);
extern bool glyph_creation(player_type *caster_ptr, POSITION y, POSITION x);
extern bool destroy_doors_touch(player_type *caster_ptr);
extern bool disarm_traps_touch(player_type *caster_ptr);
extern bool animate_dead(player_type *caster_ptr, MONSTER_IDX who, POSITION y, POSITION x);
extern bool sleep_monsters_touch(player_type *caster_ptr);
extern bool activate_ty_curse(player_type *target_ptr, bool stop_ty, int *count);
extern int activate_hi_summon(player_type *caster_ptr, POSITION y, POSITION x, bool can_pet);
extern void wall_breaker(player_type *caster_ptr);
extern bool confuse_monsters(player_type *caster_ptr, HIT_POINT dam);
extern bool charm_monsters(player_type *caster_ptr, HIT_POINT dam);
extern bool charm_animals(player_type *caster_ptr, HIT_POINT dam);
extern bool stun_monsters(player_type *caster_ptr, HIT_POINT dam);
extern bool stasis_monsters(player_type *caster_ptr, HIT_POINT dam);
extern bool banish_monsters(player_type *caster_ptr, int dist);
extern bool turn_monsters(player_type *caster_ptr, HIT_POINT dam);
extern bool turn_evil(player_type *caster_ptr, HIT_POINT dam);
extern bool deathray_monsters(player_type *caster_ptr);
extern bool charm_monster(player_type *caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
extern bool control_one_undead(player_type *caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
extern bool control_one_demon(player_type *caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
extern bool charm_animal(player_type *caster_ptr, DIRECTION dir, PLAYER_LEVEL plev);
extern bool mindblast_monsters(player_type *caster_ptr, HIT_POINT dam);
extern bool teleport_swap(player_type *caster_ptr, DIRECTION dir);
extern bool project_hook(player_type *caster_ptr, EFFECT_ID typ, DIRECTION dir, HIT_POINT dam, BIT_FLAGS flg);
extern bool project_all_los(player_type *caster_ptr, EFFECT_ID typ, HIT_POINT dam);
extern bool eat_magic(player_type *caster_ptr, int power);
extern void discharge_minion(player_type *caster_ptr);
extern bool kawarimi(player_type *caster_ptr, bool success);
extern bool rush_attack(player_type *attacker_ptr, bool *mdeath);
extern void remove_all_mirrors(player_type *caster_ptr, bool explode);
extern void ring_of_power(player_type *caster_ptr, DIRECTION dir);
extern void wild_magic(player_type *caster_ptr, int spell);
extern void cast_meteor(player_type *caster_ptr, HIT_POINT dam, POSITION rad);
extern bool cast_wrath_of_the_god(player_type *caster_ptr, HIT_POINT dam, POSITION rad);
extern void cast_wonder(player_type *caster_ptr, DIRECTION dir);
extern void cast_invoke_spirits(player_type *caster_ptr, DIRECTION dir);
extern void cast_shuffle(player_type *caster_ptr);
extern bool_hack vampirism(player_type *caster_ptr);
extern bool hit_and_away(player_type *caster_ptr);
extern bool psychometry(player_type *caster_ptr);
extern bool draconian_breath(player_type *creature_ptr);
extern bool android_inside_weapon(player_type *creature_ptr);
extern bool create_ration(player_type *crature_ptr);
extern void hayagake(player_type *creature_ptr);
extern bool double_attack(player_type *creature_ptr);
extern bool comvert_hp_to_mp(player_type *creature_ptr);
extern bool comvert_mp_to_hp(player_type *creature_ptr);
extern bool demonic_breath(player_type *creature_ptr);
extern bool mirror_concentration(player_type *creature_ptr);
extern bool sword_dancing(player_type *creature_ptr);
extern bool confusing_light(player_type *creature_ptr);
extern bool rodeo(player_type *creature_ptr);
extern bool clear_mind(player_type *creature_ptr);
extern bool concentration(player_type *creature_ptr);
extern bool vanish_dungeon(player_type *caster_ptr);

/* spells3.c */
extern bool teleport_away(player_type *caster_ptr, MONSTER_IDX m_idx, POSITION dis, teleport_flags mode);
extern void teleport_monster_to(player_type *caster_ptr, MONSTER_IDX m_idx, POSITION ty, POSITION tx, int power, teleport_flags mode);
extern bool teleport_player_aux(player_type *creature_ptr, POSITION dis, bool is_quantum_effect, teleport_flags mode);
extern void teleport_player(player_type *creature_ptr, POSITION dis, BIT_FLAGS mode);
extern void teleport_player_away(MONSTER_IDX m_idx, player_type *target_ptr, POSITION dis, bool is_quantum_effect);
extern void teleport_player_to(player_type *creature_ptr, POSITION ny, POSITION nx, teleport_flags mode);
extern void teleport_away_followable(player_type *creature_ptr, MONSTER_IDX m_idx);
extern bool teleport_level_other(player_type *caster_ptr);
extern void teleport_level(player_type *creature_ptr, MONSTER_IDX m_idx);
extern bool recall_player(player_type *creature_ptr, TIME_EFFECT turns);
extern bool free_level_recall(player_type *creature_ptr);
extern bool reset_recall(player_type *caster_ptr);
extern bool apply_disenchant(player_type *target_ptr, BIT_FLAGS mode);
extern void call_the_void(player_type *caster_ptr);
extern void fetch(player_type *caster_ptr, DIRECTION dir, WEIGHT wgt, bool require_los);
extern void reserve_alter_reality(player_type *caster_ptr);
extern void identify_pack(player_type *target_ptr);
extern int remove_curse(player_type *caster_ptr);
extern int remove_all_curse(player_type *caster_ptr);
extern bool alchemy(player_type *caster_ptr);

extern bool artifact_scroll(player_type *caster_ptr);
extern bool ident_spell(player_type *caster_ptr, bool only_equip, OBJECT_TYPE_VALUE item_tester_tval);
extern bool mundane_spell(player_type *ownner_ptr, bool only_equip);
extern bool identify_item(player_type *owner_ptr, object_type *o_ptr);
extern bool identify_fully(player_type *caster_ptr, bool only_equip, OBJECT_TYPE_VALUE item_tester_tval);
extern bool recharge(player_type *caster_ptr, int power);
extern void display_spell_list(player_type *caster_ptr);
extern EXP experience_of_spell(player_type *caster_ptr, SPELL_IDX spell, REALM_IDX use_realm);
extern MANA_POINT mod_need_mana(player_type *caster_ptr, MANA_POINT need_mana, SPELL_IDX spell, REALM_IDX realm);
extern PERCENTAGE mod_spell_chance_1(player_type *caster_ptr, PERCENTAGE chance);
extern PERCENTAGE mod_spell_chance_2(player_type *caster_ptr, PERCENTAGE chance);
extern PERCENTAGE spell_chance(player_type *caster_ptr, SPELL_IDX spell, REALM_IDX realm);
extern void print_spells(player_type* caster_ptr, SPELL_IDX target_spell, SPELL_IDX *spells, int num, TERM_LEN y, TERM_LEN x, REALM_IDX realm);
extern bool polymorph_monster(player_type *caster_ptr, POSITION y, POSITION x);
extern bool dimension_door(player_type *caster_ptr);
extern bool mirror_tunnel(player_type *caster_ptr);
extern void massacre(player_type *caster_ptr);
extern bool eat_rock(player_type *caster_ptr);
extern bool shock_power(player_type *caster_ptr);
extern bool fetch_monster(player_type *caster_ptr);
extern bool booze(player_type *creature_ptr);
extern bool detonation(player_type *creature_ptr);
extern void blood_curse_to_enemy(player_type *caster_ptr, MONSTER_IDX m_idx);
extern bool fire_crimson(player_type *shooter_ptr);
extern bool tele_town(player_type *caster_ptr);
extern bool is_teleport_level_ineffective(player_type *caster_ptr, MONSTER_IDX idx);
