#include "spell-kind/spells-neighbor.h"
#include "effect/effect-characteristics.h"
#include "floor/floor.h"
#include "grid/feature.h"
#include "spell/process-effect.h"
#include "spell-kind/earthquake.h"
#include "spell/spells-type.h"

/*!
 * @brief hA(vC[SɎ1}X) / Hooks -- affect adjacent grids (radius 1 ball attack)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
bool door_creation(player_type *caster_ptr, POSITION y, POSITION x)
{
    BIT_FLAGS flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
    return (project(caster_ptr, 0, 1, y, x, 0, GF_MAKE_DOOR, flg, -1));
}

/*!
 * @brief gbv(N_1}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @param y N_YW
 * @param x N_XW
 * @return pۂɂꍇTRUEԂ
 */
bool trap_creation(player_type *caster_ptr, POSITION y, POSITION x)
{
    BIT_FLAGS flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
    return (project(caster_ptr, 0, 1, y, x, 0, GF_MAKE_TRAP, flg, -1));
}

/*!
 * @brief Xѐ(vC[SɎ1}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
bool tree_creation(player_type *caster_ptr, POSITION y, POSITION x)
{
    BIT_FLAGS flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
    return (project(caster_ptr, 0, 1, y, x, 0, GF_MAKE_TREE, flg, -1));
}

/*!
 * @brief @̃[(vC[SɎ1}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
bool glyph_creation(player_type *caster_ptr, POSITION y, POSITION x)
{
    BIT_FLAGS flg = PROJECT_GRID | PROJECT_ITEM;
    return (project(caster_ptr, 0, 1, y, x, 0, GF_MAKE_GLYPH, flg, -1));
}

/*!
 * @brief ǐ(vC[SɎ1}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
bool wall_stone(player_type *caster_ptr)
{
    BIT_FLAGS flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
    bool dummy = (project(caster_ptr, 0, 1, caster_ptr->y, caster_ptr->x, 0, GF_STONE_WALL, flg, -1));
    caster_ptr->update |= (PU_FLOW);
    caster_ptr->redraw |= (PR_MAP);
    return dummy;
}

/*!
 * @brief hAj󏈗(vC[SɎ1}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
bool destroy_doors_touch(player_type *caster_ptr)
{
    BIT_FLAGS flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
    return (project(caster_ptr, 0, 1, caster_ptr->y, caster_ptr->x, 0, GF_KILL_DOOR, flg, -1));
}

/*!
 * @brief gbv(vC[SɎ1}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
bool disarm_traps_touch(player_type *caster_ptr)
{
    BIT_FLAGS flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
    return (project(caster_ptr, 0, 1, caster_ptr->y, caster_ptr->x, 0, GF_KILL_TRAP, flg, -1));
}

/*!
 * @brief X[vX^[(vC[SɎ1}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
bool sleep_monsters_touch(player_type *caster_ptr)
{
    BIT_FLAGS flg = PROJECT_KILL | PROJECT_HIDE;
    return (project(caster_ptr, 0, 1, caster_ptr->y, caster_ptr->x, caster_ptr->lev, GF_OLD_SLEEP, flg, -1));
}

/*!
 * @brief ҕ(N_5}X)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @param who p҃X^[ID(0Ȃ΃vC[)
 * @param y N_YW
 * @param x N_XW
 * @return pۂɂꍇTRUEԂ
 */
bool animate_dead(player_type *caster_ptr, MONSTER_IDX who, POSITION y, POSITION x)
{
    BIT_FLAGS flg = PROJECT_ITEM | PROJECT_HIDE;
    return (project(caster_ptr, who, 5, y, x, 0, GF_ANIM_DEAD, flg, -1));
}

/*!
 * @brief Ӕj(vC[S)
 * @param caster_ptr v[[ւ̎Qƃ|C^
 * @return pۂɂꍇTRUEԂ
 */
void wall_breaker(player_type *caster_ptr)
{
    POSITION y = 0, x = 0;
    int attempts = 1000;
    if (randint1(80 + caster_ptr->lev) < 70) {
        while (attempts--) {
            scatter(caster_ptr, &y, &x, caster_ptr->y, caster_ptr->x, 4, 0);

            if (!cave_have_flag_bold(caster_ptr->current_floor_ptr, y, x, FF_PROJECT))
                continue;

            if (!player_bold(caster_ptr, y, x))
                break;
        }

        project(caster_ptr, 0, 0, y, x, 20 + randint1(30), GF_KILL_WALL, (PROJECT_BEAM | PROJECT_THRU | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL), -1);
        return;
    }

    if (randint1(100) > 30) {
        earthquake(caster_ptr, caster_ptr->y, caster_ptr->x, 1, 0);
        return;
    }

    int num = damroll(5, 3);
    for (int i = 0; i < num; i++) {
        while (TRUE) {
            scatter(caster_ptr, &y, &x, caster_ptr->y, caster_ptr->x, 10, 0);

            if (!player_bold(caster_ptr, y, x))
                break;
        }

        project(caster_ptr, 0, 0, y, x, 20 + randint1(30), GF_KILL_WALL, (PROJECT_BEAM | PROJECT_THRU | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL), -1);
    }
}
