#include "angband.h"
#include "effect-player-util.h"
#include "effect/effect-player-switcher.h"
#include "spell/spells-type.h"
#include "player-damage.h"
#include "world.h"
#include "object-broken.h"
#include "player-effects.h"
#include "spells-status.h"
#include "artifact.h"
#include "player/mimic-info-table.h"
#include "monster-spell.h"
#include "mutation.h"
#include "object-curse.h"

/*!
 * @brief @̌ʂɂėlXȃbZ[o͂^_[W̑s肷
 * @param target_ptr v[[ւ̎Qƃ|C^
 * @param em_ptr v[[ʍ\̂ւ̎Qƃ|C^
 * @return Ȃ
 */
void switch_effects_player(player_type *target_ptr, effect_player_type *ep_ptr)
{
	switch (ep_ptr->effect_type)
	{
	case GF_ACID:
	{
		if (target_ptr->blind) msg_print(_("_ōUꂽI", "You are hit by acid!"));

		ep_ptr->get_damage = acid_dam(target_ptr, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell, FALSE);
		break;
	}
	case GF_FIRE:
	{
		if (target_ptr->blind) msg_print(_("ΉōUꂽI", "You are hit by fire!"));

		ep_ptr->get_damage = fire_dam(target_ptr, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell, FALSE);
		break;
	}
	case GF_COLD:
	{
		if (target_ptr->blind) msg_print(_("CōUꂽI", "You are hit by cold!"));

		ep_ptr->get_damage = cold_dam(target_ptr, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell, FALSE);
		break;
	}
	case GF_ELEC:
	{
		if (target_ptr->blind) msg_print(_("dōUꂽI", "You are hit by lightning!"));

		ep_ptr->get_damage = elec_dam(target_ptr, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell, FALSE);
		break;
	}
	case GF_POIS:
	{
		bool double_resist = is_oppose_pois(target_ptr);
		if (target_ptr->blind) msg_print(_("łōUꂽI", "You are hit by poison!"));

		if (target_ptr->resist_pois) ep_ptr->dam = (ep_ptr->dam + 2) / 3;
		if (double_resist) ep_ptr->dam = (ep_ptr->dam + 2) / 3;

		if ((!(double_resist || target_ptr->resist_pois)) && one_in_(HURT_CHANCE) && !CHECK_MULTISHADOW(target_ptr))
		{
			do_dec_stat(target_ptr, A_CON);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);

		if (!(double_resist || target_ptr->resist_pois) && !CHECK_MULTISHADOW(target_ptr))
			set_poisoned(target_ptr, target_ptr->poisoned + randint0(ep_ptr->dam) + 10);

		break;
	}
	case GF_NUKE:
	{
		bool double_resist = is_oppose_pois(target_ptr);
		if (target_ptr->blind) msg_print(_("˔\ōUꂽI", "You are hit by radiation!"));

		if (target_ptr->resist_pois) ep_ptr->dam = (2 * ep_ptr->dam + 2) / 5;
		if (double_resist) ep_ptr->dam = (2 * ep_ptr->dam + 2) / 5;
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		if ((double_resist || target_ptr->resist_pois) || CHECK_MULTISHADOW(target_ptr))
			break;

		set_poisoned(target_ptr, target_ptr->poisoned + randint0(ep_ptr->dam) + 10);

		if (one_in_(5)) /* 6 */
		{
			msg_print(_("`Iȕϐg𐋂I", "You undergo a freakish metamorphosis!"));
			if (one_in_(4)) /* 4 */
				do_poly_self(target_ptr);
			else
				status_shuffle(target_ptr);
		}

		if (one_in_(6))
		{
			inventory_damage(target_ptr, set_acid_destroy, 2);
		}

		break;
	}
	case GF_MISSILE:
	{
		if (target_ptr->blind) msg_print(_("ōUꂽI", "You are hit by something!"));
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_HOLY_FIRE:
	{
		if (target_ptr->blind) msg_print(_("ōUꂽI", "You are hit by something!"));
		if (target_ptr->align > 10)
			ep_ptr->dam /= 2;
		else if (target_ptr->align < -10)
			ep_ptr->dam *= 2;
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_HELL_FIRE:
	{
		if (target_ptr->blind) msg_print(_("ōUꂽI", "You are hit by something!"));
		if (target_ptr->align > 10)
			ep_ptr->dam *= 2;
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_ARROW:
	{
		if (target_ptr->blind)
		{
			msg_print(_("ŝōUꂽI", "You are hit by something sharp!"));
		}
		else if ((target_ptr->inventory_list[INVEN_RARM].name1 == ART_ZANTETSU) || (target_ptr->inventory_list[INVEN_LARM].name1 == ART_ZANTETSU))
		{
			msg_print(_("âĂI", "You cut down the arrow!"));
			break;
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_PLASMA:
	{
		if (target_ptr->blind) msg_print(_("ƂĂM̂ōUꂽI", "You are hit by something *HOT*!"));
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);

		if (!target_ptr->resist_sound && !CHECK_MULTISHADOW(target_ptr))
		{
			int plus_stun = (randint1((ep_ptr->dam > 40) ? 35 : (ep_ptr->dam * 3 / 4 + 5)));
			(void)set_stun(target_ptr, target_ptr->stun + plus_stun);
		}

		if (!(target_ptr->resist_fire || is_oppose_fire(target_ptr) || target_ptr->immune_fire))
		{
			inventory_damage(target_ptr, set_acid_destroy, 3);
		}

		break;
	}
	case GF_NETHER:
	{
		if (target_ptr->blind) msg_print(_("n̗͂ōUꂽI", "You are hit by nether forces!"));
		if (target_ptr->resist_neth)
		{
			if (!PRACE_IS_(target_ptr, RACE_SPECTRE))
			{
				ep_ptr->dam *= 6; ep_ptr->dam /= (randint1(4) + 7);
			}
		}
		else if (!CHECK_MULTISHADOW(target_ptr)) drain_exp(target_ptr, 200 + (target_ptr->exp / 100), 200 + (target_ptr->exp / 1000), 75);

		if (PRACE_IS_(target_ptr, RACE_SPECTRE) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("C悭ȂB", "You feel invigorated!"));
			hp_player(target_ptr, ep_ptr->dam / 4);
			learn_spell(target_ptr, ep_ptr->monspell);
		}
		else
		{
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		}

		break;
	}
	case GF_WATER:
	{
		if (target_ptr->blind) msg_print(_("̂ōUꂽI", "You are hit by something wet!"));
		if (CHECK_MULTISHADOW(target_ptr))
		{
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
			break;
		}

		if (!target_ptr->resist_sound && !target_ptr->resist_water)
		{
			set_stun(target_ptr, target_ptr->stun + randint1(40));
		}
		if (!target_ptr->resist_conf && !target_ptr->resist_water)
		{
			set_confused(target_ptr, target_ptr->confused + randint1(5) + 5);
		}

		if (one_in_(5) && !target_ptr->resist_water)
		{
			inventory_damage(target_ptr, set_cold_destroy, 3);
		}

		if (target_ptr->resist_water) ep_ptr->get_damage /= 4;

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_CHAOS:
	{
		if (target_ptr->blind) msg_print(_("̔gōUꂽI", "You are hit by a wave of anarchy!"));
		if (target_ptr->resist_chaos)
		{
			ep_ptr->dam *= 6; ep_ptr->dam /= (randint1(4) + 7);
		}

		if (CHECK_MULTISHADOW(target_ptr))
		{
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
			break;
		}

		if (!target_ptr->resist_conf)
		{
			(void)set_confused(target_ptr, target_ptr->confused + randint0(20) + 10);
		}
		if (!target_ptr->resist_chaos)
		{
			(void)set_image(target_ptr, target_ptr->image + randint1(10));
			if (one_in_(3))
			{
				msg_print(_("Ȃ̐ĝ̓JIX̗͂ŔPȂꂽI", "Your body is twisted by chaos!"));
				(void)gain_mutation(target_ptr, 0);
			}
		}
		if (!target_ptr->resist_neth && !target_ptr->resist_chaos)
		{
			drain_exp(target_ptr, 5000 + (target_ptr->exp / 100), 500 + (target_ptr->exp / 1000), 75);
		}

		if (!target_ptr->resist_chaos || one_in_(9))
		{
			inventory_damage(target_ptr, set_elec_destroy, 2);
			inventory_damage(target_ptr, set_fire_destroy, 2);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_SHARDS:
	{
		if (target_ptr->blind) msg_print(_("ŝōUꂽI", "You are hit by something sharp!"));
		if (target_ptr->resist_shard)
		{
			ep_ptr->dam *= 6; ep_ptr->dam /= (randint1(4) + 7);
		}
		else if (!CHECK_MULTISHADOW(target_ptr))
		{
			(void)set_cut(target_ptr, target_ptr->cut + ep_ptr->dam);
		}

		if (!target_ptr->resist_shard || one_in_(13))
		{
			inventory_damage(target_ptr, set_cold_destroy, 2);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_SOUND:
	{
		if (target_ptr->blind) msg_print(_("ōUꂽI", "You are hit by a loud noise!"));
		if (target_ptr->resist_sound)
		{
			ep_ptr->dam *= 5; ep_ptr->dam /= (randint1(4) + 7);
		}
		else if (!CHECK_MULTISHADOW(target_ptr))
		{
			int plus_stun = (randint1((ep_ptr->dam > 90) ? 35 : (ep_ptr->dam / 3 + 5)));
			(void)set_stun(target_ptr, target_ptr->stun + plus_stun);
		}

		if (!target_ptr->resist_sound || one_in_(13))
		{
			inventory_damage(target_ptr, set_cold_destroy, 2);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_CONFUSION:
	{
		if (target_ptr->blind) msg_print(_("̂ōUꂽI", "You are hit by something puzzling!"));
		if (target_ptr->resist_conf)
		{
			ep_ptr->dam *= 5; ep_ptr->dam /= (randint1(4) + 7);
		}
		else if (!CHECK_MULTISHADOW(target_ptr))
		{
			(void)set_confused(target_ptr, target_ptr->confused + randint1(20) + 10);
		}
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_DISENCHANT:
	{
		if (target_ptr->blind) msg_print(_("Ȃ̂ōUꂽI", "You are hit by something static!"));
		if (target_ptr->resist_disen)
		{
			ep_ptr->dam *= 6; ep_ptr->dam /= (randint1(4) + 7);
		}
		else if (!CHECK_MULTISHADOW(target_ptr))
		{
			(void)apply_disenchant(target_ptr, 0);
		}
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_NEXUS:
	{
		if (target_ptr->blind) msg_print(_("Ȃ̂ōUꂽI", "You are hit by something strange!"));
		if (target_ptr->resist_nexus)
		{
			ep_ptr->dam *= 6; ep_ptr->dam /= (randint1(4) + 7);
		}
		else if (!CHECK_MULTISHADOW(target_ptr))
		{
			apply_nexus(ep_ptr->m_ptr, target_ptr);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_FORCE:
	{
		if (target_ptr->blind) msg_print(_("^GlM[ōUꂽI", "You are hit by kinetic force!"));
		if (!target_ptr->resist_sound && !CHECK_MULTISHADOW(target_ptr))
		{
			(void)set_stun(target_ptr, target_ptr->stun + randint1(20));
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_ROCKET:
	{
		if (target_ptr->blind) msg_print(_("I", "There is an explosion!"));
		if (!target_ptr->resist_sound && !CHECK_MULTISHADOW(target_ptr))
		{
			(void)set_stun(target_ptr, target_ptr->stun + randint1(20));
		}

		if (target_ptr->resist_shard)
		{
			ep_ptr->dam /= 2;
		}
		else if (!CHECK_MULTISHADOW(target_ptr))
		{
			(void)set_cut(target_ptr, target_ptr->cut + (ep_ptr->dam / 2));
		}

		if (!target_ptr->resist_shard || one_in_(12))
		{
			inventory_damage(target_ptr, set_cold_destroy, 3);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_INERTIAL:
	{
		if (target_ptr->blind) msg_print(_("x̂ōUꂽI", "You are hit by something slow!"));
		if (!CHECK_MULTISHADOW(target_ptr)) (void)set_slow(target_ptr, target_ptr->slow + randint0(4) + 4, FALSE);

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_LITE:
	{
		if (target_ptr->blind) msg_print(_("ōUꂽI", "You are hit by something!"));
		if (target_ptr->resist_lite)
		{
			ep_ptr->dam *= 4; ep_ptr->dam /= (randint1(4) + 7);
		}
		else if (!target_ptr->blind && !target_ptr->resist_blind && !CHECK_MULTISHADOW(target_ptr))
		{
			(void)set_blind(target_ptr, target_ptr->blind + randint1(5) + 2);
		}

		if (PRACE_IS_(target_ptr, RACE_VAMPIRE) || (target_ptr->mimic_form == MIMIC_VAMPIRE))
		{
			if (!CHECK_MULTISHADOW(target_ptr)) msg_print(_("œ̂łꂽI", "The light scorches your flesh!"));
			ep_ptr->dam *= 2;
		}
		else if (PRACE_IS_(target_ptr, RACE_S_FAIRY))
		{
			ep_ptr->dam = ep_ptr->dam * 4 / 3;
		}

		if (target_ptr->wraith_form) ep_ptr->dam *= 2;
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);

		if (!target_ptr->wraith_form || CHECK_MULTISHADOW(target_ptr))
			break;

		target_ptr->wraith_form = 0;
		msg_print(_("M̂ߔ񕨎Iȉȇ݂łȂȂB",
			"The light forces you out of your incorporeal shadow form."));

		target_ptr->redraw |= (PR_MAP | PR_STATUS);
		target_ptr->update |= (PU_MONSTERS);
		target_ptr->window |= (PW_OVERHEAD | PW_DUNGEON);
		break;
	}
	case GF_DARK:
	{
		if (target_ptr->blind) msg_print(_("ōUꂽI", "You are hit by something!"));
		if (target_ptr->resist_dark)
		{
			ep_ptr->dam *= 4; ep_ptr->dam /= (randint1(4) + 7);

			if (PRACE_IS_(target_ptr, RACE_VAMPIRE) || (target_ptr->mimic_form == MIMIC_VAMPIRE) || target_ptr->wraith_form) ep_ptr->dam = 0;
		}
		else if (!target_ptr->blind && !target_ptr->resist_blind && !CHECK_MULTISHADOW(target_ptr))
		{
			(void)set_blind(target_ptr, target_ptr->blind + randint1(5) + 2);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_TIME:
	{
		if (target_ptr->blind) msg_print(_("ߋ̏ՌɍUꂽI", "You are hit by a blast from the past!"));

		if (target_ptr->resist_time)
		{
			ep_ptr->dam *= 4;
			ep_ptr->dam /= (randint1(4) + 7);
			msg_print(_("Ԃʂ߂ĂCB", "You feel as if time is passing you by."));
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
			break;
		}

		if (CHECK_MULTISHADOW(target_ptr))
		{
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
			break;
		}

		switch (randint1(10))
		{
		case 1:
		case 2:
		case 3:
		case 4:
		case 5:
		{
			if (target_ptr->prace == RACE_ANDROID) break;

			msg_print(_("lt߂肵CB", "You feel like a chunk of the past has been ripped away."));
			lose_exp(target_ptr, 100 + (target_ptr->exp / 100) * MON_DRAIN_LIFE);
			break;
		}
		case 6:
		case 7:
		case 8:
		case 9:
		{
			int k = 0;
			concptr act = NULL;
			switch (randint1(6))
			{
			case 1: k = A_STR; act = _("", "strong"); break;
			case 2: k = A_INT; act = _("", "bright"); break;
			case 3: k = A_WIS; act = _("", "wise"); break;
			case 4: k = A_DEX; act = _("p", "agile"); break;
			case 5: k = A_CON; act = _("N", "hale"); break;
			case 6: k = A_CHR; act = _("", "beautiful"); break;
			}

			msg_format(_("Ȃ͈ȑOق%sȂȂĂ܂...B", "You're not as %s as you used to be..."), act);
			target_ptr->stat_cur[k] = (target_ptr->stat_cur[k] * 3) / 4;
			if (target_ptr->stat_cur[k] < 3) target_ptr->stat_cur[k] = 3;

			target_ptr->update |= (PU_BONUS);
			break;
		}
		case 10:
		{
			msg_print(_("Ȃ͈ȑOقǗ͋ȂȂĂ܂...B", "You're not as powerful as you used to be..."));
			for (int k = 0; k < A_MAX; k++)
			{
				target_ptr->stat_cur[k] = (target_ptr->stat_cur[k] * 7) / 8;
				if (target_ptr->stat_cur[k] < 3) target_ptr->stat_cur[k] = 3;
			}

			target_ptr->update |= (PU_BONUS);
			break;
		}
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_GRAVITY:
	{
		if (target_ptr->blind) msg_print(_("d̂ōUꂽI", "You are hit by something heavy!"));
		msg_print(_("ӂ̏d͂䂪񂾁B", "Gravity warps around you."));

		if (!CHECK_MULTISHADOW(target_ptr))
		{
			teleport_player(target_ptr, 5, TELEPORT_PASSIVE);
			if (!target_ptr->levitation)
				(void)set_slow(target_ptr, target_ptr->slow + randint0(4) + 4, FALSE);
			if (!(target_ptr->resist_sound || target_ptr->levitation))
			{
				int plus_stun = (randint1((ep_ptr->dam > 90) ? 35 : (ep_ptr->dam / 3 + 5)));
				(void)set_stun(target_ptr, target_ptr->stun + plus_stun);
			}
		}

		if (target_ptr->levitation)
		{
			ep_ptr->dam = (ep_ptr->dam * 2) / 3;
		}

		if (!target_ptr->levitation || one_in_(13))
		{
			inventory_damage(target_ptr, set_cold_destroy, 2);
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_DISINTEGRATE:
	{
		if (target_ptr->blind) msg_print(_("ȃGlM[ōUꂽI", "You are hit by pure energy!"));

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_OLD_HEAL:
	{
		if (target_ptr->blind) msg_print(_("炩̍UɂċC悭ȂB", "You are hit by something invigorating!"));

		(void)hp_player(target_ptr, ep_ptr->dam);
		ep_ptr->dam = 0;
		break;
	}
	case GF_OLD_SPEED:
	{
		if (target_ptr->blind) msg_print(_("ōUꂽI", "You are hit by something!"));
		(void)set_fast(target_ptr, target_ptr->fast + randint1(5), FALSE);
		ep_ptr->dam = 0;
		break;
	}
	case GF_OLD_SLOW:
	{
		if (target_ptr->blind) msg_print(_("x̂ōUꂽI", "You are hit by something slow!"));
		(void)set_slow(target_ptr, target_ptr->slow + randint0(4) + 4, FALSE);
		break;
	}
	case GF_OLD_SLEEP:
	{
		if (target_ptr->free_act)  break;
		if (target_ptr->blind) msg_print(_("Ă܂I", "You fall asleep!"));

		if (ironman_nightmare)
		{
			msg_print(_("낵iɕłB", "A horrible vision enters your mind."));
			/* Have some nightmares */
			sanity_blast(target_ptr, NULL, FALSE);
		}

		set_paralyzed(target_ptr, target_ptr->paralyzed + ep_ptr->dam);
		ep_ptr->dam = 0;
		break;
	}
	case GF_MANA:
	case GF_SEEKER:
	case GF_SUPER_RAY:
	{
		if (target_ptr->blind) msg_print(_("@̃I[ōUꂽI", "You are hit by an aura of magic!"));

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_PSY_SPEAR:
	{
		if (target_ptr->blind) msg_print(_("GlM[̉ōUꂽI", "You are hit by an energy!"));

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_FORCE, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_METEOR:
	{
		if (target_ptr->blind) msg_print(_("󂩂炠Ȃ̓ɗĂI", "Something falls from the sky on you!"));

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		if (!target_ptr->resist_shard || one_in_(13))
		{
			if (!target_ptr->immune_fire) inventory_damage(target_ptr, set_fire_destroy, 2);
			inventory_damage(target_ptr, set_cold_destroy, 2);
		}

		break;
	}
	case GF_ICE:
	{
		if (target_ptr->blind) msg_print(_("s₽̂ōUꂽI", "You are hit by something sharp and cold!"));

		ep_ptr->get_damage = cold_dam(target_ptr, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell, FALSE);
		if (CHECK_MULTISHADOW(target_ptr)) break;

		if (!target_ptr->resist_shard)
		{
			(void)set_cut(target_ptr, target_ptr->cut + damroll(5, 8));
		}

		if (!target_ptr->resist_sound)
		{
			(void)set_stun(target_ptr, target_ptr->stun + randint1(15));
		}

		if ((!(target_ptr->resist_cold || is_oppose_cold(target_ptr))) || one_in_(12))
		{
			if (!target_ptr->immune_cold) inventory_damage(target_ptr, set_cold_destroy, 3);
		}

		break;
	}
	case GF_DEATH_RAY:
	{
		if (target_ptr->blind) msg_print(_("ɗ₽̂ōUꂽI", "You are hit by something extremely cold!"));

		if (target_ptr->mimic_form)
		{
			if (!(mimic_info[target_ptr->mimic_form].MIMIC_FLAGS & MIMIC_IS_NONLIVING))
				ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);

			break;
		}

		switch (target_ptr->prace)
		{
		case RACE_GOLEM:
		case RACE_SKELETON:
		case RACE_ZOMBIE:
		case RACE_VAMPIRE:
		case RACE_DEMON:
		case RACE_SPECTRE:
		{
			ep_ptr->dam = 0;
			break;
		}
		default:
		{
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
			break;
		}
		}

		break;
	}
	case GF_DRAIN_MANA:
	{
		if (CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("U͌eɖAȂɂ͓͂ȂB", "The attack hits Shadow, but you are unharmed!"));
			ep_ptr->dam = 0;
			break;
		}

		if (target_ptr->csp == 0)
		{
			ep_ptr->dam = 0;
			break;
		}

		if (ep_ptr->who > 0)
			msg_format(_("%^sɐ_GlM[zĂ܂I", "%^s draws psychic energy from you!"), ep_ptr->m_name);
		else
			msg_print(_("_GlM[zĂ܂I", "Your psychic energy is drawn!"));

		if (ep_ptr->dam >= target_ptr->csp)
		{
			ep_ptr->dam = target_ptr->csp;
			target_ptr->csp = 0;
			target_ptr->csp_frac = 0;
		}
		else
		{
			target_ptr->csp -= ep_ptr->dam;
		}

		learn_spell(target_ptr, ep_ptr->monspell);
		target_ptr->redraw |= (PR_MANA);
		target_ptr->window |= (PW_PLAYER | PW_SPELL);

		if ((ep_ptr->who <= 0) || (ep_ptr->m_ptr->hp >= ep_ptr->m_ptr->maxhp))
		{
			ep_ptr->dam = 0;
			break;
		}

		ep_ptr->m_ptr->hp += ep_ptr->dam;
		if (ep_ptr->m_ptr->hp > ep_ptr->m_ptr->maxhp) ep_ptr->m_ptr->hp = ep_ptr->m_ptr->maxhp;

		if (target_ptr->health_who == ep_ptr->who) target_ptr->redraw |= (PR_HEALTH);
		if (target_ptr->riding == ep_ptr->who) target_ptr->redraw |= (PR_UHEALTH);

		if (ep_ptr->m_ptr->ml)
		{
			msg_format(_("%^s͋CǂB", "%^s appears healthier."), ep_ptr->m_name);
		}

		ep_ptr->dam = 0;
		break;
	}
	case GF_MIND_BLAST:
	{
		if ((randint0(100 + ep_ptr->rlev / 2) < MAX(5, target_ptr->skill_sav)) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("͂𒵂˕ԂI", "You resist the effects!"));
			learn_spell(target_ptr, ep_ptr->monspell);
			break;
		}

		if (CHECK_MULTISHADOW(target_ptr))
		{
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
			break;
		}

		msg_print(_("IGlM[Ő_UꂽB", "Your mind is blasted by psionic energy."));
		if (!target_ptr->resist_conf)
		{
			(void)set_confused(target_ptr, target_ptr->confused + randint0(4) + 4);
		}

		if (!target_ptr->resist_chaos && one_in_(3))
		{
			(void)set_image(target_ptr, target_ptr->image + randint0(250) + 150);
		}

		target_ptr->csp -= 50;
		if (target_ptr->csp < 0)
		{
			target_ptr->csp = 0;
			target_ptr->csp_frac = 0;
		}

		target_ptr->redraw |= PR_MANA;
		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		break;
	}
	case GF_BRAIN_SMASH:
	{
		if ((randint0(100 + ep_ptr->rlev / 2) < MAX(5, target_ptr->skill_sav)) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("͂𒵂˕ԂI", "You resist the effects!"));
			learn_spell(target_ptr, ep_ptr->monspell);
			break;
		}

		if (!CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("IGlM[Ő_UꂽB", "Your mind is blasted by psionic energy."));

			target_ptr->csp -= 100;
			if (target_ptr->csp < 0)
			{
				target_ptr->csp = 0;
				target_ptr->csp_frac = 0;
			}
			target_ptr->redraw |= PR_MANA;
		}

		ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		if (CHECK_MULTISHADOW(target_ptr)) break;

		if (!target_ptr->resist_blind)
		{
			(void)set_blind(target_ptr, target_ptr->blind + 8 + randint0(8));
		}

		if (!target_ptr->resist_conf)
		{
			(void)set_confused(target_ptr, target_ptr->confused + randint0(4) + 4);
		}

		if (!target_ptr->free_act)
		{
			(void)set_paralyzed(target_ptr, target_ptr->paralyzed + randint0(4) + 4);
		}

		(void)set_slow(target_ptr, target_ptr->slow + randint0(4) + 4, FALSE);

		while (randint0(100 + ep_ptr->rlev / 2) > (MAX(5, target_ptr->skill_sav)))
			(void)do_dec_stat(target_ptr, A_INT);
		while (randint0(100 + ep_ptr->rlev / 2) > (MAX(5, target_ptr->skill_sav)))
			(void)do_dec_stat(target_ptr, A_WIS);

		if (!target_ptr->resist_chaos)
		{
			(void)set_image(target_ptr, target_ptr->image + randint0(250) + 150);
		}

		break;
	}
	case GF_CAUSE_1:
	{
		if ((randint0(100 + ep_ptr->rlev / 2) < target_ptr->skill_sav) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("͂𒵂˕ԂI", "You resist the effects!"));
			learn_spell(target_ptr, ep_ptr->monspell);
		}
		else
		{
			if (!CHECK_MULTISHADOW(target_ptr)) curse_equipment(target_ptr, 15, 0);
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		}
		break;
	}
	case GF_CAUSE_2:
	{
		if ((randint0(100 + ep_ptr->rlev / 2) < target_ptr->skill_sav) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("͂𒵂˕ԂI", "You resist the effects!"));
			learn_spell(target_ptr, ep_ptr->monspell);
		}
		else
		{
			if (!CHECK_MULTISHADOW(target_ptr)) curse_equipment(target_ptr, 25, MIN(ep_ptr->rlev / 2 - 15, 5));
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		}
		break;
	}
	case GF_CAUSE_3:
	{
		if ((randint0(100 + ep_ptr->rlev / 2) < target_ptr->skill_sav) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("͂𒵂˕ԂI", "You resist the effects!"));
			learn_spell(target_ptr, ep_ptr->monspell);
		}
		else
		{
			if (!CHECK_MULTISHADOW(target_ptr)) curse_equipment(target_ptr, 33, MIN(ep_ptr->rlev / 2 - 15, 15));
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
		}
		break;
	}
	case GF_CAUSE_4:
	{
		if ((randint0(100 + ep_ptr->rlev / 2) < target_ptr->skill_sav) && !(ep_ptr->m_ptr->r_idx == MON_KENSHIROU) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("E𒵂˕ԂI", "You resist the effects!"));
			learn_spell(target_ptr, ep_ptr->monspell);
		}
		else
		{
			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->killer, ep_ptr->monspell);
			if (!CHECK_MULTISHADOW(target_ptr)) (void)set_cut(target_ptr, target_ptr->cut + damroll(10, 10));
		}

		break;
	}
	case GF_HAND_DOOM:
	{
		if ((randint0(100 + ep_ptr->rlev / 2) < target_ptr->skill_sav) && !CHECK_MULTISHADOW(target_ptr))
		{
			msg_print(_("͂𒵂˕ԂI", "You resist the effects!"));
			learn_spell(target_ptr, ep_ptr->monspell);
		}
		else
		{
			if (!CHECK_MULTISHADOW(target_ptr))
			{
				msg_print(_("Ȃ͖܂Ă悤ɊI", "You feel your life fade away!"));
				curse_equipment(target_ptr, 40, 20);
			}

			ep_ptr->get_damage = take_hit(target_ptr, DAMAGE_ATTACK, ep_ptr->dam, ep_ptr->m_name, ep_ptr->monspell);

			if (target_ptr->chp < 1) target_ptr->chp = 1;
		}

		break;
	}
	default:
	{
		ep_ptr->dam = 0;
		break;
	}
	}
}
