/* File: tables.c */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

/* Purpose: Angband Tables */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
const s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
const s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

const s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
const s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

const s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/*
 * Circular keypad direction array
 */
const s16b cdd[8] =
{ 2, 3, 6, 9, 8, 7, 4, 1 };

/*
 * Global arrays for optimizing "ddx[cdd[i]]" and "ddy[cdd[i]]"
 */
const s16b ddx_cdd[8] =
{ 0, 1, 1, 1, 0, -1, -1, -1 };

const s16b ddy_cdd[8] =
{ 1, 1, 0, -1, -1, -1, 0, 1 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
const char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting numbers to a logical list symbol
 */
const char listsym[] =
{
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
	'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
	'\0'
};


/*
 * Encode the screen colors
 */
const cptr color_char = "dwsorgbuDWvyRGBU";


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
const byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	6	/* 18/210-18/219 */,
	6	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra 1/4-mana-points per level
 */
const byte adj_mag_mana[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	2       /* 9 */,
	3       /* 10 */,
	4       /* 11 */,
	5       /* 12 */,
	5       /* 13 */,
	6       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	11      /* 18/10-18/19 */,
	11      /* 18/20-18/29 */,
	12      /* 18/30-18/39 */,
	12      /* 18/40-18/49 */,
	13      /* 18/50-18/59 */,
	14      /* 18/60-18/69 */,
	15      /* 18/70-18/79 */,
	16      /* 18/80-18/89 */,
	17      /* 18/90-18/99 */,
	18      /* 18/100-18/109 */,
	19      /* 18/110-18/119 */,
	20      /* 18/120-18/129 */,
	21      /* 18/130-18/139 */,
	22      /* 18/140-18/149 */,
	23      /* 18/150-18/159 */,
	24      /* 18/160-18/169 */,
	25      /* 18/170-18/179 */,
	26      /* 18/180-18/189 */,
	27      /* 18/190-18/199 */,
	28      /* 18/200-18/209 */,
	29      /* 18/210-18/219 */,
	30      /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
const byte adj_mag_fail[] =
{
	99      /* 3 */,
	99      /* 4 */,
	99      /* 5 */,
	99      /* 6 */,
	99      /* 7 */,
	50      /* 8 */,
	30      /* 9 */,
	20      /* 10 */,
	15      /* 11 */,
	12      /* 12 */,
	11      /* 13 */,
	10      /* 14 */,
	9       /* 15 */,
	8       /* 16 */,
	7       /* 17 */,
	6       /* 18/00-18/09 */,
	6       /* 18/10-18/19 */,
	5       /* 18/20-18/29 */,
	5       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	4       /* 18/70-18/79 */,
	4       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	3       /* 18/100-18/109 */,
	2       /* 18/110-18/119 */,
	2       /* 18/120-18/129 */,
	2       /* 18/130-18/139 */,
	2       /* 18/140-18/149 */,
	1       /* 18/150-18/159 */,
	1       /* 18/160-18/169 */,
	1       /* 18/170-18/179 */,
	1       /* 18/180-18/189 */,
	1       /* 18/190-18/199 */,
	0       /* 18/200-18/209 */,
	0       /* 18/210-18/219 */,
	0       /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
const byte adj_mag_stat[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
const byte adj_chr_gold[] =
{
	130     /* 3 */,
	125     /* 4 */,
	122     /* 5 */,
	120     /* 6 */,
	118     /* 7 */,
	116     /* 8 */,
	114     /* 9 */,
	112     /* 10 */,
	110     /* 11 */,
	108     /* 12 */,
	106     /* 13 */,
	104     /* 14 */,
	103     /* 15 */,
	102     /* 16 */,
	101     /* 17 */,
	100     /* 18/00-18/09 */,
	99      /* 18/10-18/19 */,
	98      /* 18/20-18/29 */,
	97      /* 18/30-18/39 */,
	96      /* 18/40-18/49 */,
	95      /* 18/50-18/59 */,
	94      /* 18/60-18/69 */,
	93      /* 18/70-18/79 */,
	92      /* 18/80-18/89 */,
	91      /* 18/90-18/99 */,
	90      /* 18/100-18/109 */,
	89      /* 18/110-18/119 */,
	88      /* 18/120-18/129 */,
	87      /* 18/130-18/139 */,
	86      /* 18/140-18/149 */,
	85      /* 18/150-18/159 */,
	84      /* 18/160-18/169 */,
	83      /* 18/170-18/179 */,
	82      /* 18/180-18/189 */,
	81      /* 18/190-18/199 */,
	80      /* 18/200-18/209 */,
	79      /* 18/210-18/219 */,
	78      /* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
const byte adj_int_dev[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	7       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
const byte adj_wis_sav[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	5       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	9       /* 18/120-18/129 */,
	10      /* 18/130-18/139 */,
	11      /* 18/140-18/149 */,
	12      /* 18/150-18/159 */,
	13      /* 18/160-18/169 */,
	14      /* 18/170-18/179 */,
	15      /* 18/180-18/189 */,
	16      /* 18/190-18/199 */,
	17      /* 18/200-18/209 */,
	18      /* 18/210-18/219 */,
	19      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
const byte adj_dex_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	4       /* 18/00-18/09 */,
	4       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	8       /* 18/140-18/149 */,
	9       /* 18/150-18/159 */,
	9       /* 18/160-18/169 */,
	9       /* 18/170-18/179 */,
	9       /* 18/180-18/189 */,
	9       /* 18/190-18/199 */,
	10      /* 18/200-18/209 */,
	10      /* 18/210-18/219 */,
	10      /* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
const byte adj_int_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	7       /* 18/70-18/79 */,
	8       /* 18/80-18/89 */,
	9       /* 18/90-18/99 */,
	10      /* 18/100-18/109 */,
	10      /* 18/110-18/119 */,
	11      /* 18/120-18/129 */,
	12      /* 18/130-18/139 */,
	13      /* 18/140-18/149 */,
	14      /* 18/150-18/159 */,
	15      /* 18/160-18/169 */,
	16      /* 18/170-18/179 */,
	17      /* 18/180-18/189 */,
	18      /* 18/190-18/199 */,
	19      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
const byte adj_dex_ta[] =
{
	128 + -4    /*  3 */,
	128 + -3    /*  4 */,
	128 + -2    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 1     /* 15 */,
	128 + 1     /* 16 */,
	128 + 1     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 2     /* 18/20-18/29 */,
	128 + 2     /* 18/30-18/39 */,
	128 + 2     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 3     /* 18/70-18/79 */,
	128 + 4     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 9     /* 18/140-18/149 */,
	128 + 10    /* 18/150-18/159 */,
	128 + 11    /* 18/160-18/169 */,
	128 + 12    /* 18/170-18/179 */,
	128 + 13    /* 18/180-18/189 */,
	128 + 14    /* 18/190-18/199 */,
	128 + 15    /* 18/200-18/209 */,
	128 + 15    /* 18/210-18/219 */,
	128 + 16    /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
const byte adj_str_td[] =
{
	128 + -2    /*  3 */,
	128 + -2    /*  4 */,
	128 + -1    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 0     /* 15 */,
	128 + 1     /* 16 */,
	128 + 2     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 3     /* 18/20-18/29 */,
	128 + 3     /* 18/30-18/39 */,
	128 + 3     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 4     /* 18/70-18/79 */,
	128 + 5     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 10    /* 18/140-18/149 */,
	128 + 11    /* 18/150-18/159 */,
	128 + 12    /* 18/160-18/169 */,
	128 + 13    /* 18/170-18/179 */,
	128 + 14    /* 18/180-18/189 */,
	128 + 15    /* 18/190-18/199 */,
	128 + 16    /* 18/200-18/209 */,
	128 + 18    /* 18/210-18/219 */,
	128 + 20    /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
const byte adj_dex_th[] =
{
	128 + -3        /* 3 */,
	128 + -2        /* 4 */,
	128 + -2        /* 5 */,
	128 + -1        /* 6 */,
	128 + -1        /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 0 /* 14 */,
	128 + 0 /* 15 */,
	128 + 1 /* 16 */,
	128 + 2 /* 17 */,
	128 + 3 /* 18/00-18/09 */,
	128 + 3 /* 18/10-18/19 */,
	128 + 3 /* 18/20-18/29 */,
	128 + 3 /* 18/30-18/39 */,
	128 + 3 /* 18/40-18/49 */,
	128 + 4 /* 18/50-18/59 */,
	128 + 4 /* 18/60-18/69 */,
	128 + 4 /* 18/70-18/79 */,
	128 + 4 /* 18/80-18/89 */,
	128 + 5 /* 18/90-18/99 */,
	128 + 6 /* 18/100-18/109 */,
	128 + 7 /* 18/110-18/119 */,
	128 + 8 /* 18/120-18/129 */,
	128 + 9 /* 18/130-18/139 */,
	128 + 9 /* 18/140-18/149 */,
	128 + 10        /* 18/150-18/159 */,
	128 + 11        /* 18/160-18/169 */,
	128 + 12        /* 18/170-18/179 */,
	128 + 13        /* 18/180-18/189 */,
	128 + 14        /* 18/190-18/199 */,
	128 + 15        /* 18/200-18/209 */,
	128 + 15        /* 18/210-18/219 */,
	128 + 16        /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
const byte adj_str_th[] =
{
	128 + -3        /* 3 */,
	128 + -2        /* 4 */,
	128 + -1        /* 5 */,
	128 + -1        /* 6 */,
	128 + 0 /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 0 /* 14 */,
	128 + 0 /* 15 */,
	128 + 0 /* 16 */,
	128 + 0 /* 17 */,
	128 + 1 /* 18/00-18/09 */,
	128 + 1 /* 18/10-18/19 */,
	128 + 1 /* 18/20-18/29 */,
	128 + 1 /* 18/30-18/39 */,
	128 + 1 /* 18/40-18/49 */,
	128 + 1 /* 18/50-18/59 */,
	128 + 1 /* 18/60-18/69 */,
	128 + 2 /* 18/70-18/79 */,
	128 + 3 /* 18/80-18/89 */,
	128 + 4 /* 18/90-18/99 */,
	128 + 5 /* 18/100-18/109 */,
	128 + 6 /* 18/110-18/119 */,
	128 + 7 /* 18/120-18/129 */,
	128 + 8 /* 18/130-18/139 */,
	128 + 9 /* 18/140-18/149 */,
	128 + 10        /* 18/150-18/159 */,
	128 + 11        /* 18/160-18/169 */,
	128 + 12        /* 18/170-18/179 */,
	128 + 13        /* 18/180-18/189 */,
	128 + 14        /* 18/190-18/199 */,
	128 + 15        /* 18/200-18/209 */,
	128 + 15        /* 18/210-18/219 */,
	128 + 16        /* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
const byte adj_str_wgt[] =
{
	10      /* 3 */,
	11      /* 4 */,
	12      /* 5 */,
	13      /* 6 */,
	14      /* 7 */,
	15      /* 8 */,
	16      /* 9 */,
	17      /* 10 */,
	18      /* 11 */,
	19      /* 12 */,
	20      /* 13 */,
	21      /* 14 */,
	22      /* 15 */,
	23      /* 16 */,
	24      /* 17 */,
	25      /* 18/00-18/09 */,
	26      /* 18/10-18/19 */,
	27      /* 18/20-18/29 */,
	28      /* 18/30-18/39 */,
	29      /* 18/40-18/49 */,
	30      /* 18/50-18/59 */,
	31      /* 18/60-18/69 */,
	31      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	32      /* 18/90-18/99 */,
	33      /* 18/100-18/109 */,
	33      /* 18/110-18/119 */,
	34      /* 18/120-18/129 */,
	34      /* 18/130-18/139 */,
	35      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	36      /* 18/160-18/169 */,
	36      /* 18/170-18/179 */,
	37      /* 18/180-18/189 */,
	37      /* 18/190-18/199 */,
	38      /* 18/200-18/209 */,
	38      /* 18/210-18/219 */,
	39      /* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
const byte adj_str_hold[] =
{
	4       /* 3 */,
	5       /* 4 */,
	6       /* 5 */,
	7       /* 6 */,
	8       /* 7 */,
	9       /* 8 */,
	10      /* 9 */,
	11      /* 10 */,
	12      /* 11 */,
	13      /* 12 */,
	14      /* 13 */,
	15      /* 14 */,
	16      /* 15 */,
	17      /* 16 */,
	18      /* 17 */,
	19      /* 18/00-18/09 */,
	20      /* 18/10-18/19 */,
	21      /* 18/20-18/29 */,
	22      /* 18/30-18/39 */,
	23      /* 18/40-18/49 */,
	24      /* 18/50-18/59 */,
	25      /* 18/60-18/69 */,
	26      /* 18/70-18/79 */,
	27      /* 18/80-18/89 */,
	28      /* 18/90-18/99 */,
	30      /* 18/100-18/109 */,
	31      /* 18/110-18/119 */,
	32      /* 18/120-18/129 */,
	33      /* 18/130-18/139 */,
	34      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	37      /* 18/160-18/169 */,
	40      /* 18/170-18/179 */,
	44      /* 18/180-18/189 */,
	48      /* 18/190-18/199 */,
	50     /* 18/200-18/209 */,
	50     /* 18/210-18/219 */,
	50     /* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
const byte adj_str_dig[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	55      /* 18/110-18/119 */,
	60      /* 18/120-18/129 */,
	65      /* 18/130-18/139 */,
	70      /* 18/140-18/149 */,
	75      /* 18/150-18/159 */,
	80      /* 18/160-18/169 */,
	85      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	95      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
const byte adj_str_blow[] =
{
	3       /* 3 */,
	4       /* 4 */,
	5       /* 5 */,
	6       /* 6 */,
	7       /* 7 */,
	8       /* 8 */,
	9       /* 9 */,
	10      /* 10 */,
	11      /* 11 */,
	12      /* 12 */,
	13      /* 13 */,
	14      /* 14 */,
	15      /* 15 */,
	16      /* 16 */,
	17      /* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
const byte adj_dex_blow[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	2       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	7       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	9      /* 18/140-18/149 */,
	9      /* 18/150-18/159 */,
	10      /* 18/160-18/169 */,
	10      /* 18/170-18/179 */,
	11      /* 18/180-18/189 */,
	11      /* 18/190-18/199 */,
	12      /* 18/200-18/209 */,
	12      /* 18/210-18/219 */,
	13      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
const byte adj_dex_safe[] =
{
	0       /* 3 */,
	1       /* 4 */,
	2       /* 5 */,
	3       /* 6 */,
	4       /* 7 */,
	5       /* 8 */,
	5       /* 9 */,
	6       /* 10 */,
	6       /* 11 */,
	7       /* 12 */,
	7       /* 13 */,
	8       /* 14 */,
	8       /* 15 */,
	9       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	15      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	60      /* 18/110-18/119 */,
	70      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	90      /* 18/140-18/149 */,
	100     /* 18/150-18/159 */,
	100     /* 18/160-18/169 */,
	100     /* 18/170-18/179 */,
	100     /* 18/180-18/189 */,
	100     /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
const byte adj_con_fix[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	0       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	1       /* 16 */,
	1       /* 17 */,
	2       /* 18/00-18/09 */,
	2       /* 18/10-18/19 */,
	2       /* 18/20-18/29 */,
	2       /* 18/30-18/39 */,
	2       /* 18/40-18/49 */,
	3       /* 18/50-18/59 */,
	3       /* 18/60-18/69 */,
	3       /* 18/70-18/79 */,
	3       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	4       /* 18/100-18/109 */,
	4       /* 18/110-18/119 */,
	5       /* 18/120-18/129 */,
	6       /* 18/130-18/139 */,
	6       /* 18/140-18/149 */,
	7       /* 18/150-18/159 */,
	7       /* 18/160-18/169 */,
	8       /* 18/170-18/179 */,
	8       /* 18/180-18/189 */,
	8       /* 18/190-18/199 */,
	9       /* 18/200-18/209 */,
	9       /* 18/210-18/219 */,
	9       /* 18/220+ */
};


/*
 * Stat Table (CON) -- extra 1/4-hitpoints per level (plus 128)
 */
const byte adj_con_mhp[] =
{
	128 + -8        /* 3 */,
	128 + -6        /* 4 */,
	128 + -4        /* 5 */,
	128 + -2        /* 6 */,
	128 + -1 /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 1 /* 14 */,
	128 + 1 /* 15 */,
	128 + 2 /* 16 */,
	128 + 3 /* 17 */,
	128 + 4 /* 18/00-18/09 */,
	128 + 5 /* 18/10-18/19 */,
	128 + 6 /* 18/20-18/29 */,
	128 + 7 /* 18/30-18/39 */,
	128 + 8 /* 18/40-18/49 */,
	128 + 9 /* 18/50-18/59 */,
	128 + 10  /* 18/60-18/69 */,
	128 + 11 /* 18/70-18/79 */,
	128 + 12 /* 18/80-18/89 */,
	128 + 14 /* 18/90-18/99 */,
	128 + 17         /* 18/100-18/109 */,
	128 + 20        /* 18/110-18/119 */,
	128 + 23        /* 18/120-18/129 */,
	128 + 26        /* 18/130-18/139 */,
	128 + 29        /* 18/140-18/149 */,
	128 + 32        /* 18/150-18/159 */,
	128 + 35        /* 18/160-18/169 */,
	128 + 38        /* 18/170-18/179 */,
	128 + 40        /* 18/180-18/189 */,
	128 + 42        /* 18/190-18/199 */,
	128 + 44        /* 18/200-18/209 */,
	128 + 46        /* 18/210-18/219 */,
	128 + 48        /* 18/220+ */
};


/*
 * Stat Table (CHR) -- charm
 */
const byte adj_chr_chm[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	18      /* 18/40-18/49 */,
	21      /* 18/50-18/59 */,
	24      /* 18/60-18/69 */,
	28      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	36      /* 18/90-18/99 */,
	39      /* 18/100-18/109 */,
	42      /* 18/110-18/119 */,
	45      /* 18/120-18/129 */,
	49      /* 18/130-18/139 */,
	53      /* 18/140-18/149 */,
	57      /* 18/150-18/159 */,
	61      /* 18/160-18/169 */,
	65      /* 18/170-18/179 */,
	69      /* 18/180-18/189 */,
	73      /* 18/190-18/199 */,
	77      /* 18/200-18/209 */,
	81      /* 18/210-18/219 */,
	85      /* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 * Warrior       num = 6; mul = 5; div = MAX(70, weapon_weight);
 * Berserker     num = 6; mul = 7; div = MAX(70, weapon_weight);
 * Mage          num = 3; mul = 2; div = MAX(100, weapon_weight);
 * Priest        num = 5; mul = 3; div = MAX(100, weapon_weight);
 * Mindcrafter   num = 5; mul = 3; div = MAX(100, weapon_weight);
 * Rogue         num = 5; mul = 3; div = MAX(40, weapon_weight);
 * Ranger        num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Paladin       num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Weaponsmith   num = 5; mul = 5; div = MAX(150, weapon_weight);
 * Warrior-Mage  num = 5; mul = 3; div = MAX(70, weapon_weight);
 * Chaos Warrior num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Monk          num = 5; mul = 3; div = MAX(60, weapon_weight);
 * Tourist       num = 4; mul = 3; div = MAX(100, weapon_weight);
 * Imitator      num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Beastmaster   num = 5; mul = 3; div = MAX(70, weapon_weight);
 * Cavalry(Ride) num = 5; mul = 4; div = MAX(70, weapon_weight);
 * Cavalry(Walk) num = 5; mul = 3; div = MAX(100, weapon_weight);
 * Sorcerer      num = 1; mul = 1; div = MAX(1, weapon_weight);
 * Archer        num = 4; mul = 2; div = MAX(70, weapon_weight);
 * Magic eater   num = 4; mul = 2; div = MAX(70, weapon_weight);
 * ForceTrainer  num = 4; mul = 2; div = MAX(60, weapon_weight);
 * Mirror Master num = 3; mul = 3; div = MAX(100, weapon_weight);
 * Ninja         num = 4; mul = 1; div = MAX(20, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div".
 * Increase P by 1 if you wield a weapon two-handed.
 * Decrease P by 1 if you are a Ninja.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
const byte blows_table[12][12] =
{
	/* P/D */
	/*      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */
	/*      3   10   15  /10  /40  /60  /80 /100 /120 /140 /160 /180  */
/* 0 */{	1,   1,   1,   1,   1,   2,   2,   2,   2,   3,   3,   4 },
/* 1 */{	1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4 },
/* 2 */{	1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5 },
/* 3 */{	1,   1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },
/* 4 */{	1,   1,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },
/* 5 */{	1,   1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 6 */{	1,   1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 7 */{	1,   2,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 8 */{	1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6 },
/* 9 */{	1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
/* 10*/{	2,   2,   3,   4,   4,   4,   5,   5,   5,   6,   6,   6 },
/*11+*/{	2,   2,   3,   4,   4,   4,   5,   5,   6,   6,   6,   6 },

};


const arena_type arena_info[MAX_ARENA_MONS + 2] =
{
	{ MON_NOBORTA,       TV_AMULET, SV_AMULET_ADORNMENT           },
	{ MON_MORI_TROLL,    TV_FOOD,   SV_FOOD_PINT_OF_WINE          },
	{ MON_IMP,           TV_POTION, SV_POTION_SPEED               },
	{ MON_LION_HEART,    0,         0                             },
	{ MON_MASTER_YEEK,   TV_POTION, SV_POTION_CURING              },
	{ MON_SABRE_TIGER,   TV_WAND,   SV_WAND_STONE_TO_MUD          },
	{ MON_LIZARD_KING,   TV_WAND,   SV_WAND_TELEPORT_AWAY         },
	{ MON_WYVERN,        TV_POTION, SV_POTION_HEALING             },
	{ MON_ARCH_VILE,     TV_POTION, SV_POTION_RESISTANCE          },
	{ MON_ELF_LORD   ,   TV_POTION, SV_POTION_ENLIGHTENMENT       },
	{ MON_GHOUL_KING,    TV_FOOD,   SV_FOOD_RESTORING             },
	{ MON_COLBRAN,       TV_RING,   SV_RING_ELEC                  },
	{ MON_BICLOPS,       TV_WAND,   SV_WAND_ACID_BALL             },
	{ MON_M_MINDCRAFTER, TV_POTION, SV_POTION_SELF_KNOWLEDGE      },
	{ MON_GROO,          TV_SCROLL, SV_SCROLL_ACQUIREMENT         },
	{ MON_RAAL,          TV_SCROLL, SV_SCROLL_STAR_DESTRUCTION    },
	{ MON_DREADMASTER,   TV_WAND,   SV_WAND_DRAIN_LIFE            },
	{ MON_ULTRA_PALADIN, TV_STAFF,  SV_STAFF_DISPEL_EVIL          },
	{ MON_BARNEY,        TV_RING,   SV_RING_RES_CHAOS             },
	{ MON_TROLL_KING,    TV_SCROLL, SV_SCROLL_MASS_GENOCIDE       },
	{ MON_BARON_HELL,    TV_POTION, SV_POTION_AUGMENTATION        },
	{ MON_F_ANGEL,       TV_SCROLL, SV_SCROLL_RUNE_OF_PROTECTION  },
	{ MON_G_C_DRAKE,     TV_WAND,   SV_WAND_DRAGON_FIRE           },
	{ MON_IRON_LICH,     TV_STAFF,  SV_STAFF_DESTRUCTION          },
	{ MON_DROLEM,        TV_POTION, SV_POTION_STAR_HEALING        },
	{ MON_G_TITAN,       TV_WAND,   SV_WAND_GENOCIDE              },
	{ MON_G_BALROG,      TV_POTION, SV_POTION_EXPERIENCE          },
	{ MON_ELDER_VAMPIRE, TV_RING,   SV_RING_SUSTAIN               },
	{ MON_NIGHTWALKER,   TV_WAND,   SV_WAND_STRIKING              },
	{ MON_S_TYRANNO,     TV_SCROLL, SV_SCROLL_STAR_ACQUIREMENT    },
	{ MON_G_MASTER_MYS,  TV_ROD,    SV_ROD_IDENTIFY               },
	{ MON_LORD_CHAOS,    TV_POTION, SV_POTION_LIFE                },
	{ MON_SHADOWLORD,    TV_POTION, SV_POTION_STAR_ENLIGHTENMENT  },
	{ MON_ULT_BEHOLDER,  TV_AMULET, SV_AMULET_REFLECTION          },
	{ MON_JABBERWOCK,    TV_ROD,    SV_ROD_HEALING                },
	{ MON_LOCKE_CLONE,   TV_WAND,   SV_WAND_DISINTEGRATE          },
	{ MON_WYRM_SPACE,    TV_ROD,    SV_ROD_RESTORATION            },
	{ MON_SHAMBLER,      TV_SCROLL, SV_SCROLL_STAR_ACQUIREMENT    },
	{ MON_BLACK_REAVER,  TV_RING,   SV_RING_LORDLY                },
	{ MON_FENGHUANG,     TV_STAFF,  SV_STAFF_THE_MAGI             },
	{ MON_WYRM_POWER,    TV_SCROLL, SV_SCROLL_ARTIFACT            },
	{ 0,                 0,         0                             }, /* Victory prizing */
	{ MON_HAGURE,        TV_SCROLL, SV_SCROLL_ARTIFACT            },
};


/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 *
 * Lifted extra shopkeepers from CthAngband (don't you just love open source
 * development? ;-)). Since this gave less than 32 unique names for some
 * shops, those have their first x names copied to reach 32.
 *
 * For the weapon and armour shops, several owners have a limit of 5k.
 *
 * I want to do 50k owners, but the purse is currently s16b. Perhaps
 * we should just store 1/10th of the purse?
 */
const owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store - 32 unique names */
		/*
		  Raistlin  dragonlance  powerful wizard 
		  Rincewind the Chicken  Terry Pratchett  Discworld оʪ 嵭Υѥǥ
		  { "¼ԥ饹ȥ",       200,    175,  108,   4,  12,  RACE_HUMAN},
		  { "Raistlin the Chicken",       200,    175, 108,  4, 12, RACE_HUMAN},
		*/

#ifdef JP
		{ "եɥ꡼ʥӥ",       2000,    170,  108,   5,  15,  RACE_HOBBIT},
		{ "¼ԥ󥹥",       2000,    175,  108,   4,  12,  RACE_HUMAN}, 
		{ "ؤ㤤륿",             3000,    170,  107,   5,  15,  RACE_GNOME},
		{ "ϥ󥵥ʥ饤=",      3000,    165,  107,   6,  18,  RACE_ELF},
		{ "ڤʥեޥ",         2500,    170, 108,  5, 15, RACE_HOBBIT},
		{ "¼ԥ",       5000,    175, 108,  4, 12, RACE_HUMAN},
		{ "ӤΥ饷ʥ",          7500,    170, 107,  5, 15, RACE_BEASTMAN},
		{ "ϥ󥵥ʥå",        10000,    165, 107,  6, 18, RACE_HALF_TITAN},
		{ "ʥեӥ",         2500,    170, 108,  5, 15, RACE_HUMAN},
		{ "ϼΥꥹ",       5000,    175, 108,  4, 12, RACE_HUMAN},
		{ "ʢڥΥեС",          7500,    170, 107,  5, 15, RACE_VAMPIRE},
		{ "ʡ롦",        10000,    165, 107,  6, 18, RACE_MIND_FLAYER},
		{ "Ĺभ",         2500,    170, 108,  5, 15, RACE_SPECTRE},
		{ "ΥޤΥեǥ",       5000,    175, 108,  4, 12, RACE_ZOMBIE},
		{ "󥵥",          7500,    170, 107,  5, 15, RACE_SKELETON},
		{ "ǫʥå",        10000,    165, 107,  6, 18, RACE_VAMPIRE},
		{ "֥å",         2500,    170, 108,  5, 15, RACE_HALF_ORC},
		{ "٥쥹",       5000,    175, 108,  4, 12, RACE_HIGH_ELF},
		{ "쥹",          7500,    170, 107,  5, 15, RACE_GNOME},
		{ "ʡå",        10000,    165, 107,  6, 18, RACE_DWARF},
		{ "ӤΥإͥå",         2500,    170, 108,  5, 15, RACE_GNOME},
		{ "",       5000,    175, 108,  4, 12, RACE_HALF_GIANT},
		{ "©Υ",          7500,    170, 107,  5, 15, RACE_DRACONIAN},
		{ "Ǥ֤ä祢饡",        10000,    165, 107,  6, 18, RACE_DRACONIAN},
		{ "ǽʥס",         2500,    170, 108,  5, 15, RACE_BEASTMAN},
		{ "եեꥢ",       5000,    175, 108,  4, 12, RACE_ELF},
		{ "ǯޥ",          7500,    170, 107,  5, 15, RACE_GNOME},
		{ "ͦʥ",        10000,    165, 107,  6, 18, RACE_HALF_GIANT},
		{ "ļ˼ԥӥޡ",         2500,    170, 108,  5, 15, RACE_HUMAN},
		{ "˳ʥϡ",       5000,    175, 108,  4, 12, RACE_HALF_ORC},
		{ "ߤʥ",          7500,    170, 107,  5, 15, RACE_ZOMBIE},
		{ "Ǥʥ",        10000,    165, 107,  6, 18, RACE_ELF},
#else
		{ "Bilbo the Friendly",         2000,    170, 108,  5, 15, RACE_HOBBIT},
		{ "Rincewind the Chicken",       2000,    175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",          3000,    170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",         3000,    165, 107,  6, 18, RACE_ELF},
		{ "Falilmawen the Friendly",         2500,    170, 108,  5, 15, RACE_HOBBIT},
		{ "Voirin the Cowardly",       5000,    175, 108,  4, 12, RACE_HUMAN},
		{ "Erashnak the Midget",          7500,    170, 107,  5, 15, RACE_BEASTMAN},
		{ "Grug the Comely",        10000,    165, 107,  6, 18, RACE_HALF_TITAN},
		{ "Forovir the Cheap",         2500,    170, 108,  5, 15, RACE_HUMAN},
		{ "Ellis the Fool",       5000,    175, 108,  4, 12, RACE_HUMAN},
		{ "Filbert the Hungry",          7500,    170, 107,  5, 15, RACE_VAMPIRE},
		{ "Fthnargl Psathiggua",        10000,    165, 107,  6, 18, RACE_MIND_FLAYER},
		{ "Eloise Long-Dead",         2500,    170, 108,  5, 15, RACE_SPECTRE},
		{ "Fundi the Slow",       5000,    175, 108,  4, 12, RACE_ZOMBIE},
		{ "Granthus",          7500,    170, 107,  5, 15, RACE_SKELETON},
		{ "Lorax the Suave",        10000,    165, 107,  6, 18, RACE_VAMPIRE},
		{ "Butch",         2500,    170, 108,  5, 15, RACE_HALF_ORC},
		{ "Elbereth the Beautiful",       5000,    175, 108,  4, 12, RACE_HIGH_ELF},
		{ "Sarleth the Sneaky",          7500,    170, 107,  5, 15, RACE_GNOME},
		{ "Narlock",        10000,    165, 107,  6, 18, RACE_DWARF},
		{ "Haneka the Small",         2500,    170, 108,  5, 15, RACE_GNOME},
		{ "Loirin the Mad",       5000,    175, 108,  4, 12, RACE_HALF_GIANT},
		{ "Wuto Poisonbreath",          7500,    170, 107,  5, 15, RACE_DRACONIAN},
		{ "Araaka the Rotund",        10000,    165, 107,  6, 18, RACE_DRACONIAN},
		{ "Poogor the Dumb",         2500,    170, 108,  5, 15, RACE_BEASTMAN},
		{ "Felorfiliand",       5000,    175, 108,  4, 12, RACE_ELF},
		{ "Maroka the Aged",          7500,    170, 107,  5, 15, RACE_GNOME},
		{ "Sasin the Bold",        10000,    165, 107,  6, 18, RACE_HALF_GIANT},
		{ "Abiemar the Peasant",         2500,    170, 108,  5, 15, RACE_HUMAN},
		{ "Hurk the Poor",       5000,    175, 108,  4, 12, RACE_HALF_ORC},
		{ "Soalin the Wretched",          7500,    170, 107,  5, 15, RACE_ZOMBIE},
		{ "Merulla the Humble",        10000,    165, 107,  6, 18, RACE_ELF},
#endif
	},
	{
		/* Armoury - 28 unique names */
#ifdef JP
		{ "=",      5000,   210,  115,   5,   7,  RACE_HALF_ORC},
		{ "Ǽԥ=",  10000,  190,  111,   4,   9,  RACE_HUMAN},
		{ "ԥǥ",                 25000,  200,  112,   4,  10,  RACE_DUNADAN},
		{ "결Υ",   30000,  200,  112,   4,   5,  RACE_DWARF},
		{ "=",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Ǽԥ=",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "ɥ饴󥹥",          30000,  200, 112,  4,  5, RACE_ELF},
		{ "ǥꥫȥ",           10000,   210, 115,  5,  7, RACE_SPRITE},
		{ "ʥ롼",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
		{ "˥ॹ",            25000,  200, 112,  4, 10, RACE_GOLEM},
		{ "ޥ",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
		{ "饯",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
		{ "ǥ",          5000,  190, 111,  4,  9, RACE_SPECTRE},
		{ "ʥɥꥪ",            25000,  200, 112,  4, 10, RACE_SPECTRE},
		{ "䤿Хå",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
		{ "󥸥",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
		{ "ԥ",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "襸",            25000,  200, 112,  4, 10, RACE_DWARF},
		{ "ͥʥ顼",          30000,  200, 112,  4,  5, RACE_AMBERITE},
		{ "ԾΥۥХ",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "ƥѥΥ",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
		{ "ɥꥢ",            25000,  200, 112,  4, 10, RACE_SPRITE},
		{ "ܥʡ",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
		{ "٤Υǥå",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
		{ "إ",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
		{ "벰Υ٥ꥹ",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
		{ "פΥ",          30000,  200, 112,  4,  5, RACE_IMP},
		{ "=",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Ǽԥ=",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "결Υ",          30000,  200, 112,  4,  5, RACE_DWARF},
#else
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
		{ "Kon-Dar the Ugly",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "Elo Dragonscale",          30000,  200, 112,  4,  5, RACE_ELF},
		{ "Delicatus",           10000,   210, 115,  5,  7, RACE_SPRITE},
		{ "Gruce the Huge",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
		{ "Animus",            25000,  200, 112,  4, 10, RACE_GOLEM},
		{ "Malvus",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
		{ "Selaxis",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
		{ "Deathchill",          5000,  190, 111,  4,  9, RACE_SPECTRE},
		{ "Drios the Faint",            25000,  200, 112,  4, 10, RACE_SPECTRE},
		{ "Bathric the Cold",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
		{ "Vengella the Cruel",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
		{ "Wyrana the Mighty",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Yojo II",            25000,  200, 112,  4, 10, RACE_DWARF},
		{ "Ranalar the Sweet",          30000,  200, 112,  4,  5, RACE_AMBERITE},
		{ "Horbag the Unclean",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Elelen the Telepath",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
		{ "Isedrelias",            25000,  200, 112,  4, 10, RACE_SPRITE},
		{ "Vegnar One-eye",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
		{ "Rodish the Chaotic",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
		{ "Hesin Swordmaster",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
		{ "Elvererith the Cheat",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
		{ "Zzathath the Imp",          30000,  200, 112,  4,  5, RACE_IMP},
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
#endif
	},

	{
		/* Weapon Smith - 28 unique names */
#ifdef JP
		{ "Ǧʤ륢Υ",        5000,   210,  115,   6,   6,  RACE_HALF_TROLL},
		{ "ûΥ", 10000,  185,  110,   5,   9,  RACE_HALF_ELF},
		{ "åޥΥǥ", 25000,  190,  115,   5,   7,  RACE_HOBBIT},
		{ "εΥ饤", 30000,  195,  112,   4,   8,  RACE_DWARF},
		{ "ԥɥ塼",      10000,   210, 115,  6,  6, RACE_HUMAN},
		{"ζλҥå",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
		{ "µΥ󥹥å",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "ԥ륳",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "ԤΥꥢ",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
		{"Υȥ",        15000,  185, 110,  5,  9, RACE_SKELETON},
		{ "ӥꥪ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "ե",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
		{ "ѥǥΥեꥹ",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
		{"'ȥ'",        15000,  185, 110,  5,  9, RACE_KLACKON},
		{ "ͧɥ",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
		{ "ͻΥե󥰥",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "ǥ",      10000,   210, 115,  6,  6, RACE_ELF},
		{"󥸥㡼Υӥ",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "ΥޤΥ",         25000,  190, 115,  5,  7, RACE_GOLEM},
		{ "󡦥եå",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
		{ "ԥʥɥå",      10000,   210, 115,  6,  6, RACE_HOBBIT},
		{"⥰",        15000,  185, 110,  5,  9, RACE_KOBOLD},
		{ "ʥꥹ",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
		{ "ХΥҥ奤⥰",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
		{ "ԡ",      5000,   210, 115,  6,  6, RACE_HUMAN},
		{ "⥰ 쥤䡼",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
		{ "աʥ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "ƮХ",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
		{ " Ǧʤ륢Υ",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "ûΥ",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "ӡȥޥǥ",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "εΥ饤",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Drew the Skilled",      10000,   210, 115,  6,  6, RACE_HUMAN},
		{"Orrax Dragonson",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
		{ "Anthrax Disease-Carrier",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Arkhoth the Stout",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Sarlyas the Rotten",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
		{"Tuethic Bare-Bones",        15000,  185, 110,  5,  9, RACE_SKELETON},
		{ "Bilious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Fasgul",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
		{ "Ellefris the Paladin",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
		{"K'trrik'k",        15000,  185, 110,  5,  9, RACE_KLACKON},
		{ "Drocus Spiderfriend",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
		{ "Fungus Giant-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Delantha",      10000,   210, 115,  6,  6, RACE_ELF},
		{"Solvistani the Ranger",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Xoril the Slow",         25000,  190, 115,  5,  7, RACE_GOLEM},
		{ "Aeon Flux",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
		{ "Nadoc the Strong",      10000,   210, 115,  6,  6, RACE_HOBBIT},
		{"Eramog the Weak",        15000,  185, 110,  5,  9, RACE_KOBOLD},
		{ "Eowilith the Fair",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
		{ "Huimog Balrog-Slayer",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
		{ "Peadus the Cruel",      5000,   210, 115,  6,  6, RACE_HUMAN},
		{ "Vamog Slayer",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
		{ "Hooshnak the Vicious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Balenn War-Dancer",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif
	},
	{
		/* Temple - 22 unique names */
#ifdef JP
		{ "Ǥʥ롼ɥ",         5000,   175,  109,   6,  15,  RACE_HUMAN},
		{ "ѥǥΥʡ",       10000,  185,  110,   5,  23,  RACE_HUMAN},
		{ "Ф줷ȥ",                     25000,  180,  107,   6,  20,  RACE_ELF},
		{ "ʤ륵饹ȥ",                     30000,  185,  109,   5,  15,  RACE_DWARF},
		{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "ɥ륤ɤΥϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "եʥ",          30000,  185, 109,  5, 15, RACE_YEEK},
		{ "ꥭå",         10000,   175, 109,  6, 15, RACE_KLACKON},
		{ "Ӥԥ",         15000,  185, 110,  5, 23, RACE_ELF},
		{ "Ťۥå",           25000,  180, 107,  6, 20, RACE_IMP},
		{ "ԥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "٥˥å",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "ǥ",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "ѻեɥ",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
		{ "Υϥ",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
		{ "㤭ץ롼ǥ",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
		{ "磻",         15000,  185, 110,  5, 23, RACE_YEEK},
		{ "ͭԥ",           25000,  180, 107,  6, 20, RACE_KOBOLD},
		{ "ɥС",          30000,  185, 109,  5, 15, RACE_SPECTRE},
		{ "Ǥʥ롼ɥ",         5000,   175,  109,   6,  15,  RACE_HUMAN},
		{ "ѥǥΥʡ",       10000,  185,  110,   5,  23,  RACE_HUMAN},
		{ "Ф줷ȥ",                     25000,  180,  107,   6,  20,  RACE_ELF},
		{ "ʤ륵饹ȥ",                     30000,  185,  109,   5,  15,  RACE_DWARF},
		{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "ɥ륤ɤΥϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "եʥ",          30000,  185, 109,  5, 15, RACE_YEEK},
#else
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
		{ "Krikkik",         10000,   175, 109,  6, 15, RACE_KLACKON},
		{ "Morival the Wild",         15000,  185, 110,  5, 23, RACE_ELF},
		{ "Hoshak the Dark",           25000,  180, 107,  6, 20, RACE_IMP},
		{ "Atal the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Ibenidd the Chaste",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Eridish",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Vrudush the Shaman",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
		{ "Haob the Berserker",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
		{ "Proogdish the Youthfull",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
		{ "Lumwise the Mad",         15000,  185, 110,  5, 23, RACE_YEEK},
		{ "Muirt the Virtuous",           25000,  180, 107,  6, 20, RACE_KOBOLD},
		{ "Dardobard the Weak",          30000,  185, 109,  5, 15, RACE_SPECTRE},
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
#endif
	},
	{
		/* Alchemist - 26 unique names */
#ifdef JP
		{ "ؼԥޥ",             10000,  190,  111,   5,   8,  RACE_HALF_ELF},
		{ "Υ",   10000,  190,  110,   6,   8,  RACE_HOBBIT},
		{ "ߥߥ",              15000,  200,  116,   6,   9,  RACE_GNOME},
		{ "ϼ奸=ե",                   15000,  220,  111,   4,   9,  RACE_ELF},/*FIRST*/
		{ "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "ѿեͥ饹",         10000,  190, 111,  5,  8, RACE_DWARF},
		{ "Υ󥷡",         10000,  190, 110,  6,  8, RACE_HUMAN},
		{ "֥",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "եå",       15000,  220, 111,  4,  9, RACE_SPRITE},
		{ "륹",         10000,  190, 111,  5,  8, RACE_HUMAN},
		{ "ŤС",         10000,  190, 110,  6,  8, RACE_DWARF},
		{ "ؤ⤭ɥ",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
		{ "ϣѻե",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
		{ "Ťեꥢ",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
		{ "Ǥʥɥ",           15000,  200, 116,  6,  9, RACE_DWARF},
		{ "λҥ䥡å",       15000,  220, 111,  4,  9, RACE_IMP},
		{ "եɡ",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
		{ "ԥ",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
		{ "ǥ˥ȤΥե",           15000,  200, 116,  6,  9, RACE_IMP},
		{ "ϣѻեɥꥢ",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
		{ "ԥͥꥢ",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
		{ "ɸꥰʥ",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
		{ "ƥ",           15000,  200, 116,  6,  9, RACE_HOBBIT},
		{ "ߥɥå",       15000,  220, 111,  4,  9, RACE_HUMAN},

		{ "ʳؼԥޥ",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Υ",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "ߥߥ",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "ϣѻե=ե",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
#else
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Fanelath the Cautious",         10000,  190, 111,  5,  8, RACE_DWARF},
		{ "Runcie the Insane",         10000,  190, 110,  6,  8, RACE_HUMAN},
		{ "Grumbleworth",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Flitter",       15000,  220, 111,  4,  9, RACE_SPRITE},
		{ "Xarillus",         10000,  190, 111,  5,  8, RACE_HUMAN},
		{ "Egbert the Old",         10000,  190, 110,  6,  8, RACE_DWARF},
		{ "Valindra the Proud",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
		{ "Taen the Alchemist",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "Cayd the Sweet",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
		{ "Fulir the Dark",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
		{ "Domli the Humble",           15000,  200, 116,  6,  9, RACE_DWARF},
		{ "Yaarjukka Demonspawn",       15000,  220, 111,  4,  9, RACE_IMP},
		{ "Gelaraldor the Herbmaster",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
		{ "Olelaldan the Wise",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
		{ "Fthoglo the Demonicist",           15000,  200, 116,  6,  9, RACE_IMP},
		{ "Dridash the Alchemist",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
		{ "Nelir the Strong",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
		{ "Lignus the Pungent",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
		{ "Tilba",           15000,  200, 116,  6,  9, RACE_HOBBIT},
		{ "Myrildric the Wealthy",       15000,  220, 111,  4,  9, RACE_HUMAN},

		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif
	},

	{
		/* Magic Shop - 23 unique names */
#ifdef JP
		{ "顼Υ=ѥ",       20000,  200,  110,   7,   8,  RACE_HALF_ELF},
		{ "ʤ֥ӥ",         20000,  215,  113,   6,  10,  RACE_GNOME},
		{ "ˡȤ",     30000,  200,  110,   7,  10,  RACE_HUMAN},
		{ "Ȥ㥯",30000,      175,  110,   5,  11,  RACE_HIGH_ELF},
		{ "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "²Υ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Ťե",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ʤ륱ɡ",        15000,  200, 110,  7,  8, RACE_DWARF},
		{ "ե󥹥ץ",         20000,  215, 113,  6, 10, RACE_HOBBIT},
		{ "Υʡ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻեӥꥢ",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
		{ "ϥᥤΥ饯",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
		{ "ηüԥޥǥå",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
		{ "ե֥ܡ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "ե=",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ѻե쥴",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
		{ "ȥȥ",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "ѻե٥",       30000,  200, 110,  7, 10, RACE_SKELETON},
		{ "ѻեإȡ",       30000,  175, 110,  5, 11, RACE_YEEK},
		{ "ѻե=ѥ",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "ʤ֥ӥ",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "ˡȤ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻե㥯",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "Kaza the Noble",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Fazzil the Dark",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Keldorn the Grand",        15000,  200, 110,  7,  8, RACE_DWARF},
		{ "Philanthropus",         20000,  215, 113,  6, 10, RACE_HOBBIT},
		{ "Agnar the Enchantress",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Buliance the Necromancer",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
		{ "Vuirak the High-Mage",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
		{ "Madish the Smart",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
		{ "Falebrimbor",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Felil-Gand the Subtle",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Thalegord the Shaman",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
		{ "Cthoaloth the Mystic",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "Ibeli the Illusionist",       30000,  200, 110,  7, 10, RACE_SKELETON},
		{ "Heto the Necromancer",       30000,  175, 110,  5, 11, RACE_YEEK},
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif
	},
	{
		/* Black Market - 32 unique names */
#ifdef JP
		{ "꡼=",            20000,  250,  150,  10,   5,  RACE_HALF_TROLL},
		{ "֥Υҥȡ",       20000,  250,  150,  10,   5,  RACE_HALF_ORC},
		{ "ե󥮿ͥ",           30000,  250,  150,  10,   5,  RACE_HUMAN},
		{ "ʤ(?)ȥå",                     30000,  250,  150,  10,   5,  RACE_ELF},
		{ "ͥå",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "΢ڤԥ",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "֥ܥ˥",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "ץ饤",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "˵ѥå",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "",          20000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Υץƥ",          30000,  250, 150, 10,  5, RACE_SKELETON},
		{ "ʹֻΥꥨ",           30000,  250, 150, 10,  5, RACE_IMP},
		{ "󥸥",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Ĥեĥ",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "ˡ",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "뤤ʥ",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "ѻեƥ", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
		{ "ܥΥץʥ",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "ʥեåȥ",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "ؤΥɥꥢ",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "ʻեꥢ",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
		{ "꤯Υʥå",          20000,  250, 150, 10,  5, RACE_GNOME},
		{ "ޥ",          30000,  250, 150, 10,  5, RACE_GNOME},
		{ "ޥ˥å",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
		{ "˳㥨",                 20000,  250, 150, 10,  5, RACE_HUMAN},
		{ "±եɡ",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
		{ "ߥ饶",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
		{ "ե쥦",           30000,  250, 150, 10,  5, RACE_SPRITE},
		{ "路",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
		{ "ϥ󥵥ʥ饪",          20000,  250, 150, 10,  5, RACE_AMBERITE},
		{ "餱ɥե",          30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "­Υ롼",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#else
		{ "Gary Gygaz",                 20000,  250, 150, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Quark the Ferengi",          30000,  250, 150, 10,  5, RACE_DWARF},
		{ "Topi the Fair(?)",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Vhassa the Dead",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "Kyn the Treacherous",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Bubonicus",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "Corpselight",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "Parrish the Bloodthirsty",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Vile",          20000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Prentice the Trusted",          30000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Griella Humanslayer",           30000,  250, 150, 10,  5, RACE_IMP},
		{ "Angel",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Flotsam the Bloated",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "Nieval",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Anastasia the Luminous",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "Charity the Necromancer", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
		{ "Pugnacious the Pugilist",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Footsore the Lucky",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "Sidria Lighfingered",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Riatho the Juggler",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
		{ "Janaaka the Shifty",          20000,  250, 150, 10,  5, RACE_GNOME},
		{ "Cina the Rogue",          30000,  250, 150, 10,  5, RACE_GNOME},
		{ "Arunikki Greatclaw",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
		{ "Chaeand the Poor",                 20000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Afardorf the Brigand",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
		{ "Lathaxl the Greedy",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
		{ "Falarewyn",           30000,  250, 150, 10,  5, RACE_SPRITE},
		{ "Vosur the Wrinkled",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
		{ "Araord the Handsome",          20000,  250, 150, 10,  5, RACE_AMBERITE},
		{ "Theradfrid the Loser",          30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "One-Legged Eroolo",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#endif
	},
	{
		/* Home */
#ifdef JP
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
#else
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
#endif

	},

	{
		/* Bookstore - 21 unique names */
#ifdef JP
		{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ȻΥ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
		{ "", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "ǥޥ", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
		{ "ؼԤΥ", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
		{ "ͤΥץ", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
		{ "ŴΥʡ", 25000, 120, 110, 7, 19, RACE_GOLEM},
#else
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
		{ "Shallowgrave", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Death Mask", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
		{ "Asuunu the Learned", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
		{ "Prirand the Dead", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
		{ "Ronar the Iron", 25000, 120, 110, 7, 19, RACE_GOLEM},
#endif
#ifdef JP
		{ "=ߥ", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ܿХ", 15000, 175, 108, 4, 12, RACE_KOBOLD},
		{ "ꥢꥭ", 20000, 120, 105, 6, 16, RACE_KLACKON},
		{ "Ťʤ", 25000, 120, 110, 7, 19, RACE_DWARF},
		{ "ԥ", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
		{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Ȼ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#else
		{ "Galil-Gamir", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Rorbag Book-Eater", 15000, 175, 108, 4, 12, RACE_KOBOLD},
		{ "Kiriarikirk", 20000, 120, 105, 6, 16, RACE_KLACKON},
		{ "Rilin the Quiet", 25000, 120, 110, 7, 19, RACE_DWARF},
		{ "Isung the Lord", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#endif
	},

	{
		/* Museum */
#ifdef JP
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
		{ "ʪ",                          0,      100, 100,  0, 99, 99},
#else
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
		{ "Museum",                          0,      100, 100,  0, 99, 99},
#endif

	},

};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
const byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};




/*
 * Base experience levels, may be adjusted up for race and/or class
 */
const s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,/*10*/
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,/*20*/
	5400,
	6800,
	8400,
	10200,
	12500,
	17500,
	25000,
	35000L,
	50000L,
	75000L,/*30*/
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,/*40*/
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,/*50*/
	5000000L
};


const s32b player_exp_a[PY_MAX_LEVEL] =
{
	20,
	50,
	100,
	170,
	280,
	430,
	650,
	950,
	1400,/*10*/
	1850,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10400,
	12500,/*20*/
	17500,
	25000,
	35000,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,/*30*/
	450000L,
	550000L,
	650000L,
	800000L,
	950000L,
	1100000L,
	1250000L,
	1400000L,
	1550000L,
	1700000L,/*40*/
	1900000L,
	2100000L,
	2300000L,
	2550000L,
	2800000L,
	3050000L,
	3300000L,
	3700000L,
	4100000L,
	4500000L,/*50*/
	5000000L
};


/*
 * Player Sexes
 *
 *      Title,
 *      Winner
 */
const player_sex sex_info[MAX_SEXES] =
{
	{
#ifdef JP
		"",
		"",
#endif
		"Female",
		"Queen"
	},
	{
#ifdef JP
		"",
		"",
#endif
		"Male",
		"King"
	}
};


/*
 * Player Races
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *      hitdie, exp base,
 *      Age (Base, Mod),
 *      Male (Hgt, Wgt),
 *      Female (Hgt, Wgt)
 *      infra,
 *      class-choices
 */
const player_race race_info[MAX_RACES] =
{
	{
#ifdef JP
		"ʹ",
#endif
		"Human",

		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		0xFFFFFFF,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Elf",

		{ -1,  1,  1,  1, -1,  1 },
		2,  3,  2,  1, 6,  11, -1,  5,
		9,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		0xE77E7FF,
	},
	{
#ifdef JP
		"",
#endif
		"Elf",

		{ -1,  2,  0,  1, -2,  2 },
		5,  6,  4,  2, 8,  12, -5, 15,
		8,  120,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		0xE77E75B,

	},
	{
#ifdef JP
		"ۥӥå",
#endif
		"Hobbit",

		{ -2,  1,  1,  3,  2,  1 },
		15, 12, 10, 5, 12,  15, -10, 20,
		7,  110,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		0xF6FFC0B,
	},
	{
#ifdef JP
		"Ρ",
#endif
		"Gnome",

		{ -1,  2,  0,  2,  1, -1 },
		10, 8, 7,  3, 6,  13, -8, 12,
		8,  120,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		0xF67D60F,
	},
	{
#ifdef JP
		"ɥ",
#endif
		"Dwarf",

		{  2, -2,  2, -2,  2, -1 },
		2,  7,  6,  -1,  7,  10, 15,  0,
		11,  125,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		0x1890005,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Orc",

		{  2, -1,  0,  0,  1, -2 },
		-3, -3, -2,  -1,  0, 7, 12, -5,
		10,  110,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		0xDD8818D,
	},
	{
#ifdef JP
		"ϡեȥ",
#endif
		"Half-Troll",

		{ 4, -4, -1, -3,  3, -3 },
		-5, -8, -5, -2,  -1, 5, 20, -10,
		12,  125,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		0x0880005,
	},
	{
#ifdef JP
		"Х饤",
#endif
		"Amberite",

		{  1,  2,  2,  2,  3,  2 },
		4,  5,  3,  2, 3, 13, 15, 10,
		10,  225,
		50, 50,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0xFFFF7FF,
	},
	{
#ifdef JP
		"ϥ",
#endif
		"High-Elf",

		{  1,  3,  -1,  3,  1,  3 },
		4,  13, 12,  4,  3, 14, 10, 25,
		10,  200,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		0xF77E75B,
	},
	{
#ifdef JP
		"ڿ",
#endif
		"Barbarian",

		{ 3, -2,  -1,  1,  2, 0 },
		-2, -10, 2,  -1,  1, 7, 12, 10,
		11, 120,
		14, 8,
		82, 5, 200, 20,
		78,  6, 190, 15,
		0,
		0x5C0A09D,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Ogre",

		{ 3, -2, 0, -1, 3, -2 },
		-3, -5, -3, -2, -1, 5, 20, 0,
		12,  145,
		40, 10,
		92, 10, 255, 60,
		80,  8, 235, 60,
		3,
		0x0A80407,
	},
	{
#ifdef JP
		"Ⱦ",
#endif
		"Half-Giant",

		{ 4, -2, -2, -2, 3, -2 },
		-6, -8, -3, -2, -1, 5, 25, 5,
		13, 160,
		40, 10,
		100,10, 255, 65,
		80, 10, 240, 64,
		3,
		0x8880011,
	},
	{
#ifdef JP
		"Ⱦ",
#endif
		"Half-Titan",

		{ 5, 1, 2, -2, 3, 1 },
		-5, 5, 1, -2, 1, 8, 25, 0,
		14, 255,
		100,30,
		111, 11, 255, 86,
		99, 11, 250, 86,
		0,
		0x23D4727,
	},
	{
#ifdef JP
		"ץ",
#endif
		"Cyclops",

		{ 4, -3, -2, -3, 4, -3 },
		-4, -5, -3, -2, -2, 5, 20, 12,
		13, 150,
		50, 24,
		92, 10, 255, 60,
		80,  8, 235, 60,
		1,
		0x0888005,
	},
	{
#ifdef JP
		"",
#endif
		"Yeek",

		{ -2, 1, 1, 1, -2, -4 },
		2, 4, 6, 3, 5, 15, -5, -5,
		7, 100,
		14, 3,
		50,  3, 90,  6,
		50,  3, 75,  3,
		2,
		0x667360F,
	},
	{
#ifdef JP
		"å",
#endif
		"Klackon",

		{ 2, -1, -1, 1, 2, -1 },
		10, 5, 3, 0, -1, 10, 5, 5,
		12, 190,
		20, 3,
		60,  3, 80,  4,
		54,  3, 70,  4,
		2,
		0x04D8011,
	},
	{
#ifdef JP
		"ܥ",
#endif
		"Kobold",

		{ 1, -1, 0, 1, 0, -2 },
		-2, -3, -1, -1, 1, 8, 10, -8,
		9, 125,
		11,  3,
		60,  1, 130,  5,
		55,  1, 100,  5,
		3,
		0x444A009,
	},
	{
#ifdef JP
		"ˡ٥",
#endif
		"Nibelung",

		{ 1, -1, 2, 0, 2, -2 },
		3, 5, 6, 1, 5, 10, 9, 0,
		11, 170,
		40, 12,
		43,  3, 92,  6,
		40,  3, 78,  3,
		5,
		0x569040F,
	},
	{
#ifdef JP
		"",
#endif
		"Dark-Elf",

		{ -1, 3, 2, 2, -2, 1 },
		5, 10, 12, 3, 8, 12, -5, 10,
		9, 150,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		5,
		0xE77C7DF,
	},
	{
#ifdef JP
		"ɥ饳˥",
#endif
		"Draconian",

		{ 2, 1, 1, 1, 2, -1 },
		-2, 5, 2, 0, 1, 10, 5, 5,
		11, 220,
		75, 33,
		76,  1, 160,  5,
		72,  1, 130,  5,
		2,
		0x7FFE757,
	},
	{
#ifdef JP
		"ޥɥե쥢",
#endif
		"Mindflayer",

		{ -3, 4, 4, 0, -2, -3 },
		10, 15, 9, 2, 5, 12, -10, -5,
		9, 140,
		100, 25,
		68,  6, 142, 15,
		63,  6, 112, 10,
		4,
		0x2334746,
	},
	{
#ifdef JP
		"",
#endif
		"Imp",

		{ 0, -1, -1, 1, 2, -1 },
		-3, 2, -1, 1, -1, 10, 5, -5,
		10, 115,
		13,  4,
		68,  1, 150,  5,
		64,  1, 120,  5,
		3,
		0xDB537CB,
	},
	{
#ifdef JP
		"",
#endif
		"Golem",

		{ 4, -5, -5, -2, 4, -2 },
		-5, -5, 6, -1, -1, 8, 20, 0,
		12, 200,
		1, 100,
		66,  1, 200,  6,
		62,  1, 180,  6,
		4,
		0x0800001,
	},
	{
#ifdef JP
		"",
#endif
		"Skeleton",

		{ 0, 1, -2, 0, 1, -2 },
		-5, 0, 3, -1, -1, 8, 10, 0,
		10, 145,
		100, 35,
		72,  6, 50, 5,
		66,  4, 50, 5,
		2,
		0x234070F,
	},
	{
#ifdef JP
		"",
#endif
		"Zombie",

		{ 2, -6, -6, 1, 4, -3 },
		-5, -5, 5, -1, -1, 5, 15, 0,
		13, 150,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		2,
		0x0800001,
	},
	{
#ifdef JP
		"۷쵴",
#endif
		"Vampire",

		{ 3, 3, -1, -1, 1, 2 },
		4, 8, 6, 4, 1, 8, 5, 0,
		11, 200,
		100, 30,
		72,  6, 180, 25,
		66,  4, 150, 20,
		5,
		0x67DC7FF,
	},
	{
#ifdef JP
		"ͩ",
#endif
		"Spectre",

		{ -5, 4, -1, 2, 0, -3 },
		10, 15, 12, 5, 5, 14, -15, -5,
		7, 210,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		5,
		0x631474A,
	},
	{
#ifdef JP
		"",
#endif
		"Sprite",

		{ -4, 3, 3, 3, -2, 2 },
		10, 8, 6, 4, 10, 10, -12, 0,
		7, 145,
		50, 25,
		32,  2, 75,  2,
		29,  2, 65,  2,
		4,
		0x623F65E,
	},
	{
#ifdef JP
		"ÿ",  
#endif
		"Beastman",

		{ 2, -2, -1, -1, 2, -2 },
		-5, -2, -1, -1, -1, 5, 12, 5,
		11, 140,
		14, 6,
		65,  6, 150, 20,
		61,  6, 120, 15,
		0,
		0x57887CF,
	},
	{
#ifdef JP
		"",
#endif
		"Ent",
		{ 2,  0,  2, -3,  2,  0 },
		 -5,  2,  5,  -1, 0, 9,  15, -5,
		 12, 140,
		120,  60,
		111, 11, 255, 50,
		99, 11, 250, 45,
		  0,
		0x0010005,
	},
	{
#ifdef JP
		"륳",
#endif
		"Archon",

		{  2,  0,  4,  1,  2,  3 },
		0,  12,  8,  2, 2, 11, 10, 10,
		11,  235,
		150, 150,
		82, 5, 190, 20,
		78,  6, 180, 15,
		3,
		0x779F777,
	},
	{
#ifdef JP
		"Х",
		"Balrog",
#else
		"Balrog",
#endif

		{  4,  2,  -10,  2,  3,  -5 },
		-3,  12, 15,  -2,  1, 8, 20, 0,
		12,  250,
		255, 255,
		100,10, 255, 65,
		80, 10, 240, 64,
		5,
		0x7EDC4DB,
	},
	{
#ifdef JP
		"ɥʥ",
#endif
		"Dunadan",

		{  1,  2,  2,  2,  3,  2 },
		4,  5,  3,  2, 3, 13, 15, 10,
		10,  180,
		50, 20,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0xFFFF7FF,
	},
	{
#ifdef JP
		"ƥե꡼",
#endif
		"Shadow-Fairy",
		{-2,  2,  2,  1, -1,  0 },
		  7,  8,  0,  6, 12, 15, -10, -5,
		  7, 120,
		200, 100,
		 80,  8, 90, 20,
		 73,  8, 80, 15,
		  4,
		0xE33C7DF,
	},
	{
#ifdef JP
		"",
#endif
		"Kutar",

		{  0,  -1,  -1,  1,  2,  3 },
		-2,  5,  5,  5,  -2,  6,  0,  -5,
		11,  140,
		14,  6,
		48,  6, 150, 25,
		44,  4, 130, 20,
		0,
		0xC18B7AD,
	},
	{
#ifdef JP
		"ɥ",
#endif
		"Android",

		{ 4, -5, -5, 0, 4, -2 },
		0, -5, 0, -2, 3, 14, 20, 10,
		13, 200,
		1, 100,
		72, 12, 240, 64,
		66, 12, 220, 64,
		0,
		0x0800001,
	},
};


/*
 * Player Classes
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *      x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *      HD, Exp, pet_upkeep_div
 */
const player_class class_info[MAX_CLASS] =
{
	{
#ifdef JP
		"",
#endif
		"Warrior",

		{ 4, -2, -2, 2, 2, -1},
		25, 18, 31, 1,  14, 2, 70, 55,
		12, 7,  10, 0,  0,  0,  30, 30,
		9,  0, 40
	},

	{
#ifdef JP
		"ᥤ",
#endif
		"Mage",

		{-4, 3, 0, 1, -2, 1},
		30, 40, 38, 3,  16, 20, 34, 20,
		7,  15, 11,  0,  0,  0,  6, 7,
		0, 30, 30
	},

	{
#ifdef JP
		"ץ꡼",
#endif
		"Priest",

		{-1, -3, 3, -1, 0, 2},
		25, 35, 40, 2,  16, 8, 48, 35,
		7,  11, 12, 0,  0,  0, 13, 11,
		2, 20, 35
	},

	{
#ifdef JP
		"±",
#endif
		"Rogue",

		{ 2, 1, -2, 3, 1, -1},
		45, 37, 36, 5, 32, 24, 60, 66,
		15, 12, 10, 0,  0,  0, 21, 18,
		6, 25, 40
	},

	{
#ifdef JP
		"󥸥㡼",
#endif
		"Ranger",

		{ 2, 2, 0, 1, 1, 1},
		30, 37, 36, 3,  24, 16, 56, 72,
		8,  11, 10, 0,  0,  0,  18, 28,
		4, 40, 35
	},

	{
#ifdef JP
		"ѥǥ",
#endif
		"Paladin",

		{ 3, -3, 1, 0, 2, 2},
		20, 24, 34, 1,  12, 2, 68, 40,
		7,  10, 11, 0,  0,  0,  21, 18,
		6, 35, 40
	},

	{
#ifdef JP
		"ˡ",
#endif
		"Warrior-Mage",

		{ 2, 2, 0, 1, 0, 1},
		30, 35, 36, 2,  18, 16, 50, 25,
		7,  10, 10, 0,  0,  0,  15, 11,
		4, 40, 35
	},

	{
#ifdef JP
		"٤",
#endif
		"Chaos-Warrior",

		{ 2, 1, -1, 0, 2, -2},
		20, 25, 34, 1,  14, 12, 65, 40,
		7,  11, 10, 0,  0,  0,  20, 17,
		6, 25, 40
	},

	{
#ifdef JP
		"",
#endif
		"Monk",

		{ 2, -1, 1, 3, 2, 1},
		45, 34, 36, 5, 32, 24, 64, 60,
		15, 11, 10, 0,  0,  0, 18, 18,
		6, 30, 35
	},

	{
#ifdef JP
		"Ķǽϼ",
#endif
		"Mindcrafter",

		{-1, 0, 3, -1, -1, 2},   /* note: spell stat is Wis */
		30, 33, 38, 3,  22, 16, 50, 40,
		10, 11, 10, 0,   0,  0, 14, 18,
		2, 25, 35
	},

	{
#ifdef JP
		"ϥ=ᥤ",
#endif
		"High-Mage",

		{-4, 4, 0, 0, -2, 1},
		30, 40, 38, 3,  16, 20, 34, 20,
		7,  15, 11,  0,  0,  0,  6, 7,
		0, 30, 25
	},

	{
#ifdef JP
		"Ѹ",
#endif
		"Tourist",
		{ -1, -1, -1, -1, -1, -1},
		15, 18, 28, 1, 12, 2, 40, 20,
		5, 7, 9, 0,  0,  0,  11, 11,
		0, -30, 40
	},

	{
#ifdef JP
		"Τޤͻ",
#endif
		"Imitator",
		{ 0, 1, -1, 2, 0, 1},
		25, 30, 36, 2,  18, 16, 60, 50,
		7,  10,  10, 0,  0,  0,  18, 20,
		5, 10, 20
	},

	{
#ifdef JP
		"ûȤ",
#endif
		"BeastMaster",
		{ 1, -1, -1, 1, 0, 2},
		20, 25, 32, 2,  18, 16, 52, 63,
		7,  10, 10, 0,  0,  0,  14, 25,
		3, 20, 10
	},

	{
#ifdef JP
		"ڥޥ",
#endif
		"Sorcerer",

		{-5, 6, -2, 2, 0, -2},
		30, 48, 75, 2,  12, 22,  0, 0,
		 7, 18, 13, 0,  0,  0,  0, 0,
		4, 60, 25
	},

	{
#ifdef JP
		"㡼",
#endif
		"Archer",

		{ 2, -1, -1, 2, 1, 0},
		38, 24, 35, 4,  24, 16, 56, 82,
		12, 10, 10, 0,  0,  0,  18, 36,
		6, 10, 40
	},

	{
#ifdef JP
		"ƻѻ",
#endif
		"Magic-Eater",

		{-1, 2, 1, 2, -2, 1},
		25, 42, 36, 2,  20, 16, 48, 35,
		7,  16, 10,  0,  0,  0, 13, 11,
		3, 30, 30
	},

	{
#ifdef JP
		"ͷ",
#endif
		"Bard",              /* Note : spell stat is Charisma */
		{-2, 1, 2, -1, -2, 4},
		20, 33, 34, -5, 16, 20, 34, 20,
		8,  13, 11, 0,  0,  0,  10, 8,
		2, 40, 25
	},

	{
#ifdef JP
		"ƻ",
#endif
		"Red-Mage",

		{ 2, 2, -1, 1, 0, -1},
		20, 34, 34, 1,  16, 10, 56, 25,
		7,  11, 11, 0,  0,  0,  18, 11,
		4, 40, 40
	},

	{
#ifdef JP
		"Ѳ",
#endif
		"Samurai",

		{ 3, -2, 1, 2, 1, 0},
		25, 18, 32, 2,  16, 6, 70, 40,
		12, 7,  10, 0,  0,  0,  23, 18,
		6,  30, 40
	},

	{
#ifdef JP
		"ѻ",
#endif
		"ForceTrainer",

		{ 0, -1, 3, 2, 1, 1},
		30, 34, 38, 4, 32, 24, 50, 40,
		10, 11, 11, 0,  0,  0, 14, 15,
		2, 35, 40
	},

	{
#ifdef JP
		"ƻ",
#endif
		"Blue-Mage",

		{-4, 4, -1, 1, -2, -1},
		30, 40, 36, 3,  20, 16, 40, 25,
		7,  16, 11,  0,  0,  0,  6, 7,
		2, 30, 35
	},

	{
#ifdef JP
		"ʼ",
#endif
		"Cavalry",
		{ 2, -2, -2, 2, 2, 0},
		20, 18, 32, 1,  16, 10, 60, 66,
		10,  7, 10, 0,  0,  0,  22, 26,
		5, 20, 35
	},

	{
#ifdef JP
		"",
#endif
		"Berserker",

		{ 8, -20, -20, 4, 4, -5},
		-100, -1000, -200, -100,  -100, -100, 120, -2000,
		0, 0,  0, 0,  0,  0,  50, 0,
		11,  60, 255
	},

	{
#ifdef JP
		"",
#endif
		"Weaponsmith",

		{ 3, -1, -1, 1, 0, -1},
		30, 28, 28, 1,  20, 10, 60, 45,
		10, 10,  10, 0,  0,  0,  21, 15,
		6,  30, 40
	},
	{
#ifdef JP
		"Ȥ",
#endif
		"Mirror-Master",

		{ -2,  3, 1, -1, -2, 1},
		30, 33, 40, 3, 14, 16, 34,30,
		10, 11, 12, 0,  0,  0,  6,10,
		2,  30, 30
	},
	{
#ifdef JP
		"Ǧ",
#endif
		"Ninja",

		{ 0,  -1, -1, 3, 2, -1},
		45, 24, 36, 8, 48, 32, 70,66,
		15, 10, 10, 0,  0,  0, 25,18,
		2,  20, 40
	},

	{
#ifdef JP
		"ʥѡ",
#endif
		"Sniper",

		{ 2, -1, -1, 2, 1, 0},
		25, 24, 28, 5, 32, 18, 56,  72,
		12, 10, 10, 0,  0,  0, 18,  28,
		2, 20, 40,
	},
};

const player_seikaku seikaku_info[MAX_SEIKAKU] =
{
	{
#ifdef JP
		"դĤ",
#endif
		"Ordinary",
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  0,  0,  0,
		0, 1, 0
	},

	{
#ifdef JP
		"餸ޤ",
#endif
		"Mighty",
		{  2,  -2,  -1,  0,  1,  0 },
		-5,  -5,  -3,  -1,  -2,  -2,  10,  0,
		1, 1, 0
	},

	{
#ifdef JP
		"",
#endif
		"Shrewd",
		{  -2,  2,  0,  1,  -1,  -1 },
		3,  8,  2,  0,  -2,  5,  -8,  -5,
		-1, 1, 0
	},

	{
#ifdef JP
		"碌",
#endif
		"Pious",
		{  0,  -1,  2,  -1,  0,  1 },
		-5,  2,  4,  -1,  3,  -2,  -3,  -6,
		0, 1, 0
	},

	{
#ifdef JP
		"Фä",
#endif
		"Nimble",
		{  -1,  1,  -1,  2,  -1,  -1 },
		7,  2,  -1,  1,  5,  5,  0,  10,
		0, 0, 0
	},

	{
#ifdef JP
		"Τ餺",
#endif
		"Fearless",
		{  2,  1,  1,  -1,  -1,  0 },
		-5,  5,  -2,  0,  2,  -2,  10,  10,
		-1, 1, 0
	},

	{
#ifdef JP
		"Хå",
#endif
		"Combat",
		{  1,  -1,  -2,  2,  0,  1 },
		-2,  -3,  -3,  0,  -1,  2,  5,  5,
		0, 0, 0
	},

	{
#ifdef JP
		"ʤޤ",
#endif
		"Lazy",
		{  -2,  -2,  -2,  -2,  -2,  -2 },
		-5,  -5,  -3,  -1,  -4,  -2,  -8,  -8,
		-1, 1, 0
	},

	{
#ifdef JP
		"",
#endif
		"Sexy",
		{  1,  1,  1,  1,  1,  3 },
		10,  5,  3,  0,  4,  2,  10,  10,
		0, 1, 1
	},

	{
#ifdef JP
		"åޥ",
#endif
		"Lucky",
		{  -2,  -2,  -2,  -2,  -2,  2 },
		10,  7,  3,  2, 10,  8,  15,  15,
		0, 1, 2
	},

	{
#ifdef JP
		"ޤŤ褤",
#endif
		"Patient",
		{  -1,  -1,  1,  -2,  2,  0 },
		-5,  -3,  3,  1,  0,  -3,  -6,  -6,
		1, 0, 0
	},

	{
#ifdef JP
		"",
#endif
		"Munchkin",
		{ 10,  10,  10,  10,  10,  10 },
		 20, 40, 30, 10, 40, 40,  80, 80,
		 15, 1, 0
	},
};



const player_race mimic_info[] =
{
	{
#ifdef JP
		"[ɸ]",
#endif
		"Default",

		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		0,
		0x000000,
	},
	{
#ifdef JP
		"[]",
#endif
		"[Demon]",

		{  5,  3,  2,  3,  4,  -6 },
		-5,  18, 20, -2,  3,  10, 40, 20,
		12,  0,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		5,
		0x000003,
	},
	{
#ifdef JP
		"[Ⲧ]",
#endif
		"[Demon lord]",

		{  20,  20,  20,  20,  20,  20 },
		20,  20, 25, -2,  3,  10, 70, 40,
		14,  0,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		20,
		0x000003,
	},
	{
#ifdef JP
		"[۷쵴]",
#endif
		"[Vampire]",

		{ 4, 4, 1, 1, 2, 3 },
		6, 12, 8, 6, 2, 12, 30, 20,
		11,  0,
		0,  0,
		0,  0, 0, 0,
		0,  0, 0, 0,
		5,
		0x000005,
	},
};



const magic_type technic_info[NUM_TECHNIC][32] =
{
	{
		/* Music */
		{ 1,  1,  10,   2},
		{ 2,  1,  10,   2},
		{ 3,  2,  20,   3},
		{ 4,  2,  20,   4},
		{ 5,  2,  20,   6},
		{ 7,  4,  30,   8},
		{ 9,  3,  30,   10},
		{ 10, 2,  30,   12},

		{ 12,  3,   40,   20},
		{ 15, 16,  42,   35},
		{ 17, 18,  40,   25},
		{ 18,  2,  45,   30},
		{ 23,  8,  50,   38},
		{ 28, 30,  50,   41},
		{ 33, 35,  60,   42},
		{ 38, 35,  70,   46},

		{ 10,  4,  20,   13},
		{ 22,  5,  30,   26},
		{ 23,  3,  35,   27},
		{ 26,  28,  37,   29},
		{ 32,  37,  41,   36},
		{ 33,  22,  43,   40},
		{ 37,  35,  46,   42},
		{ 45,  60,  50,   56},

		{ 23,  18,  20,   23},
		{ 30,  30,  30,   26},
		{ 33,  65,  41,   30},
		{ 37,  35,  43,   35},
		{ 40,  30,  46,   50},
		{ 42,  75,  50,   68},
		{ 45,  58,  62,   73},
		{ 49,  48,  70,  200}
	},

	{
		/* Hissatsu */
		{ 1,   15,   0,   0},
		{ 3,   10,   0,   0},
		{ 6,   15,   0,   0},
		{ 9,    8,   0,   0},
		{ 10,  12,   0,   0},
		{ 12,  25,   0,   0},
		{ 14,   7,   0,   0},
		{ 17,  20,   0,   0},

		{ 19,  10,   0,   0},
		{ 22,  20,   0,   0},
		{ 24,  30,   0,   0},
		{ 25,  10,   0,   0},
		{ 27,  15,   0,   0},
		{ 29,  45,   0,   0},
		{ 32,  70,   0,   0},
		{ 35,  50,   0,   0},

		{ 18,  40,   0,   0},
		{ 22,  22,   0,   0},
		{ 24,  30,   0,   0},
		{ 26,  35,   0,   0},
		{ 30,  30,   0,   0},
		{ 32,  60,   0,   0},
		{ 36,  40,   0,   0},
		{ 39,  80,   0,   0},

		{ 26,  20,   0,   0},
		{ 29,  40,   0,   0},
		{ 31,  35,   0,   0},
		{ 36,  80,   0,   0},
		{ 39, 100,   0,   0},
		{ 42, 110,   0,   0},
		{ 45, 130,   0,   0},
		{ 50, 255,   0,   0}
	},

	{
		/* Hex */
		{  1,  2, 20,   2},
		{  1,  2, 20,   2},
		{  3,  2, 30,   3},
		{  5,  3, 30,   4},
		{  7,  3, 40,   6},
		{  8, 10, 60,   8},
		{  9,  3, 30,  10},
		{ 10,  5, 40,  12},

		{ 12,  8, 40,  15},
		{ 12,  9, 35,  15},
		{ 15, 10, 50,  20},
		{ 20, 12, 45,  35},
		{ 25, 15, 50,  50},
		{ 30, 12, 60,  70},
		{ 35, 10, 60,  80},
		{ 40, 16, 70, 100},

		{ 15,  8, 20,  20},
		{ 18, 15, 50,  20},
		{ 22, 10, 65,  35},
		{ 25, 28, 70,  50},
		{ 28, 10, 70,  60},
		{ 30, 20, 60,  60},
		{ 36, 22, 70,  80},
		{ 40, 28, 70, 100},

		{  5,  6, 35,   5},
		{ 22, 24, 70,  40},
		{ 25,  2, 65,  50},
		{ 32, 20, 50,  70},
		{ 35, 35, 70,  80},
		{ 38, 32, 70,  90},
		{ 42, 24, 70, 120},
		{ 46, 45, 80, 200}
	},
};


/*
 * Zangband uses this array instead of the spell flags table, as there
 * are 5 realms of magic, each with 4 spellbooks and 8 spells per book -- TY
 */
const u32b fake_spell_flags[4]=
{
	0x000000ff,
	0x0000ff00,
	0x00ff0000,
	0xff000000
};


const s32b realm_choices1[MAX_CLASS] =
{
	(CH_NONE),				/* Warrior */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Mage */
	(CH_LIFE | CH_DEATH | CH_DAEMON |
	 CH_CRUSADE),                              /* Priest */
	(CH_SORCERY | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT),               /* Rogue */
	(CH_NATURE),                            /* Ranger */
	(CH_CRUSADE | CH_DEATH),                   /* Paladin */
	(CH_ARCANE),                            /* Warrior-Mage */
	(CH_CHAOS | CH_DAEMON),                 /* Chaos-Warrior */
	(CH_LIFE | CH_NATURE | CH_DEATH |
	 CH_ENCHANT),                           /* Monk */
	(CH_NONE),                              /* Mindcrafter */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE | CH_HEX),                  /* High-Mage */
	(CH_ARCANE),                            /* Tourist */
	(CH_NONE),                              /* Imitator */
	(CH_TRUMP),                             /* Beastmaster */
	(CH_NONE),                              /* Sorcerer */
	(CH_NONE),                              /* Archer */
	(CH_NONE),                              /* Magic eater */
	(CH_MUSIC),                             /* Bard */
	(CH_NONE),                              /* Red Mage */
	(CH_HISSATSU),                          /* Samurai */
	(CH_LIFE | CH_NATURE | CH_DEATH |
	 CH_ENCHANT | CH_CRUSADE),                 /* ForceTrainer */
	(CH_NONE),                              /* Blue Mage */
	(CH_NONE),				/* Cavalry */
	(CH_NONE),				/* Berserker */
	(CH_NONE),				/* Weaponsmith */
	(CH_NONE),				/* Mirror-master */
	(CH_NONE),				/* Ninja */
	(CH_NONE),				/* Sniper */
};


const s32b realm_choices2[MAX_CLASS] =
{
	(CH_NONE),                              /* Warrior */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Mage */
	(CH_LIFE | CH_SORCERY | CH_NATURE |
	 CH_CHAOS | CH_DEATH | CH_TRUMP |
	 CH_ARCANE | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Priest */
	(CH_NONE),                              /* Rogue */
	(CH_SORCERY | CH_CHAOS | CH_DEATH |
	 CH_TRUMP | CH_ARCANE | CH_DAEMON),     /* Ranger */
	(CH_NONE),                              /* Paladin */
	(CH_LIFE | CH_NATURE | CH_CHAOS |
	 CH_DEATH | CH_TRUMP | CH_ARCANE |
	 CH_SORCERY | CH_ENCHANT | CH_DAEMON |
	 CH_CRUSADE),                              /* Warrior-Mage */
	(CH_NONE),                              /* Chaos-Warrior */
	(CH_NONE),                              /* Monk */
	(CH_NONE),                              /* Mindcrafter */
	(CH_NONE),                              /* High-Mage */
	(CH_NONE),                              /* Tourist */
	(CH_NONE),                              /* Imitator */
	(CH_NONE),                              /* Beastmanster */
	(CH_NONE),                              /* Sorcerer */
	(CH_NONE),                              /* Archer */
	(CH_NONE),                              /* Magic eater */
	(CH_NONE),                              /* Bard */
	(CH_NONE),                              /* Red Mage */
	(CH_NONE),                              /* Samurai */
	(CH_NONE),                              /* ForceTrainer */
	(CH_NONE),                              /* Blue Mage */
	(CH_NONE),				/* Cavalry */
	(CH_NONE),				/* Berserker */
	(CH_NONE),				/* Weaponsmith */
	(CH_NONE),				/* Mirror-master */
	(CH_NONE),				/* Ninja */
	(CH_NONE),				/* Sniper */
};


#ifdef JP
const cptr realm_names[] =
{
	"ˡʤ",
	"̿",
	"",
	"",
	"",
	"Ź",
	"ȥ",
	"",
	"",
	"",
	"˼",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	""
};
#endif

#ifdef JP
const cptr E_realm_names[]
#else
const cptr realm_names[]
#endif
= {
	"none",
	"Life",
	"Sorcery",
	"Nature",
	"Chaos",
	"Death",
	"Trump",
	"Arcane",
	"Craft",
	"Daemon",
	"Crusade",
	"unknown",
	"unknown",
	"unknown",
	"unknown",
	"unknown",
	"Music",
	"Kendo",
	"Hex",
	"unknown"
};


/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
const int chest_traps[64] =
{
	0,                                      /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),                       /* 5 == best small wooden */
	0,
	(CHEST_ALARM),
	(CHEST_ALARM),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_SCATTER),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),                 /* 15 == best large wooden */
	0,
	(CHEST_ALARM),
	(CHEST_SCATTER),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),                        /* 25 == best small iron */
	0,
	(CHEST_E_SUMMON),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_BIRD_STORM),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON), /* 35 == best large iron */
	0,
	(CHEST_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_BIRD_STORM),
	(CHEST_EXPLODE | CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_H_SUMMON),        /* 45 == best small steel */
	0,
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM | CHEST_ALARM),
	(CHEST_H_SUMMON | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_H_SUMMON | CHEST_SCATTER | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL | CHEST_EXPLODE),  /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
#ifdef JP
const cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"",
	},

	/* Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Priest */
	{
		"",                 /* */
		"",             /*żԡΡȼΡ */
		"",
		"",                 /* */
		"ƻ",               /*ʺɾİƻ */
		"һ",               /*޶ */
		"",               /*ʶ綵ʶ */
		"׻",                 /*׻ʡʺ */
		"׻Ĺ",               /*׻ʡ׻Ĺ */
		"",
	},

	/* Rogues */
	{
		/* "Ĥ",*/                     /*Ĥ˷ϲ */
		"",
		"ɤϤ",                     /*ɤť */
		"",                         /*ť */
		"ť",                       /*ťť */
		"ڥƥ",                     /*̡ڥƥա */
		"",
		"ϥ",
		"ޥ", /* "ޥ", */
		"",						/* Ż */
		"Ƭ", /*"ɥޥ",*/
	},

	/* Rangers */
	{
		"Ȥ",
		"",
		"͸",                         /*͸ĥꡢ廡ʼ */
		"",
		"׼",
		"Ƴ",
		"õ",                       /*ԡõ */
		"",
		"Ƭ",
		"",
	},

	/* Paladins */
	{
		"ͦ",                 /*ˡ͡ԡͦʿ */
		"һ",
		"ݸ",
		"ɱҼ",
		"Ҽ",
		"",
		"ŵ",
		"",
		"",
		"Ĺ",
	},

	/* Warrior-Mage */
	{
		"",
		"",			/*ա */
		"",
		"Żʼ",
		"ʼ",
		"Ʈ",
		"Ѥαͺ", /* Mage-Hero */
		"˼",
		/* "", */
		"Ʈѻ",
		"μμ", /* "ɥ", */
	},

	/* Chaos Warrior */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"٤αͺ",
		"٤˼",
		"٤θ",
		"٤β",
	},

	/* Monk */
	{
		"",
		"",
		"ľ",
		"",
		"",
		"ƻ",
		"̾",
		"̾",
		"",
		"",
	},

	/* Mindcrafter */
	{
		"",
		"",
		"",
		"ã",
		"ۻ",
		"ѻ",
		"å",
		"˥å",
		"Ķǽϼ",
		"λۼ", /* "ޥɥޥ", */
	},

	/* High Mage; same as Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Tourist */
	{
		"סϺ",
		"Ѹ",
		"ͷιԼ",
		"",
		"ιԼ",
		"ϲ", /* "ι", */
		"ҳ",
		"õ",
		"",
		"ڥ󥫡",
	},

	/* Imitator */
	{
		"줫",
		"ޤ",
		"ޤޤ",
		"ܤܤ",
		"",
		"ޤޤ",
		"ʤʤ",
		"",
		"Ȥ",
		"餤",
	},

	/* Beastmaster */
	{
		"Ȥ",
		"إӻȤ",
		"Ȥ",
		"ϵȤ",
		"ȥȤ",
		"Ȥ",
		"ҥɥȤ",
		"ϥɻȤ",
		"ࡼޥȤ",
		"ɥ饴Ȥ",
	},

	/* Sorcerer; same as Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Archer */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"μ",
	},

	/* Magic eater */
	{
		"̵Τʤ",
		"",
		"ѻ",
		"ѻ",
		"ѻ",
		"",
		"ã",
		"ã",
		"ƻ",
		"ƤΤ",
	},

	/* Bard */
	{
		"",	/*"Apprentice"*/
		"ʲ",	/*"Songsmith"*/
		"ͷ",	/*"Bard"*/
		"ѥ˥",	/*"Companion"*/
		"",	/*"Minstrel"*/
		"è׻",	/*"Harper"*/
		"¤",	/*"Loreweaver"*/
		"ο",	/*"Muse"*/
		"̴¤",	/*"Dreamweaver"*/
		"ޥ",	/*"Master Harper"*/
	},

	/* Red Mage; same as Warrior-Mage */
	{
		"",
		"",			/*ա */
		"",
		"Żʼ",
		"ʼ",
		"Ʈ",
		"Ѥαͺ", /* Mage-Hero */
		"˼",
		/* "", */
		"Ʈѻ",
		"μμ", /* "ɥ", */
	},

	/* Samurai */
	{
		"",
		"",
		"ľ",
		"",
		"",
		"ƻ",
		"̾",
		"̾",
		"",
		"",
	},

	/* ForceTrainer; same as Monk(?) */
	{
		"",
		"",
		"ľ",
		"",
		"",
		"ƻ",
		"̾",
		"̾",
		"",
		"",
	},

	/* Blue Mage; same as Mage */
	{
				/*"",*/
		"",                 /*ա */
		"ѻ",               /*աڥƥ */
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ƻ",
		"ץޥ",
		"ƻ",
	},

	/* Cavalry */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"μ",
	},

	/* Berserker */
	{
		"С",
		"С",
		"С",
		"ܤθ",
		"ܤθ",
		"ܤθ",
		"ܤβ",
		"ܤβ",
		"ܤβ",
		"ܤβ",
	},

	/* Weaponsmith */
	{
		"Ƽä",
		"Ŵä",
		"ݤä",
		"ä",
		"εä",
		"ä",
		"ä",
		"ä",
		"ä",
		"ä",
	},

	/* Mirror Master */
	{
		"򸫤",
		"᤭",
		"",
		"ѻ",
		"Ƴ",
		"θ",
		"β",
		"ι",
		"β",
		"եΡ벦",
	},
	/* Ninja */
	{
		"",
		"ż",
		"ã",
		"ûȤ",
		"ڤ",
		"",
		"ο",
		"Ǥΰ",
		"Ż",
		"Ĺ",
	},

	/* Sniper */
	{
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"μ",
	},
};

#else
const cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Mage */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Priest */
	{
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Priest",
		"High Priest",
		"Cardinal",
		"Inquisitor",
		"Pope",
	},

	/* Rogues */
	{
		"Cutpurse",
		"Robber",
		"Burglar",
		"Filcher",
		"Sharper",
		"Low Thief",
		"High Thief",
		"Master Thief",
		"Assassin",
		"Guildmaster",
	},

	/* Rangers */
	{
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
	},

	/* Paladins */
	{
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
	},

	/* Warrior-Mage */
	{
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
	},

	/* Chaos Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Chaos Hero",
		"Chaos Baron",
		"Chaos Duke",
		"Chaos Lord",
	},

	/* Monk */
	{
		"Initiate",
		"Brother",
		"Disciple",
		"Immaculate",
		"Master",
		"Soft Master",
		"Hard Master",
		"Flower Master",
		"Dragon Master",
		"Grand Master",
	},

	/* Mindcrafter */
	{
		"Trainee",
		"Acolyte",
		"Adept",
		"Immaculate",
		"Contemplator",
		"Mentalist",
		"Psychic",
		"Psionicist",
		"Esper",
		"Mindmaster",
	},

	/* High Mage; same as Mage */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Tourist */
	{
		"Rambler",
		"Sightseer",
		"Excursionist",
		"Peregrinator",
		"Traveler",
		"Journeyer",
		"Voyager",
		"Explorer",
		"Adventurer",
		"Spelunker",
	},

	/* Imitator */
	{
		"Yet",
		"Lacks",
		"Still more",
		"So so",
		"All right",
		"Not bad",
		"Considerable",
		"Go go",
		"Sizable",
		"Great man",
	},

	/* BeastMaster */
	{
		"Newt Master",
		"Snake Master",
		"Spider Master",
		"Wolf Master",
		"Tiger Master",
		"Beetle Master",
		"Hydra Master",
		"Hound Master",
		"Mumak Master",
		"Dragon Master",
	},

	/* Sorcerer */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Archer */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Bowman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Magic eater */
	{
		"Apprentice",
		"Beginner",
		"Jagguler",
		"Skilled",
		"Conjurer",
		"Magician",
		"Master",
		"Master",
		"Wizard",
		"Almighty",
	},

	/* Bard */
	{
		"Apprentice",	/*"Apprentice"*/
		"Songsmith",	/*"Songsmith"*/
		"Bard",	/*"Bard"*/
		"Companion",	/*"Companion"*/
		"Minstrel",	/*"Minstrel"*/
		"Harper",	/*"Harper"*/
		"Loreweaver",	/*"Loreweaver"*/
		"Muse",	/*"Muse"*/
		"Dreamweaver",	/*"Dreamweaver"*/
		"Master Harper",	/*"Master Harper"*/
	},

	/* Red Mage */
	{
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
	},

	/* Samurai */
	{
		"Initiate",
		"Brother",
		"Disciple",
		"Immaculate",
		"Master",
		"Soft Master",
		"Hard Master",
		"Flower Master",
		"Dragon Master",
		"Grand Master",
	},

	/* ForceTrainer */
	{
		"Initiate",
		"Brother",
		"Disciple",
		"Immaculate",
		"Master",
		"Soft Master",
		"Hard Master",
		"Flower Master",
		"Dragon Master",
		"Grand Master",
	},

	/* Blue Mage */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Berserker */
	{
		    "Berserker",
		    "Berserker",
		    "Berserker",
		    "Rage Prince",
		    "Rage Prince",
		    "Rage Prince",
		    "Rage King",
		    "Rage King",
		    "Rage King",
		    "God of Rage",
	},

	/* Weaponsmith */
	{
		"Copper smith",
		"Iron smith",
		"Steel smith",
		"Silver smith",
		"Dragon smith",
		"Spirit smith",
		"Magic smith",
		"Soul smith",
		"God smith",
		"AlmightySmith",
	},

	/* Mirror Master */
	{
		"Mirrorstarer",
		"Mirrorcleaner",
		"Mirrormaker",
		"Mirrormagician",
		"Mirror Guru",
		"Mirror Mage",
		"Mirror King",
		"Mirror Emperor",
		"Mirror Avatar",
		"Ruffnor King",
	},

	/* Ninja */
	{
		"Trainee",
		"Myrmidon",
		"Initiate",
		"Knifer",
		"Bladesman",
		"Hashishin",
		"Black Dagger",
		"Shadowstrike",
		"Assassinator",
		"Death Lord",
	},

	/* Sniper */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},
};
#endif

const monster_power monster_powers[MAX_MONSPELLS] =
{
/* level,  smana,  %fail,  manedam,  %manefail,  use_stat, name */
#ifdef JP
{  1,   1,  10,    0,  15, A_CON,  ""},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 40,  35,  85,    0,  40, A_INT,  "Ͼõ"},
{ 35,  30,  80,  800,  70, A_STR,  "å"},
{  5,   1,  20,   18,  15, A_DEX,  "ͷ"},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 10,   4,  35,   89,  40, A_INT,  ""},
{ 20,  15,  55, 1600,  95, A_CON,  "Υ֥쥹"},
{ 20,  15,  55, 1600,  95, A_CON,  "ŷΥ֥쥹"},
{ 20,  15,  55, 1600,  95, A_CON,  "Υ֥쥹"},
{ 20,  15,  55, 1600,  95, A_CON,  "䵤Υ֥쥹"},
{ 20,  15,  55,  800,  95, A_CON,  "ǤΥ֥쥹"},
{ 20,  15,  70,  550,  95, A_CON,  "ϹΥ֥쥹"},
{ 20,  16,  70,  400,  95, A_CON,  "Υ֥쥹"},
{ 20,  16,  70,  400,  95, A_CON,  "ŹΥ֥쥹"},
{ 20,  20,  70,  450,  95, A_CON,  "Υ֥쥹"},
{ 20,  20,  70,  450,  95, A_CON,  "첻Υ֥쥹"},
{ 20,  20,  70,  600,  95, A_CON,  "Υ֥쥹"},
{ 20,  16,  70,  500,  95, A_CON,  "Υ֥쥹"},
{ 30,  25,  80,  250,  95, A_CON,  "̺Υ֥쥹"},
{ 35,  18,  80,  150,  95, A_CON,  "ֵžΥ֥쥹"},
{ 30,  25,  80,  200,  95, A_CON,  "ߤΥ֥쥹"},
{ 30,  28,  90,  200,  95, A_CON,  "ϤΥ֥쥹"},
{ 20,  15,  70,  500,  95, A_CON,  "ҤΥ֥쥹"},
{ 35,  15,  80,  150,  95, A_CON,  "ץ饺ޤΥ֥쥹"},
{ 30,  18,  70,  200,  95, A_CON,  "եΥ֥쥹"},
{ 30,  28,  80,  250,  95, A_CON,  "ϤΥ֥쥹"},
{ 25,  20,  95,  320,  80, A_INT,  "ǽ"},
{ 25,  15,  70,  800,  95, A_CON,  "ѴʪΥ֥쥹"},
{ 30,  32,  85,  400,  80, A_INT,  "륹"},
{ 35,  40,  95,  150,  95, A_CON,  "ʬΥ֥쥹"},
{ 18,  13,  55,  630,  80, A_INT,  "åɡܡ"},
{ 14,  10,  45,  316,  60, A_INT,  "ܡ"},
{ 20,  14,  60,  720,  80, A_INT,  "եܡ"},
{ 15,  11,  50,  320,  60, A_INT,  "ܡ"},
{  5,   3,  40,   48,  20, A_INT,  ""},
{ 25,  18,  70,  350,  80, A_INT,  "Ϲ"},
{ 30,  22,  75,  350,  80, A_INT,  "ܡ"},
{ 44,  45,  85,  550,  95, A_INT,  "Ϥ"},
{ 40,  42,  90,  550,  95, A_INT,  "Ź"},
{ 10,   5,  50,    0,  25, A_INT,  "ϵۼ"},
{ 25,  10,  60,    0,  30, A_INT,  ""},
{ 30,  14,  65,    0,  30, A_INT,  "Ǿ"},
{  3,   1,  25,   24,  20, A_INT,  "ڽ"},
{ 12,   2,  35,   64,  25, A_INT,  "Ž"},
{ 22,   6,  50,  150,  30, A_INT,  "̿"},
{ 32,  10,  70,  225,  35, A_INT,  "빦ͤ"},
{ 13,   7,  40,  178,  40, A_INT,  "åɡܥ"},
{ 10,   5,  35,  130,  35, A_INT,  "ܥ"},
{ 15,   9,  50,  210,  45, A_INT,  "եܥ"},
{ 12,   6,  35,  162,  40, A_INT,  "ܥ"},
{ 40,  42,  90,  550,  95, A_INT,  "С"},
{ 25,  17,  60,  255,  60, A_INT,  "Ϲ"},
{ 25,  20,  65,  250,  60, A_INT,  "ܥ"},
{ 25,  24,  90,  400,  80, A_INT,  "Ϥ"},
{ 25,  20,  80,  216,  60, A_INT,  "ץ饺ޡܥ"},
{ 25,  16,  60,  186,  60, A_INT,  "˴"},
{  3,   1,  25,   12,  20, A_INT,  "ޥåߥ"},
{  5,   3,  35,    0,  20, A_INT,  ""},
{ 10,   5,  40,    0,  20, A_INT,  ""},
{ 10,   5,  40,    0,  20, A_INT,  "ѥ˥å󥹥"},
{ 10,   5,  40,    0,  20, A_INT,  "󥹥"},
{ 10,   5,  40,    0,  20, A_INT,  "꡼ס󥹥"},
{ 20,  10,  70,    0,  40, A_INT,  "ԡ"},
{ 45, 120,  95,    0,  60, A_INT,  "Ǥμ"},
{ 20,  15,  70,    0,  20, A_WIS,  "ϲ"},
{ 45,  65,  80,    0,  60, A_INT,  "̵ε"},
{  5,   1,  30,    0,  20, A_INT,  "硼ȡƥݡ"},
{ 15,   8,  40,    0,  30, A_INT,  "ƥݡ"},
{ 40, 999,  99,    0,  80, A_INT,  ""},
{  1,   0,   0,    0,  15, A_INT,  ""},
{ 15,   8,  50,    0,  30, A_INT,  "褻"},
{ 20,  13,  80,    0,  30, A_INT,  "ƥݡȡ"},
{ 30,  40,  95,    0,  40, A_INT,  "ƥݡȡ٥"},
{ 35,  30,  80,  350,  70, A_INT,  "η"},
{  5,   1,  20,    0,  15, A_INT,  "Ű"},
{  5,   1,  20,    0,  15, A_DEX,  "ȥå¤"},
{ 15,   3,  40,    0,  30, A_INT,  "Ӽ"},
{ 30,  30,  70,    0,  40, A_INT,  ""},
{ 40,  70,  85,    0,  45, A_INT,  "緳Ƥ"},
{ 45,  90,  90,    0,  50, A_INT,  "Сǡξ"},
{ 25,  20,  65,    0,  30, A_INT,  "󥹥ξ"},
{ 35,  30,  75,    0,  40, A_INT,  "ʣΥ󥹥ξ"},
{ 25,  25,  65,    0,  25, A_INT,  "ξ"},
{ 25,  20,  60,    0,  25, A_INT,  "ξ"},
{ 35,  26,  75,    0,  40, A_INT,  "ϥɤξ"},
{ 30,  23,  70,    0,  35, A_INT,  "ҥɥξ"},
{ 40,  50,  85,    0,  40, A_INT,  "ŷȤξ"},
{ 35,  50,  80,    0,  35, A_INT,  "ǡξ"},
{ 30,  30,  75,    0,  35, A_INT,  "ǥåɤξ"},
{ 39,  70,  80,    0,  40, A_INT,  "ɥ饴ξ"},
{ 43,  85,  85,    0,  45, A_INT,  "饢ǥåɤξ"},
{ 46,  90,  85,    0,  45, A_INT,  "ɥ饴ξ"},
{ 48, 120,  90,    0,  50, A_INT,  "Сβ²ξ"},
{ 50, 150,  95,    0,  50, A_INT,  "ˡ󥹥ξ"},
#else
{  1,   1,  10,    0,  15, A_CON,  "shriek"},
{ 10,   4,  35,   89,  40, A_INT,  "something"},
{ 40,  35,  85,    0,  40, A_INT,  "dispel-magic"},
{ 35,  30,  80,  800,  70, A_STR,  "rocket"},
{  2,   1,  15,   10,  15, A_DEX,  "arrow"},
{  5,   2,  20,   18,  20, A_DEX,  "arrows"},
{ 12,   3,  25,   30,  25, A_DEX,  "missile"},
{ 16,   4,  30,   42,  30, A_DEX,  "missiles"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath acid"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath lightning"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath fire"},
{ 20,  15,  55, 1600,  95, A_CON,  "breath cold"},
{ 20,  15,  55,  800,  95, A_CON,  "breath poison"},
{ 20,  15,  70,  550,  95, A_CON,  "breath nether"},
{ 20,  16,  70,  400,  95, A_CON,  "breath light"},
{ 20,  16,  70,  400,  95, A_CON,  "breath dark"},
{ 20,  20,  70,  450,  95, A_CON,  "breath confusion"},
{ 20,  20,  70,  450,  95, A_CON,  "breath sound"},
{ 20,  20,  70,  600,  95, A_CON,  "breath chaos"},
{ 20,  16,  70,  500,  95, A_CON,  "breath disenchantment"},
{ 30,  25,  80,  250,  95, A_CON,  "breath nexus"},
{ 35,  18,  80,  150,  95, A_CON,  "breath time"},
{ 30,  25,  80,  200,  95, A_CON,  "breath inertia"},
{ 30,  28,  90,  200,  95, A_CON,  "breath gravity"},
{ 20,  15,  70,  500,  95, A_CON,  "breath shards"},
{ 35,  15,  80,  150,  95, A_CON,  "breath plasma"},
{ 30,  18,  70,  200,  95, A_CON,  "breath force"},
{ 30,  28,  80,  250,  95, A_CON,  "breath mana"},
{ 25,  20,  95,  320,  80, A_INT,  "nuke ball"},
{ 25,  15,  70,  800,  95, A_CON,  "breath nuke"},
{ 30,  32,  85,  400,  80, A_INT,  "raw Logrus"},
{ 35,  40,  95,  150,  95, A_CON,  "breath disintegrate"},
{ 18,  13,  55,  630,  80, A_INT,  "acid ball"},
{ 14,  10,  45,  316,  60, A_INT,  "lightning ball"},
{ 20,  14,  60,  720,  80, A_INT,  "fire ball"},
{ 15,  11,  50,  320,  60, A_INT,  "frost ball"},
{  5,   3,  40,   48,  20, A_INT,  "stinking cloud"},
{ 25,  18,  70,  350,  80, A_INT,  "nether ball"},
{ 30,  22,  75,  350,  80, A_INT,  "water ball"},
{ 44,  45,  85,  550,  95, A_INT,  "mana storm"},
{ 40,  42,  90,  550,  95, A_INT,  "darkness storm"},
{ 10,   5,  50,    0,  25, A_INT,  "drain mana"},
{ 25,  10,  60,    0,  30, A_INT,  "mind blast"},
{ 30,  14,  65,    0,  30, A_INT,  "brain smash"},
{  3,   1,  25,   24,  20, A_INT,  "cause light wounds"},
{ 12,   2,  35,   64,  25, A_INT,  "cause serious wounds"},
{ 22,   6,  50,  150,  30, A_INT,  "cause critical wounds"},
{ 32,  10,  70,  225,  35, A_INT,  "cause mortal wounds"},
{ 13,   7,  40,  178,  40, A_INT,  "acid bolt"},
{ 10,   5,  35,  130,  35, A_INT,  "lightning bolt"},
{ 15,   9,  50,  210,  45, A_INT,  "fire bolt"},
{ 12,   6,  35,  162,  40, A_INT,  "frost bolt"},
{ 40,  42,  90,  550,  95, A_INT,  "starburst"},
{ 25,  17,  60,  255,  60, A_INT,  "nether bolt"},
{ 25,  20,  65,  250,  60, A_INT,  "water bolt"},
{ 25,  24,  90,  400,  80, A_INT,  "mana bolt"},
{ 25,  20,  80,  216,  60, A_INT,  "plasma bolt"},
{ 25,  16,  60,  186,  60, A_INT,  "ice bolt"},
{  3,   1,  25,   12,  20, A_INT,  "magic missile"},
{  5,   3,  35,    0,  20, A_INT,  "scare"},
{ 10,   5,  40,    0,  20, A_INT,  "blind"},
{ 10,   5,  40,    0,  20, A_INT,  "confuse"},
{ 10,   5,  40,    0,  20, A_INT,  "slow"},
{ 10,   5,  40,    0,  20, A_INT,  "sleep"},
{ 20,  10,  70,    0,  40, A_INT,  "speed"},
{ 45, 120,  95,    0,  60, A_INT,  "the Hand of Doom"},
{ 20,  15,  70,    0,  20, A_WIS,  "heal-self"},
{ 45,  65,  80,    0,  60, A_INT,  "make invulnerable"},
{  5,   1,  30,    0,  20, A_INT,  "blink-self"},
{ 15,   8,  40,    0,  30, A_INT,  "teleport-self"},
{ 40, 999,  99,    0,  80, A_INT,  "The world"},
{  1,   0,   0,    0,  15, A_INT,  "something"},
{ 15,   8,  50,    0,  30, A_INT,  "teleport to"},
{ 20,  13,  80,    0,  30, A_INT,  "teleport away"},
{ 30,  40,  95,    0,  40, A_INT,  "teleport level"},
{ 35,  30,  80,  350,  70, A_INT,  "psycho-spear"},
{  5,   1,  20,    0,  15, A_INT,  "create darkness"},
{  5,   1,  20,    0,  15, A_DEX,  "create traps"},
{ 15,   3,  40,    0,  30, A_INT,  "cause amnesia"},
{ 30,  30,  70,    0,  40, A_INT,  "raise dead"},
{ 40,  70,  85,    0,  45, A_INT,  "summon aid"},
{ 45,  90,  90,    0,  50, A_INT,  "summon Cyberdemons"},
{ 25,  20,  65,    0,  30, A_INT,  "summon a monster"},
{ 35,  30,  75,    0,  40, A_INT,  "summon monsters"},
{ 25,  25,  65,    0,  25, A_INT,  "summon ants"},
{ 25,  20,  60,    0,  25, A_INT,  "summon spiders"},
{ 35,  26,  75,    0,  40, A_INT,  "summon hounds"},
{ 30,  23,  70,    0,  35, A_INT,  "summon hydras"},
{ 40,  50,  85,    0,  40, A_INT,  "summon an angel"},
{ 35,  50,  80,    0,  35, A_INT,  "summon a daemon"},
{ 30,  30,  75,    0,  35, A_INT,  "summon an undead"},
{ 39,  70,  80,    0,  40, A_INT,  "summon a dragon"},
{ 43,  85,  85,    0,  45, A_INT,  "summon Greater Undead"},
{ 46,  90,  85,    0,  45, A_INT,  "summon Ancient Dragon"},
{ 48, 120,  90,    0,  50, A_INT,  "summon Lords of Amber"},
{ 50, 150,  95,    0,  50, A_INT,  "summon Unique Monsters"},
#endif

};


const cptr monster_powers_short[MAX_MONSPELLS] = {
#ifdef JP

	"", "", "Ͼõ", "å", "ͷ", "", "", "",
	"", "ŷ", "б", "䵤", "", "Ϲ", "", "Ź",
	"", "첻", "", "", "̺", "ֵž", "", "",
	"", "ץ饺", "ե", "", "ǽ", "Ѵʪ", "륹", "ʬ",

	"", "ŷ", "б", "䵤", "", "Ϲ", "", "Ϥ",
	"Ź", "ϵۼ", "", "Ǿ", "ڽ", "Ž", "̿", "빦ͤ",
	"", "ŷ", "б", "䵤", "С", "Ϲ", "", "Ϥ",
	"ץ饺", "˴", "ޥåߥ", "", "", "", "®", "̲",

	"®", "Ǥμ", "ϲ", "̵ε", "硼ȥƥݡ", "ƥݡ", "ߤ", "",
	"褻", "ƥݡȥ", "ƥݡȥ٥", "η", "Ű", "ȥå¤", "Ӽ", "",
	"緳", "Сǡ", "󥹥", "ʣΥ󥹥", "", "", "ϥ", "ҥɥ",
	"ŷ", "", "ǥå", "ɥ饴", "饢ǥå", "ɥ饴", "Сβ²", "ˡ"

#else

	"Shriek", "Something", "Dispel-magic", "Rocket", "Arrow", "Arrows", "Missile", "Missiles",
	"Acid", "Lightning", "Fire", "Cold", "Poison", "Nether", "Light", "Dark",
	"Confusion", "Sound", "Chaos", "Disenchantment", "Nexus", "Time", "Inertia", "Gravity",
	"Shards", "Plasma", "Force", "Mana", "Nuke", "Nuke", "Logrus", "Disintergrate",

	"Acid", "Lightning", "Fire", "Frost", "Stinking Cloud", "Nether", "Water", "Mana storm",
	"Darkness storm", "Drain mana", "Mind blast", "Brain smash", "Cause Light Wound", "Cause Serious Wound", "Cause Critical Wound", "Cause Mortal Wound",
	"Acid", "Lightning", "Fire", "Frost", "Starburst", "Nether", "Water", "Mana",
	"Plasm", "Ice", "Magic missile", "Scare", "Blind", "Confuse", "Slow", "Sleep",

	"Speed", "Hand of doom", "Heal-self", "Invulnerable", "Blink", "Teleport", "The world", "Something",
	"Teleport to", "Teleport away", "Teleport level", "Psycho-spear", "Create darkness", "Create traps", "Amnesia", "Raise dead",
	"Aid", "Cyberdeamons", "A monster", "Monsters", "Ants", "Spiders", "Hounds", "Hydras",
	"Angel", "Daemon", "Undead", "Dragon", "Greater Undead", "Ancient Dragon", "Lords of Amber", "Unique monsters"

#endif
};


/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
const cptr color_names[16] =
{
#ifdef JP
	"",
	"",
	"ĳ",
	"",
	"",
	"",
	"",
	"ῧ",
	"",
	"ĳ",
	"",
	"",
	"뤤",
	"뤤",
	"뤤",
	"ῧ",
#else
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
#endif

};


/*
 * Abbreviations of healthy stats
 */
const cptr stat_names[6] =
{
#ifdef JP
	" :", "ǽ :", " :", " :", "ѵ :", "̥ :"
#else
	"STR : ", "INT : ", "WIS : ", "DEX : ", "CON : ", "CHR : "
#endif

};

/*
 * Abbreviations of damaged stats
 */
const cptr stat_names_reduced[6] =
{
#ifdef JP
	"x:", "ǽx:", "x:", "x:", "ѵx:", "̥x:"
#else
	"Str : ", "Int : ", "Wis : ", "Dex : ", "Con : ", "Chr : "
#endif

};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
const cptr window_flag_desc[32] =
{
#ifdef JP
	"ʪ/",
#else
	"Display inven/equip",
#endif

#ifdef JP
	"/ʪ",
#else
	"Display equip/inven",
#endif

#ifdef JP
	"ʸ",
#else
	"Display spell list",
#endif

#ifdef JP
	"饯",
#else
	"Display character",
#endif
		
#ifdef JP
	"볦Υ󥹥ɽ",
#else
	"Display monsters in sight",
#endif		

	NULL,
#ifdef JP
	"å",
#else
	"Display messages",
#endif

#ifdef JP
	"󥸥ο",
#else
	"Display overhead view",
#endif

#ifdef JP
	"󥹥λפ",
#else
	"Display monster recall",
#endif

#ifdef JP
	"ƥξܺ",
#else
	"Display object recall",
#endif

#ifdef JP
	"ʬμϤɽ", 
#else
	"Display dungeon view",
#endif

#ifdef JP
	"ǰ",
#else
	"Display snap-shot",
#endif

	NULL,
	NULL,
#ifdef JP
	"ܡå",
#else
	"Display borg messages",
#endif

#ifdef JP
	"ܡơ",
#else
	"Display borg status",
#endif

	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 */
const option_type option_info[] =
{
	/*** Input Options ***/

	{ &rogue_like_commands,         FALSE, OPT_PAGE_INPUT, 0, 0,
	"rogue_like_commands",          _("֤Ѥ", "Rogue-like commands") },

	{ &always_pickup,               FALSE, OPT_PAGE_INPUT, 0, 5,
	"always_pickup",                _("˥ƥ򽦤" , "Pick things up by default") },

	{ &carry_query_flag,            FALSE, OPT_PAGE_INPUT, 0, 3,
	"carry_query_flag",             _("ƥ򽦤˳ǧ", "Prompt before picking things up") },
		
	{ &quick_messages,              TRUE,  OPT_PAGE_INPUT, 0, 1,
	"quick_messages",               _("ååѤ", "Activate quick messages") },
		
	{ &auto_more,                   FALSE, OPT_PAGE_INPUT, 2, 6,
	"auto_more",                    _("ԤʤϢ³ǥåɽ", "Automatically clear '-more-' prompts") },
	
	{ &command_menu,                TRUE,  OPT_PAGE_INPUT, 2, 7,
	"command_menu",                 _("˥塼ˤꥳޥͭˤ", "Enable command selection menu") },
	
	{ &other_query_flag,            FALSE, OPT_PAGE_INPUT, 0, 2,
	"other_query_flag",             _("ΥƥѤȤ˳ǧ", "Prompt for floor item selection") },
	
	{ &use_old_target,              FALSE, OPT_PAGE_INPUT, 0, 4,
	"use_old_target",               _("˰ΥåȤꤹ", "Use old target by default") },

	{ &always_repeat,               TRUE,  OPT_PAGE_INPUT, 0, 6,
	"always_repeat",                _("ޥɼư֤", "Repeat obvious commands") },

	{ &confirm_destroy,             FALSE, OPT_PAGE_INPUT, 5, 3,
	"confirm_destroy",              _("̵͡פʥƥ˲ǧ", "Prompt for destruction of known worthless items") },

	{ &confirm_wear,                TRUE,  OPT_PAGE_INPUT, 5, 4,
	"confirm_wear",                 _("줿ʪǧ", "Confirm to wear/wield known cursed items") },

	{ &confirm_quest,               TRUE,  OPT_PAGE_INPUT, 1, 9,
	"confirm_quest",                _("ȤƳʤƨ˳ǧ", "Prompt before exiting a quest level") },

	{ &target_pet,                  FALSE, OPT_PAGE_INPUT, 2, 5,
	"target_pet",                   _("ڥåȤ򥿡åȤˤ", "Allow targetting pets") },

#ifdef ALLOW_EASY_OPEN
	{ &easy_open,                   TRUE,  OPT_PAGE_INPUT, 5, 7,
	"easy_open",                    _("ưŪ˥ɥ򳫤", "Automatically open doors") },
#endif /* ALLOW_EASY_OPEN */

#ifdef ALLOW_EASY_DISARM
	{ &easy_disarm,                 TRUE,  OPT_PAGE_INPUT, 5, 8,
	"easy_disarm",                  _("ưŪ櫤", "Automatically disarm traps") },
#endif /* ALLOW_EASY_DISARM */

#ifdef ALLOW_EASY_FLOOR /* TNB */
	{ &easy_floor,                  FALSE, OPT_PAGE_INPUT, 5, 9,
	"easy_floor",                   _("ǽŤʤäƥꥹȤ", "Display floor stacks in a list") },
#endif /* ALLOW_EASY_FLOOR -- TNB */

	{ &use_command,                 FALSE, OPT_PAGE_INPUT, 5, 10,
	"use_command",                  _("ֻȤ(a)ץޥɤǥƥ򲿤ǤȤ", "Allow unified use command") },

	{ &over_exert,                  FALSE, OPT_PAGE_INPUT, 0, 29,
	"over_exert",                   _("MP­ʤƤˡĩ魯", "Allow casting spells when short of mana") },

	{ &numpad_as_cursorkey,         TRUE, OPT_PAGE_INPUT, 2, 31,
	"numpad_as_cursorkey",          _("ǥǥƥ󥭡򥫡륭ȤƻȤ", "Use numpad keys as cursor keys in editor mode") },

	/*** Map Screen Options ***/

	{ &center_player,               FALSE, OPT_PAGE_MAPSCREEN, 5, 11,
	"center_player",                _("˥ץ쥤䡼濴֤(*٤*)", "Center map while walking (*slow*)") },

	{ &center_running,              TRUE,  OPT_PAGE_MAPSCREEN, 5, 12,
	"center_running",               _("äƤǤ濴֤", "Centering even while running") },

	{ &view_yellow_lite,            TRUE,  OPT_PAGE_MAPSCREEN, 1, 28,
	"view_yellow_lite",             _("ϰϤ̤ʿɽ", "Use special colors for torch-lit grids") },

	{ &view_bright_lite,            TRUE,  OPT_PAGE_MAPSCREEN, 1, 29,
	"view_bright_lite",             _("볦ϰϤ̤ʿɽ", "Use special colors for 'viewable' grids") },

	{ &view_granite_lite,           TRUE,  OPT_PAGE_MAPSCREEN, 1, 30,
	"view_granite_lite",            _("ɤ̤ʿɽ(Ť)", "Use special colors for wall grids (slow)") },

	{ &view_special_lite,           TRUE,  OPT_PAGE_MAPSCREEN, 1, 31,
	"view_special_lite",            _("̤ʿɽ(Ť)", "Use special colors for floor grids (slow)") },

	{ &view_perma_grids,            TRUE,  OPT_PAGE_MAPSCREEN, 1, 6,
	"view_perma_grids",             _("뤤ϤΤޤޤˤ", "Map remembers all perma-lit grids") },

	{ &view_torch_grids,            FALSE, OPT_PAGE_MAPSCREEN, 1, 7,
	"view_torch_grids",             _("ǾȤ餷ϤΤޤޤˤ", "Map remembers all torch-lit grids") },

	{ &view_unsafe_grids,           FALSE, OPT_PAGE_MAPSCREEN, 1, 8,
	"view_unsafe_grids",            _("ȥå״κѤߤǤʤɽ", "Map marked by detect traps") },

	{ &view_reduce_view,            FALSE, OPT_PAGE_MAPSCREEN, 1, 17,
	"view_reduce_view",             _("Ǥϻ򶹤", "Reduce view-radius in town") },

	{ &fresh_before,                TRUE,  OPT_PAGE_MAPSCREEN, 1, 23,
	"fresh_before",                 _("Ϣ³ޥ˲̤褷³", "Flush output while continuous command") },

	{ &fresh_after,                 FALSE, OPT_PAGE_MAPSCREEN, 1, 24,
	"fresh_after",                  _("ޥɸ˲̤˺褷³", "Flush output after monster's move") },

	{ &fresh_message,               FALSE, OPT_PAGE_MAPSCREEN, 1, 25,
	"fresh_message",                _("åθ˲̤褹", "Flush output after every message") },

	{ &hilite_player,               FALSE, OPT_PAGE_MAPSCREEN, 1, 27,
	"hilite_player",                _("ץ쥤䡼˥碌", "Hilite the player with the cursor") },

	{ &display_path,                FALSE, OPT_PAGE_MAPSCREEN, 2, 8,
	"display_path",                 _("ˡεפɽ", "Display actual path before shooting") },

	/*** Text Display Options ***/

	{ &plain_descriptions,          TRUE,  OPT_PAGE_TEXT, 5, 1,
	"plain_descriptions",           _("ƥεҤάˤ", "Plain object descriptions") },

	{ &plain_pickup,                FALSE, OPT_PAGE_TEXT, 6, 6,
	"plain_pickup",                 _("ֽäץåά", "Plain pickup messages(japanese only)") },

	{ &always_show_list,            TRUE,  OPT_PAGE_TEXT, 4, 0,
	"always_show_list",             _("ˤϾ˰ɽ", "Always show list when choosing items") },

	{ &depth_in_feet,               FALSE, OPT_PAGE_TEXT, 0, 7,
	"depth_in_feet",                _("󥸥οեȤɽ", "Show dungeon level in feet") },

	{ &show_labels,                 TRUE,  OPT_PAGE_TEXT, 0, 10,
	"show_labels",                  _("ɽ", "Show labels in object listings") },

	{ &show_weights,                TRUE,  OPT_PAGE_TEXT, 0, 11,
	"show_weights",                 _("ƥǽ̤ɽ", "Show weights in object listings") },

	{ &show_item_graph,             TRUE,  OPT_PAGE_TEXT, 2, 0,
	"show_item_graph",              _("ƥΥܥɽ", "Show items graphics") },

	{ &equippy_chars,               TRUE,  OPT_PAGE_TEXT, 1, 12,
	"equippy_chars",                _("ơʸɽ", "Display 'equippy' chars") },

	{ &display_mutations,           FALSE, OPT_PAGE_TEXT, 5, 0,
	"display_mutations",            _("'C'ޥɤѰۤɽ", "Display mutations in 'C'haracter Display") },

	{ &compress_savefile,           FALSE, OPT_PAGE_TEXT, 1, 26,
	"compress_savefile",            _("֡եΥå򰵽̤", "Compress messages in savefiles") },

	{ &abbrev_extra,                FALSE, OPT_PAGE_TEXT, 2, 10,
	"abbrev_extra",                 _("ƥɲ/ǽϤάΤ", "Describe obj's extra resistances by abbreviation") },

	{ &abbrev_all,                  FALSE, OPT_PAGE_TEXT, 2, 11,
	"abbrev_all",                   _("ƥƤ/ǽϤάΤ", "Describe obj's all resistances by abbreviation") },

	{ &exp_need,                    FALSE, OPT_PAGE_TEXT, 2, 12,
	"exp_need",                     _("Υ٥ɬפʷиͤɽ", "Show the experience needed for next level") },

	{ &ignore_unview,               FALSE, OPT_PAGE_TEXT, 2, 13,
	"ignore_unview",                _("볦Υ󥹥ιưɽʤ", "Ignore whenever any monster does") },
	
	{ &show_ammo_detail,            TRUE, OPT_PAGE_TEXT, 2, 14,
	"show_ammo_detail",             _("ƤΥ᡼ɽ", "Show description of ammo damage") },
		
	{ &show_ammo_no_crit,           FALSE, OPT_PAGE_TEXT, 2, 15,
	"show_ammo_no_crit",            _("񿴤θʤƤΥ᡼ɽ", "Show ammo damage with no critical") },

	{ &show_ammo_crit_ratio,           FALSE, OPT_PAGE_TEXT, 2, 16,
	"show_ammo_crit_ratio",            _("ƤβȯΨɽ", "Show critical ratio of ammo") },
		

	/*** Game-Play ***/

	{ &stack_force_notes,           TRUE,  OPT_PAGE_GAMEPLAY, 0, 8,
	"stack_force_notes",            _("ۤʤäΥƥޤȤ", "Merge inscriptions when stacking") },

	{ &stack_force_costs,           FALSE, OPT_PAGE_GAMEPLAY, 0, 9,
	"stack_force_costs",            _("ۤʤɽΥƥޤȤ", "Merge discounts when stacking") },

	{ &expand_list,                 TRUE,  OPT_PAGE_GAMEPLAY, 1, 5,
	"expand_list",                  _("ְץޥɤĥ", "Expand the power of the list commands") },

	{ &small_levels,                TRUE,  OPT_PAGE_GAMEPLAY, 0, 30,
	"small_levels",                 _("˾եǽˤ", "Allow unusually small dungeon levels") },

	{ &always_small_levels,         FALSE, OPT_PAGE_GAMEPLAY, 2, 3,
	"always_small_levels",          _("˾ե", "Always create unusually small dungeon levels") },

	{ &empty_levels,                TRUE,  OPT_PAGE_GAMEPLAY, 0, 31,
	"empty_levels",                 _("äݤΡ֥꡼ʡץ٥ǽˤ", "Allow empty 'arena' levels") },

	{ &bound_walls_perm,            FALSE, OPT_PAGE_GAMEPLAY, 2, 1,
	"bound_walls_perm",             _("󥸥γɤʵ״ˤ", "Boundary walls become 'permanent wall'") },

	{ &last_words,                  TRUE,  OPT_PAGE_GAMEPLAY, 0, 28,
	"last_words",                   _("饯Τ", "Leave last words when your character dies") },

#ifdef WORLD_SCORE
	{ &send_score,                  TRUE,  OPT_PAGE_GAMEPLAY, 4, 6,
	"send_score",                   _("Ф˥", "Send score dump to the world score server") },
#endif
	
	{ &allow_debug_opts,            FALSE, OPT_PAGE_GAMEPLAY, 6, 11,
	"allow_debug_opts",             _("ǥХå/ץĤ", "Allow use of debug/cheat options") },

	/*** Disturbance ***/

	{ &find_ignore_stairs,          FALSE, OPT_PAGE_DISTURBANCE, 0, 16,
	"find_ignore_stairs",           _("ʤ̲᤹", "Run past stairs") },

	{ &find_ignore_doors,           TRUE,  OPT_PAGE_DISTURBANCE, 0, 17,
	"find_ignore_doors",            _("ɥ̲᤹", "Run through open doors") },

	{ &find_cut,                    FALSE, OPT_PAGE_DISTURBANCE, 0, 18,
	"find_cut",                     _("ʤѤФ˺ûΥ̲᤹", "Run past known corners") },

	{ &check_abort,                 TRUE,  OPT_PAGE_DISTURBANCE, 1, 18,
	"check_abort",                  _("Ϣ³ޥɤϥϤǤ", "Check for user abort while continuous command") },

	{ &flush_failure,               TRUE,  OPT_PAGE_DISTURBANCE, 1, 20,
	"flush_failure",                _("͡ʥߥȯϤ򥯥ꥢ", "Flush input on various failures") },

	{ &flush_disturb,               FALSE, OPT_PAGE_DISTURBANCE, 1, 21,
	"flush_disturb",                _("㳲ȯϤ򥯥ꥢ", "Flush input whenever disturbed") },

	{ &disturb_move,                FALSE, OPT_PAGE_DISTURBANCE, 0, 20,
	"disturb_move",                 _("ɤΥ󥹥ưƤưߤ", "Disturb whenever any monster moves") },

	{ &disturb_high,                FALSE, OPT_PAGE_DISTURBANCE, 1, 3,
	"disturb_high",                 _("٥ι⤤󥹥ưưߤ", "Disturb whenever high-level monster moves") },

	{ &disturb_near,                TRUE,  OPT_PAGE_DISTURBANCE, 0, 21,
	"disturb_near",                 _("볦Υ󥹥ưưߤ", "Disturb whenever viewable monster moves") },

	{ &disturb_pets,                FALSE, OPT_PAGE_DISTURBANCE, 5, 6,
	"disturb_pets",                 _("볦ΥڥåȤưưߤ", "Disturb when visible pets move") },

	{ &disturb_panel,               TRUE,  OPT_PAGE_DISTURBANCE, 0, 22,
	"disturb_panel",                _("̥˹ưߤ", "Disturb whenever map panel changes") },

	{ &disturb_state,               TRUE,  OPT_PAGE_DISTURBANCE, 0, 23,
	"disturb_state",                _("ʬΥơѲ˹ưߤ", "Disturb whenever player state changes") },

	{ &disturb_minor,               TRUE,  OPT_PAGE_DISTURBANCE, 0, 24,
	"disturb_minor",                _("٤ʤȤƤưߤ", "Disturb whenever boring things happen") },

	{ &ring_bell,                   FALSE, OPT_PAGE_DISTURBANCE, 0, 14,
	"ring_bell",                    _("顼˥ӡײĤ餹", "Audible bell (on errors, etc)") },

	{ &disturb_trap_detect,         TRUE,  OPT_PAGE_DISTURBANCE, 0, 27,
	"disturb_trap_detect",          _("ȥå״ϰϳ˽Фľ˹ưߤ", "Disturb when leaving trap detected area") },

	{ &alert_trap_detect,           FALSE, OPT_PAGE_DISTURBANCE, 0, 25,
	"alert_trap_detect",            _("ȥå״ϰϳ˽Фľ˷ٹ𤹤", "Alert when leaving trap detected area") },

	/*** Birth Options ***/
	{ &manual_haggle,               FALSE, OPT_PAGE_BIRTH, 1, 0,
	"manual_haggle",                _("ŹڤĤ򤹤", "Manually haggle in stores") },

	{ &easy_band,                   FALSE, OPT_PAGE_BIRTH, 6, 31,
	"easy_band",                    _("鿴Ѵñ⡼(*)", "Easy Mode (*)") },

	{ &smart_learn,                 TRUE,  OPT_PAGE_BIRTH, 1, 14,
	"smart_learn",                  _("󥹥ϼԤؽ(*)", "Monsters learn from their mistakes (*)") },
	
	{ &smart_cheat,                 FALSE, OPT_PAGE_BIRTH, 1, 15,
	"smart_cheat",                  _("󥹥ϥץ쥤䡼μߤͤ(*)", "Monsters exploit players weaknesses (*)") },

	{ &vanilla_town,                FALSE, OPT_PAGE_BIRTH, 6, 0,
	"vanilla_town",                 _("Ĥγ/Ȥȹʤ", "Use 'vanilla' town without quests and wilderness") },

	{ &lite_town,                   FALSE, OPT_PAGE_BIRTH, 6, 1,
	"lite_town",                    _("Ϥʳ/ʤ", "Use 'lite' town without a wilderness") },

	{ &ironman_shops,               FALSE, OPT_PAGE_BIRTH, 6, 2,
	"ironman_shops",                _("(Ŵ)ŹѤʤ(*)", "Stores are permanently closed (*)") },

	{ &ironman_small_levels,        FALSE, OPT_PAGE_BIRTH, 6, 3,
	"ironman_small_levels",         _("(Ŵ)˾ե(*)", "Always create unusually small dungeon levels (*)") },

	{ &ironman_downward,            FALSE, OPT_PAGE_BIRTH, 6, 4,
	"ironman_downward",             _("(Ŵ)ԤȾ곬ʤʤ(*)", "Disable recall and use of up stairs (*)") },

	{ &ironman_empty_levels,        FALSE, OPT_PAGE_BIRTH, 6, 8,
	"ironman_empty_levels",         _("(Ŵ)˶äݤΥ꡼ʥ٥(*)", "Always create empty 'arena' levels (*)") },

	{ &ironman_rooms,               FALSE, OPT_PAGE_BIRTH, 6, 12,
	"ironman_rooms",                _("(Ŵ)̤Ǥʤ(*)", "Always generate very unusual rooms (*)") },

	{ &ironman_nightmare,           FALSE, OPT_PAGE_BIRTH, 6, 18,
	"ironman_nightmare",            _("(Ŵ)̴⡼(ԾǤ)(*)", "Nightmare mode(it isn't even remotely fair!)(*)") },

	{ &left_hander,                 FALSE, OPT_PAGE_BIRTH, 6, 13,
	"left_hander",                  _("Ǥ", "Left-Hander") },

	{ &preserve_mode,               TRUE,  OPT_PAGE_BIRTH, 6, 14,
	"preserve_mode",                _("ΥƥƨƤ(*)", "Preserve artifacts (*)") },

	{ &autoroller,                  TRUE,  OPT_PAGE_BIRTH, 6, 15,
	"autoroller",                   _("ǽͤ˥ȥ顼(*)", "Allow use of autoroller for stats (*)") },

	{ &autochara,                   FALSE, OPT_PAGE_BIRTH, 6, 16,
	"autochara",                   _("γ/ϰ̤˥ȥ顼", "Autoroll for weight, height and social status") },

	{ &powerup_home,                TRUE,  OPT_PAGE_BIRTH, 4, 3,
	"powerup_home",                 _("椬Ȥĥ(*)", "Increase capacity of your home (*)") },

	/*** Easy Object Auto-Destroyer ***/

	{ &destroy_items,               FALSE, OPT_PAGE_AUTODESTROY, 7, 0,
	"destroy_items",                _("ƥδʰ׼ư˲Ѥ", "Use easy auto-destroyer") },

	{ &destroy_feeling,             FALSE, OPT_PAGE_AUTODESTROY, 7, 8,
	"destroy_feeling",              _("ʰ״ꤷȤư˲ŬѤ", "Apply auto-destroy as sense feeling") },

	{ &destroy_identify,            FALSE, OPT_PAGE_AUTODESTROY, 7, 9,
	"destroy_identify",             _("ꤷȤư˲ŬѤ", "Apply auto-destroy as identify an item") },

	{ &leave_worth,                 TRUE,  OPT_PAGE_AUTODESTROY, 7, 2,
	"leave_worth",                  _("ͤ륢ƥϲʤ", "Auto-destroyer leaves known worthy items") },

	{ &leave_equip,                 FALSE, OPT_PAGE_AUTODESTROY, 7, 3,
	"leave_equip",                  _("/ɶϲʤ", "Auto-destroyer leaves weapons and armour") },

	{ &leave_chest,                 TRUE,  OPT_PAGE_AUTODESTROY, 7, 7,
	"leave_chest",                  _("ƤʤȢϲʤ", "Auto-destroyer leaves closed chests") },

	{ &leave_wanted,                TRUE,  OPT_PAGE_AUTODESTROY, 7, 4,
	"leave_wanted",                 _("޶λ/ϲʤ", "Auto-destroyer leaves wanted corpses") },

	{ &leave_corpse,                FALSE, OPT_PAGE_AUTODESTROY, 7, 5,
	"leave_corpse",                 _("/ϲʤ", "Auto-destroyer leaves corpses and skeletons") },

	{ &leave_junk,                  FALSE, OPT_PAGE_AUTODESTROY, 7, 6,
	"leave_junk",                   _("餯ϲʤ", "Auto-destroyer leaves junk") },

	{ &leave_special,               TRUE,  OPT_PAGE_AUTODESTROY, 7, 1,
	"leave_special",                _("²/Ȥ̤ɬפʥƥϲʤ", "Auto-destroyer leaves items your race/class needs") },

	/*** Play-record Options ***/

	{ &record_fix_art,              TRUE,  OPT_PAGE_PLAYRECORD, 4, 11,
	"record_fix_art",               _("ꥢƥեȤϿ", "Record fixed artifacts") },

	{ &record_rand_art,             TRUE,  OPT_PAGE_PLAYRECORD, 4, 12,
	"record_rand_art",              _("ॢƥեȤϿ", "Record random artifacts") },

	{ &record_destroy_uniq,         TRUE,  OPT_PAGE_PLAYRECORD, 4, 13,
	"record_destroy_uniq",          _("ˡ󥹥ݤȤϿ", "Record when destroy unique monster") },

	{ &record_fix_quest,            TRUE,  OPT_PAGE_PLAYRECORD, 4, 14,
	"record_fix_quest",             _("ꥯȤãϿ", "Record fixed quests") },

	{ &record_rand_quest,           TRUE,  OPT_PAGE_PLAYRECORD, 4, 15,
	"record_rand_quest",            _("९ȤãϿ", "Record random quests") },

	{ &record_maxdepth,             TRUE,  OPT_PAGE_PLAYRECORD, 4, 16,
	"record_maxdepth",              _("ǿ򹹿Ȥ˵Ͽ", "Record movements to deepest level") },

	{ &record_stair,                TRUE,  OPT_PAGE_PLAYRECORD, 4, 17,
	"record_stair",                 _("ΰưϿ", "Record recall and stair movements") },

	{ &record_buy,                  TRUE,  OPT_PAGE_PLAYRECORD, 4, 18,
	"record_buy",                   _("ƥιϿ", "Record purchased items") },

	{ &record_sell,                 FALSE, OPT_PAGE_PLAYRECORD, 4, 19,
	"record_sell",                  _("ƥѤϿ", "Record sold items") },

	{ &record_danger,               TRUE,  OPT_PAGE_PLAYRECORD, 4, 20,
	"record_danger",                _("ԥˤʤäȤϿ", "Record hitpoint warning") },

	{ &record_arena,                TRUE,  OPT_PAGE_PLAYRECORD, 4, 21,
	"record_arena",                 _("꡼ʤǤξϿ", "Record arena victories") },

	{ &record_ident,                TRUE,  OPT_PAGE_PLAYRECORD, 4, 22,
	"record_ident",                 _("̤ȽΥƥμ̤Ͽ", "Record first identified items") },

	{ &record_named_pet,            FALSE, OPT_PAGE_PLAYRECORD, 4, 23,
	"record_named_pet",             _("̾ĤڥåȤξϿ", "Record informations of named pets") },

	/*** End of Table ***/

	{ NULL,                         0, 0, 0, 0,
	NULL,                           NULL }
};


#ifdef JP
const cptr chaos_patrons[MAX_PATRON] =
{
	"",
	"ޥ٥",
	"㡼ɥ",
	"ϥϡ",
	"С",

	"ԥ졼",
	"Х",
	"ꥪå",
	"",
	"ʡ",

	"Х",
	"",
	"顼ͥå",
	"ʡ",
	"ƥ",

	""
};
#else
const cptr chaos_patrons[MAX_PATRON] =
{
	"Slortar",
	"Mabelode",
	"Chardros",
	"Hionhurn",
	"Xiombarg",

	"Pyaray",
	"Balaan",
	"Arioch",
	"Eequor",
	"Narjhan",

	"Balo",
	"Khorne",
	"Slaanesh",
	"Nurgle",
	"Tzeentch",

	"Khaine"
};
#endif


const int chaos_stats[MAX_PATRON] =
{
	A_CON,  /* Slortar */
	A_CON,  /* Mabelode */
	A_STR,  /* Chardros */
	A_STR,  /* Hionhurn */
	A_STR,  /* Xiombarg */

	A_INT,  /* Pyaray */
	A_STR,  /* Balaan */
	A_INT,  /* Arioch */
	A_CON,  /* Eequor */
	A_CHR,  /* Narjhan */

	-1,     /* Balo */
	A_STR,  /* Khorne */
	A_CHR,  /* Slaanesh */
	A_CON,  /* Nurgle */
	A_INT,  /* Tzeentch */

	A_STR,  /* Khaine */
};




const int chaos_rewards[MAX_PATRON][20] =
{
	/* Slortar the Old: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_SLF, REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_EXP,
		REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Mabelode the Faceless: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_H_SUMMON, REW_SUMMON_M,
		REW_SUMMON_M, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_WND,
		REW_POLY_SLF, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_ABL, REW_SER_UNDE,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GOOD_OBJ, REW_GOOD_OBS, REW_GOOD_OBS
	},

	/* Chardros the Reaper: */
	{
		REW_WRATH, REW_WRATH, REW_HURT_LOT, REW_PISS_OFF, REW_H_SUMMON,
		REW_SUMMON_M, REW_IGNORE, REW_IGNORE, REW_DESTRUCT, REW_SER_UNDE,
		REW_GENOCIDE, REW_MASS_GEN, REW_MASS_GEN, REW_DISPEL_C, REW_GOOD_OBJ,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Hionhurn the Executioner: */
	{
		REW_WRATH, REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL,
		REW_IGNORE, REW_IGNORE, REW_SER_UNDE, REW_DESTRUCT, REW_GENOCIDE,
		REW_MASS_GEN, REW_MASS_GEN, REW_HEAL_FUL, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Xiombarg the Sword-Queen: */
	{
		REW_TY_CURSE, REW_TY_CURSE, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND, REW_POLY_WND,
		REW_GENOCIDE, REW_DISPEL_C, REW_GOOD_OBJ, REW_GOOD_OBJ, REW_SER_MONS,
		REW_GAIN_ABL, REW_CHAOS_WP, REW_GAIN_EXP, REW_AUGM_ABL, REW_GOOD_OBS
	},


	/* Pyaray the Tentacled Whisperer of Impossible Secretes: */
	{
		REW_WRATH, REW_TY_CURSE, REW_PISS_OFF, REW_H_SUMMON, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_SLF,
		REW_POLY_SLF, REW_SER_DEMO, REW_HEAL_FUL, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_CHAOS_WP, REW_DO_HAVOC, REW_GOOD_OBJ, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Balaan the Grim: */
	{
		REW_TY_CURSE, REW_HURT_LOT, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL,
		REW_SUMMON_M, REW_LOSE_EXP, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND,
		REW_SER_UNDE, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_EXP, REW_GAIN_EXP,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GOOD_OBS, REW_GREA_OBS, REW_AUGM_ABL
	},

	/* Arioch, Duke of Hell: */
	{
		REW_WRATH, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_EXP, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF,
		REW_POLY_SLF, REW_MASS_GEN, REW_SER_DEMO, REW_HEAL_FUL, REW_CHAOS_WP,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GAIN_EXP, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Eequor, Blue Lady of Dismay: */
	{
		REW_WRATH, REW_TY_CURSE, REW_PISS_OFF, REW_CURSE_WP, REW_RUIN_ABL,
		REW_IGNORE, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND,
		REW_GOOD_OBJ, REW_GOOD_OBJ, REW_SER_MONS, REW_HEAL_FUL, REW_GAIN_EXP,
		REW_GAIN_ABL, REW_CHAOS_WP, REW_GOOD_OBS, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Narjhan, Lord of Beggars: */
	{
		REW_WRATH, REW_CURSE_AR, REW_CURSE_WP, REW_CURSE_WP, REW_CURSE_AR,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF,
		REW_POLY_WND, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_EXP, REW_AUGM_ABL,
		REW_GOOD_OBJ, REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Balo the Jester: */
	{
		REW_WRATH, REW_SER_DEMO, REW_CURSE_WP, REW_CURSE_AR, REW_LOSE_EXP,
		REW_GAIN_ABL, REW_LOSE_ABL, REW_POLY_WND, REW_POLY_SLF, REW_IGNORE,
		REW_DESTRUCT, REW_MASS_GEN, REW_CHAOS_WP, REW_GREA_OBJ, REW_HURT_LOT,
		REW_AUGM_ABL, REW_RUIN_ABL, REW_H_SUMMON, REW_GREA_OBS, REW_AUGM_ABL
	},

	/* Khorne the Bloodgod: */
	{
		REW_WRATH, REW_HURT_LOT, REW_HURT_LOT, REW_H_SUMMON, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_SER_MONS, REW_SER_DEMO,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GOOD_OBJ,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Slaanesh: */
	{
		REW_WRATH, REW_PISS_OFF, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_SER_DEMO,
		REW_POLY_SLF, REW_HEAL_FUL, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GAIN_EXP,
		REW_GAIN_EXP, REW_CHAOS_WP, REW_GAIN_ABL, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Nurgle: */
	{
		REW_WRATH, REW_PISS_OFF, REW_HURT_LOT, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GAIN_ABL,
		REW_GAIN_ABL, REW_SER_UNDE, REW_CHAOS_WP, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Tzeentch: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_CHAOS_WP, REW_GREA_OBJ,
		REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_EXP, REW_GAIN_EXP, REW_AUGM_ABL
	},

	/* Khaine: */
	{
		REW_WRATH, REW_HURT_LOT, REW_PISS_OFF, REW_LOSE_ABL, REW_LOSE_EXP,
		REW_IGNORE,   REW_IGNORE,   REW_DISPEL_C, REW_DO_HAVOC, REW_DO_HAVOC,
		REW_POLY_SLF, REW_POLY_SLF, REW_GAIN_EXP, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_SER_MONS, REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_GOOD_OBS
	}
};

const martial_arts ma_blows[MAX_MA] =
{
#ifdef JP
	{ "%s򲥤ä",                          1, 0, 1, 5, 0 },
	{ "%s򽳤ä",                           2, 0, 1, 7, 0 },
	{ "%sͤ򤯤路",                         3, 0, 1, 9, 0 },
	{ "%sɨ򤯤路",             5, 5, 2, 4, MA_KNEE },
	{ "%sɪǤ򤯤路",            7, 5, 1, 12, 0 },
	{ "%sꤷ",                           9, 10, 2, 6, 0 },
	{ "%s򽳤ä",                           11, 10, 3, 6, MA_SLOW },
	{ "%s˥åѡ򤯤路",                       13, 12, 5, 5, 6 },
	{ "%sʽ򤯤路",                    16, 15, 5, 6, 8 },
	{ "%sǭ޷򤯤路",          20, 20, 5, 8, 0 },
	{ "%sķӤ򤯤路",           24, 25, 6, 8, 10 },
	{ "%s޽򤯤路",       28, 25, 7, 9, 0 },
	{ "%s˲󤷽򤯤路",         32, 30, 8, 10, 10 },
	{ "%sŴ򤯤路",          35, 35, 8, 11, 10 },
	{ "%sӤ򤯤路",         39, 35, 8, 12, 12 },
	{ "%s˾ζ򤯤路",         43, 35, 9, 12, 16 },
	{ "%sŷ÷򤯤路",       48, 40, 10, 13, 18 },
#else
	{ "You punch %s.",                          1, 0, 1, 4, 0 },
	{ "You kick %s.",                           2, 0, 1, 6, 0 },
	{ "You strike %s.",                         3, 0, 1, 7, 0 },
	{ "You hit %s with your knee.",             5, 5, 2, 3, MA_KNEE },
	{ "You hit %s with your elbow.",            7, 5, 1, 8, 0 },
	{ "You butt %s.",                           9, 10, 2, 5, 0 },
	{ "You kick %s.",                           11, 10, 3, 4, MA_SLOW },
	{ "You uppercut %s.",                       13, 12, 4, 4, 6 },
	{ "You double-kick %s.",                    16, 15, 5, 4, 8 },
	{ "You hit %s with a Cat's Claw.",          20, 20, 5, 5, 0 },
	{ "You hit %s with a jump kick.",           25, 25, 5, 6, 10 },
	{ "You hit %s with an Eagle's Claw.",       29, 25, 6, 6, 0 },
	{ "You hit %s with a circle kick.",         33, 30, 6, 8, 10 },
	{ "You hit %s with an Iron Fist.",          37, 35, 8, 8, 10 },
	{ "You hit %s with a flying kick.",         41, 35, 8, 10, 12 },
	{ "You hit %s with a Dragon Fist.",         45, 35, 10, 10, 16 },
	{ "You hit %s with a Crushing Blow.",       48, 35, 10, 12, 18 },
#endif

};

const int monk_ave_damage[PY_MAX_LEVEL+1][3] =
{
  {0, 0, 0},
  {249, 249, 249},
  {324, 324, 324},
  {382, 438, 382},
  {382, 439, 382},
  {390, 446, 390},
  {394, 473, 394},
  {425, 528, 425},
  {430, 535, 430},
  {505, 560, 435},
  {517, 575, 444},
  {566, 655, 474},
  {585, 713, 486},
  {653, 843, 527},
  {678, 890, 544},
  {703, 973, 558},
  {765, 1096, 596},
  {914, 1146, 614},
  {943, 1240, 629},
  {971, 1276, 643},
  {1018, 1350, 667},
  {1063, 1464, 688},
  {1099, 1515, 705},
  {1128, 1559, 721},
  {1153, 1640, 735},
  {1336, 1720, 757},
  {1387, 1789, 778},
  {1430, 1893, 794},
  {1610, 2199, 863},
  {1666, 2280, 885},
  {1713, 2401, 908},
  {1755, 2465, 925},
  {1909, 2730, 984},
  {2156, 2891, 1009},
  {2218, 2970, 1031},
  {2319, 3107, 1063},
  {2404, 3290, 1098},
  {2477, 3389, 1125},
  {2544, 3483, 1150},
  {2771, 3899, 1228},
  {2844, 3982, 1259},
  {3129, 4064, 1287},
  {3200, 4190, 1313},
  {3554, 4674, 1432},
  {3614, 4738, 1463},
  {3679, 4853, 1485},
  {3741, 4905, 1512},
  {3785, 4943, 1538},
  {4141, 5532, 1652},
  {4442, 5581, 1679},
  {4486, 5636, 1702},
};

/*
 * Table of game-generated inscriptions (indexed by the defines in
 * defines.h). -- RG
 */
const cptr game_inscriptions[] =
{
	NULL,            /* FEEL_NONE */
#ifdef JP
	"Ƥ",    /* FEEL_BROKEN */
	"",      /* FEEL_TERRIBLE */
	"̵",        /* FEEL_WORTHLESS */
	"Ƥ",  /* FEEL_CURSED */
	"ʾ",      /* FEEL_UNCURSED */
	"",            /* FEEL_AVERAGE */
	"",          /* FEEL_GOOD */
	"",        /* FEEL_EXCELLENT */
	"",        /* FEEL_SPECIAL */
#else
	"broken",        /* FEEL_BROKEN */
	"terrible",      /* FEEL_TERRIBLE */
	"worthless",     /* FEEL_WORTHLESS */
	"cursed",        /* FEEL_CURSED */
	"uncursed",      /* FEEL_UNCURSED */
	"average",       /* FEEL_AVERAGE */
	"good",          /* FEEL_GOOD */
	"excellent",     /* FEEL_EXCELLENT */
	"special",       /* FEEL_SPECIAL */
#endif

};

const kamae kamae_shurui[MAX_KAMAE] =
{
#ifdef JP
	{"", 25, ""},
	{"", 30, ""},
	{"ε", 35, ""},
	{"", 40, ""},
#else
	{"Genbu", 25, "(Black Tortoise) "},
	{"Byakko", 30, "(White Tiger) "},
	{"Seiryuu", 35, "(Blue Dragon) "},
	{"Suzaku", 40, "(Red Phoenix) "},
#endif
};

const kamae kata_shurui[MAX_KATA] =
{
#ifdef JP
	{"", 25, ""},
	{"", 30, ""},
	{"ߵ", 35, ""},
	{"̵", 40, ""},
#else
	{"Iai", 25, ""},
	{"Huujin", 30, ""},
	{"Kouki", 35, ""},
	{"Musou", 40, ""},
#endif
};

const cptr exp_level_str[5]=
#ifdef JP
{"[鿴]", "[]", "[]", "[ѡ]", "[ã]"};
#else
{"[Unskilled]", "[Beginner]", "[Skilled]", "[Expert]", "[Master]"};
#endif

/* Weird melee attack types when hallucinating */
#ifdef JP
const cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"˾ؤ򤫤줿",
	"ʤβ3äƥȸä",
	"ˤФޤ蘆줿",
	"˷ʤᤵ줿",
	"˥ϥʥФ줿",
	"˥ǹ⤵줿",
	"ʤˤ«ǤФ",
	"ʤǥݡ󥰤򤷤",
	"˥١줿",
	"ˡֿιȯű줿",
	"˥áޤ줿",
	"ˤĤäߤ줿",
	"Ϥʤ٤ä",
	"˴ˤ餯񤭤򤵤줿",
	"˼ڶֺѤ򤻤ޤ줿",
	"˥Ȥ᤯줿",
	"Ϥʤμä",
	"夬줿",
	"鰦ι򤵤줿",
	"Ϥʤ500ߤǸۤä",
	"Ϥʤ100̩ˤĤǮä",
	"˥㡼Ĥ",
	"Ϥʤ˵Ĥ",
	"Ϥʤݥꥴ󲽤",
	"˾줿",
	"ϥƥޤμʸ򾧤",
	"ϤʤΥѥ֥å",
	"ϥ饤ɰư",
	"ϾζޥɤϤ˼Ԥ",
	"ϳȻưˤȯͤ",
	"ϥǥ顼ˡ򤷤",
	"˥饤åǹ⤵줿",
	"󽵴ְǥӥǥͤ˸ʤȻ̼򤫤줿",
	"ϥѥץƤ򾧤",
	"ϥѡȥ饮饯ƥޥʥä",
	"ˤ㤬߾åǥϥ줿",
	"˥åȥȥ꡼ॢå򤫤줿",
	"ϤʤĸǤ򤫤ơ123áפȶ",
	"ϡ֤ʤФФФפȤäƶФ",
	"֤󡢥롼٥󥹤γפȸäŤܤĤ",
	"ϸäѶܡ仿桪",
};

/* Note: %s for strfmt() */
const cptr silly_attacks2[MAX_SILLY_ATTACK] =
{
	"%s˾ؤ򤫤",
	"%sβ3äƥȸä",
	"%s򤷤Фޤ路",
	"%s˷ʤᤵ",
	"%s˥ϥʥФ",
	"%s򥸥ǹ⤷",
	"%sˤ«ǤФ",
	"%sǥݡ󥰤򤷤",
	"%s˥١",
	"%sˡֿιȯű᤿",
	"%s˥áޤ",
	"%sˤĤäߤ줿",
	"%s٤ä",
	"%sδˤ餯񤭤򤷤",
	"%s˼ڶֺѤ򤻤ޤä",
	"%sΥȤ᤯ä",
	"%sμä",
	"%s夬ä",
	"%s˰ι򤷤",
	"%s500ߤǸۤä",
	"%s100̩ˤĤǮä",
	"˥㡼Ĥ",
	"%s˵Ĥ",
	"%sݥꥴ󲽤",
	"%s򾯤ä",
	"ƥޤμʸ򾧤",
	"%sΥѥ֥å",
	"饤ɰư",
	"ζޥɤϤ˼Ԥ",
	"%s˳Ȼưˤȯͤ",
	"%s˥ǥ顼ˡ򤷤",
	"%s饤åǹ⤷",
	"%s󽵴ְǥӥǥͤ˸ʤȻ̼򤫤",
	"ѥץƤ򾧤",
	"%s˥ѡȥ饮饯ƥޥʥä",
	"%s򤷤㤬߾åǥϥ᤿",
	"%s˥åȥȥ꡼ॢå򤫤",
	"%sĸǤ򤫤ơ123áפȶ",
	"֤ʤФФФפȤäƶФ",
	"֤󡢥롼٥󥹤γפȸäŤܤĤ",
	"äѶܡ仿桪",
};
#else
const cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"smothers",
	"hugs",
	"humiliates",
	"whips",
	"kisses",

	"disgusts",
	"pees all over",
	"passes the gas on",
	"makes obscene gestures at",
	"licks",

	"stomps on",
	"swallows",
	"drools on",
	"misses",
	"shrinks",

	"emasculates",
	"evaporates",
	"solidifies",
	"digitizes",
	"insta-kills",

	"massacres",
	"slaughters",
	"drugs",
	"psychoanalyzes",
	"deconstructs",

	"falsifies",
	"disbelieves",
	"molests",
	"pusupusu",
};
#endif


/*
 * The table of "symbol info" -- each entry is a string of the form
 * "X:desc" where "X" is the trigger, and "desc" is the "info".
 */
const cptr ident_info[] =
{
#ifdef JP
	" :Ű",
	"!:, ",
	"\":ߥå, ",
	"#:(ɥ)/ʪ/",
	"$:(⤫)",
	"%:̮(ϴ䤫б)",
	"&:Ȣ",
	"':ɥ",
	"(:餫ɶ",
	"):",
	"*:ޤ̮ޤϵβʪ",
	"+:Ĥɥ",
	",:ʪ, ФΥ",
	"-:ˡ, å",
	".:",
	"/:Ⱦ(å/ѥ/)",
	"0:ʪۤ",
	"1:߲",
	"2:ɶ񲰤",
	"3:Ź",
	"4:",
	"5:ϣѤŹ",
	"6:ˡŹ",
	"7:֥åޡåȤ",
	"8:椬Ȥ",
	"9:Ź",
	"::",
	";:Ħ/ȯΥ롼",
	"<:곬",
	"=:",
	">:곬",
	"?:ʪ",
	"@:ץ쥤䡼",
	"A:ŷ",
	"B:Ļ",
	"C:",
	"D:ɥ饴/磻",
	"E:󥿥",
	"F:ȥ",
	"G:",
	"H:",
	"I:",
	"J:إ",
	"K:顼ӡȥ",
	"L:å",
	"M:¿",
	"N:ʪ",
	"O:",
	"P:ʹַʪ",
	"Q:륹륰(̮Ǥ)",
	"R:/ξ",
	"S://",
	"T:ȥ",
	"U:ǡ",
	"V:Хѥ",
	"W:磻/쥤/",
	"X://",
	"Y:ƥ",
	"Z:ϥ",
	"[:ޡ",
	"\\:ߴ(ᥤ//)",
	"]:ɶ",
	"^:ȥå",
	"_:",
	"`:ͷĦ",
	"a:",
	"b:",
	"c:५",
	"d:ɥ饴",
	"e:ܶ",
	"f:ͥ",
	"g:",
	"h:ۥӥå//ɥ",
	"i:٥ȥ٥",
	"j:꡼",
	"k:ܥ",
	"l:ʪ",
	"m:",
	"n:ʡ",
	"o:",
	"p:ʹ",
	"q:­",
	"r:ͥ",
	"s:ȥ",
	"t:Įο",
	"u:ǡ",
	"v:ܥƥå",
	"w:ॷ/緲",
	/* "x:unused", */
	"y:",
	"z:/ߥ",
	"{:ƻ(/)",
	"|:(//)",
	"}:ƻ(/ܥ/)",
	"~:/ϴή(Υƥ)",
#else
	" :A dark grid",
	"!:A potion (or oil)",
	"\":An amulet (or necklace)",
	"#:A wall (or secret door) / a plant / a gas",
	"$:Treasure (gold or gems)",
	"%:A vein (magma or quartz)",
	"&:A chest",
	"':An open door",
	"(:Soft armor",
	"):A shield",
	"*:A vein with treasure or a ball monster",
	"+:A closed door",
	",:Food (or mushroom patch)",
	"-:A wand (or rod)",
	".:Floor",
	"/:A polearm (Axe/Pike/etc)",
	"0:Entrance to Museum",
	"1:Entrance to General Store",
	"2:Entrance to Armory",
	"3:Entrance to Weaponsmith",
	"4:Entrance to Temple",
	"5:Entrance to Alchemy shop",
	"6:Entrance to Magic store",
	"7:Entrance to Black Market",
	"8:Entrance to your home",
	"9:Entrance to the bookstore",
	"::Rubble",
	";:A glyph of warding / an explosive rune",
	"<:An up staircase",
	"=:A ring",
	">:A down staircase",
	"?:A scroll",
	"@:You",
	"A:Angel",
	"B:Bird",
	"C:Canine",
	"D:Ancient Dragon/Wyrm",
	"E:Elemental",
	"F:Dragon Fly",
	"G:Ghost",
	"H:Hybrid",
	"I:Insect",
	"J:Snake",
	"K:Killer Beetle",
	"L:Lich",
	"M:Multi-Headed Reptile",
	"N:Mystery Living",
	"O:Ogre",
	"P:Giant Humanoid",
	"Q:Quylthulg (Pulsing Flesh Mound)",
	"R:Reptile/Amphibian",
	"S:Spider/Scorpion/Tick",
	"T:Troll",
	"U:Major Demon",
	"V:Vampire",
	"W:Wight/Wraith/etc",
	"X:Xorn/Xaren/etc",
	"Y:Yeti",
	"Z:Zephyr Hound",
	"[:Hard armor",
	"\\:A hafted weapon (mace/whip/etc)",
	"]:Misc. armor",
	"^:A trap",
	"_:A staff",
	"`:A figurine or statue",
	"a:Ant",
	"b:Bat",
	"c:Centipede",
	"d:Dragon",
	"e:Floating Eye",
	"f:Feline",
	"g:Golem",
	"h:Hobbit/Elf/Dwarf",
	"i:Icky Thing",
	"j:Jelly",
	"k:Kobold",
	"l:Aquatic monster",
	"m:Mold",
	"n:Naga",
	"o:Orc",
	"p:Person/Human",
	"q:Quadruped",
	"r:Rodent",
	"s:Skeleton",
	"t:Townsperson",
	"u:Minor Demon",
	"v:Vortex",
	"w:Worm/Worm-Mass",
	/* "x:unused", */
	"y:Yeek",
	"z:Zombie/Mummy",
	"{:A missile (arrow/bolt/shot)",
	"|:An edged weapon (sword/dagger/etc)",
	"}:A launcher (bow/crossbow/sling)",
	"~:Fluid terrain (or miscellaneous item)",
#endif

	NULL
};


/*
 * The table of monsters' blow effects
 */
const mbe_info_type mbe_info[] =
{
	{  0, 0,             }, /* None      */
	{ 60, GF_MISSILE,    }, /* HURT      */
	{  5, GF_POIS,       }, /* POISON    */
	{ 20, GF_DISENCHANT, }, /* UN_BONUS  */
	{ 15, GF_MISSILE,    }, /* UN_POWER  */ /* ToDo: Apply the correct effects */
	{  5, GF_MISSILE,    }, /* EAT_GOLD  */
	{  5, GF_MISSILE,    }, /* EAT_ITEM  */
	{  5, GF_MISSILE,    }, /* EAT_FOOD  */
	{  5, GF_MISSILE,    }, /* EAT_LITE  */
	{  0, GF_ACID,       }, /* ACID      */
	{ 10, GF_ELEC,       }, /* ELEC      */
	{ 10, GF_FIRE,       }, /* FIRE      */
	{ 10, GF_COLD,       }, /* COLD      */
	{  2, GF_MISSILE,    }, /* BLIND     */
	{ 10, GF_CONFUSION,  }, /* CONFUSE   */
	{ 10, GF_MISSILE,    }, /* TERRIFY   */
	{  2, GF_MISSILE,    }, /* PARALYZE  */
	{  0, GF_MISSILE,    }, /* LOSE_STR  */
	{  0, GF_MISSILE,    }, /* LOSE_INT  */
	{  0, GF_MISSILE,    }, /* LOSE_WIS  */
	{  0, GF_MISSILE,    }, /* LOSE_DEX  */
	{  0, GF_MISSILE,    }, /* LOSE_CON  */
	{  0, GF_MISSILE,    }, /* LOSE_CHR  */
	{  2, GF_MISSILE,    }, /* LOSE_ALL  */
	{ 60, GF_ROCKET,     }, /* SHATTER   */
	{  5, GF_MISSILE,    }, /* EXP_10    */
	{  5, GF_MISSILE,    }, /* EXP_20    */
	{  5, GF_MISSILE,    }, /* EXP_40    */
	{  5, GF_MISSILE,    }, /* EXP_80    */
	{  5, GF_POIS,       }, /* DISEASE   */
	{  5, GF_TIME,       }, /* TIME      */
	{  5, GF_MISSILE,    }, /* EXP_VAMP  */
	{  5, GF_MANA,       }, /* DR_MANA   */
	{ 60, GF_MISSILE,    }, /* SUPERHURT */
};


/*
 * The table of features' actions
 */
const byte feature_action_flags[FF_FLAG_MAX] =
{
	0, /* LOS */
	0, /* PROJECT */
	0, /* MOVE */
	0, /* PLACE */
	0, /* DROP */
	0, /* SECRET */
	0, /* NOTICE */
	0, /* REMEMBER */
	0, /* OPEN */
	0, /* CLOSE */
	FAF_CRASH_GLASS, /* BASH */
	0, /* SPIKE */
	FAF_DESTROY, /* DISARM */
	0, /* STORE */
	FAF_DESTROY | FAF_CRASH_GLASS, /* TUNNEL */
	0, /* MAY_HAVE_GOLD */
	0, /* HAS_GOLD */
	0, /* HAS_ITEM */
	0, /* DOOR */
	0, /* TRAP */
	0, /* STAIRS */
	0, /* GLYPH */
	0, /* LESS */
	0, /* MORE */
	0, /* RUN */
	0, /* FLOOR */
	0, /* WALL */
	0, /* PERMANENT */
	0, /* INNER */
	0, /* OUTER */
	0, /* SOLID */
	0, /* HIT_TRAP */

	0, /* BRIDGE */
	0, /* RIVER */
	0, /* LAKE */
	0, /* BRIDGED */
	0, /* COVERED */
	0, /* GLOW */
	0, /* ENSECRET */
	0, /* WATER */
	0, /* LAVA */
	0, /* SHALLOW */
	0, /* DEEP */
	0, /* FILLED */
	FAF_DESTROY | FAF_CRASH_GLASS, /* HURT_ROCK */
	0, /* HURT_FIRE */
	0, /* HURT_COLD */
	0, /* HURT_ACID */
	0, /* ICE */
	0, /* ACID */
	0, /* OIL */
	0, /* XXX04 */
	0, /* CAN_CLIMB */
	0, /* CAN_FLY */
	0, /* CAN_SWIM */
	0, /* CAN_PASS */
	0, /* CAN_OOZE */
	0, /* CAN_DIG */
	0, /* HIDE_ITEM */
	0, /* HIDE_SNEAK */
	0, /* HIDE_SWIM */
	0, /* HIDE_DIG */
	0, /* KILL_HUGE */
	0, /* KILL_MOVE */

	0, /* PICK_TRAP */
	0, /* PICK_DOOR */
	0, /* ALLOC */
	0, /* CHEST */
	0, /* DROP_1D2 */
	0, /* DROP_2D2 */
	0, /* DROP_GOOD */
	0, /* DROP_GREAT */
	0, /* HURT_POIS */
	0, /* HURT_ELEC */
	0, /* HURT_WATER */
	0, /* HURT_BWATER */
	0, /* USE_FEAT */
	0, /* GET_FEAT */
	0, /* GROUND */
	0, /* OUTSIDE */
	0, /* EASY_HIDE */
	0, /* EASY_CLIMB */
	0, /* MUST_CLIMB */
	0, /* TREE */
	0, /* NEED_TREE */
	0, /* BLOOD */
	0, /* DUST */
	0, /* SLIME */
	0, /* PLANT */
	0, /* XXX2 */
	0, /* INSTANT */
	0, /* EXPLODE */
	0, /* TIMED */
	0, /* ERUPT */
	0, /* STRIKE */
	0, /* SPREAD */

	0, /* SPECIAL */
	FAF_DESTROY | FAF_NO_DROP | FAF_CRASH_GLASS, /* HURT_DISI */
	0, /* QUEST_ENTER */
	0, /* QUEST_EXIT */
	0, /* QUEST */
	0, /* SHAFT */
	0, /* MOUNTAIN */
	0, /* BLDG */
	0, /* MINOR_GLYPH */
	0, /* PATTERN */
	0, /* TOWN */
	0, /* ENTRANCE */
	0, /* MIRROR */
	0, /* UNPERM */
	0, /* TELEPORTABLE */
	0, /* CONVERT */
	0, /* GLASS */
};


/*
 * Define flags, effect type, name for dragon breath activation
 */
const dragonbreath_type dragonbreath_info[] = {
	{ TR_RES_ACID, GF_ACID, _("", "acid") },
	{ TR_RES_ELEC, GF_ELEC, _("ŷ", "lightning") },
	{ TR_RES_FIRE, GF_FIRE, _("б", "fire") },
	{ TR_RES_COLD, GF_COLD, _("䵤", "cold") },
	{ TR_RES_POIS, GF_POIS, _("", "poison") },
	{ TR_RES_LITE, GF_LITE, _("", "light") },
	{ TR_RES_DARK, GF_DARK, _("Ź", "dark") },
	{ TR_RES_SHARDS, GF_SHARDS, _("", "shard") },
	{ TR_RES_CONF, GF_CONFUSION, _("", "confusion") },
	{ TR_RES_SOUND, GF_SOUND, _("첻", "sound") },
	{ TR_RES_NEXUS, GF_NEXUS, _("̺", "nexus") },
	{ TR_RES_NETHER, GF_NETHER, _("Ϲ", "nether") },
	{ TR_RES_CHAOS, GF_CHAOS, _("", "chaos") },
	{ TR_RES_DISEN, GF_DISENCHANT, _("", "disenchant") },
	{ 0, 0, NULL }
};

/*
 * Define flags, levels, values of activations
 */
const activation_type activation_info[] =
{
	{ "SUNLIGHT", ACT_SUNLIGHT, 10, 250, {10, 0},
	  _("۸", "beam of sunlight") },
	{ "BO_MISS_1", ACT_BO_MISS_1, 10, 250, {2, 0},
	  _("ޥåߥ(2d6)", "magic missile (2d6)") },
	{ "BA_POIS_1", ACT_BA_POIS_1, 10, 300, {4, 0},
	  _("(12)", "stinking cloud (12)") },
	{ "BO_ELEC_1", ACT_BO_ELEC_1, 20, 250, {5, 0},
	  _("ܥ(4d8)", "lightning bolt (4d8)") },
	{ "BO_ACID_1", ACT_BO_ACID_1, 20, 250, {6, 0},
	  _("åɡܥ(5d8)", "acid bolt (5d8)") },
	{ "BO_COLD_1", ACT_BO_COLD_1, 20, 250, {7, 0},
	  _("ܥ(6d8)", "frost bolt (6d8)") },
	{ "BO_FIRE_1", ACT_BO_FIRE_1, 20, 250, {8, 0},
	  _("եܥ(9d8)", "fire bolt (9d8)") },
	{ "BA_COLD_1", ACT_BA_COLD_1, 30, 750, {6, 0},
	  _("ܡ(48)", "ball of cold (48)") },
	{ "BA_COLD_2", ACT_BA_COLD_2, 40, 1000, {12, 0},
	  _("ܡ(100)", "ball of cold (100)") },
	{ "BA_COLD_3", ACT_BA_COLD_3, 70, 2500, {50, 0},
	  _("祢ܡ(400)", "ball of cold (400)") },
	{ "BA_FIRE_1", ACT_BA_FIRE_1, 30, 1000, {9, 0},
	  _("եܡ(72)", "ball of fire (72)") },
	{ "BA_FIRE_2", ACT_BA_FIRE_2, 40, 1500, {15, 0},
	  _("եܡ(120)", "large fire ball (120)") },
	{ "BA_FIRE_3", ACT_BA_FIRE_3, 60, 1750, {40, 0},
	  _("եܡ(300)", "fire ball (300)") },
	{ "BA_FIRE_4", ACT_BA_FIRE_4, 40, 1000, {12, 0},
	  _("եܡ(100)", "fire ball (100)") },
	{ "BA_ELEC_2", ACT_BA_ELEC_2, 40, 1000, {12, 0},
	  _("ܡ(100)", "ball of lightning (100)") },
	{ "BA_ELEC_3", ACT_BA_ELEC_3, 70, 2500, {70, 0},
	  _("祵ܡ(500)", "ball of lightning (500)") },
	{ "BA_ACID_1", ACT_BA_ACID_1, 30, 1000, {12, 0},
	  _("åɡܡ(100)", "ball of acid (100)") },
	{ "BA_NUKE_1", ACT_BA_NUKE_1, 50, 1000, {12, 0},
	  _("ǽ(100)", "ball of nuke (100)") },
	{ "DRAIN_1", ACT_DRAIN_1, 30, 500, {12, 0},
	  _("©(100)", "a strangling attack (100)") },
	{ "DRAIN_2", ACT_DRAIN_2, 40, 750, {15, 0},
	  _("̿ϵۼ(120)", "drain life (120)") },
	{ "VAMPIRE_1", ACT_VAMPIRE_1, 40, 1000, {20, 0},
	  _("۷ɥ쥤(3*50)", "vampiric drain (3*50)") },
	{ "BO_MISS_2", ACT_BO_MISS_2, 40, 1000, {20, 0},
	  _("(150)", "arrows (150)") },
	{ "WHIRLWIND", ACT_WHIRLWIND, 50, 7500, {25, 0},
	  _("ޥ", "whirlwind attack") },
	{ "VAMPIRE_2", ACT_VAMPIRE_2, 50, 2500, {40, 0},
	  _("۷ɥ쥤(3*100)", "vampiric drain (3*100)") },
	{ "CALL_CHAOS", ACT_CALL_CHAOS, 70, 5000, {35, 0},
	  _("پ", "call chaos") },
	{ "ROCKET", ACT_ROCKET, 70, 5000, {20, 0},
	  _("å(120+٥)", "launch rocket (120+level)") },
	{ "DISP_EVIL", ACT_DISP_EVIL, 50, 4000, {50, 0},
	  _("ٰ໶(x5)", "dispel evil (x5)") },
	{ "BA_MISS_3", ACT_BA_MISS_3, 50, 1500, {50, 0},
	  _("ȤΥ֥쥹(300)", "elemental breath (300)") },
	{ "DISP_GOOD", ACT_DISP_GOOD, 50, 3500, {50, 0},
	  _("໶(x5)", "dispel good (x5)") },
	{ "BO_MANA", ACT_BO_MANA, 40, 1500, {20, 0},
	  _("ˡ(150)", "a magical arrow (150)") },
	{ "BA_WATER", ACT_BA_WATER, 50, 2000, {25, 0},
	  _("ܡ(200)", "water ball (200)") },
	{ "BA_STAR", ACT_BA_STAR, 50, 2200, {25, 0},
	  _("祹ܡ(200)", "large star ball (200)") },
	{ "BA_DARK", ACT_BA_DARK, 50, 2200, {30, 0},
	  _("Ź(250)", "darkness storm (250)") },
	{ "BA_MANA", ACT_BA_MANA, 70, 2500, {30, 0},
	  _("Ϥ(250)", "a mana storm (250)") },
	{ "PESTICIDE", ACT_PESTICIDE, 10, 500, {10, 0},
	  _("ζ", "dispel small life") },
	{ "BLINDING_LIGHT", ACT_BLINDING_LIGHT, 30, 5000, {40, 0},
	  _("", "blinding light") },
	{ "BIZARRE", ACT_BIZARRE, 90, 10000, {50, 0},
	  _("񤤤", "bizarre things") },
	{ "CAST_BA_STAR", ACT_CAST_BA_STAR, 70, 7500, {100, 0},
	  _("ܡ롦(150)", "cast star balls (150)") },
	{ "BLADETURNER", ACT_BLADETURNER, 80, 20000, {80, 0},
	  _("ȤΥ֥쥹(300), εȡʡ", "breathe elements (300), hero, bless, and resistance") },
	{ "BR_FIRE", ACT_BR_FIRE, 50, 5000, {-1, 0},
	  _("бΥ֥쥹 (200)", "fire breath (200)") },
	{ "BR_COLD", ACT_BR_COLD, 50, 5000, {-1, 0},
	  _("䵤Υ֥쥹 (200)", "cold breath (200)") },
	{ "BR_DRAGON", ACT_BR_DRAGON, 70, 10000, { 30, 0 },
	  "" /* built by item_activation_dragon_breath() */ },

	{ "CONFUSE", ACT_CONFUSE, 10, 500, {10, 0},
	  _("ѥ˥å󥹥", "confuse monster") },
	{ "SLEEP", ACT_SLEEP, 10, 750, {15, 0},
	  _("ϤΥ󥹥̲餻", "sleep nearby monsters") },
	{ "QUAKE", ACT_QUAKE, 30, 600, {20, 0},
	  _("Ͽ", "earthquake") },
	{ "TERROR", ACT_TERROR, 20, 2500, {-1, 0},
	  _("", "terror") },
	{ "TELE_AWAY", ACT_TELE_AWAY, 20, 2000, {15, 0},
	  _("ƥݡȡ", "teleport away") },
	{ "BANISH_EVIL", ACT_BANISH_EVIL, 40, 2000, {250, 0},
	  _("ٰ", "banish evil") },
	{ "GENOCIDE", ACT_GENOCIDE, 50, 10000, {500, 0},
	  _("", "genocide") },
	{ "MASS_GENO", ACT_MASS_GENO, 50, 10000, {1000, 0},
	  _("", "mass genocide") },
	{ "SCARE_AREA", ACT_SCARE_AREA, 20, 2500, {20, 0},
	  _("󥹥", "frighten monsters") },
	{ "AGGRAVATE", ACT_AGGRAVATE, 0, 100, {0, 0},
	  _("󥹥ܤ餻", "aggravete monsters") },

	{ "CHARM_ANIMAL", ACT_CHARM_ANIMAL, 40, 7500, {200, 0},
	  _("ưʪ̥λ", "charm animal") },
	{ "CHARM_UNDEAD", ACT_CHARM_UNDEAD, 40, 10000, {333, 0},
	  _("ǥåɽ°", "enslave undead") },
	{ "CHARM_OTHER", ACT_CHARM_OTHER, 40, 10000, {400, 0},
	  _("󥹥̥λ", "charm monster") },
	{ "CHARM_ANIMALS", ACT_CHARM_ANIMALS, 40, 12500, {500, 0},
	  _("ưʪͧ", "animal friendship") },
	{ "CHARM_OTHERS", ACT_CHARM_OTHERS, 40, 17500, {750, 0},
	  _("̥λ", "mass charm") },
	{ "SUMMON_ANIMAL", ACT_SUMMON_ANIMAL, 50, 10000, {200, 300},
	  _("ưʪ", "summon animal") },
	{ "SUMMON_PHANTOM", ACT_SUMMON_PHANTOM, 50, 12000, {200, 200},
	  _("", "summon phantasmal servant") },
	{ "SUMMON_ELEMENTAL", ACT_SUMMON_ELEMENTAL, 50, 15000, {750, 0},
	  _("󥿥뾤", "summon elemental") },
	{ "SUMMON_DEMON", ACT_SUMMON_DEMON, 50, 20000, {666, 0},
	  _("⾤", "summon demon") },
	{ "SUMMON_UNDEAD", ACT_SUMMON_UNDEAD, 50, 20000, {666, 0},
	  _("ǥåɾ", "summon undead") },
	{ "SUMMON_HOUND", ACT_SUMMON_HOUND, 50, 15000, {300, 0},
	  _("ϥɾ", "summon hound") },
	{ "SUMMON_DAWN", ACT_SUMMON_DAWN, 50, 15000, {500, 0},
	  _("Ǥλľ", "summon the Legion of the Dawn") },
	{ "SUMMON_OCTOPUS", ACT_SUMMON_OCTOPUS, 50, 15000, {300, 0},
	  _("緲", "summon octopus") },

	{ "CHOIR_SINGS", ACT_CHOIR_SINGS, 60, 20000, {300, 0},
	  _("(777)ε", "heal 777 hit points, curing and heloism") },
	{ "CURE_LW", ACT_CURE_LW, 10, 500, {10, 0},
	  _("ݽ/ϲ(30)", "remove fear and heal 30 hp") },
	{ "CURE_MW", ACT_CURE_MW, 20, 750, {3, 3},
	  _("(4d8)", "heal 4d8 and wounds") },
	{ "CURE_POISON", ACT_CURE_POISON, 10, 1000, {5, 0},
	  _("ݽ/Ǿä", "remove fear and cure poison") },
	{ "REST_LIFE", ACT_REST_LIFE, 40, 7500, {450, 0},
	  _("и", "restore life levels") },
	{ "REST_ALL", ACT_REST_ALL, 30, 15000, {750, 0},
	  _("ơȷи", "restore stats and life levels") },
	{ "CURE_700", ACT_CURE_700, 40, 10000, {250, 0},
	  _("ϲ(700)", "heal 700 hit points") },
	{ "CURE_1000", ACT_CURE_1000, 50, 15000, {888, 0},
	  _("ϲ(1000)", "heal 1000 hit points") },
	{ "CURING", ACT_CURING, 30, 5000, {100, 0},
	  _("", "curing") },
	{ "CURE_MANA_FULL", ACT_CURE_MANA_FULL, 60, 20000, {777, 0},
	  _("", "restore mana") },

	{ "ESP", ACT_ESP, 30, 1500, {100, 0},
	  _("ƥѥ( 25+d30)", "telepathy (dur 25+d30)") },
	{ "BERSERK", ACT_BERSERK, 10, 800, {75, 0},
	  _("β(25+d25)", "berserk (25+d25 turns)") },
	{ "PROT_EVIL", ACT_PROT_EVIL, 30, 5000, {100, 0},
	  _("мٰ볦( 3*٥+d25)", "protect evil (dur level*3 + d25)") },
	{ "RESIST_ALL", ACT_RESIST_ALL, 30, 5000, {111, 0},
	  _("( 20+d20)", "resist elements (dur 20+d20)") },
	{ "SPEED", ACT_SPEED, 40, 15000, {250, 0},
	  _("®( 20+d20)", "speed (dur 20+d20)") },
	{ "XTRA_SPEED", ACT_XTRA_SPEED, 40, 25000, {200, 200},
	  _("®( 75+d75)", "speed (dur 75+d75)") },
	{ "WRAITH", ACT_WRAITH, 90, 25000, {1000, 0},
	  _("ͩβ( (٥/2)+d(٥/2))", "wraith form (dur level/2 + d(level/2))") },
	{ "INVULN", ACT_INVULN, 90, 25000, {1000, 0},
	  _("̵Ũ( 8+d8)", "invulnerability (dur 8+d8)") },
	{ "HELO", ACT_HELO, 10, 500, {30, 30},
	  _("ε", "heroism") },
	{ "HELO_SPEED", ACT_HELO_SPEED, 30, 20000, {100, 200},
	  _("ε, ԡ( 50+d50)", "hero and +10 to speed (50)") },
	{ "RESIST_ACID", ACT_RESIST_ACID, 20, 2000, {40, 40},
	  _("ؤ( 20+d20)", "resist acid (dur 20+d20)") },
	{ "RESIST_FIRE", ACT_RESIST_FIRE, 20, 2000, {40, 40},
	  _("бؤ( 20+d20)", "resist fire (dur 20+d20)") },
	{ "RESIST_COLD", ACT_RESIST_COLD, 20, 2000, {40, 40},
	  _("䵤ؤ( 20+d20)", "resist cold (dur 20+d20)") },
	{ "RESIST_ELEC", ACT_RESIST_ELEC, 20, 2000, {40, 40},
	  _("ŷؤ( 20+d20)", "resist elec (dur 20+d20)") },
	{ "RESIST_POIS", ACT_RESIST_POIS, 20, 2000, {40, 40},
	  _("Ǥؤ( 20+d20)", "resist poison (dur 20+d20)") },

	{ "LIGHT", ACT_LIGHT, 10, 150, {10, 10},
	  _("ߥ͡", "light area (dam 2d15)") },
	{ "MAP_LIGHT", ACT_MAP_LIGHT, 30, 500, {50, 50},
	  _("ˡϿޤȸ", "light (dam 2d15) & map area") },
	{ "DETECT_ALL", ACT_DETECT_ALL, 30, 1000, {55, 55},
	  _("", "detection") },
	{ "DETECT_XTRA", ACT_DETECT_XTRA, 50, 12500, {100, 0},
	  _("Ρõ**", "detection, probing and identify true") },
	{ "ID_FULL", ACT_ID_FULL, 50, 10000, {75, 0},
	  _("**", "identify true") },
	{ "ID_PLAIN", ACT_ID_PLAIN, 20, 1250, {10, 0},
	  _("", "identify spell") },
	{ "RUNE_EXPLO", ACT_RUNE_EXPLO, 40, 4000, {200, 0},
	  _("ȯΥ롼", "explosive rune") },
	{ "RUNE_PROT", ACT_RUNE_PROT, 60, 10000, {400, 0},
	  _("Υ롼", "rune of protection") },
	{ "SATIATE", ACT_SATIATE, 10, 2000, {200, 0},
	  _("ʢ­", "satisfy hunger") },
	{ "DEST_DOOR", ACT_DEST_DOOR, 10, 100, {10, 0},
	  _("ɥ˲", "destroy doors") },
	{ "STONE_MUD", ACT_STONE_MUD, 20, 1000, {3, 0},
	  _("ϲ", "stone to mud") },
	{ "RECHARGE", ACT_RECHARGE, 30, 1000, {70, 0},
	  _("ϽŶ", "recharging") },
	{ "ALCHEMY", ACT_ALCHEMY, 50, 10000, {500, 0},
	  _("ϣ", "alchemy") },
	{ "DIM_DOOR", ACT_DIM_DOOR, 50, 10000, {100, 0},
	  _("", "dimension door") },
	{ "TELEPORT", ACT_TELEPORT, 10, 2000, {25, 0},
	  _("ƥݡ", "teleport") },
	{ "RECALL", ACT_RECALL, 30, 7500, {200, 0},
	  _("Ԥξ", "word of recall") },
	{ "JUDGE", ACT_JUDGE, 90, 50000, {20, 20},
	  _("ϤȰؤΤȵ", "a telekinesis (500 lb)") },
	{ "TELEKINESIS", ACT_TELEKINESIS, 20, 5500, {25, 25},
	  _("ʪΤ󤻤(25kgޤ)", "clairvoyance and recall, draining you") },
	{ "DETECT_UNIQUE", ACT_DETECT_UNIQUE, 40, 10000, {200, 0},
	  _("γˤˡ󥹥ɽ", "list of the uniques on the level") },
	{ "ESCAPE", ACT_ESCAPE, 10, 3000, {35, 0},
	  _("ƨ", "a getaway") },
	{ "DISP_CURSE_XTRA", ACT_DISP_CURSE_XTRA, 40, 30000, {0, 0},
	  _("**Ĵ", "dispel curse and probing") },
	{ "BRAND_FIRE_BOLTS", ACT_BRAND_FIRE_BOLTS, 40, 20000, {999, 0},
	  _("Υեܥ", "fire branding of bolts") },
	{ "RECHARGE_XTRA", ACT_RECHARGE_XTRA, 70, 30000, {200, 0},
	  _("ϽŶ", "recharge item") },
	{ "LORE", ACT_LORE, 10, 30000, {0, 0},
	  _("ȼ", "perilous identify") },
	{ "SHIKOFUMI", ACT_SHIKOFUMI, 10, 10000, {100, 100},
	  _("͸Ƨ", "shiko") },
	{ "PHASE_DOOR", ACT_PHASE_DOOR, 10, 1500, {10, 0},
	  _("硼ȡƥݡ", "blink") },
	{ "DETECT_ALL_MONS", ACT_DETECT_ALL_MONS, 30, 3000, {150, 0},
	  _("󥹥", "detect all monsters") },
	{ "ULTIMATE_RESIST", ACT_ULTIMATE_RESIST, 90, 20000, {777, 0},
	  _("εȡʡˤ", "hero, bless, and ultimate resistance") },

	{ "CAST_OFF", ACT_CAST_OFF, 30, 15000, {100, 0},
	  _("æȾǳ", "cast it off and cosmic heroism") },
	{ "FISHING", ACT_FISHING, 0, 100, {0, 0},
	  _("򤹤", "fishing") },
	{ "INROU", ACT_INROU, 40, 15000, {150, 150},
	  _("Υ", "reveal your identity") },
	{ "MURAMASA", ACT_MURAMASA, 0, 0, {-1, 0},
	  _("Ϥξ徺", "increase STR") },
	{ "BLOODY_MOON", ACT_BLOODY_MOON, 0, 0, {3333, 0},
	  _("°ѹ", "change zokusei") },
	{ "CRIMSON", ACT_CRIMSON, 0, 50000, {15, 0},
	  _("ե", "fire!") },

	{ "STRAIN_HASTE", ACT_STRAIN_HASTE, 10, 1000, {120, 100},
	  _("ϤȰ˲®", "haste with strain") },
	{ "GRAND_CROSS", ACT_GRAND_CROSS, 30, 15000, {250, 200},
	  _("ɡ", "grand cross") },
	{ "TELEPORT_LEVEL", ACT_TELEPORT_LEVEL, 10, 1500, {100, 200},
	  _("ƥݡȡ٥", "teleort level") },
	{ "ARTS_FALLING_STAR", ACT_FALLING_STAR, 20, 5500, {30, 50},
	  _("ή", "blade arts 'falling star'") },
	{ NULL, 0, 0, 0, {0, 0},
	  "" }
};
