#include "hole_punchd.h"

int	ja_checki(char call[]);

void	repeater_connect (struct sockaddr_in sender_info, unsigned char buff[], int length)
{
	struct	RepeaterTable	*next;
	char	buff_temp[25];
	time_t	atime;

	if (length == 24)
	{
		if (memcmp (&buff[16], &buff[4], 7)) return;
		if (buff[15] < 0x28)	// 00.40
		{
			time (&atime);
			fprintf (log_file, "%24.24s old version %8.8s\n", 
				ctime(&atime), &buff[4]);
			fflush (log_file);
			return;        // check new version
		}
	}

	if (!ja_check(&buff[4])) return;
	if (memcmp (&buff[4], &buff[16], 7)) return;
	next = RepeaterTablePnt;
	while (next)
	{
		if (!memcmp(&next->repeater_addr.sin_addr, &sender_info.sin_addr, sizeof(struct in_addr))
			//&& (next->repeater_addr.sin_port == sender_info.sin_port)
			&& !memcmp(&buff[4], &next->ar_callsign[0], 8))
		{
			next->repeater_addr.sin_port = sender_info.sin_port;
			time (&next->AccessTime);
			return;
		}
		next = next->f_chain;
	}
	if (!memcmp (&buff[4], "RPT", 3) || (buff[11] == 'S'))
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s Iligal call sign %8.8s %s:%d\n", 
			ctime(&cur_time), &buff[4],
			inet_ntoa (sender_info.sin_addr), ntohs(sender_info.sin_port));
		fflush (log_file);
		return;
	}
	next = malloc (sizeof(struct RepeaterTable));
	next->f_chain = RepeaterTablePnt;
	memcpy (&next->repeater_addr, &sender_info, sizeof (sender_info));
	time (&next->AccessTime);
	next->status = OFF;
	memset (next->ur_call, 0x20, 8);
	memset (next->my_call, 0x20, 8);
	time(&cur_time);
	memcpy (next->ar_callsign, &buff[4], 8);
	memset (next->zr_callsign, 0x20, 8);
	if (length == 24) memcpy (next->zr_callsign, &buff[16], 8);
	next->area_code[0] = 0x30;
	next->area_code[1] = buff[6];
	if (buff[6] == 0x30) next->area_code[0] = 0x31;
	next->port = ((buff[12] & 0xff) << 8) | (buff[13] & 0xff);
	next->dv_port = 0;
	RepeaterTablePnt = next;
	fprintf (log_file, "%24.24s Connect from %s:%d %8.8s\n", 
		ctime(&cur_time), 
		inet_ntoa (sender_info.sin_addr), ntohs(sender_info.sin_port), &buff[4]);
	fflush (log_file);
	bubbleSort();
}

