/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import org.castor.mapping.BindingType;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.ClassValidator;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XPathLocation;

public class Validator
implements ClassValidator {
    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            throw new ValidationException("Cannot validate a null Object.");
        }
        if (context == null) {
            this.validate(object, new ValidationContext());
            return;
        }
        if (context.getResolver() == null) {
            context.setResolver((XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML));
        }
        XMLClassDescriptor classDesc = null;
        if (!MarshalFramework.isPrimitive(object.getClass())) {
            try {
                classDesc = context.getResolver().resolveXML(object.getClass());
            }
            catch (ResolverException rx) {
                throw new ValidationException(rx);
            }
        }
        if (classDesc == null) {
            return;
        }
        XMLFieldDescriptor fieldDesc = null;
        try {
            TypeValidator validator = classDesc.getValidator();
            if (validator != null) {
                validator.validate(object, context);
            } else {
                FieldDescriptor[] fields = classDesc.getFields();
                if (fields != null) {
                    for (int i = 0; i < fields.length; ++i) {
                        FieldValidator fieldValidator;
                        fieldDesc = (XMLFieldDescriptor)fields[i];
                        if (fieldDesc == null || (fieldValidator = fieldDesc.getValidator()) == null) continue;
                        fieldValidator.validate(object, context);
                    }
                }
            }
        }
        catch (ValidationException vx) {
            XPathLocation loc = (XPathLocation)vx.getLocation();
            if (loc == null) {
                loc = new XPathLocation();
                vx.setLocation(loc);
                if (fieldDesc != null) {
                    if (fieldDesc.getNodeType() == NodeType.Attribute) {
                        loc.addAttribute(fieldDesc.getXMLName());
                    } else {
                        loc.addChild(fieldDesc.getXMLName());
                    }
                }
            }
            if (classDesc.getXMLName() != null) {
                loc.addParent(classDesc.getXMLName());
            }
            throw vx;
        }
        if (context.getUnresolvedIdRefs().size() > 0) {
            String err = "Unresolved IDREfs: " + context.getUnresolvedIdRefs().toString();
            throw new ValidationException(err);
        }
    }
}

