/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.jacorb.naming.namemanager.Handler;
import org.jacorb.naming.namemanager.NSTable;
import org.jacorb.naming.namemanager.NSTree;
import org.jacorb.naming.namemanager.TableHandler;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class NameManager {
    public static void main(String[] stringArray) {
        ORB oRB = ORB.init(stringArray, null);
        JFrame jFrame = new JFrame("JacORB NameManager");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Edit");
        JMenu jMenu3 = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("Quit", 81);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Options");
        JMenuItem jMenuItem3 = new JMenuItem("BindNewContext", 78);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        JMenuItem jMenuItem4 = new JMenuItem("Bind Object", 66);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        JMenuItem jMenuItem5 = new JMenuItem("Unbind name", 85);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("About...");
        jMenu3.add(jMenuItem6);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        NamingContextExt namingContextExt = null;
        try {
            namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jFrame, "Could not find name service", "Initialization error", 0);
            NameManager.usage();
            System.exit(1);
        }
        if (namingContextExt == null) {
            System.err.println("Narrow for name service failed, exiting...");
            NameManager.usage();
            System.exit(1);
        }
        NSTable nSTable = new NSTable();
        JScrollPane jScrollPane = new JScrollPane(nSTable);
        nSTable.setPreferredScrollableViewportSize(new Dimension(300, 250));
        NSTree nSTree = new NSTree(300, 200, nSTable, namingContextExt, oRB);
        JScrollPane jScrollPane2 = new JScrollPane(nSTree);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jScrollPane2);
        jSplitPane.setRightComponent(jScrollPane);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setDividerSize(2);
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.getContentPane().add(jSplitPane);
        nSTree.update();
        Handler handler = new Handler(jFrame, nSTree);
        TableHandler tableHandler = new TableHandler(jFrame, nSTable);
        jMenuItem.addActionListener(handler);
        jMenuItem2.addActionListener(handler);
        jMenuItem3.addActionListener(handler);
        jMenuItem4.addActionListener(handler);
        jMenuItem5.addActionListener(handler);
        jMenuItem6.addActionListener(handler);
        nSTree.addMouseListener(handler);
        nSTree.addKeyListener(handler);
        jFrame.addWindowListener(handler);
        nSTable.addMouseListener(tableHandler);
        nSTable.addKeyListener(tableHandler);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.pack();
        jFrame.show();
        oRB.run();
    }

    public static void usage() {
        System.out.println("Usage: NameManager [orb_options]");
        System.out.println("          e.g. nmg -ORBInitRef NameService=file:///c:/ns.ior");
    }
}

