/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.AbstractObservableMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IBidirectionalMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMappingChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMappingWithDomain;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.MappingDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.set.WritableSet;

public class BidirectionalMapping
extends AbstractObservableMapping
implements IBidirectionalMapping,
IObservableMappingWithDomain {
    private final IObservableMapping wrappedMapping;
    private IObservableSet range;
    private Map valueToElements = new HashMap();
    private ISetChangeListener domainListener = new ISetChangeListener(){

        public void handleSetChange(IObservableSet source, SetDiff diff) {
            HashSet<Object> rangeAdditions = new HashSet<Object>();
            Iterator it = diff.getAdditions().iterator();
            while (it.hasNext()) {
                Object added = it.next();
                Object mappingValue = BidirectionalMapping.this.wrappedMapping.getMappingValue(added);
                rangeAdditions.add(mappingValue);
                BidirectionalMapping.this.addMapping(mappingValue, added);
            }
            BidirectionalMapping.this.range.addAll(rangeAdditions);
            it = diff.getRemovals().iterator();
            while (it.hasNext()) {
                Object removed = it.next();
                BidirectionalMapping.this.removeMapping(BidirectionalMapping.this.wrappedMapping.getMappingValue(removed), removed);
            }
            BidirectionalMapping.this.range.retainAll((Collection)BidirectionalMapping.this.valueToElements.keySet());
        }
    };
    private IMappingChangeListener mappingChangeListener = new IMappingChangeListener(){

        public void handleMappingValueChange(IObservable source, MappingDiff diff) {
            Set affectedElements = diff.getElements();
            Iterator it = affectedElements.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                Object oldFunctionValue = diff.getOldMappingValues(element, new int[0])[0];
                Object newFunctionValue = diff.getNewMappingValues(element, new int[0])[0];
                BidirectionalMapping.this.removeMapping(oldFunctionValue, element);
                BidirectionalMapping.this.addMapping(newFunctionValue, element);
            }
            Set tempRange = BidirectionalMapping.this.valueToElements.keySet();
            BidirectionalMapping.this.range.addAll((Collection)tempRange);
            BidirectionalMapping.this.range.retainAll((Collection)tempRange);
            BidirectionalMapping.this.fireMappingValueChange(diff);
        }
    };
    private IObservableSet domain;

    public BidirectionalMapping(IObservableMappingWithDomain functionWithDomain) {
        this(functionWithDomain, functionWithDomain.getDomain());
    }

    public BidirectionalMapping(IObservableMapping wrappedMapping, IObservableSet domain) {
        this.wrappedMapping = wrappedMapping;
        this.domain = domain;
        HashSet<Object> tempRange = new HashSet<Object>();
        Iterator it = domain.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            Object functionValue = wrappedMapping.getMappingValue(element);
            this.addMapping(functionValue, element);
            tempRange.add(functionValue);
        }
        this.range = new WritableSet(tempRange);
        domain.addSetChangeListener(this.domainListener);
    }

    private void addMapping(Object functionValue, Object element) {
        Object elementOrSet = this.valueToElements.get(functionValue);
        if (elementOrSet == null) {
            this.valueToElements.put(functionValue, element);
            return;
        }
        if (!(elementOrSet instanceof Set)) {
            elementOrSet = new HashSet(Collections.singleton(elementOrSet));
            this.valueToElements.put(functionValue, elementOrSet);
        }
        Set set = (Set)elementOrSet;
        set.add(element);
    }

    private void removeMapping(Object functionValue, Object element) {
        Object elementOrSet = this.valueToElements.get(functionValue);
        if (elementOrSet instanceof Set) {
            Set set = (Set)elementOrSet;
            set.remove(element);
            if (set.size() == 0) {
                this.valueToElements.remove(functionValue);
            }
        } else {
            this.valueToElements.remove(functionValue);
        }
    }

    protected Object doGetMappingValue(Object element) {
        return this.wrappedMapping.getMappingValue(element);
    }

    public void setMappingValue(Object element, Object value) {
        this.wrappedMapping.setMappingValue(element, value);
    }

    public IObservableSet getRange() {
        return this.range;
    }

    public Set getDomainElementsForValue(Object value) {
        return null;
    }

    public void dispose() {
        this.wrappedMapping.removeMappingChangeListener(this.mappingChangeListener);
        this.domain.removeSetChangeListener(this.domainListener);
    }

    public IObservableSet getDomain() {
        return this.domain;
    }

    public Object getValueType() {
        return this.wrappedMapping.getValueType();
    }
}

