/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class JSSEUtil {
    private static final boolean isJDK14;

    public static void setEnabledProtocols(SSLSocket sSLSocket, String[] stringArray) {
        JSSEUtil._setEnabledProtocols(sSLSocket, stringArray);
    }

    public static void setEnabledProtocols(SSLServerSocket sSLServerSocket, String[] stringArray) {
        JSSEUtil._setEnabledProtocols(sSLServerSocket, stringArray);
    }

    private static void _setEnabledProtocols(Object object, String[] stringArray) {
        if (!isJDK14) {
            return;
        }
        try {
            Method method = object.getClass().getMethod("setEnabledProtocols", stringArray.getClass());
            method.invoke(object, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static void registerSecurityProvider() {
        if (isJDK14) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            Security.addProvider((Provider)clazz.newInstance());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static boolean isJDK14() {
        return isJDK14;
    }

    public static boolean wantClientAuth(boolean bl, boolean bl2) {
        if (isJDK14) {
            return bl;
        }
        return bl && !bl2;
    }

    public static void setWantClientAuth(SSLServerSocket sSLServerSocket, boolean bl) {
        if (!isJDK14) {
            throw new RuntimeException("Request mutual authentication not supported with JSSE 1.0.x");
        }
        try {
            Method method = sSLServerSocket.getClass().getMethod("setWantClientAuth", Boolean.TYPE);
            method.invoke((Object)sSLServerSocket, bl);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    static {
        boolean bl;
        try {
            Class<?> clazz = Class.forName("javax.net.ssl.SSLSocket");
            clazz.getMethod("setEnabledProtocols", String;.class);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        isJDK14 = bl;
    }
}

