/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui.splash;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import proguard.gui.splash.OverrideGraphics2D;
import proguard.gui.splash.Sprite;
import proguard.gui.splash.VariableDouble;
import proguard.gui.splash.VariableInt;

public class ShadowedSprite
implements Sprite {
    private VariableInt xOffset;
    private VariableInt yOffset;
    private VariableDouble alpha;
    private VariableInt blur;
    private Sprite sprite;
    private float cachedAlpha = -1.0f;
    private Color cachedColor;

    public ShadowedSprite(VariableInt variableInt, VariableInt variableInt2, VariableDouble variableDouble, VariableInt variableInt3, Sprite sprite) {
        this.xOffset = variableInt;
        this.yOffset = variableInt2;
        this.alpha = variableDouble;
        this.blur = variableInt3;
        this.sprite = sprite;
    }

    public void paint(Graphics graphics, long l) {
        double d = this.alpha.getDouble(l);
        int n = this.blur.getInt(l) + 1;
        OverrideGraphics2D overrideGraphics2D = new OverrideGraphics2D((Graphics2D)graphics);
        float f = 1.0f - (float)Math.pow(1.0 - d, 1.0 / (double)(n * n));
        if (f != this.cachedAlpha) {
            this.cachedAlpha = f;
            this.cachedColor = new Color(0.0f, 0.0f, 0.0f, f);
        }
        overrideGraphics2D.setOverrideColor(this.cachedColor);
        int n2 = this.xOffset.getInt(l) - n / 2;
        int n3 = this.yOffset.getInt(l) - n / 2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = n2 + i;
                int n5 = n3 + j;
                overrideGraphics2D.translate(n4, n5);
                this.sprite.paint(overrideGraphics2D, l);
                overrideGraphics2D.translate(-n4, -n5);
            }
        }
        this.sprite.paint(graphics, l);
    }
}

