/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;

public class ClassCpInfo
extends CpInfo {
    public int u2nameIndex;
    public ClassFile referencedClassFile;

    protected ClassCpInfo() {
    }

    public ClassCpInfo(int n, ClassFile classFile) {
        this.u2nameIndex = n;
        this.referencedClassFile = classFile;
    }

    protected int getNameIndex() {
        return this.u2nameIndex;
    }

    protected void setNameIndex(int n) {
        this.u2nameIndex = n;
    }

    public String getName(ClassFile classFile) {
        return classFile.getCpString(this.u2nameIndex);
    }

    public int getTag() {
        return 7;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u2nameIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2nameIndex);
    }

    public void accept(ClassFile classFile, CpInfoVisitor cpInfoVisitor) {
        cpInfoVisitor.visitClassCpInfo(classFile, this);
    }

    public void referencedClassAccept(ClassFileVisitor classFileVisitor) {
        if (this.referencedClassFile != null) {
            this.referencedClassFile.accept(classFileVisitor);
        }
    }
}

