/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;

public class EnumConstantElementValue
extends ElementValue {
    protected static final int CONSTANT_FIELD_SIZE = 5;
    public int u2typeNameIndex;
    public int u2constantNameIndex;
    public ClassFile[] referencedClassFiles;

    protected EnumConstantElementValue() {
    }

    protected int getLength() {
        return 5;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u2typeNameIndex = dataInput.readUnsignedShort();
        this.u2constantNameIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2typeNameIndex);
        dataOutput.writeShort(this.u2constantNameIndex);
    }

    public void accept(ClassFile classFile, Annotation annotation, ElementValueVisitor elementValueVisitor) {
        elementValueVisitor.visitEnumConstantElementValue(classFile, annotation, this);
    }
}

