/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;

public class MultiInstructionVisitor
implements InstructionVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private final SimpleInstruction simpleInstruction = new SimpleInstruction();
    private final CpInstruction cpInstruction = new CpInstruction();
    private final VariableInstruction variableInstruction = new VariableInstruction();
    private final BranchInstruction branchInstruction = new BranchInstruction();
    private final TableSwitchInstruction tableSwitchInstruction = new TableSwitchInstruction();
    private final LookUpSwitchInstruction lookUpSwitchInstruction = new LookUpSwitchInstruction();
    private InstructionVisitor[] instructionVisitors;
    private int instructionVisitorCount;

    public MultiInstructionVisitor() {
    }

    public MultiInstructionVisitor(InstructionVisitor[] instructionVisitorArray) {
        this.instructionVisitors = instructionVisitorArray;
        this.instructionVisitorCount = instructionVisitorArray.length;
    }

    public void addInstructionVisitor(InstructionVisitor instructionVisitor) {
        this.ensureArraySize();
        this.instructionVisitors[this.instructionVisitorCount++] = instructionVisitor;
    }

    private void ensureArraySize() {
        if (this.instructionVisitors == null) {
            this.instructionVisitors = new InstructionVisitor[5];
        } else if (this.instructionVisitors.length == this.instructionVisitorCount) {
            InstructionVisitor[] instructionVisitorArray = new InstructionVisitor[this.instructionVisitorCount + 5];
            System.arraycopy(this.instructionVisitors, 0, instructionVisitorArray, 0, this.instructionVisitorCount);
            this.instructionVisitors = instructionVisitorArray;
        }
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        simpleInstruction = this.simpleInstruction.copy(simpleInstruction);
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitSimpleInstruction(classFile, methodInfo, codeAttrInfo, n, simpleInstruction);
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        variableInstruction = this.variableInstruction.copy(variableInstruction);
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitVariableInstruction(classFile, methodInfo, codeAttrInfo, n, variableInstruction);
        }
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        cpInstruction = this.cpInstruction.copy(cpInstruction);
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitCpInstruction(classFile, methodInfo, codeAttrInfo, n, cpInstruction);
        }
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        branchInstruction = this.branchInstruction.copy(branchInstruction);
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitBranchInstruction(classFile, methodInfo, codeAttrInfo, n, branchInstruction);
        }
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        tableSwitchInstruction = this.tableSwitchInstruction.copy(tableSwitchInstruction);
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitTableSwitchInstruction(classFile, methodInfo, codeAttrInfo, n, tableSwitchInstruction);
        }
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        lookUpSwitchInstruction = this.lookUpSwitchInstruction.copy(lookUpSwitchInstruction);
        for (int i = 0; i < this.instructionVisitorCount; ++i) {
            this.instructionVisitors[i].visitLookUpSwitchInstruction(classFile, methodInfo, codeAttrInfo, n, lookUpSwitchInstruction);
        }
    }
}

