/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.MethodInfoLinker;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class KeepMarker
implements ClassFileVisitor,
MemberInfoVisitor {
    private static final Object KEPT = new Object();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        KeepMarker.markAsKept(programClassFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        KeepMarker.markAsKept(libraryClassFile);
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        KeepMarker.markAsKept(programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        KeepMarker.markAsKept(MethodInfoLinker.lastMemberInfo(programMethodInfo));
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        KeepMarker.markAsKept(libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        KeepMarker.markAsKept(MethodInfoLinker.lastMemberInfo(libraryMethodInfo));
    }

    public static void markAsKept(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(KEPT);
    }

    public static boolean isKept(VisitorAccepter visitorAccepter) {
        return MethodInfoLinker.lastVisitorAccepter(visitorAccepter).getVisitorInfo() == KEPT;
    }
}

