/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.MethodImplementationFilter;
import proguard.optimize.MethodOptimizationInfo;

public class NonPrivateMethodMarker
implements ClassFileVisitor,
CpInfoVisitor,
MemberInfoVisitor {
    private MethodImplementationFilter filteredMethodMarker = new MethodImplementationFilter(this);

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.methodAccept("<clinit>", "()V", this);
        programClassFile.methodAccept("<init>", "()V", this);
        programClassFile.constantPoolEntriesAccept(this);
        programClassFile.methodsAccept(this.filteredMethodMarker);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        libraryClassFile.methodsAccept(this);
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        interfaceMethodrefCpInfo.referencedMemberInfoAccept(this);
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        ClassFile classFile2 = methodrefCpInfo.referencedClassFile;
        if (classFile2 != null && !classFile2.equals(classFile)) {
            methodrefCpInfo.referencedMemberInfoAccept(this);
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        NonPrivateMethodMarker.markCanNotBeMadePrivate(programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        NonPrivateMethodMarker.markCanNotBeMadePrivate(libraryMethodInfo);
    }

    public static void markCanNotBeMadePrivate(MethodInfo methodInfo) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(methodInfo);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setCanNotBeMadePrivate();
        }
    }

    public static boolean canBeMadePrivate(MethodInfo methodInfo) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(methodInfo);
        return methodOptimizationInfo != null && methodOptimizationInfo.canBeMadePrivate();
    }
}

