/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.NoSideEffectMethodMarker;
import proguard.optimize.SideEffectMethodMarker;
import proguard.optimize.WriteOnlyFieldMarker;

public class SideEffectInstructionChecker
implements InstructionVisitor,
CpInfoVisitor,
MemberInfoVisitor {
    private boolean includeReturnInstructions;
    private boolean isReading;
    private boolean hasSideEffects;

    public SideEffectInstructionChecker(boolean bl) {
        this.includeReturnInstructions = bl;
    }

    public boolean hasSideEffects(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, Instruction instruction) {
        this.hasSideEffects = false;
        instruction.accept(classFile, methodInfo, codeAttrInfo, n, this);
        return this.hasSideEffects;
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        byte by = simpleInstruction.opcode;
        if (by == 79 || by == 80 || by == 81 || by == 82 || by == 83 || by == 84 || by == 85 || by == 86 || by == -65 || by == -62 || by == -61 || this.includeReturnInstructions && (by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -79)) {
            this.hasSideEffects = true;
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        byte by = variableInstruction.opcode;
        if (this.includeReturnInstructions && by == -87) {
            this.hasSideEffects = true;
        }
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        byte by = cpInstruction.opcode;
        if (by == -77 || by == -75 || by == -74 || by == -73 || by == -72 || by == -71) {
            classFile.constantPoolEntryAccept(cpInstruction.cpIndex, this);
        }
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        byte by = branchInstruction.opcode;
        if (this.includeReturnInstructions && (by == -88 || by == -55)) {
            this.hasSideEffects = true;
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        MemberInfo memberInfo = fieldrefCpInfo.referencedMemberInfo;
        if (memberInfo == null) {
            this.hasSideEffects = true;
        } else {
            fieldrefCpInfo.referencedMemberInfoAccept(this);
        }
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        MemberInfo memberInfo = interfaceMethodrefCpInfo.referencedMemberInfo;
        if (memberInfo == null) {
            this.hasSideEffects = true;
        } else {
            interfaceMethodrefCpInfo.referencedMemberInfoAccept(this);
            if (!this.hasSideEffects) {
                ClassFile classFile2 = interfaceMethodrefCpInfo.referencedClassFile;
                MethodInfo methodInfo = (MethodInfo)memberInfo;
                classFile2.methodImplementationsAccept(methodInfo, false, this);
            }
        }
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        MemberInfo memberInfo = methodrefCpInfo.referencedMemberInfo;
        if (memberInfo == null) {
            this.hasSideEffects = true;
        } else {
            methodrefCpInfo.referencedMemberInfoAccept(this);
            if (!this.hasSideEffects) {
                ClassFile classFile2 = methodrefCpInfo.referencedClassFile;
                MethodInfo methodInfo = (MethodInfo)memberInfo;
                classFile2.methodImplementationsAccept(methodInfo, false, this);
            }
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.hasSideEffects = this.isReading ? (programFieldInfo.getAccessFlags() & 0x40) != 0 : !WriteOnlyFieldMarker.isWriteOnly(programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.hasSideEffects = this.hasSideEffects || SideEffectMethodMarker.hasSideEffects(programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.hasSideEffects = this.isReading ? (libraryFieldInfo.getAccessFlags() & 0x40) != 0 : !WriteOnlyFieldMarker.isWriteOnly(libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.hasSideEffects = this.hasSideEffects || !NoSideEffectMethodMarker.hasNoSideEffects(libraryMethodInfo);
    }
}

