package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * @stereotype Main
 */
public class Console {
	private SystemBase sb = SystemBase.getInstance();
	private ViewManager vmgr = null;

	/**
	 * Console
	 */
	public Console() {
		sb.setLoggerInfo(AppKeys.ProgramName, AppKeys.LogFilename);
		sb.getLogger().info("NCAgJn܂B");

		vmgr = ViewManager.getInstance();		
	}

	/**
	 * run
	 */
	private void run() {
		vmgr.run();
		/**
		 * Safe termination!?.
		 */
		sb.getLogger().debug(sb.gc()); // Gabage collection.				
	}

	/**
	 * main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		new Console().run();
		try {
	    Thread.sleep(1000);
    }
    catch (InterruptedException e) {
    }
		System.exit(0);
	}
}
