package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

/**
 * @stereotype Main
 */
public class Recovery extends IUserAdmin {
	/**
	 * Useradd
	 * @param args
	 */
	public Recovery(String[] args) {
		super(args);

		sb.setLoggerInfo(AppKeys.ProgramName, AppKeys.LogFilename);
	}

	/**
	 * parseOptions
	 * @param args
	 */
	protected void parseOptions(String[] args) {
		if (args.length == 0) {
			usage();
			System.exit(-1);
		}
		for (int i = 0; i < args.length; i++) {
			if ("-rootpass".equalsIgnoreCase(args[i])) {
				setRootPassword(args[++i]);
			}
			else if ("-host".equalsIgnoreCase(args[i])) {
				setAdminHost(args[++i]);
			}
			else if ("-port".equalsIgnoreCase(args[i])) {
				setAdminPort(new Integer(args[++i]).intValue());
			}
		}
		if (getRootPassword().length() == 0 || this.getAdminHost().length() == 0) {
			usage();
			System.exit(-1);
		}
	}

	/**
	 * usage
	 */
	private void usage() {
		System.out.println("Usage: recovery -rootpass <password> -host <targethost> -port <portnum>");
		System.out
		    .println("HotShot utility recovery runs the database recovery procedure on a HotShot repository. Please do this if you've been getting errors indicationg that recovery ought to be run. Recovery requires exclusive access and will exit if the repository is in use by another process.");
		System.out.println("\t-rootpass <pass>\t: Password for root account.");
		System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
		System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
	}

	/**
	 * run
	 * The ORB/SVN connections carried out in the upper layer.
	 */
	@Override
	protected void run() {
		try {
			orbmgr.recovery("root", getRootPassword());
		}
		catch (InternalFailException ex) {
			sb.getLogger().error("JoɎs܂Bf[^Z^|WgꎞIɃbNĂ\܂̂ŁA΂炭ԂĂĎsĂ݂ĂB");
			sb.getLogger().error(ex.getMessage());
			return;
		}
		catch (Exception ex) {
			sb.getLogger().fatal(ex.getMessage());
			return;
		}
		sb.getLogger().info("f[^Z^̃|WgEJo܂B");
	}

	/**
	 * main
	 * @param args
	 */
	public static void main(String[] args) {
		IUserAdmin admin = new Recovery(args);
		admin.exec();
	}
}
