package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountExistException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

/**
 * @stereotype Main
 */
public class Useradd extends IUserAdmin {
	/**
	 * Useradd
	 * @param args
	 */
	public Useradd(String[] args) {
		super(args);

		sb.setLoggerInfo(AppKeys.ProgramName, AppKeys.LogFilename);
	}

	/**
	 * parseOptions
	 * @param args
	 */
	protected void parseOptions(String[] args) {
		if (args.length == 0) {
			usage();
			System.exit(-1);
		}
		for (int i = 0; i < args.length; i++) {
			if ("-rootpass".equalsIgnoreCase(args[i])) {
				setRootPassword(args[++i]);
			}
			else if ("-user".equalsIgnoreCase(args[i])) {
				setNewAccount(args[++i]);
			}
			else if ("-pass".equalsIgnoreCase(args[i])) {
				setNewPassword(args[++i]);
			}
			else if ("-host".equalsIgnoreCase(args[i])) {
				setAdminHost(args[++i]);
			}
			else if ("-port".equalsIgnoreCase(args[i])) {
				setAdminPort(new Integer(args[++i]).intValue());
			}
		}
		if (getRootPassword().length() == 0 || getNewAccount().length() == 0 || getNewPassword().length() == 0) {
			usage();
			System.exit(-1);
		}
	}

	/**
	 * usage
	 */
	private void usage() {
		System.out
		    .println("Usage: useradd -rootpass <password> -user <new account> -pass <new password> -host <targethost> -port <portnum>");
		System.out.println("HotShot utility useradd administer a new user login on the HotShot system.");
		System.out.println("\t-rootpass <pass>\t: Password for root account.");
		System.out.println("\t-user <account>\t\t: New login ID to be added.");
		System.out.println("\t-pass <newpass>\t: The password for the login ID.");
		System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
		System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
	}

	/**
	 * run
	 * The ORB/SVN connections carried out in the upper layer.
	 */
	@Override
	protected void run() {

		try {
			orbmgr.createAccount("root", getRootPassword(), getNewAccount(), getNewPassword());
		}
		catch (Exception ex) {
			sb.getLogger().error("VKAJEg̍쐬Ɏs܂B: " + ex.getMessage());
			return;
		}

		/**
		 * Establish SVN connection. - It should be done after finishing createAccount().
		 */
		try {
			svnmgr.connect(getNewAccount(), getNewPassword());
		}
		catch (ConnectionFailException ex) {
			sb.getLogger().error("f[^Z^ւ̐ڑɎs܂B: " + ex.getMessage());
			return;
		}

		/**
		 * Assign a space for new user.
		 */
		try {
			svnmgr.createAccountArea(getNewAccount());
		}
		catch (InternalFailException ex) {
			sb.getLogger().error("VKAJEg̗̈mۂɎs܂B: " + ex.getMessage());
			return;
		}
		catch (AccountExistException ex) {
			sb.getLogger().fatal("ɃAJEg" + getNewAccount() + "̂߂̗̈悪o^Ă܂B");
			sb.getLogger().fatal("UAJEg" + getNewAccount() + "폜Aēxo^邱Ƃ߂܂B");
			return;
		}
		sb.getLogger().info("VKAJEg" + getNewAccount() + "̓o^܂B");
	}

	/**
	 * main
	 * @param args
	 */
	public static void main(String[] args) {
		IUserAdmin admin = new Useradd(args);
		admin.exec();
	}
}
