package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

/**
 * @stereotype Main
 */
public class Userdel extends IUserAdmin {
	/**
	 * Userdel
	 * @param args
	 */
	public Userdel(String[] args) {
		super(args);

		sb.setLoggerInfo(AppKeys.ProgramName, AppKeys.LogFilename);
	}

	/**
	 * parseOptions
	 */
	@Override
	protected void parseOptions(String[] args) {
		if (args.length == 0) {
			usage();
			System.exit(-1);
		}
		for (int i = 0; i < args.length; i++) {
			if ("-rootpass".equalsIgnoreCase(args[i])) {
				setRootPassword(args[++i]);
			}
			else if ("-user".equalsIgnoreCase(args[i])) {
				setNewAccount(args[++i]);
			}
			else if ("-host".equalsIgnoreCase(args[i])) {
				setAdminHost(args[++i]);
			}
			else if ("-port".equalsIgnoreCase(args[i])) {
				setAdminPort(new Integer(args[++i]).intValue());
			}
		}
		if (getRootPassword().length() == 0 || getNewAccount().length() == 0) {
			usage();
			System.exit(-1);
		}
	}

	/**
	 * usage
	 */
	private void usage() {
		System.out.println("Usage: Userdel -rootpass <password> -user <account> -host <targethost> -port <portnum>");
		System.out
		    .println("HotShot utility userdel deletes a user account from the system and makes the appropriate account-related changes to the system file and file system.");
		System.out.println("\t-rootpass <pass>\t: Password for root account.");
		System.out.println("\t-user <account>\t\t: The login ID to be deleted.");
		System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
		System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
	}

	/**
	 * run
	 * The ORB/SVN connections carried out in the upper layer.  
	 */
	@Override
	protected void run() {
		try {
			orbmgr.deleteAccount("root", getRootPassword(), getNewAccount());
		}
		catch (Exception ex) {
			String msg = ex.getMessage();
			sb.getLogger().error(msg);
			return;
		}

		/**
		 * Establish SVN connection. - It should be done after finishing createAccount().
		 */
		try {
			svnmgr.connect("root", getRootPassword());
		}
		catch (ConnectionFailException ex) {
			String msg = ex.getMessage();
			sb.getLogger().error(msg);
			return;
		}

		/**
		 * Delete space for a user.
		 */
		try {
			svnmgr.deleteAccountArea(getNewAccount());
		}
		catch (InternalFailException ex) {
			String msg = ex.getMessage();
			sb.getLogger().error(msg);
			return;
		}
		catch (AccountNotFoundException ex) {
			sb.getLogger().warn("AJEg" + getNewAccount() + "̗݂̈͑Ă܂B");
		}
		sb.getLogger().info("AJEg" + getNewAccount() + "̍폜܂B");
	}

	/**
	 * main
	 * @param args
	 */
	public static void main(String[] args) {
		IUserAdmin admin = new Userdel(args);
		admin.exec();
	}

}
