package com.interpress_project.modernshare.client.controller.actions;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.interpress_project.modernshare.client.view.ViewManager;

/**
 * @stereotype action
 */
final public class AboutAction extends ActionAdaptor {
	private final ViewManager fmgr;

	@SuppressWarnings("unused")
	private final AboutFrame frame = new AboutFrame();

	/**
	 * AboutAction
	 *
	 * @param fmgr FrameManager
	 */
	public AboutAction(ViewManager fmgr) {
		setText("HotShot clientɂ(&A)");
		setEnabled(true);
		setToolTipText("ModernShare ClientɊւ\܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("about"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.fmgr = fmgr;
	}

	/**
	 * run
	 */
	public void run() {
		fmgr.getShell().getDisplay().syncExec(new Runnable() {
			public void run() {
				frame.run();
			}
		});
	}

	private final class AboutFrame {
		public void run() {
			final Display display = fmgr.getShell().getDisplay();
			final Shell splash = new Shell(fmgr.getShell(), SWT.ON_TOP | SWT.APPLICATION_MODAL | SWT.TITLE);
			splash.setText("HotShotɂ");
			splash.setLayout(new GridLayout(1, false));
			Image img = new Image(display, "images/hotshot_banner.png");
			Label label = new Label(splash, SWT.NONE);
			label.setImage(img);
			label.addMouseListener(new MouseAdapter() {
				public void mouseDown(MouseEvent mouseEvent) {
					Label label = (Label) mouseEvent.getSource();
					Image img = label.getImage();
					img.dispose();
					splash.dispose();

					sb.getLogger().debug(sb.gc()); // Gabage collection.							
				}
			});
			splash.pack();

			//XvbVEBhE𒆉ɔzu
			Rectangle shellRect = splash.getBounds();
			Rectangle dispRect = display.getBounds();
			int x = (dispRect.width - shellRect.width) / 2;
			int y = (dispRect.height - shellRect.height) / 2;

			//ʒu̎wpack()̂ƂɌĂԕKv
			splash.setLocation(x, y);
			splash.open();
			while (!splash.isDisposed()) {
				display.readAndDispatch();
				display.sleep();
			}
		}
	}
}
