package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class DeActivateTargetAction extends ActionAdaptor {
	private SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private ViewManager vmgr;
	private String path;

	/**
	 * DeActivateTargetAction
	 * @param vmgr
	 * @param path
	 */
	public DeActivateTargetAction(ViewManager vmgr, String path) {
		setText("Ď~(&T)");
		setToolTipText("ΏۂƂȂzbgVbgtH_ɑ΂鎩Ď~܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("unconnected"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.path = path;
	}

	/**
	 * setDeActive
	 * @param path
	 */
	private void setDeActive(String path) {
		ISVNCommand command = factory.createActiveTargetCommand(path, RootStatus.deactive);
		cmdmgr.addCommand(command);
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		try {
			taskmgr.stop();

			boolean bAnswer = vmgr.getDialogManager().createYesNoMessageDialog("Ď̒~mF",
			  "zbgVbgtH_" + path + "ɑ΂鎩Ď~܂B");
			if (bAnswer == false) {
				return;
			}
			setDeActive(path);
		}
		finally {
			guiEventSource.fireEvent(new GUIEvent(this, "zbgVbgtH_" + path + "ɑ΂鎩Ď~܂B", GUIEventType.FINISH));
			taskmgr.start();
		}
	}
}
