package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class ExportAction extends ActionAdaptor {
	private final ViewManager vmgr;
	private final RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
	private ISVNFileItem item = null;

	/**
	 * RegisterTargetAction
	 * @param vmgr
	 */
	public ExportAction(ViewManager vmgr, ISVNFileItem item) {
		setText("f[^̎o(&X)");
		setToolTipText("f[^Z^Ɋi[ꂽf[^o܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("export"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.item = item;
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		try {
			taskmgr.stop();
			logEventSource.fireEvent(new LogEvent(this, LogEventType.CLEAR));

			try {
				svnmgr.connect();
			}
			catch (ConnectionFailException ex) {
				logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
				vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
				return;
			}
			vmgr.getDialogManager().createRemoteExportWizard(item);
		}
		finally {
			taskmgr.start();
		}
	}
}
