package com.interpress_project.modernshare.client.controller.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * @stereotype Utils
 */
public final class ImageFactory {
	private SystemBase sb = SystemBase.getInstance();

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Singleton
	 * @supplierRole Singleton factory
	 */
	/*# private ImageFactory _imageFactory; */
	private static ImageFactory instance = new ImageFactory();

	private Hashtable<String, ImageDescriptor> ht = new Hashtable<String, ImageDescriptor>();
	private Hashtable<String, Image> htImage = new Hashtable<String, Image>();

	/**
	 * ImageFactory
	 */
	protected ImageFactory() {
		loadingImages();
	}

	/**
	 * loadingImages
	 */
	private void loadingImages() {
		ImageDescriptor imgdesc = null;
		try {
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/unconnected.gif"));
			ht.put("unconnected", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/connected.gif"));
			ht.put("connected", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/connected_ro.gif"));
			ht.put("connected_ro", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/exit.png"));
			ht.put("exit", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/co.png"));
			ht.put("chkout", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/help.gif"));
			ht.put("help", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/about.gif"));
			ht.put("about", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/folder.png"));
			ht.put("folder", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/file.gif"));
			ht.put("file", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/rfolder.gif"));
			ht.put("rfolder", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/rfile.gif"));
			ht.put("rfile", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/property.gif"));
			ht.put("property", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/register.png"));
			ht.put("register", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/security.png"));
			ht.put("security", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/delete.gif"));
			ht.put("delete", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/disable.png"));
			ht.put("disable", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/sync.png"));
			ht.put("sync", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/syncserver.png"));
			ht.put("syncserver", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/repository.gif"));
			ht.put("repository", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/refresh.png"));
			ht.put("refresh", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/localpc.png"));
			ht.put("localpc", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/remotepc.png"));
			ht.put("remotepc", imgdesc);
			imgdesc = ImageDescriptor.createFromURL(new URL("file:images/export.png"));
			ht.put("export", imgdesc);
		}
		catch (MalformedURLException ex) {
			sb.getLogger().fatal("ACRt@C̃[fBOɎs܂B", ex);
			System.exit(-1);
		}
	}

	/**
	 * dispose
	 */
	public void dispose() {
		Enumeration<String> enumeration = ht.keys();
		while (enumeration.hasMoreElements()) {
			String key = enumeration.nextElement();
			ImageDescriptor desc = ht.get(key);
			desc.createImage().dispose();
		}
	}

	/**
	 * getImage
	 * @param name String
	 * @return org.eclipse.swt.graphics.Image
	 */
	public Image getImage(String name) {
		ImageDescriptor desc = this.getImageDescriptor(name);
		Image image = desc.createImage();
		return image;
	}

	/**
	 * getImageDescriptor
	 * @param name String
	 * @return org.eclipse.jface.resource.ImageDescriptor
	 */
	public ImageDescriptor getImageDescriptor(String name) {
		ImageDescriptor desc = ht.get(name);
		if (desc == null) {
			sb.getLogger().fatal(name + " not found in image repository.");
			System.exit(-1);
		}
		return desc;
	}

	/**
	 * getAssociatedImageToFile
	 * @param fileName
	 * @return
	 */
	public Image getAssociatedImageToFile(String fileName) {
		Image image = null;
		String ext = FilenameUtils.getExtension(fileName);
		if (ext == null) {
			image = ImageFactory.getInstance().getImage("file");
			return image;
		}
		image = htImage.get(ext);
		if (image != null) {
			return image;
		}

		Program program = Program.findProgram(ext);
		if (program == null) {
			image = ImageFactory.getInstance().getImage("file");
			return image;
		}
		ImageData data = program.getImageData();
		if (data == null) {
			image = ImageFactory.getInstance().getImage("file");
			return image;
		}
		image = new Image(null, data);
		htImage.put(ext, image);
		return image;
	}

	/**
	 * getInstance CX^X擾֐
	 * @return ImageFactory
	 */
	public static ImageFactory getInstance() {
		return instance;
	}
}
