package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class RemoteDeleteAction extends ActionAdaptor {
	private final ViewManager vmgr;
	private final RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private ISVNFileItem[] items = null;

	/**
	 * RegisterTargetAction
	 * @param vmgr
	 */
	public RemoteDeleteAction(ViewManager vmgr, ISVNFileItem[] items) {
		setText("폜(&D)");
		setToolTipText("f[^Z^烆[UE\[X폜܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("delete"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.items = items;
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		try {
			taskmgr.stop();

			boolean bResult = vmgr.getDialogManager().createYesNoMessageDialog("f[^Z^̃\[X폜mF",
			  "f[^Z^Ɋi[ꂽ\[X폜܂B폜AzbgVbgEtH_DataCenter -> PC[hōXVĂB ");
			if (bResult == false) {
				return;
			}

			guiEventSource.fireEvent(new GUIEvent(this, "[gE\[X폜Ă܂...", GUIEventType.START));

			try {
				svnmgr.connect();
			}
			catch (ConnectionFailException ex) {
				logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
				vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
				return;
			}

			try {
				svnmgr.deleteRemoteItem(items);
			}
			catch (InternalFailException ex) {
				logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
				vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
				return;
			}

			/**
			 * Refresh remote view.
			 */
			ISVNCommand command = factory.createRemoteRefreshCommand();
			cmdmgr.addCommand(command);
		}
		finally {
			guiEventSource.fireEvent(new GUIEvent(this, GUIEventType.FINISH));
			taskmgr.start();
		}
	}
}
