package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.ViewEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * @stereotype action
 */
public class StartupSyncAction extends ActionAdaptor {
	private final SystemBase sb = SystemBase.getInstance();
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private final ViewManager vmgr;

	/**
	 * SyncDataAction
	 * @param vmgr
	 * @param item
	 */
	public StartupSyncAction(final ViewManager vmgr) {
		setText("f[^Z^zbgVbgtH_𓯊(&S)");
		setToolTipText("f[^Z^̃f[^ŃzbgVbgtH_𓯊܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("syncserver"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		try {
			taskmgr.stop();
			/**
			 * update Local XML file.
			 */
			cmdmgr.execCommand(factory.createUpdateClientXMLCommand());

			localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));

			/**
			 * [J^[QbgXg𓯊
			 */
			cmdmgr.execCommand(factory.createSyncListCommand());

			final LocalModelManager lmmgr = LocalModelManager.getInstance();
			final LocalRoot[] roots = lmmgr.getRootLineItem().getActiveRoots();
			if (roots.length == 0) {
				vmgr.getDialogManager().createInformationMessageDialog("f[^Z^Ƃ̓mF", "XV[h̃zbgVbgtH_͓o^Ă܂B");
				return;
			}

			boolean bResult = vmgr.getDialogManager().createYesNoMessageDialog("f[^Z^Ƃ̓mF",
			  "SẴzbgVbgtH_Af[^Z^Ɠ܂? (f[^Z^Ɋi[ꂽf[^Ń[JPC̃zbgVbgtH_XV܂B)");
			if (bResult == false) {
				return;
			}

			for (int i = 0; i < roots.length; i++) {
				try {
					String msg = "zbgVbgtH_" + roots[i].getAbsolutePath() + "f[^Z^̃f[^œĂ܂...";
					guiEventSource.fireEvent(new GUIEvent(this, msg, GUIEventType.START));
					cmdmgr.execCommand(factory.createSyncLocalWithRemoteCommand(roots[i]));
				}
				finally {
					String msg = "zbgVbgtH_" + roots[i].getAbsolutePath() + "̓I܂B";
					guiEventSource.fireEvent(new GUIEvent(this, msg, GUIEventType.FINISH));
					roots[i].setDirty(false);
				}
			}
		}
		catch (CommandException ex) {
			String msg = ex.getCause().getMessage();
			logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.ERROR, ex));
			vmgr.getDialogManager().createErrorMessageDialog(msg);
		}
		finally {
			taskmgr.start();
		}
	}
}
