package com.interpress_project.modernshare.client.controller.command;

import java.io.File;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoPermissionException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.UnknownHostException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class LocalExportCommand extends ISVNCommand {
	private final ORBManager orbmgr = ORBManager.getInstance();
	private final SystemBase sb = SystemBase.getInstance();
	private final RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
	private ISVNFileItem item = null;
	private String path = null;

	/**
	 * SyncListCommand
	 */
	public LocalExportCommand(ISVNFileItem item, String path) {
		super();

		this.item = item;
		this.path = path;
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		try {
			_execute();
		}
		finally {
			sb.getLogger().debug(sb.gc()); // Gabage collection.							
		}
	}

	/**
	 * _execute
	 * @throws CommandException
	 */
	private void _execute() throws CommandException {
		/**
		 * Refresh SVN port information.
		 */
		try {
			orbmgr.updateSVNServerInfo();
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}
		catch (NoPermissionException ex) {
			throw new CommandException(ex);
		}
		catch (UnknownHostException ex) {
			throw new CommandException(ex);
		}

		try {
			svnmgr.connect();
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}

		try {
			svnmgr.exportItem(item, new File(path));
		}
		catch (InternalFailException ex) {
			throw new CommandException(ex);
		}
	}
}
