package com.interpress_project.modernshare.client.controller.command;

import java.util.ArrayList;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.RemoteModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.RemoteViewEvent;
import com.interpress_project.modernshare.client.events.ViewEventType;

public class RemoteRefreshCommand extends ISVNCommand {
	/**
	 * RemoteRefreshCommand
	 */
	public RemoteRefreshCommand() {
		super();
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
		RemoteModelManager rmtmgr = RemoteModelManager.getInstance();
		try {
			guiEventSource.fireEvent(new GUIEvent(this, "tbVsĂ܂...", GUIEventType.START));

			try {
				svnmgr.connect();
			}
			catch (ConnectionFailException ex) {
				throw new CommandException(ex);
			}

			rmtmgr.clear();

			try {
				ArrayList<SVNRoot> list = svnmgr.getTagNames();
				for (int i = 0; i < list.size(); i++) {
					rmtmgr.addRoot(list.get(i));
				}
				remoteViewEventSource.fireEvent(new RemoteViewEvent(this, ViewEventType.REFRESH));
			}
			catch (InternalFailException ex) {
				throw new CommandException(ex);
			}
		}
		finally {
			guiEventSource.fireEvent(new GUIEvent(this, GUIEventType.FINISH));
		}
	}
}
