package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;

/**
 * Represents a singleton.
 * @stereotype Singleton factory
 */
public class SVNCommandFactory {

	/**
	 * Holds singleton instance
	 */
	private static SVNCommandFactory instance;

	/**
	 * prevents instantiation
	 */
	private SVNCommandFactory() {
	}

	/**
	 * Returns the singleton instance.
	 @return	the singleton instance
	 */
	static public SVNCommandFactory getInstance() {
		if (instance == null) {
			instance = new SVNCommandFactory();
		}
		return instance;
	}

	/**
	 * createUpdateClientXMLCommand
	 * @return
	 */
	public ISVNCommand createUpdateClientXMLCommand() {
		return new UpdateClientXMLCommand();
	}

	/**
	 * createStoreClientXMLCommand
	 * @return
	 */
	public ISVNCommand createStoreClientXMLCommand() {
		return new StoreClientXMLCommand();
	}

	/**
	 * createSyncRemoteWithLocalCommand
	 * @param localRoot
	 * @return
	 */
	public ISVNCommand createSyncRemoteWithLocalCommand(LocalRoot localRoot) {
		return new SyncRemoteWithLocalCommand(localRoot);
	}

	/**
	 * createSyncLocalWithRemoteCommand
	 * @param localRoot
	 * @return
	 */
	public ISVNCommand createSyncLocalWithRemoteCommand(LocalRoot localRoot) {
		return new SyncLocalWithRemoteCommand(localRoot);
	}

	/**
	 * createSyncListCommand
	 * @return
	 */
	public ISVNCommand createSyncListCommand() {
		return new SyncListCommand();
	}

	/**
	 * createCheckoutCommand
	 * @param path
	 * @param root
	 * @param status
	 * @param bPc2host
	 * @return
	 */
	public ISVNCommand createCheckoutCommand(String path, SVNRoot root, RootStatus status, boolean bPc2host) {
		return new CheckoutCommand(path, root, status, bPc2host);
	}

	/**
	 * createActiveTargetCommand
	 * @param path
	 * @param status
	 * @return
	 */
	public ISVNCommand createActiveTargetCommand(String path, RootStatus status) {
		return new ActiveTargetCommand(path, status);
	}

	/**
	 * createLocalExportCommand
	 * @param item
	 * @param path
	 * @return
	 */
	public ISVNCommand createLocalExportCommand(ISVNFileItem item, String path) {
		return new LocalExportCommand(item, path);
	}

	/**
	 * createLocalRefreshCommand
	 * @return
	 */
	public ISVNCommand createLocalRefreshCommand() {
		return new LocalRefreshCommand();
	}

	/**
	 * createRemoteRefreshCommand
	 * @return
	 */
	public ISVNCommand createRemoteRefreshCommand() {
		return new RemoteRefreshCommand();
	}
}
