package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoPermissionException;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.UnknownHostException;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;

/**
 * @author ys
 */
public class StoreClientXMLCommand extends ISVNCommand {
	private final SystemBase sb = SystemBase.getInstance();
	private final ORBManager orbmgr = ORBManager.getInstance();

	/**
	 * StoreClientXMLCommand
	 */
	public StoreClientXMLCommand() {
		super();
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		sb.getLogger().debug("Enter StoreClientXMLCommand.execute()");

		/**
		 * Store Client XML data.
		 */
		try {
			orbmgr.storeClientData(); // ύXĂȂΉȂB
		}
		catch (NoPermissionException ex) {
			throw new CommandException(ex);
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}
		catch (UnknownHostException ex) {
			throw new CommandException(ex);
		}
		sb.getLogger().debug("Leave StoreClientXMLCommand().execute");
	}
}
