package com.interpress_project.modernshare.client.controller.command;

import java.io.File;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class SyncRemoteWithLocalCommand extends ISVNCommand {
	private final SystemBase sb = SystemBase.getInstance();
	private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private LocalRoot localRoot = null;
	private File rootpath;

	/**
	 * SyncRemoteWithLocalCommand
	 * @param localRoot
	 */
	public SyncRemoteWithLocalCommand(LocalRoot localRoot) {
		super();

		this.rootpath = new File(localRoot.getAbsolutePath());
		this.localRoot = localRoot;
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		logEventSource.fireEvent(new LogEvent(this, rootpath + "Ɋi[ꂽf[^Ńf[^Z^XV܂...", LogEventType.INFO));

		localRoot.stopFsWatcher(); // XV̓t@CVXeĎ~
		try {
			/**
			 * Main process
			 */
			_execute();

			localRoot.setDirty(false);

			/**
			 * Refresh both local and remote view.
			 */
			cmdmgr.addCommand(factory.createRemoteRefreshCommand());
			cmdmgr.addCommand(factory.createLocalRefreshCommand());
		}
		finally {
			localRoot.startFsWatcher();
			sb.getLogger().debug(sb.gc()); // Gabage collection.			
		}
		logEventSource.fireEvent(new LogEvent(this, rootpath + "ւ̍XV͐܂B", LogEventType.INFO));
	}

	/**
	 * _execute
	 * @throws CommandException
	 */
	public void _execute() throws CommandException {
		sb.getLogger().debug("Enter SyncRemoteWithLocalCommand()._execute()");

		// Make a connection.
		try {
			svnmgr.connect();
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}

		// SVN Cleanup
		try {
			svnmgr.cleanupFiles(rootpath);
		}
		catch (InternalFailException ex) {
			logEventSource.fireEvent(new LogEvent(this, "SVNN[Abvs܂Bp܂B: " + ex.getMessage(),
			  LogEventType.INFO));
			// fall through...
		}

		try {
			/**
			 * [JŃ[gXVAŏIIFile񃊃XgԂB
			 */
			File[] files = svnmgr.prepareSyncRemoteFiles(rootpath);
			/**
			 * commit̂߂rootpathwB(commiẗɂ͍폜ACewłȂ悤Ȃ̂rootpathnB)
			 * 2ԖڂfilescommitɃt@Cꂽꍇ̃`FbN̂߁B
			 */
			svnmgr.commitDirectory(rootpath, files);
		}
		catch (InternalFailException ex) {
			throw new CommandException(ex);
		}
		sb.getLogger().debug("Leave SyncRemoteWithLocalCommand()._execute");
	}
}
