package com.interpress_project.modernshare.client.controller.command;

import java.util.TimerTask;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LocalViewEventSource;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.ViewEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class TaskWorkerThread extends TimerTask {
	private final SystemBase sb = SystemBase.getInstance();
	private final LocalModelManager lmmgr = LocalModelManager.getInstance();
	private final SVNCommandFactory commandFactory = SVNCommandFactory.getInstance();
	private final SVNCommandManager commandManager = SVNCommandManager.getInstance();
	private final LogEventSource logEventSource = LogEventSource.getInstance();
	private final LocalViewEventSource localViewEventSource = LocalViewEventSource.getInstance();

	/**
	 * TaskWorkerThread
	 */
	public TaskWorkerThread() {
	}

	/**
	 * run
	 */
	public void run() {
		sb.getLogger().debug("TaskThread started.");
		/**
		 * update Local XML file.
		 */
		try {
			commandManager.execCommand(commandFactory.createUpdateClientXMLCommand());
		}
		catch (CommandException ex) {
			logEventSource.fireEvent(new LogEvent(this, ex.getCause().getMessage(), LogEventType.ERROR, ex));
			return;
		}
		localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));

		LocalRoot[] roots = lmmgr.getRootLineItem().getRoots();
		for (int i = 0; i < roots.length; i++) {
			switch (roots[i].getStatus()) {
				case deactive:
				case disable: {
					continue;
				}
				case active: {
					boolean bPc2host = roots[i].getPc2host();

					if (bPc2host) {
						if (!roots[i].isDirty()) {
							continue;
						}
					}

					try {
						commandManager.execCommand(commandFactory.createSyncListCommand());
					}
					catch (CommandException ex) {
						logEventSource.fireEvent(new LogEvent(this, ex.getCause().getMessage(), LogEventType.ERROR, ex));
						return;
					}

					if (bPc2host) {
						commandManager.addCommand(commandFactory.createSyncRemoteWithLocalCommand(roots[i]));
					}
					else {
						commandManager.addCommand(commandFactory.createSyncLocalWithRemoteCommand(roots[i]));
					}
					break;
				}
			}
		} /* End Of for() loop. */

		/**
		 * Refresh remote viewer.
		 */
		commandManager.addCommand(commandFactory.createLocalRefreshCommand());

		/**
		 * Store Client XML config file.
		 */
		commandManager.addCommand(commandFactory.createStoreClientXMLCommand());

		sb.getLogger().debug("TaskThread terminated.");
	}
}
