package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoPermissionException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.UnknownHostException;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * @author ys
 */
public class UpdateClientXMLCommand extends ISVNCommand {
	private final SystemBase sb = SystemBase.getInstance();
	private final ORBManager orbmgr = ORBManager.getInstance();

	/**
	 * UpdateClientXMLCommand
	 */
	public UpdateClientXMLCommand() {
		super();
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		sb.getLogger().debug("Enter UpdateClientXMLCommand.execute()");
		/**
		 * Get SVN port and license information.
		 */
		try {
			orbmgr.updateClientData();
		}
		catch (NoPermissionException ex) {
			throw new CommandException(ex);
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}
		catch (UnknownHostException ex) {
			throw new CommandException(ex);
		}
		sb.getLogger().debug("Leave UpdateClientXMLCommand().execute");
	}
}
