package com.interpress_project.modernshare.client.controller.delegate;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;

import org.apache.commons.io.FileUtils;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.TagExistException;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.GUIEventSource;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class ISVNManager implements ISVNNotifyListener {
	// static variables that are shared with Remote/LocalManagers.
	protected static SystemBase sb = SystemBase.getInstance();
	protected static PropertyManager propmgr = PropertyManager.getInstance();
	protected static LogEventSource logEventSource = LogEventSource.getInstance();
	protected static GUIEventSource guiEventSource = GUIEventSource.getInstance();
	protected static SVNUrl svnAccounturl = null; // SVNUrl, like a "svn://<hostname>:<port>/<account>/".
	protected static String accounturl = null; // url, like a "svn://<hostname>:<port>/<account>/".
	protected static SVNUrl svnHosturl = null; // SVNUrl, like a "svn://<hostname>:<port>/".	
	protected static String hosturl = null; // url, like a "svn://<hostname>:<port>/".

	protected ISVNClientAdapter svnClient = null;
	protected boolean bConnected = false;
	private String[] ignoredfilter = null;
	private String account = null;

	/**
	 * ISVNManager
	 */
	public ISVNManager() {
		try {
			JhlClientAdapterFactory.setup();
		}
		catch (SVNClientException e) {
			// Must be javahl already registered. 
		}
		String bestClientType = null;
		try {
			bestClientType = SVNClientAdapterFactory.getPreferredSVNClientType();
		}
		catch (SVNClientException ex) {
			sb.getLogger().fatal("JhlClientAdapter: A_v^̏Ɏs܂BAvP[VI܂B(" + ex.getMessage() + ")", ex);
			System.exit(-1);
		}
		svnClient = SVNClientAdapterFactory.createSVNClient(bestClientType);
		addNotifyListener();

		ignoredfilter = propmgr.getIgnoreFilterList();
	}

	/**
	 * addNotifyListener
	 */
	protected void addNotifyListener() {
		svnClient.addNotifyListener(this);
	}

	/**
	 * removeNotifyListener
	 */
	protected void removeNotifyListener() {
		svnClient.removeNotifyListener(this);
	}

	/**
	 * connect
	 * @throws ConnectionFailException
	 */
	public void connect() throws ConnectionFailException {
		String account = propmgr.getUsername();
		String password = propmgr.getPassword();

		connect(account, password);
	}

	/**
	 * connect
	 * @param account
	 * @param password
	 * @throws ConnectionFailException 
	 */
	public void connect(String account, String password) throws ConnectionFailException {
		sb.getLogger().debug("ڑJn܂B(" + account + ")");

		this.account = account;
		svnClient.setUsername(account);
		svnClient.setPassword(password);

		/**
		 * Check if it already connected.
		 */
		if (bConnected) {
			sb.getLogger().debug("ڑς݂łB(" + account + ")");
			return;
		}

		// Get svnurl, like a "svn://<hostname>:<port>/<account>/".
		hosturl = propmgr.getTargetSVNURL();
		accounturl = propmgr.getTargetSVNURL(account);

		try {
			svnAccounturl = new SVNUrl(accounturl);
			svnHosturl = new SVNUrl(hosturl);
		}
		catch (MalformedURLException ex) {
			bConnected = false;
			throw new ConnectionFailException(accounturl + "ɑ΂AhXϊs܂B(" + ex.getMessage() + ")", ex);
		}

		// Ping for the host.
		try {
			sb.getLogger().debug(propmgr.getAdminHost() + "ւpings܂B");
			svnClient.getInfo(svnHosturl);
		}
		catch (SVNClientException ex) {
			bConnected = false;
			throw new ConnectionFailException(
			  "f[^Z^" + propmgr.getAdminHost() + "֐ڑɃ^CAEg܂Bf[^Z^̃zXgmFĂB", ex);
		}
		sb.getLogger().debug("ڑ܂B(" + account + ")");
		bConnected = true;
	}

	/**
	 * addIgnoredFile
	 * @param file
	 * @throws InternalFailException
	 */
	public void addIgnoredFilter(File file) throws InternalFailException {
		ArrayList<String> list = new ArrayList<String>();
		for (int i = 0; i < ignoredfilter.length; i++) {
			list.add(ignoredfilter[i]);
		}

		try {
			svnClient.setIgnoredPatterns(file, list);
		}
		catch (SVNClientException ex) {
			throw new InternalFailException(file.getAbsolutePath() + "ւ̏Op^[ݒɎs܂B", ex);
		}
	}

	/**
	 * existAccount
	 * @throws InternalFailException
	 */
	public void existAccount() throws AccountNotFoundException {
		try {
			svnClient.getInfo(svnAccounturl);
		}
		catch (SVNClientException ex) {
			throw new AccountNotFoundException("f[^Z^ɁAAJEg" + account + "͓o^Ă܂B", ex);
		}
	}

	/**
	 * _getTagNames
	 * @return
	 * @throws InternalFailException
	 */
	private ISVNDirEntry[] _getTagNames() throws InternalFailException {
		ISVNDirEntry[] entries = null;
		try {
			entries = svnClient.getList(svnAccounturl, SVNRevision.HEAD, false);
		}
		catch (SVNClientException ex) {
			throw new InternalFailException("AJEg" + account + "ɑ΂^OXg̎擾Ɏs܂B", ex);
		}
		return entries;
	}

	/**
	 * existTagName
	 * @param tagName
	 * @throws InternalFailException
	 * @throws TagExistException 
	 */
	public void existTagName(String tagName) throws InternalFailException, TagExistException {
		ISVNDirEntry[] tagnames = _getTagNames();
		for (int i = 0; i < tagnames.length; i++) {
			String tgname = tagnames[i].getPath();
			if (tgname.equalsIgnoreCase(tagName)) {
				throw new TagExistException("^O" + tagName + "́AɃf[^Z^ɓo^Ă܂B");
			}
		}
		return;
	}

	/**
	 * getTagNames
	 * @return
	 * @throws InternalFailException
	 */
	public ArrayList<SVNRoot> getTagNames() throws InternalFailException {
		ArrayList<SVNRoot> list = new ArrayList<SVNRoot>();
		ISVNDirEntry[] tagnames = _getTagNames();
		for (int i = 0; i < tagnames.length; i++) {
			ISVNDirEntry entry = tagnames[i];
			String name = entry.getPath();
			long fsize = entry.getSize();
			String author = entry.getLastCommitAuthor();
			Date lcdate = entry.getLastChangedDate();
			long revision = entry.getLastChangedRevision().getNumber();
			long lcrevision = revision;
			SVNNodeKind kind = entry.getNodeKind();
			if (kind == SVNNodeKind.DIR) {
				list.add(new SVNRoot(name, fsize, author, lcdate, revision, lcrevision, accounturl + "/" + name, ""));
			}
		}
		return list;
	}

	/**
	 * createSVNUrl
	 * @param url
	 * @return
	 * @throws InternalFailException
	 */
	protected SVNUrl createSVNUrl(String url) throws InternalFailException {
		SVNUrl u = null;
		try {
			u = new SVNUrl(url);
		}
		catch (MalformedURLException ex) {
			throw new InternalFailException(url + "ɑ΂AhXϊs܂B(" + ex.getMessage() + ")", ex);
		}
		return u;
	}

	/**
	 * deleteRemoteFolder
	 * @param tagName
	 * @throws InternalFailException
	 */
	public void deleteRemoteFolder(String tagName) throws InternalFailException {

		SVNUrl u = createSVNUrl(accounturl + "/" + tagName);

		String msg = "Unregister deletion at" + new Date().toString();
		try {
			svnClient.remove(new SVNUrl[] { u }, msg);
		}
		catch (SVNClientException ex) {
			throw new InternalFailException("f[^Z^ɂtH_" + tagName + "̍폜Ɏs܂B(" + u.toString() + ")", ex);
		}
	}

	/**
	 * commitDirectory
	 * @param path
	 * @throws InternalFailException 
	 */
	public void commitDirectory(File rootpath, File[] pathes) throws InternalFailException {
		try {
			String msg = "Committed at " + new Date().toString();
			/**
			 * commitrootpathɑ΂čsBnĂ݂폜ACe܂܂ƃG[B
			 */
			svnClient.commit(new File[] { rootpath }, msg, true);
			logEventSource.fireEvent(new LogEvent(this, "f[^Z^ւ̓R~bgɏI܂B", LogEventType.INFO));
		}
		catch (SVNClientException ex) {
			/**
			 * commit̊OɃt@Cړ͍폜ꂽ\B
			 * Ƃ肠t@C쐬邱ƂŐۂB
			 */
			for (int i = 0; i < pathes.length; i++) {
				if (!pathes[i].exists()) {
					try {
						FileUtils.touch(pathes[i]);
					}
					catch (IOException e) {
					}
				}
			}
			throw new InternalFailException("f[^Z^ւ̓R~bgɎs܂B");
		}
	}

	/**
	 * logCommandLine
	 */
	public void logCommandLine(String msg) {
		msg = msg.replace("\r", "");
		msg = msg.replace("\n", " ");
		sb.getLogger().debug("Enter logCommandLine : " + msg);
	}

	/**
	 * logCompleted
	 */
	public void logCompleted(String msg) {
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
	}

	/**
	 * logError
	 */
	public void logError(String msg) {
		msg = msg.replace("\r", "");
		msg = msg.replace("\n", " ");
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.ERROR));
	}

	/**
	 * logMessage 
	 */
	public void logMessage(String msg) {
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
	}

	/**
	 * logRevision
	 */
	public void logRevision(long arg0, String msg) {
		logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
	}

	/**
	 * onNotify
	 */
	public void onNotify(File arg0, SVNNodeKind arg1) {
	}

	/**
	 * setCommand
	 */
	public void setCommand(int arg0) {
	}
}
