package com.interpress_project.modernshare.client.controller.model;

import java.io.File;

public class LocalFile implements IFileItem {
	private File file = null;

	/**
	 * LocalFile
	 * @param path
	 */
	public LocalFile(String path) {
		file = new File(path);
	}

	/**
	 * getAbsolutePath
	 */
	public String getAbsolutePath() {
		return file.getAbsolutePath();
	}

	/**
	 * getFilesize
	 */
	public long getFilesize() {
		return file.length();
	}

	/**
	 * getLocalItems
	 */
	public IFileItem[] getLocalItems() {
		return null;
	}

	/**
	 * getName
	 */
	public String getName() {
		return file.getName();
	}

	/**
	 * getParent
	 */
	public IFileItem getParent() {
		String parent = file.getParent();
		if (parent == null) {
			return null;
		}
		return new LocalFolder(parent);
	}

	/**
	 * isDirectory
	 */
	public boolean isDirectory() {
		return false;
	}

	/**
	 * isExist
	 */
	public boolean isExist() {
		return file.exists();
	}
}
