package com.interpress_project.modernshare.client.controller.model;

import java.io.File;
import java.util.ArrayList;

public class LocalFolder implements IFileItem {
	private File file;

	/**
	 * LocalFolder
	 * @param path
	 */
	public LocalFolder(String path) {
		file = new File(path);
	}

	/**
	 * getAbsolutePath
	 */
	public String getAbsolutePath() {
		return file.getAbsolutePath();
	}

	/**
	 * getFilesize
	 */
	public long getFilesize() {
		return 0;
	}

	/**
	 * getLocalItems
	 */
	public IFileItem[] getLocalItems() {
		if(!isExist()) {
			return null;
		}
		ArrayList<IFileItem> arrayList = new ArrayList<IFileItem>(12);
		File[] files = file.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isDirectory()) {
				arrayList.add(new LocalFolder(files[i].getAbsolutePath()));
			}
			else {
				arrayList.add(new LocalFile(files[i].getAbsolutePath()));
			}
		}
		return arrayList.toArray(new IFileItem[arrayList.size()]);
	}

	/**
	 * getName
	 */
	public String getName() {
		return file.getName();
	}

	/**
	 * getParent
	 */
	public IFileItem getParent() {
		String parent = file.getParent();
		if (parent == null) {
			return null;
		}
		return new LocalFolder(parent);
	}

	/**
	 * isDirectory
	 */
	public boolean isDirectory() {
		return true;
	}

	/**
	 * isExist
	 */
	public boolean isExist() {
		return file.exists();
	}
}