package com.interpress_project.modernshare.client.controller.model;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.preference.PreferenceStore;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * Represents a singleton.
 * @stereotype Singleton factory
 */
public class PropertyManager extends PreferenceStore {
	private SystemBase sb = SystemBase.getInstance();
	private String fileName = null;

	/**
	 * Holds singleton instance
	 */
	private static PropertyManager instance;

	/**
	 * PropertyManager
	 */
	private PropertyManager() {
		setDefault(AppKeys.FRAME_X, "0");
		setDefault(AppKeys.FRAME_Y, "0");
		setDefault(AppKeys.FRAME_WIDTH, "640");
		setDefault(AppKeys.FRAME_HEIGHT, "480");

		setDefault(AppKeys.ADMIN_HOST, "localhost");
		setDefault(AppKeys.ADMIN_PORT, "17770");

		setDefault(AppKeys.USERNAME, "anonymous");
		String result = sb.getSystemUtil().crypt(AppKeys.PASSENCODEKEY, "anonymous@localhost");
		setDefault(AppKeys.PASSWORD, result);

		try {
			InetAddress inet = InetAddress.getLocalHost();
			String name = inet.getHostName();
			setDefault(AppKeys.CLIENTID, name);
		}
		catch (UnknownHostException ex) {
			sb.getLogger().fatal("[JzXg擾ł܂łB");
			sb.getLogger().fatal("AvP[VI܂B");
			System.exit(-1);
		}

		setDefault(AppKeys.SVN_SECUREGUARDHOST, "127.0.0.1");
		setDefault(AppKeys.SVN_SECUREGUARDPORT, "65321");

		setDefault(AppKeys.SVN_PORT, 3690);

		setDefault(AppKeys.SVN_DURATION, 3);
		setDefault(AppKeys.SVN_DIRECTION, "true");
		setDefault(AppKeys.SVN_MAXCACHE, 12);
		setDefault(AppKeys.SVN_IGNOREFILTER, "*.bak *.swp ~$*.* ~*.tmp *.$$$ " + " " + AppKeys.NOTICEFILE + " *."
		    + AppKeys.HOTSHOTBKUPFILE);
		setDefault(AppKeys.ADMIN_LICENSE, "PERSONAL");
		setDefault(AppKeys.SVN_TCPBUFSZ, 1024 * 32);
		setDefault(AppKeys.SVN_CONNTIMEOUT, 4 * 1000);

		setDefault(AppKeys.KEYSTORE, "jsse_client_ks");
		setDefault(AppKeys.KEYSTOREPASS, "jsse_client_ks_pass");
		fileName = sb.getUserHomeDirectory() + "/" + AppKeys.PropFilename;
		setFilename(fileName);
		try {
			load();
		}
		catch (IOException e) {
		}
	}

	/**
	 * PropertyManager
	 * @return
	 */
	static public PropertyManager getInstance() {
		if (instance == null) {
			instance = new PropertyManager();
		}
		return instance;
	}

	/**
	 * store
	 */
	public void store() {
		try {
			if (needsSaving()) {
				save();
			}
		}
		catch (IOException ex) {
			sb.getLogger().warn("IOException saving properties into the file, " + AppKeys.PropFilename, ex);
		}
	}

	/**
	 * setFramePosition
	 * @param x
	 * @param y
	 * @param w
	 * @param h
	 */
	public void setFramePosition(int x, int y, int w, int h) {
		this.setValue(AppKeys.FRAME_X, x);
		this.setValue(AppKeys.FRAME_Y, y);
		this.setValue(AppKeys.FRAME_WIDTH, w);
		this.setValue(AppKeys.FRAME_HEIGHT, h);
	}

	/**
	 * getFramePosition
	 *
	 * @return int[]
	 */
	public int[] getFramePosition() {
		int x = this.getInt(AppKeys.FRAME_X);
		int y = this.getInt(AppKeys.FRAME_Y);
		int w = this.getInt(AppKeys.FRAME_WIDTH);
		int h = this.getInt(AppKeys.FRAME_HEIGHT);
		int[] pos = { x, y, w, h };
		return pos;
	}

	/**
	 * getUsername
	 * @return
	 */
	public String getUsername() {
		return this.getString(AppKeys.USERNAME);
	}

	/**
	 * setUsername
	 * @param name
	 */
	public void setUsername(String name) {
		this.setValue(AppKeys.USERNAME, name);
	}

	/**
	 * getPassword
	 * @return
	 */
	public String getPassword() {
		String p = getString(AppKeys.PASSWORD);
		String result = sb.getSystemUtil().decrypt(AppKeys.PASSENCODEKEY, p);
		return result;
	}

	/**
	 * setPassword
	 * @param password
	 */
	public void setPassword(String password) {
		String result = sb.getSystemUtil().crypt(AppKeys.PASSENCODEKEY, password);
		setValue(AppKeys.PASSWORD, result);
	}

	/**
	 * getTargetSVNURL
	 * @param account
	 * @return
	 */
	public String getTargetSVNURL(String account) {
		String url = "svn://" + getSecureGuardHost() + ":" + getSecureGuardPort() + "/" + account;
		return url;
	}

	/**
	 * getTargetSVNURL
	 * @return
	 */
	public String getTargetSVNURL() {
		String url = "svn://" + getSecureGuardHost() + ":" + getSecureGuardPort() + "/";
		return url;
	}

	/**
	 * getTargetCorbaloc
	 * @return
	 */
	public String getTargetCorbaloc() {
		String url = "corbaloc:ssliop:1.2@" + getAdminHost() + ":" + String.valueOf(getAdminPort())
		    + "/StandardImplName/MyFactory_poa/MyFactory";
		return url;
	}

	/**
	 * getAdminHost
	 * @return
	 */
	public String getAdminHost() {
		return getString(AppKeys.ADMIN_HOST);
	}

	/**
	 * getAdminPort
	 * @return
	 */
	public int getAdminPort() {
		return this.getInt(AppKeys.ADMIN_PORT);
	}

	/**
	 * getSVNHost
	 * @return
	 */
	public String getSVNHost() {
		return getAdminHost();
	}

	/**
	 * setAdminHost
	 * @param host
	 */
	public void setSVNHost(String host) {
		this.setValue(AppKeys.ADMIN_HOST, host);
	}

	/**
	 * getSVNPort
	 * @return
	 */
	public int getSVNPort() {
		return getInt(AppKeys.SVN_PORT);
	}

	/**
	 * setSVNPort
	 * @param port
	 */
	public void setSVNPort(int port) {
		this.setValue(AppKeys.SVN_PORT, port);
	}

	/**
	 * getSecureGuardHost
	 * @return
	 */
	public String getSecureGuardHost() {
		return getString(AppKeys.SVN_SECUREGUARDHOST);
	}

	/**
	 * setSecureGuardPort
	 * @param port
	 */
	public void setSecureGuardPort(int port) {
		this.setValue(AppKeys.SVN_SECUREGUARDPORT, port);
	}

	/**
	 * getSecureGuardPort
	 * @return
	 */
	public int getSecureGuardPort() {
		return this.getInt(AppKeys.SVN_SECUREGUARDPORT);
	}

	/**
	 * getDuration
	 * @return
	 */
	public int getDuration() {
		return getInt(AppKeys.SVN_DURATION);
	}

	/**
	 * setDuration
	 * @param duration
	 */
	public void setDuration(int duration) {
		setValue(AppKeys.SVN_DURATION, duration);
	}

	/**
	 * isPC2HOST
	 * @return
	 */
	public boolean isPc2Host() {
		return getBoolean(AppKeys.SVN_DIRECTION);
	}

	/**
	 * setPc2Host
	 * @param b
	 */
	public void setPc2Host(boolean b) {
		this.setValue(AppKeys.SVN_DIRECTION, b);
	}

	/**
	 * setMaxCache
	 * @param c
	 */
	public void setMaxCache(int c) {
		this.setValue(AppKeys.SVN_MAXCACHE, c);
	}

	/**
	 * getMaxCache
	 * @return
	 */
	public int getMaxCache() {
		return this.getInt(AppKeys.SVN_MAXCACHE);
	}

	/**
	 * getTcpBufSz
	 * @return
	 */
	public int getTcpBufSz() {
		return this.getInt(AppKeys.SVN_TCPBUFSZ);
	}

	/**
	 * getIgnoreFilterList
	 * @return
	 */
	public String[] getIgnoreFilterList() {
		ArrayList<String> list = new ArrayList<String>();

		String f = this.getString(AppKeys.SVN_IGNOREFILTER);
		StringTokenizer st = new StringTokenizer(f, " ");
		while (st.hasMoreTokens()) {
			String s = st.nextToken();
			list.add(s);
		}
		list.trimToSize();
		return (String[]) list.toArray(new String[list.size()]);
	}

	/**
	 * setConnectionTimeout
	 * @param value
	 */
	public void setConnectionTimeout(int value) {
		this.setValue(AppKeys.SVN_CONNTIMEOUT, value);
	}

	/**
	 * getConnectionTimeout
	 * @return
	 */
	public int getConnectionTimeout() {
		return this.getInt(AppKeys.SVN_CONNTIMEOUT);
	}

	/**
	 * setKeystore
	 * @param s
	 */
	public void setKeystore(String s) {
		this.setValue(AppKeys.KEYSTORE, s);
	}

	/**
	 * getKeystore
	 * @return
	 */
	public String getKeystore() {
		return this.getString(AppKeys.KEYSTORE);
	}

	/**
	 * setKeystorePass
	 * @param s
	 */
	public void setKeystorePass(String s) {
		this.setValue(AppKeys.KEYSTOREPASS, s);
	}

	/**
	 * getKeystorePass
	 * @return
	 */
	public String getKeystorePass() {
		return this.getString(AppKeys.KEYSTOREPASS);
	}

	/**
	 * setClientId
	 * @param s
	 */
	public void setClientId(String s) {
		this.setValue(AppKeys.CLIENTID, s);
	}

	/**
	 * getClientId
	 * @return
	 */
	public String getClientId() {
		return this.getString(AppKeys.CLIENTID);
	}

	/**
	 * getXMLFileName
	 * @return
	 */
	public String getXMLFileName() {
		String path = sb.getUserHomeDirectory() + "/" + AppKeys.XmlFilename;
		return FilenameUtils.normalize(path);
	}

	/**
	 * getPropFileName
	 * @return
	 */
	public String getPropFileName() {
		return fileName;
	}
}
