package com.interpress_project.modernshare.client.controller.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class RemoteRootLineItem implements ISVNFileItem {
	/**
	 * @associates com.interpress_project.modernshare.client.controller.model.SVNRoot
	 * @directed directed
	 * @link aggregation
	 * @supplierCardinality 0..*
	 */
	Hashtable<String, SVNRoot> htTargetFolders = null;

	/**
	 * RemoteRootLineItem
	 */
	public RemoteRootLineItem() {
		htTargetFolders = new Hashtable<String, SVNRoot>();
	}

	/**
	 * addRoot
	 * @param item
	 */
	public void addRoot(SVNRoot item) {
		htTargetFolders.put(item.getName(), item);
	}

	/**
	 * remoteRoot
	 * @param tagName
	 */
	public void remoteRoot(String tagName) {
		htTargetFolders.remove(tagName);
	}

	/**
	 * clear
	 */
	public void clear() {
		htTargetFolders.clear();
	}

	/**
	 * getFilesize
	 */
	public long getFilesize() {
		return 0;
	}

	/**
	 * getLastChangedDate
	 */
	public Date getLastChangedDate() {
		return null;
	}

	/**
	 * getLastChangedRevision
	 */
	public long getLastChangedRevision() {
		return 0;
	}

	/**
	 * geteLastFCommitAuthor
	 */
	public String getLastCommitAuthor() {
		return null;
	}

	/**
	 * getName
	 */
	public String getName() {
		return null;
	}

	/**
	 * getRevision
	 */
	public long getRevision() {
		return 0;
	}

	/**
	 * getSVNItems
	 */
	public ISVNFileItem[] getSVNItems() {
		ArrayList<ISVNFileItem> arrayList = new ArrayList<ISVNFileItem>();
		Enumeration<SVNRoot> enumeration = htTargetFolders.elements();
		while (enumeration.hasMoreElements()) {
			SVNFolder item = enumeration.nextElement();
			arrayList.add(item);
		}
		return arrayList.toArray(new ISVNFileItem[arrayList.size()]);
	}

	/**
	 * getRevisionInfo
	 */
	public ISVNFileItem[] getRevisionInfo() {
		return null;
	}

	/**
	 * getURL
	 */
	public String getURL() {
		return null;
	}

	/**
	 * getUUID
	 */
	public String getUUID() {
		return null;
	}

	/**
	 * isDirectory
	 */
	public boolean isDirectory() {
		return false;
	}
}
